/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import java.util.Collection;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public abstract class HtmlUnknownElementInspection
extends HtmlLocalInspectionTool
implements XmlEntitiesInspection {
    public JDOMExternalizableStringList myValues;
    public boolean myCustomValuesEnabled = true;

    public HtmlUnknownElementInspection(@NotNull String defaultValues) {
        this.myValues = HtmlUnknownElementInspection.reparseProperties(defaultValues);
    }

    protected static JDOMExternalizableStringList reparseProperties(@NotNull String properties) {
        JDOMExternalizableStringList result = new JDOMExternalizableStringList();
        StringTokenizer tokenizer = new StringTokenizer(properties, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add((Object)StringUtil.toLowerCase((String)tokenizer.nextToken()).trim());
        }
        return result;
    }

    protected static void registerProblemOnAttributeName(@NotNull XmlAttribute attribute, String message, @NotNull ProblemsHolder holder, LocalQuickFix ... quickfixes) {
        PsiElement nameElement;
        ASTNode node = attribute.getNode();
        assert (node != null);
        ASTNode nameNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node);
        if (nameNode != null && (nameElement = nameNode.getPsi()).getTextLength() > 0) {
            holder.registerProblem(nameElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickfixes);
        }
    }

    protected boolean isCustomValue(@NotNull String value) {
        return this.myValues.contains((Object)StringUtil.toLowerCase((String)value));
    }

    @Override
    public void addEntry(@NotNull String text) {
        String s = StringUtil.toLowerCase((String)text.trim());
        if (!this.isCustomValue(s)) {
            this.myValues.add((Object)s);
        }
        if (!this.isCustomValuesEnabled()) {
            this.myCustomValuesEnabled = true;
        }
    }

    public boolean isCustomValuesEnabled() {
        return this.myCustomValuesEnabled;
    }

    @Override
    public String getAdditionalEntries() {
        return StringUtil.join((Collection)this.myValues, (String)",");
    }

    public void enableCustomValues(boolean customValuesEnabled) {
        this.myCustomValuesEnabled = customValuesEnabled;
    }

    public void updateAdditionalEntries(@NotNull String values) {
        this.myValues = HtmlUnknownElementInspection.reparseProperties(values);
    }

    protected abstract String getCheckboxTitle();

    @NotNull
    protected abstract String getPanelTitle();

    @NotNull
    protected abstract Logger getLogger();
}

