/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class HtmlMissingClosingTagInspection
extends HtmlLocalInspectionTool {
    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!(tag instanceof HtmlTag) || !XmlHighlightVisitor.shouldBeValidated(tag)) {
            return;
        }
        PsiElement child = tag.getLastChild();
        if (child instanceof PsiErrorElement) {
            return;
        }
        if (child != null && child.getNode().getElementType() == XmlTokenType.XML_EMPTY_ELEMENT_END) {
            return;
        }
        XmlToken tagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        if (tagNameElement == null) {
            return;
        }
        String tagName = tagNameElement.getText();
        if (HtmlUtil.isSingleHtmlTag(tag, true) || XmlTagUtil.getEndTagNameElement((XmlTag)tag) != null) {
            return;
        }
        holder.registerProblem((PsiElement)tagNameElement, XmlAnalysisBundle.message((String)"element.missing.end.tag", (Object[])new Object[0]), new LocalQuickFix[]{new MissingClosingTagFix(tagName)});
    }

    private static class MissingClosingTagFix
    implements LocalQuickFix {
        private final String myName;

        MissingClosingTagFix(String name) {
            this.myName = name;
        }

        @Nls
        @NotNull
        public String getName() {
            return XmlAnalysisBundle.message((String)"add.named.closing.tag", (Object[])new Object[]{this.myName});
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return XmlAnalysisBundle.message((String)"add.closing.tag", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof XmlToken)) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof XmlTag)) {
                return;
            }
            String text = parent.getText();
            if (text.contains("\n")) {
                int cutoff = -1;
                for (int i = text.length() - 1; i > 0; --i) {
                    char c = text.charAt(i);
                    if (c == ' ' || c == '\t') continue;
                    if (c != '\n') break;
                    cutoff = i;
                }
                if (cutoff > 0) {
                    text = text.substring(0, cutoff);
                }
            }
            String replacementText = text + "</" + element.getText() + ">";
            XmlElementFactory factory = XmlElementFactory.getInstance((Project)project);
            XmlTag newTag = factory.createHTMLTagFromText(replacementText);
            PsiElement child = parent.getLastChild().copy();
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> {
                PsiElement grandChild;
                PsiElement replacement = parent.replace((PsiElement)newTag);
                if (child instanceof XmlText && (grandChild = child.getLastChild()) instanceof PsiWhiteSpace) {
                    XmlTag dummyTag = factory.createHTMLTagFromText("<dummy>" + grandChild.getText() + "</dummy>");
                    XmlText whitespace = (XmlText)PsiTreeUtil.getChildOfType((PsiElement)dummyTag, XmlText.class);
                    assert (whitespace != null);
                    replacement.getParent().addAfter((PsiElement)whitespace, replacement);
                }
            });
        }
    }
}

