/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.filters;

import com.google.common.base.Strings;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentZenCodingFilter
extends ZenCodingFilter {
    private static String buildCommentString(@Nullable String classAttr, @Nullable String idAttr) {
        StringBuilder builder = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)idAttr)) {
            builder.append('#').append(idAttr);
        }
        if (!Strings.isNullOrEmpty((String)classAttr)) {
            builder.append('.').append(classAttr);
        }
        return builder.toString();
    }

    @Override
    @NotNull
    public String filterText(@NotNull String text, @NotNull TemplateToken token) {
        XmlTag tag = token.getXmlTag();
        if (tag != null) {
            String classAttr = tag.getAttributeValue(this.getClassAttributeName());
            String idAttr = tag.getAttributeValue("id");
            if (!Strings.isNullOrEmpty((String)classAttr) || !Strings.isNullOrEmpty((String)idAttr)) {
                String commentString = CommentZenCodingFilter.buildCommentString(classAttr, idAttr);
                return String.format(this.getCommentFormat(), text, commentString);
            }
        }
        return text;
    }

    @NotNull
    protected String getCommentFormat() {
        return "%s\n<!-- /%s -->";
    }

    @NotNull
    public String getClassAttributeName() {
        return "class";
    }

    @Override
    @NotNull
    public String getSuffix() {
        return "c";
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context) {
        PsiElement parent = context.getParent();
        return parent != null && parent.getLanguage() instanceof XMLLanguage;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return XmlBundle.message((String)"emmet.filter.comment.tags", (Object[])new Object[0]);
    }
}

