/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.LiveTemplateBuilder;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.emmet.CollectCustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetAbbreviationBalloon;
import com.intellij.codeInsight.template.emmet.EmmetException;
import com.intellij.codeInsight.template.emmet.EmmetLexer;
import com.intellij.codeInsight.template.emmet.EmmetParser;
import com.intellij.codeInsight.template.emmet.filters.SingleLineEmmetFilter;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.nodes.FilterNode;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.TemplateNode;
import com.intellij.codeInsight.template.emmet.nodes.TextNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.TextToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZenCodingTemplate
extends CustomLiveTemplateBase {
    public static final char MARKER = '\u0000';
    private static final String EMMET_RECENT_WRAP_ABBREVIATIONS_KEY = "emmet.recent.wrap.abbreviations";
    private static final String EMMET_LAST_WRAP_ABBREVIATIONS_KEY = "emmet.last.wrap.abbreviations";
    private static final Logger LOG = Logger.getInstance(ZenCodingTemplate.class);
    private static final String DOCUMENTATION = "Wraps text with HTML generated by Emmet abbreviation. It takes an abbreviation, expands it and places currently selected content in the last element of generated snippet.<p/>By default, when you wrap something, Emmet puts original content inside the latest element.<p/>You can control the output position with <code>$#</code> placeholder.";
    private static final EmmetAbbreviationBalloon.EmmetContextHelp CONTEXT_HELP = new EmmetAbbreviationBalloon.EmmetContextHelp("Wraps text with HTML generated by Emmet abbreviation. It takes an abbreviation, expands it and places currently selected content in the last element of generated snippet.<p/>By default, when you wrap something, Emmet puts original content inside the latest element.<p/>You can control the output position with <code>$#</code> placeholder.", "More at docs.emmet.io", "https://docs.emmet.io/actions/wrap-with-abbreviation/");

    @Nullable
    public static ZenCodingGenerator findApplicableDefaultGenerator(@NotNull CustomTemplateCallback callback, boolean wrapping) {
        PsiElement context = callback.getContext();
        if (!context.isValid()) {
            return null;
        }
        for (ZenCodingGenerator generator : ZenCodingGenerator.getInstances()) {
            if (!generator.isMyContext(callback, wrapping) || !generator.isAppliedByDefault(context)) continue;
            return generator;
        }
        return null;
    }

    @Nullable
    public static ZenCodingNode parse(@NotNull String text, @NotNull CustomTemplateCallback callback, @NotNull ZenCodingGenerator generator, @Nullable String surroundedText) {
        List<ZenCodingToken> tokens = new EmmetLexer().lex(text);
        if (tokens == null) {
            return null;
        }
        if (!ZenCodingTemplate.validate(tokens, generator)) {
            return null;
        }
        EmmetParser parser = generator.createParser(tokens, callback, generator, surroundedText != null);
        ZenCodingNode node = parser.parse();
        if (parser.getIndex() != tokens.size() || node instanceof TextNode) {
            return null;
        }
        return node;
    }

    private static boolean validate(@NotNull List<ZenCodingToken> tokens, @NotNull ZenCodingGenerator generator) {
        for (ZenCodingToken token : tokens) {
            if (!(token instanceof TextToken) || generator instanceof XmlZenCodingGenerator) continue;
            return false;
        }
        return true;
    }

    public static boolean checkTemplateKey(@NotNull String key, CustomTemplateCallback callback, @NotNull ZenCodingGenerator generator) {
        return ZenCodingTemplate.parse(key, callback, generator, null) != null;
    }

    public void expand(@NotNull String key, @NotNull CustomTemplateCallback callback) {
        ZenCodingGenerator defaultGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, false);
        if (defaultGenerator == null) {
            LOG.error("Cannot find defaultGenerator for key `" + key + "` at " + callback.getEditor().getCaretModel().getOffset() + " offset", new Attachment[]{AttachmentFactory.createAttachment((Document)callback.getEditor().getDocument())});
            return;
        }
        try {
            ZenCodingTemplate.expand(key, callback, defaultGenerator, Collections.emptyList(), true, Registry.intValue((String)"emmet.segments.limit"));
        }
        catch (EmmetException e) {
            CommonRefactoringUtil.showErrorHint((Project)callback.getProject(), (Editor)callback.getEditor(), (String)e.getMessage(), (String)XmlBundle.message((String)"emmet.error", (Object[])new Object[0]), (String)"");
        }
    }

    @Nullable
    private static ZenCodingGenerator findApplicableGenerator(ZenCodingNode node, CustomTemplateCallback callback, boolean wrapping) {
        ZenCodingGenerator defaultGenerator = null;
        List<ZenCodingGenerator> generators = ZenCodingGenerator.getInstances();
        PsiElement context = callback.getContext();
        for (ZenCodingGenerator generator : generators) {
            if (!generator.isMyContext(callback, wrapping) || !generator.isAppliedByDefault(context)) continue;
            defaultGenerator = generator;
            break;
        }
        while (node instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node;
            String suffix = filterNode.getFilter();
            for (ZenCodingGenerator generator : generators) {
                if (!generator.isMyContext(callback, wrapping) || suffix == null || !suffix.equals(generator.getSuffix())) continue;
                return generator;
            }
            node = filterNode.getNode();
        }
        return defaultGenerator;
    }

    @NotNull
    private static List<ZenCodingFilter> getFilters(ZenCodingNode node, PsiElement context) {
        ArrayList<ZenCodingFilter> result = new ArrayList<ZenCodingFilter>();
        while (node instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node;
            String filterSuffix = filterNode.getFilter();
            for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
                if (!filter.isMyContext(context) || !filter.getSuffix().equals(filterSuffix)) continue;
                result.add(filter);
            }
            node = filterNode.getNode();
        }
        for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
            if (!filter.isMyContext(context) || !filter.isAppliedByDefault(context)) continue;
            result.add(filter);
        }
        Collections.reverse(result);
        return result;
    }

    public static void expand(@NotNull String key, @NotNull CustomTemplateCallback callback, @NotNull ZenCodingGenerator defaultGenerator, @NotNull Collection<? extends ZenCodingFilter> extraFilters, boolean expandPrimitiveAbbreviations, int segmentsLimit) throws EmmetException {
        ZenCodingNode node = ZenCodingTemplate.parse(key, callback, defaultGenerator, null);
        if (node == null) {
            return;
        }
        if (node instanceof TemplateNode && key.equals(((TemplateNode)node).getTemplateToken().getKey()) && callback.findApplicableTemplates(key).size() > 1) {
            Map template2Argument;
            TemplateManagerImpl templateManager = (TemplateManagerImpl)callback.getTemplateManager();
            Runnable runnable = templateManager.startNonCustomTemplates(template2Argument = templateManager.findMatchingTemplates(callback.getFile(), callback.getEditor(), null, TemplateSettings.getInstance()), callback.getEditor(), null);
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        PsiElement context = callback.getContext();
        ZenCodingGenerator generator = (ZenCodingGenerator)ObjectUtils.notNull((Object)ZenCodingTemplate.findApplicableGenerator(node, callback, false), (Object)defaultGenerator);
        List<ZenCodingFilter> filters = ZenCodingTemplate.getFilters(node, context);
        filters.addAll(extraFilters);
        ZenCodingTemplate.checkTemplateOutputLength(node, callback);
        callback.deleteTemplateKey(key);
        ZenCodingTemplate.expand(node, generator, filters, null, callback, expandPrimitiveAbbreviations, segmentsLimit);
    }

    private static void expand(ZenCodingNode node, ZenCodingGenerator generator, List<ZenCodingFilter> filters, String surroundedText, CustomTemplateCallback callback, boolean expandPrimitiveAbbreviations, int segmentsLimit) throws EmmetException {
        ZenCodingTemplate.checkTemplateOutputLength(node, callback);
        GenerationNode fakeParentNode = new GenerationNode(TemplateToken.EMPTY_TEMPLATE_TOKEN, -1, 1, surroundedText, true, null);
        node.expand(-1, 1, surroundedText, callback, true, fakeParentNode);
        if (!expandPrimitiveAbbreviations && ZenCodingTemplate.isPrimitiveNode(node)) {
            return;
        }
        List<GenerationNode> genNodes = fakeParentNode.getChildren();
        LiveTemplateBuilder builder = new LiveTemplateBuilder(EmmetOptions.getInstance().isAddEditPointAtTheEndOfTemplate(), segmentsLimit);
        int end = -1;
        int genNodesSize = genNodes.size();
        for (int i = 0; i < genNodesSize; ++i) {
            GenerationNode genNode = genNodes.get(i);
            TemplateImpl template = genNode.generate(callback, generator, filters, true, segmentsLimit);
            int e = builder.insertTemplate(builder.length(), template, null);
            if (i < genNodesSize - 1 && genNode.isInsertNewLineBetweenNodes()) {
                builder.insertText(e, "\n", false);
                ++e;
            }
            if (end != -1 || end >= builder.length()) continue;
            end = e;
        }
        for (ZenCodingFilter filter : filters) {
            if (!(filter instanceof SingleLineEmmetFilter)) continue;
            builder.setIsToReformat(false);
            break;
        }
        callback.startTemplate((Template)builder.buildTemplate(), null, null);
    }

    private static void checkTemplateOutputLength(ZenCodingNode node, CustomTemplateCallback callback) throws EmmetException {
        int predictedOutputLength = node.getApproximateOutputLength(callback);
        if (predictedOutputLength > 15360) {
            throw new EmmetException();
        }
    }

    private static boolean isPrimitiveNode(@NotNull ZenCodingNode node) {
        TemplateToken token;
        if (node instanceof TemplateNode && (token = ((TemplateNode)node).getTemplateToken()) != null) {
            Map<String, String> attributes = token.getAttributes();
            return attributes.isEmpty() || attributes.containsKey("class") && StringUtil.isEmpty((String)attributes.get("class"));
        }
        return false;
    }

    public void wrap(@NotNull String selection, final @NotNull CustomTemplateCallback callback) {
        new EmmetAbbreviationBalloon(EMMET_RECENT_WRAP_ABBREVIATIONS_KEY, EMMET_LAST_WRAP_ABBREVIATIONS_KEY, new EmmetAbbreviationBalloon.Callback(){

            @Override
            public void onEnter(@NotNull String abbreviation) {
                ZenCodingTemplate.doWrap(abbreviation, callback);
            }
        }, CONTEXT_HELP).show(callback);
    }

    public static boolean checkTemplateKey(String inputString, CustomTemplateCallback callback) {
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, true);
        if (generator == null) {
            int offset = callback.getEditor().getCaretModel().getOffset();
            LOG.error("Emmet is disabled for context for file " + callback.getFileType().getName() + " in offset: " + offset, new Attachment[]{AttachmentFactory.createAttachment((Document)callback.getEditor().getDocument())});
            return false;
        }
        return ZenCodingTemplate.checkTemplateKey(inputString, callback, generator);
    }

    public boolean isApplicable(@NotNull CustomTemplateCallback callback, int offset, boolean wrapping) {
        ZenCodingGenerator applicableGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, wrapping);
        return applicableGenerator != null && applicableGenerator.isEnabled();
    }

    public boolean hasCompletionItem(@NotNull CustomTemplateCallback callback, int offset) {
        ZenCodingGenerator applicableGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, false);
        return applicableGenerator != null && applicableGenerator.isEnabled() && applicableGenerator.hasCompletionItem();
    }

    public static void doWrap(@NotNull String abbreviation, @NotNull CustomTemplateCallback callback) {
        ZenCodingGenerator defaultGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, true);
        assert (defaultGenerator != null);
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(callback.getProject(), () -> callback.getEditor().getCaretModel().runForEachCaret(__ -> {
            String selectedText = callback.getEditor().getSelectionModel().getSelectedText();
            if (selectedText != null) {
                ZenCodingNode node = ZenCodingTemplate.parse(abbreviation, callback, defaultGenerator, selectedText);
                assert (node != null);
                PsiElement context = callback.getContext();
                ZenCodingGenerator generator = ZenCodingTemplate.findApplicableGenerator(node, callback, true);
                List<ZenCodingFilter> filters = ZenCodingTemplate.getFilters(node, context);
                EditorModificationUtil.deleteSelectedText((Editor)callback.getEditor());
                PsiDocumentManager.getInstance((Project)callback.getProject()).commitAllDocuments();
                try {
                    ZenCodingTemplate.expand(node, generator, filters, selectedText, callback, true, Registry.intValue((String)"emmet.segments.limit"));
                }
                catch (EmmetException e) {
                    CommonRefactoringUtil.showErrorHint((Project)callback.getProject(), (Editor)callback.getEditor(), (String)e.getMessage(), (String)XmlBundle.message((String)"emmet.error", (Object[])new Object[0]), (String)"");
                }
            }
        }), CodeInsightBundle.message((String)"insert.code.template.command", (Object[])new Object[0]), null));
    }

    @NotNull
    public String getTitle() {
        return XmlBundle.message((String)"emmet.title", (Object[])new Object[0]);
    }

    public char getShortcut() {
        return (char)EmmetOptions.getInstance().getEmmetExpandShortcut();
    }

    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, false);
        if (generator == null) {
            return null;
        }
        return generator.computeTemplateKey(callback);
    }

    public boolean supportsWrapping() {
        return true;
    }

    public void addCompletions(CompletionParameters parameters, CompletionResultSet result) {
        if (!parameters.isAutoPopup()) {
            return;
        }
        PsiFile file = parameters.getPosition().getContainingFile();
        int offset = parameters.getOffset();
        Editor editor = parameters.getEditor();
        CollectCustomTemplateCallback callback = new CollectCustomTemplateCallback(editor, file);
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, false);
        if (generator != null && generator.addToCompletion()) {
            String templatePrefix = this.computeTemplateKeyWithoutContextChecking(callback);
            if (templatePrefix != null) {
                List regularTemplates = TemplateManagerImpl.listApplicableTemplates((TemplateActionContext)TemplateActionContext.expanding((PsiFile)file, (int)offset));
                boolean regularTemplateWithSamePrefixExists = !ContainerUtil.filter((Collection)regularTemplates, template -> templatePrefix.equals(template.getKey())).isEmpty();
                result = result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(templatePrefix));
                result.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().startsWith(templatePrefix));
                if (!regularTemplateWithSamePrefixExists) {
                    LinkedList extraFilters = ContainerUtil.newLinkedList((Object[])new SingleLineEmmetFilter[]{new SingleLineEmmetFilter()});
                    try {
                        ZenCodingTemplate.expand(templatePrefix, callback, generator, extraFilters, false, 0);
                    }
                    catch (EmmetException emmetException) {
                        // empty catch block
                    }
                    TemplateImpl template2 = callback.getGeneratedTemplate();
                    if (template2 != null) {
                        template2.setKey(templatePrefix);
                        template2.setDescription(template2.getTemplateText());
                        CustomLiveTemplateLookupElement lookupElement = new CustomLiveTemplateLookupElement(this, template2.getKey(), template2.getKey(), template2.getDescription(), !LiveTemplateCompletionContributor.shouldShowAllTemplates(), true){

                            public void renderElement(LookupElementPresentation presentation) {
                                super.renderElement(presentation);
                                presentation.setTailText("\t Emmet abbreviation", true);
                            }
                        };
                        result.addElement((LookupElement)lookupElement);
                    }
                }
            } else if (result.getPrefixMatcher().getPrefix().isEmpty()) {
                result.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().longerThan(0));
            }
        }
    }
}

