/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DtdSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof XmlAttlistDecl || e instanceof XmlElementDecl;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        PsiElement[] children = e.getChildren();
        XmlToken first = null;
        XmlToken last = null;
        for (PsiElement child : children) {
            if (!(child instanceof XmlToken)) continue;
            XmlToken token = (XmlToken)child;
            if (token.getTokenType() == XmlTokenType.XML_TAG_END) {
                last = token;
                break;
            }
            if (token.getTokenType() != XmlTokenType.XML_ELEMENT_DECL_START && token.getTokenType() != XmlTokenType.XML_ATTLIST_DECL_START) continue;
            first = token;
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>(1);
        if (first != null && last != null) {
            int offset = last.getTextRange().getEndOffset() + 1;
            result.addAll(ExtendWordSelectionHandlerBase.expandToWholeLine((CharSequence)editorText, (TextRange)new TextRange(first.getTextRange().getStartOffset(), Math.min(offset, editorText.length())), (boolean)false));
        }
        return result;
    }
}

