/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionUtil;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlHighlightVisitorBasedInspection
extends GlobalSimpleInspectionTool {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    public void checkFile(final @NotNull PsiFile file, final @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, final @NotNull GlobalInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        HighlightInfoHolder myHolder = new HighlightInfoHolder(file, new HighlightInfoFilter[0]){

            public boolean add(@Nullable HighlightInfo info) {
                if (info != null) {
                    GlobalInspectionUtil.createProblem((PsiElement)file, (HighlightInfo)info, (TextRange)new TextRange(info.startOffset, info.endOffset), null, (InspectionManager)manager, (ProblemDescriptionsProcessor)problemDescriptionsProcessor, (GlobalInspectionContext)globalContext);
                }
                return true;
            }
        };
        final XmlHighlightVisitor highlightVisitor = new XmlHighlightVisitor();
        highlightVisitor.analyze(file, true, myHolder, new Runnable(){

            @Override
            public void run() {
                file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitElement(@NotNull PsiElement element) {
                        highlightVisitor.visit(element);
                        super.visitElement(element);
                    }
                });
            }
        });
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return XmlHighlightVisitorBasedInspection.getGeneralGroupName();
    }

    @NotNull
    public String getShortName() {
        return "XmlHighlighting";
    }
}

