/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KotlinIdeaReplBundle;
import org.jetbrains.kotlin.console.KotlinConsoleKeeper;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/console/actions/KtExecuteCommandAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "consoleFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "kotlin.repl"})
public final class KtExecuteCommandAction
extends AnAction {
    private final VirtualFile consoleFile;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            RunExecuteActionsKt.errorNotification(null, KotlinIdeaReplBundle.message("cannot.find.project", new Object[0]));
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return erro\u2026e(\"cannot.find.project\"))");
        Project project2 = project;
        KotlinConsoleRunner kotlinConsoleRunner = KotlinConsoleKeeper.Companion.getInstance(project2).getConsoleByVirtualFile(this.consoleFile);
        if (kotlinConsoleRunner == null) {
            return;
        }
        KotlinConsoleRunner ktConsole = kotlinConsoleRunner;
        ktConsole.getExecutor().executeCommand();
    }

    public KtExecuteCommandAction(@NotNull VirtualFile consoleFile) {
        Intrinsics.checkNotNullParameter((Object)consoleFile, (String)"consoleFile");
        this.consoleFile = consoleFile;
    }
}

