/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceIdentifier;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class XmlResourceMapChunk
extends Chunk {
    private static final int RESOURCE_SIZE = 4;
    private final List<Integer> resources = new ArrayList<Integer>();

    protected XmlResourceMapChunk(ByteBuffer buffer, Chunk parent) {
        super(buffer, parent);
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        this.resources.addAll(this.enumerateResources(buffer));
    }

    private List<Integer> enumerateResources(ByteBuffer buffer) {
        int resourceCount = (this.getOriginalChunkSize() - this.getHeaderSize()) / 4;
        ArrayList<Integer> result2 = new ArrayList<Integer>(resourceCount);
        int offset = this.offset + this.getHeaderSize();
        buffer.mark();
        buffer.position(offset);
        for (int i = 0; i < resourceCount; ++i) {
            result2.add(buffer.getInt());
        }
        buffer.reset();
        return result2;
    }

    public BinaryResourceIdentifier getResourceId(int attributeId) {
        return BinaryResourceIdentifier.create(this.resources.get(attributeId));
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.XML_RESOURCE_MAP;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        super.writePayload(output, header, shrink);
        for (Integer resource : this.resources) {
            output.writeInt(resource);
        }
    }
}

