/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.PackageChunk;
import com.google.devrel.gmscore.tools.apk.arsc.ResourceTableChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeChunk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ArscBlamer {
    private final Map<PackageChunk, List<ResourceEntry>[]> keyToBlame = new HashMap<PackageChunk, List<ResourceEntry>[]>();
    private final Map<PackageChunk, List<ResourceEntry>[]> typeToBlame = new HashMap<PackageChunk, List<ResourceEntry>[]>();
    private final Multimap<PackageChunk, ResourceEntry> packageToBlame = HashMultimap.create();
    private final List<ResourceEntry>[] stringToBlame;
    private final Multimap<TypeChunk.Entry, ResourceEntry> typeEntryToBlame = HashMultimap.create();
    private Multimap<ResourceEntry, TypeChunk.Entry> resourceEntries;
    private Multimap<ResourceEntry, TypeChunk.Entry> baselessKeys;
    private List<TypeChunk> typeChunks;
    private final ResourceTableChunk resourceTable;

    public ArscBlamer(ResourceTableChunk resourceTable) {
        this.resourceTable = resourceTable;
        this.stringToBlame = ArscBlamer.createEntryListArray(resourceTable.getStringPool().getStringCount());
    }

    public void blame() {
        Multimap<ResourceEntry, TypeChunk.Entry> entries = this.getResourceEntries();
        for (Map.Entry entry : entries.asMap().entrySet()) {
            ResourceEntry resourceEntry = (ResourceEntry)entry.getKey();
            PackageChunk packageChunk = (PackageChunk)Preconditions.checkNotNull((Object)this.resourceTable.getPackage(resourceEntry.packageName()));
            int keyCount = packageChunk.getKeyStringPool().getStringCount();
            int typeCount = packageChunk.getTypeStringPool().getStringCount();
            for (TypeChunk.Entry chunkEntry : (Collection)entry.getValue()) {
                this.blameKeyOrType(this.keyToBlame, packageChunk, chunkEntry.keyIndex(), resourceEntry, keyCount);
                this.blameKeyOrType(this.typeToBlame, packageChunk, chunkEntry.parent().getId() - 1, resourceEntry, typeCount);
                this.blameFromTypeChunkEntry(chunkEntry);
            }
            this.blamePackage(packageChunk, resourceEntry);
        }
        Multimaps.invertFrom(entries, this.typeEntryToBlame);
        for (TypeChunk.Entry entry : this.typeEntryToBlame.keySet()) {
            this.blameFromTypeChunkEntry(entry);
        }
    }

    private void blameKeyOrType(Map<PackageChunk, List<ResourceEntry>[]> keyOrType, PackageChunk packageChunk, int keyIndex, ResourceEntry entry, int entryCount) {
        if (!keyOrType.containsKey(packageChunk)) {
            keyOrType.put(packageChunk, ArscBlamer.createEntryListArray(entryCount));
        }
        keyOrType.get(packageChunk)[keyIndex].add(entry);
    }

    private void blamePackage(PackageChunk packageChunk, ResourceEntry entry) {
        this.packageToBlame.put((Object)packageChunk, (Object)entry);
    }

    private void blameFromTypeChunkEntry(TypeChunk.Entry chunkEntry) {
        for (BinaryResourceValue value : this.getAllResourceValues(chunkEntry)) {
            for (ResourceEntry entry : this.typeEntryToBlame.get((Object)chunkEntry)) {
                switch (value.type()) {
                    case STRING: {
                        this.blameString(value.data(), entry);
                        break;
                    }
                }
            }
        }
    }

    private Collection<BinaryResourceValue> getAllResourceValues(TypeChunk.Entry entry) {
        HashSet<BinaryResourceValue> values = new HashSet<BinaryResourceValue>();
        BinaryResourceValue binaryResourceValue = entry.value();
        if (binaryResourceValue != null) {
            values.add(binaryResourceValue);
        }
        for (BinaryResourceValue value : entry.values().values()) {
            values.add(value);
        }
        return values;
    }

    private void blameString(int stringIndex, ResourceEntry entry) {
        this.stringToBlame[stringIndex].add(entry);
    }

    public Map<PackageChunk, List<ResourceEntry>[]> getKeyToBlamedResources() {
        return Collections.unmodifiableMap(this.keyToBlame);
    }

    public Map<PackageChunk, List<ResourceEntry>[]> getTypeToBlamedResources() {
        return Collections.unmodifiableMap(this.typeToBlame);
    }

    public Multimap<PackageChunk, ResourceEntry> getPackageToBlamedResources() {
        return Multimaps.unmodifiableMultimap(this.packageToBlame);
    }

    public List<ResourceEntry>[] getStringToBlamedResources() {
        return this.stringToBlame;
    }

    public Multimap<TypeChunk.Entry, ResourceEntry> getTypeEntryToBlamedResources() {
        return Multimaps.unmodifiableMultimap(this.typeEntryToBlame);
    }

    public Multimap<ResourceEntry, TypeChunk.Entry> getBaselessKeys() {
        if (this.baselessKeys != null) {
            return this.baselessKeys;
        }
        HashMultimap result2 = HashMultimap.create();
        for (Map.Entry entry : this.getResourceEntries().asMap().entrySet()) {
            Collection chunkEntries = (Collection)entry.getValue();
            if (this.hasBaseConfiguration(chunkEntries)) continue;
            result2.putAll(entry.getKey(), (Iterable)chunkEntries);
        }
        this.baselessKeys = result2;
        return result2;
    }

    public Multimap<ResourceEntry, TypeChunk.Entry> getResourceEntries() {
        if (this.resourceEntries != null) {
            return this.resourceEntries;
        }
        HashMultimap result2 = HashMultimap.create();
        for (TypeChunk typeChunk : this.getTypeChunks()) {
            for (TypeChunk.Entry entry : typeChunk.getEntries().values()) {
                result2.put((Object)ResourceEntry.create(entry), (Object)entry);
            }
        }
        this.resourceEntries = result2;
        return result2;
    }

    public List<TypeChunk> getTypeChunks() {
        if (this.typeChunks != null) {
            return this.typeChunks;
        }
        ArrayList<TypeChunk> result2 = new ArrayList<TypeChunk>();
        for (PackageChunk packageChunk : this.resourceTable.getPackages()) {
            for (TypeChunk typeChunk : packageChunk.getTypeChunks()) {
                result2.add(typeChunk);
            }
        }
        this.typeChunks = result2;
        return result2;
    }

    private boolean hasBaseConfiguration(Collection<TypeChunk.Entry> entries) {
        for (TypeChunk.Entry entry : entries) {
            if (!entry.parent().getConfiguration().isDefault()) continue;
            return true;
        }
        return false;
    }

    private static List<ResourceEntry>[] createEntryListArray(int size) {
        ArrayListResourceEntry[] result2 = new ArrayListResourceEntry[size];
        for (int i = 0; i < size; ++i) {
            result2[i] = new ArrayListResourceEntry();
        }
        return result2;
    }

    public static class ResourceEntry {
        private final String packageName;
        private final String typeName;
        private final String entryName;

        static ResourceEntry create(TypeChunk.Entry entry) {
            PackageChunk packageChunk = (PackageChunk)Preconditions.checkNotNull((Object)entry.parent().getPackageChunk());
            String packageName = packageChunk.getPackageName();
            String typeName = entry.typeName();
            String entryName = entry.key();
            return new ResourceEntry(packageName, typeName, entryName);
        }

        private ResourceEntry(String packageName, String typeName, String entryName) {
            this.packageName = packageName;
            this.typeName = typeName;
            this.entryName = entryName;
        }

        public String packageName() {
            return this.packageName;
        }

        public String typeName() {
            return this.typeName;
        }

        public String entryName() {
            return this.entryName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceEntry that = (ResourceEntry)o;
            return Objects.equals(this.packageName, that.packageName) && Objects.equals(this.typeName, that.typeName) && Objects.equals(this.entryName, that.entryName);
        }

        public int hashCode() {
            return Objects.hash(this.packageName, this.typeName, this.entryName);
        }
    }

    private static class ArrayListResourceEntry
    extends ArrayList<ResourceEntry> {
        private ArrayListResourceEntry() {
            super(2);
        }
    }
}

