/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Archive;
import com.android.zipflinger.CentralDirectory;
import com.android.zipflinger.CentralDirectoryRecord;
import com.android.zipflinger.Compressor;
import com.android.zipflinger.EndOfCentralDirectory;
import com.android.zipflinger.Entry;
import com.android.zipflinger.ExtractionInfo;
import com.android.zipflinger.FreeStore;
import com.android.zipflinger.LocalFileHeader;
import com.android.zipflinger.Location;
import com.android.zipflinger.Source;
import com.android.zipflinger.Zip64;
import com.android.zipflinger.Zip64Eocd;
import com.android.zipflinger.Zip64Locator;
import com.android.zipflinger.ZipInfo;
import com.android.zipflinger.ZipMap;
import com.android.zipflinger.ZipReader;
import com.android.zipflinger.ZipSource;
import com.android.zipflinger.ZipWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ZipArchive
implements Archive {
    private final FreeStore freestore;
    private boolean closed;
    private final File file;
    private final CentralDirectory cd;
    private final ZipWriter writer;
    private final ZipReader reader;
    private final Zip64.Policy policy;
    private ZipInfo zipInfo;
    private boolean modified;

    public ZipArchive(File file) throws IOException {
        this(file, Zip64.Policy.ALLOW);
    }

    public ZipArchive(File file, Zip64.Policy policy) throws IOException {
        this.file = file;
        this.policy = policy;
        if (Files.exists(file.toPath(), new LinkOption[0])) {
            ZipMap map = ZipMap.from(file, true, policy);
            this.zipInfo = new ZipInfo(map.getPayloadLocation(), map.getCdLoc(), map.getEocdLoc());
            this.cd = map.getCentralDirectory();
            this.freestore = new FreeStore(map.getEntries());
        } else {
            this.zipInfo = new ZipInfo();
            LinkedHashMap<String, Entry> entries = new LinkedHashMap<String, Entry>();
            this.cd = new CentralDirectory(ByteBuffer.allocate(0), entries);
            this.freestore = new FreeStore(entries);
        }
        this.writer = new ZipWriter(file);
        this.reader = new ZipReader(file);
        this.closed = false;
        this.modified = false;
    }

    public static Map<String, Entry> listEntries(File file) throws IOException {
        return ZipMap.from(file, false).getEntries();
    }

    public List<String> listEntries() {
        return this.cd.listEntries();
    }

    public ByteBuffer getContent(String name) throws IOException {
        ExtractionInfo extractInfo = this.cd.getExtractionInfo(name);
        if (extractInfo == null) {
            return null;
        }
        Location loc = extractInfo.getLocation();
        ByteBuffer payloadByteBuffer = ByteBuffer.allocate(Math.toIntExact(loc.size()));
        this.reader.read(payloadByteBuffer, loc.first);
        if (extractInfo.isCompressed()) {
            return Compressor.inflate(payloadByteBuffer.array());
        }
        return payloadByteBuffer;
    }

    @Override
    public void add(Source source) throws IOException {
        if (this.closed) {
            throw new IllegalStateException(String.format("Cannot add source to closed archive %s", this.file));
        }
        this.writeSource(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ZipSource sources) throws IOException {
        if (this.closed) {
            throw new IllegalStateException(String.format("Cannot add zip source to closed archive %s", this.file));
        }
        try {
            sources.open();
            for (Source source : sources.getSelectedEntries()) {
                this.writeSource(source);
            }
        }
        finally {
            sources.close();
        }
    }

    @Override
    public void delete(String name) {
        if (this.closed) {
            throw new IllegalStateException(String.format("Cannot delete '%s' from closed archive %s", name, this.file));
        }
        Location loc = this.cd.delete(name);
        if (loc.isValid()) {
            this.freestore.free(loc);
            this.modified = true;
        }
    }

    @Override
    public void close() throws IOException {
        this.closeWithInfo();
    }

    public ZipInfo closeWithInfo() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Attempt to close a closed archive");
        }
        this.closed = true;
        try (ZipWriter w = this.writer;
             ZipReader r = this.reader;){
            this.writeArchive(w);
        }
        return this.zipInfo;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void writeArchive(ZipWriter writer) throws IOException {
        if (this.zipInfo.eocd.isValid() && !this.modified) {
            return;
        }
        List<Location> freeLocations = this.freestore.getFreeLocations();
        for (int i = 0; i < freeLocations.size() - 1; ++i) {
            ZipArchive.fillFreeLocation(freeLocations.get(i), writer);
        }
        Location lastFreeLocation = this.freestore.getLastFreeLocation();
        long cdStart = lastFreeLocation.first;
        writer.position(cdStart);
        this.cd.write(writer);
        Location cdLocation = new Location(cdStart, writer.position() - cdStart);
        long numEntries = this.cd.getNumEntries();
        this.writeZip64Footers(writer, cdLocation, numEntries);
        Location eocdLocation = EndOfCentralDirectory.write(writer, cdLocation, numEntries);
        writer.truncate(writer.position());
        Location payLoadLocation = new Location(0L, cdStart);
        this.zipInfo = new ZipInfo(payLoadLocation, cdLocation, eocdLocation);
    }

    private void writeZip64Footers(ZipWriter writer, Location cdLocation, long numEntries) throws IOException {
        if (!Zip64.needZip64Footer(numEntries, cdLocation)) {
            return;
        }
        if (this.policy == Zip64.Policy.FORBID) {
            String message2 = String.format("Zip64 required but forbidden (#entries=%d, cd=%s)", numEntries, cdLocation);
            throw new IllegalStateException(message2);
        }
        Zip64Eocd eocd = new Zip64Eocd(numEntries, cdLocation);
        Location eocdLocation = eocd.write(writer);
        Zip64Locator.write(writer, eocdLocation);
    }

    private static void fillFreeLocation(Location location, ZipWriter writer) throws IOException {
        long spaceToFill = location.size();
        if (spaceToFill < 30L) {
            return;
        }
        while (spaceToFill > 0L) {
            long entrySize = spaceToFill <= 65565L ? spaceToFill : 65535L;
            int size = Math.toIntExact(entrySize);
            ByteBuffer virtualEntry = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
            LocalFileHeader.fillVirtualEntry(virtualEntry);
            writer.write(virtualEntry, location.first + location.size() - spaceToFill);
            spaceToFill -= (long)virtualEntry.capacity();
        }
    }

    private void writeSource(Source source) throws IOException {
        Location loc;
        this.modified = true;
        this.validateName(source);
        source.prepare();
        LocalFileHeader lfh = new LocalFileHeader(source);
        long headerSize = lfh.getSize();
        long bytesNeeded = headerSize + source.getCompressedSize();
        if (source.isAligned()) {
            loc = this.freestore.alloc(bytesNeeded, headerSize, source.getAlignment());
            lfh.setPadding(Math.toIntExact(loc.size() - bytesNeeded));
        } else {
            loc = this.freestore.ualloc(bytesNeeded);
        }
        this.writer.position(loc.first);
        lfh.write(this.writer);
        long payloadStart = this.writer.position();
        long payloadSize = source.writeTo(this.writer);
        Location payloadLocation = new Location(payloadStart, payloadSize);
        CentralDirectoryRecord cdRecord = new CentralDirectoryRecord(source, loc, payloadLocation);
        this.cd.add(source.getName(), cdRecord);
        this.checkPolicy(source, loc, payloadLocation);
    }

    private void checkPolicy(Source source, Location cdloc, Location payloadLoc) {
        if (this.policy == Zip64.Policy.ALLOW) {
            return;
        }
        if (source.getUncompressedSize() >= 0xFFFFFFFFL || source.getCompressedSize() >= 0xFFFFFFFFL || cdloc.first >= 0xFFFFFFFFL || payloadLoc.first >= 0xFFFFFFFFL) {
            String message2 = String.format("Zip64 forbidden but required in entry %s size=%d, csize=%d, cdloc=%s, loc=%s", source.getName(), source.getUncompressedSize(), source.getCompressedSize(), cdloc, payloadLoc);
            throw new IllegalStateException(message2);
        }
    }

    private void validateName(Source source) {
        byte[] nameBytes = source.getNameBytes();
        String name = source.getName();
        if ((long)nameBytes.length > 65535L) {
            throw new IllegalStateException(String.format("Name '%s' is more than %d bytes", name, 65535L));
        }
        if (this.cd.contains(name)) {
            throw new IllegalStateException(String.format("Entry name '%s' collided", name));
        }
    }
}

