/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.OtherFileScanner;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\r\u001a\u00020\tH\u0002J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/client/api/OtherFileVisitor;", "", "detectors", "", "Lcom/android/tools/lint/detector/api/Detector;", "(Ljava/util/List;)V", "files", "Ljava/util/EnumMap;", "Lcom/android/tools/lint/detector/api/Scope;", "Ljava/io/File;", "collectFiles", "", "", "file", "scan", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "main", "android.sdktools.lint-api"})
public final class OtherFileVisitor {
    private final EnumMap<Scope, List<File>> files;
    private final List<Detector> detectors;

    /*
     * WARNING - void declaration
     */
    public final void scan(@NotNull LintDriver driver, @NotNull Project project, @Nullable Project main) {
        List<File> manifestFiles;
        ArrayList<File> files;
        Object applicable;
        File projectFolder = project.getDir();
        EnumSet<Scope> scopes = EnumSet.noneOf(Scope.class);
        Object object = this.detectors.iterator();
        while (object.hasNext()) {
            Detector detector;
            Detector detector2 = detector = object.next();
            if (detector2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.tools.lint.detector.api.OtherFileScanner");
            }
            OtherFileScanner fileScanner = (OtherFileScanner)((Object)detector2);
            applicable = fileScanner.getApplicableFiles();
            if (((AbstractCollection)applicable).contains((Object)Scope.OTHER)) {
                scopes = Scope.ALL;
                break;
            }
            scopes.addAll((Collection)applicable);
        }
        List<File> subset = project.getSubset();
        if (scopes.contains((Object)Scope.RESOURCE_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList<File>(subset.size());
                for (File file : subset) {
                    if (!SdkUtils.endsWith((CharSequence)file.getPath(), (CharSequence)".xml") || !(Intrinsics.areEqual((Object)file.getName(), (Object)"AndroidManifest.xml") ^ true)) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.RESOURCE_FILE, files);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File res : project.getResourceFolders()) {
                    this.collectFiles((List<File>)files, res);
                }
                File assets = new File(projectFolder, "assets");
                if (assets.exists()) {
                    this.collectFiles((List<File>)files, assets);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.RESOURCE_FILE, files);
                }
            }
        }
        if (scopes.contains((Object)Scope.JAVA_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList<File>(subset.size());
                for (File file : subset) {
                    if (!StringsKt.endsWith$default((String)file.getPath(), (String)".java", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)file.getPath(), (String)".kt", (boolean)false, (int)2, null)) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.JAVA_FILE, files);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File srcFolder : project.getJavaSourceFolders()) {
                    this.collectFiles((List<File>)files, srcFolder);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.JAVA_FILE, files);
                }
            }
        }
        if (scopes.contains((Object)Scope.CLASS_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file : subset) {
                    if (!StringsKt.endsWith$default((String)file.getPath(), (String)".class", (boolean)false, (int)2, null)) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.CLASS_FILE, files);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File classFolder : project.getJavaClassFolders()) {
                    this.collectFiles((List<File>)files, classFolder);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.CLASS_FILE, files);
                }
            }
        }
        if (scopes.contains((Object)Scope.MANIFEST)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file : subset) {
                    if (!Intrinsics.areEqual((Object)file.getName(), (Object)"AndroidManifest.xml")) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.MANIFEST, files);
                }
            } else {
                manifestFiles = project.getManifestFiles();
                ((Map)this.files).put(Scope.MANIFEST, manifestFiles);
            }
        }
        if (scopes.contains((Object)Scope.GRADLE_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file : subset) {
                    if (!StringsKt.endsWith$default((String)file.getName(), (String)".gradle", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)file.getName(), (String)".kts", (boolean)false, (int)2, null)) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.GRADLE_FILE, files);
                }
            } else {
                manifestFiles = project.getGradleBuildScripts();
                ((Map)this.files).put(Scope.GRADLE_FILE, manifestFiles);
            }
        }
        if (scopes.contains((Object)Scope.PROGUARD_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file : subset) {
                    if (!StringsKt.startsWith$default((String)file.getName(), (String)"proguard", (boolean)false, (int)2, null)) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.PROPERTY_FILE, files);
                }
            } else {
                manifestFiles = project.getProguardFiles();
                ((Map)this.files).put(Scope.PROGUARD_FILE, manifestFiles);
            }
        }
        if (scopes.contains((Object)Scope.PROPERTY_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file : subset) {
                    if (!StringsKt.endsWith$default((String)file.getName(), (String)".properties", (boolean)false, (int)2, null)) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.PROPERTY_FILE, files);
                }
            } else {
                List<File> propertyFiles = project.getPropertyFiles();
                ((Map)this.files).put(Scope.PROPERTY_FILE, propertyFiles);
            }
        }
        applicable = this.files;
        boolean bl = false;
        Iterator iterator = applicable.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            applicable = (Scope)((Object)object2.getKey());
            object2 = object;
            bl2 = false;
            List files2 = (List)object2.getValue();
            ArrayList<Detector> applicable2 = new ArrayList<Detector>(this.detectors.size());
            Iterator<Detector> iterator2 = this.detectors.iterator();
            while (iterator2.hasNext()) {
                void scope;
                Detector detector;
                Detector detector3 = detector = iterator2.next();
                if (detector3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.tools.lint.detector.api.OtherFileScanner");
                }
                OtherFileScanner fileScanner = (OtherFileScanner)((Object)detector3);
                EnumSet<Scope> appliesTo = fileScanner.getApplicableFiles();
                if (!appliesTo.contains((Object)Scope.OTHER) && !appliesTo.contains(scope)) continue;
                applicable2.add(detector);
            }
            if (applicable2.isEmpty()) continue;
            for (File file : files2) {
                Context context2 = new Context(driver, project, main, file, null, 16, null);
                for (Detector detector : applicable2) {
                    detector.beforeCheckFile(context2);
                    detector.run(context2);
                    detector.afterCheckFile(context2);
                    LintDriver lintDriver = driver;
                    int n = lintDriver.getFileCount();
                    lintDriver.setFileCount(n + 1);
                }
            }
        }
    }

    private final void collectFiles(List<File> files, File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.collectFiles(files, child);
                }
            }
        } else {
            files.add(file);
        }
    }

    public OtherFileVisitor(@NotNull List<? extends Detector> detectors) {
        this.detectors = detectors;
        this.files = new EnumMap(Scope.class);
    }
}

