/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/PackageVisibilityDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "cachedQueryPermissions", "Lcom/android/tools/lint/checks/PackageVisibilityDetector$QueryPermissions;", "getApplicableElements", "", "", "getApplicableMethodNames", "", "getQueryPermissions", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "visitElement", "", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "visitMethodCall", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "QueryPermissions", "android.sdktools.lint-checks"})
public final class PackageVisibilityDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    private QueryPermissions cachedQueryPermissions;
    private static final int INITIAL_API = 30;
    @JvmField
    @NotNull
    public static final Issue QUERY_ALL_PACKAGES_PERMISSION;
    @JvmField
    @NotNull
    public static final Issue QUERY_PERMISSIONS_NEEDED;
    public static final Companion Companion;

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"uses-permission");
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        if (context2.getMainProject().getTargetSdk() < 30) {
            return;
        }
        if (Intrinsics.areEqual((Object)element.getTagName(), (Object)"uses-permission") ^ true) {
            return;
        }
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        if (attr == null) {
            return;
        }
        Attr permission = attr;
        if (Intrinsics.areEqual((Object)permission.getValue(), (Object)"android.permission.QUERY_ALL_PACKAGES")) {
            Context.report$default(context2, QUERY_ALL_PACKAGES_PERMISSION, context2.getLocation(permission), "A `<queries>` declaration should generally be used instead of QUERY_ALL_PACKAGES; \\\nsee https://g.co/dev/packagevisibility for details", null, 8, null);
        }
    }

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object[])new String[]{"getInstalledPackages", "getInstalledApplications", "queryBroadcastReceivers", "queryContentProviders", "queryIntentServices", "queryIntentActivities", "resolveActivity", "resolveActivityInfo"});
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        if (context.getMainProject().getTargetSdk() < 30) {
            return;
        }
        if (!context.isEnabled(PackageVisibilityDetector.QUERY_PERMISSIONS_NEEDED)) {
            return;
        }
        v0 = methodName = node.getMethodName();
        if (v0 == null) ** GOTO lbl-1000
        var6_5 = v0;
        tmp = -1;
        switch (var6_5.hashCode()) {
            case -150905391: {
                if (!var6_5.equals("getInstalledPackages")) break;
                tmp = 1;
                break;
            }
            case 1700882705: {
                if (!var6_5.equals("queryContentProviders")) break;
                tmp = 1;
                break;
            }
            case 1600494599: {
                if (!var6_5.equals("getInstalledApplications")) break;
                tmp = 1;
                break;
            }
            case -1721890933: {
                if (!var6_5.equals("queryBroadcastReceivers")) break;
                tmp = 1;
                break;
            }
            case -109758974: {
                if (!var6_5.equals("queryIntentServices")) break;
                tmp = 1;
                break;
            }
            case 1374193809: {
                if (!var6_5.equals("queryIntentActivities")) break;
                tmp = 1;
                break;
            }
            case -1219166103: {
                if (!var6_5.equals("resolveActivityInfo")) break;
                tmp = 2;
                break;
            }
            case 630467867: {
                if (!var6_5.equals("resolveActivity")) break;
                tmp = 2;
                break;
            }
        }
        switch (tmp) {
            case 1: {
                v1 = "android.content.pm.PackageManager";
                break;
            }
            case 2: {
                v1 = "android.content.Intent";
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                var7_6 = "Unexpected method name: " + methodName;
                var8_7 = false;
                throw (Throwable)new IllegalStateException(var7_6.toString());
            }
        }
        intendedOwner = v1;
        if (!JavaEvaluator.isMemberInSubClassOf$default(context.getEvaluator(), (PsiMember)method, intendedOwner, false, 4, null)) {
            return;
        }
        v2 = this.getQueryPermissions(context);
        if (v2 == null) {
            return;
        }
        permissions = v2;
        if (Intrinsics.areEqual((Object)methodName, (Object)"getInstalledPackages") || Intrinsics.areEqual((Object)methodName, (Object)"getInstalledApplications")) {
            if (!permissions.getCanQueryAllPackages()) {
                v3 = node.getMethodIdentifier();
                v4 = node.getMethodIdentifier();
                JavaContext.report$default(context, PackageVisibilityDetector.QUERY_PERMISSIONS_NEEDED, v3 != null ? (UElement)v3 : (UElement)node, context.getLocation(v4 != null ? (UElement)v4 : (UElement)node), "As of Android 11, this method no longer returns information about all apps; \\\nsee https://g.co/dev/packagevisibility for details", null, 16, null);
            }
        } else if (!permissions.getCanQuerySomePackages()) {
            v5 = node.getMethodIdentifier();
            v6 = node.getMethodIdentifier();
            JavaContext.report$default(context, PackageVisibilityDetector.QUERY_PERMISSIONS_NEEDED, v5 != null ? (UElement)v5 : (UElement)node, context.getLocation(v6 != null ? (UElement)v6 : (UElement)node), "Consider adding a `<queries>` declaration to your manifest when calling this \\\nmethod; see https://g.co/dev/packagevisibility for details", null, 16, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final QueryPermissions getQueryPermissions(JavaContext context) {
        v0 = this.cachedQueryPermissions;
        if (v0 != null) {
            var2_2 = v0;
            var3_4 = false;
            var4_6 = false;
            it = var2_2;
            $i$a$-let-PackageVisibilityDetector$getQueryPermissions$1 = false;
            return it;
        }
        v1 = context.getMainProject().getMergedManifest();
        if (v1 == null) {
            return null;
        }
        manifest = v1;
        canQuerySomePackages = false;
        canQueryAllPackages = false;
        for (Element tag : XmlUtils.getSubTags((Node)manifest.getDocumentElement())) {
            if (tag.getNodeName() == null) continue;
            switch (var7_13.hashCode()) {
                case 599862896: {
                    if (!var7_13.equals("uses-permission")) ** break;
                    break;
                }
                case 655087462: {
                    if (!var7_13.equals("queries")) ** break;
                    canQuerySomePackages = true;
                    ** break;
                }
            }
            v2 = permission = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            if (!Intrinsics.areEqual((Object)(v2 != null ? v2.getValue() : null), (Object)"android.permission.QUERY_ALL_PACKAGES")) ** break;
            canQuerySomePackages = true;
            canQueryAllPackages = true;
            ** break;
lbl30:
            // 6 sources

        }
        var5_9 = new QueryPermissions(canQuerySomePackages, canQueryAllPackages);
        var6_12 = false;
        var7_14 = false;
        it = var5_9;
        $i$a$-also-PackageVisibilityDetector$getQueryPermissions$2 = false;
        this.cachedQueryPermissions = it;
        return var5_9;
    }

    static {
        Companion = new Companion(null);
        Collection collection = null;
        EnumSet enumSet = null;
        String string = "https://g.co/dev/packagevisibility";
        boolean bl = false;
        Boolean bl2 = true;
        Implementation implementation = new Implementation(PackageVisibilityDetector.class, Scope.MANIFEST_SCOPE);
        Severity severity = Severity.ERROR;
        int n = 8;
        Category category = Category.COMPLIANCE;
        QUERY_ALL_PACKAGES_PERMISSION = Issue.Companion.create$default(Issue.Companion, "QueryAllPackagesPermission", "Using the QUERY_ALL_PACKAGES permission", "\n            If you need to query or interact with other installed apps, you should be using a \\\n            `<queries>` declaration in your manifest. Using the QUERY_ALL_PACKAGES permission in \\\n            order to see all installed apps is rarely necessary, and most apps on Google Play are \\\n            not allowed to have this permission.\n            ", implementation, string, category, n, severity, bl, bl2, enumSet, collection, 3328, null);
        collection = null;
        enumSet = null;
        string = "https://g.co/dev/packagevisibility";
        bl = false;
        bl2 = true;
        implementation = new Implementation(PackageVisibilityDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.MANIFEST), Scope.JAVA_FILE_SCOPE);
        severity = Severity.WARNING;
        n = 5;
        category = Category.CORRECTNESS;
        QUERY_PERMISSIONS_NEEDED = Issue.Companion.create$default(Issue.Companion, "QueryPermissionsNeeded", "Using APIs affected by query permissions", "\n            Apps that target Android 11 cannot query or interact with other installed apps \\\n            by default. If you need to query or interact with other installed apps, you may need \\\n            to add a `<queries>` declaration in your manifest.\n\n            As a corollary, the methods `PackageManager#getInstalledPackages` and \\\n            `PackageManager#getInstalledApplications` will no longer return information about all \\\n            installed apps. To query specific apps or types of apps, you can use methods like \\\n            `PackageManager#getPackageInfo` or `PackageManager#queryIntentActivities`.\n            ", implementation, string, category, n, severity, bl, bl2, enumSet, collection, 3328, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/PackageVisibilityDetector$QueryPermissions;", "", "canQuerySomePackages", "", "canQueryAllPackages", "(ZZ)V", "getCanQueryAllPackages", "()Z", "getCanQuerySomePackages", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "android.sdktools.lint-checks"})
    private static final class QueryPermissions {
        private final boolean canQuerySomePackages;
        private final boolean canQueryAllPackages;

        public final boolean getCanQuerySomePackages() {
            return this.canQuerySomePackages;
        }

        public final boolean getCanQueryAllPackages() {
            return this.canQueryAllPackages;
        }

        public QueryPermissions(boolean canQuerySomePackages, boolean canQueryAllPackages) {
            this.canQuerySomePackages = canQuerySomePackages;
            this.canQueryAllPackages = canQueryAllPackages;
        }

        public final boolean component1() {
            return this.canQuerySomePackages;
        }

        public final boolean component2() {
            return this.canQueryAllPackages;
        }

        @NotNull
        public final QueryPermissions copy(boolean canQuerySomePackages, boolean canQueryAllPackages) {
            return new QueryPermissions(canQuerySomePackages, canQueryAllPackages);
        }

        public static /* synthetic */ QueryPermissions copy$default(QueryPermissions queryPermissions, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = queryPermissions.canQuerySomePackages;
            }
            if ((n & 2) != 0) {
                bl2 = queryPermissions.canQueryAllPackages;
            }
            return queryPermissions.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "QueryPermissions(canQuerySomePackages=" + this.canQuerySomePackages + ", canQueryAllPackages=" + this.canQueryAllPackages + ")";
        }

        public int hashCode() {
            int n = this.canQuerySomePackages ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.canQueryAllPackages ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            return n2 + n3;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof QueryPermissions)) break block3;
                    QueryPermissions queryPermissions = (QueryPermissions)object;
                    if (this.canQuerySomePackages != queryPermissions.canQuerySomePackages || this.canQueryAllPackages != queryPermissions.canQueryAllPackages) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/PackageVisibilityDetector$Companion;", "", "()V", "INITIAL_API", "", "QUERY_ALL_PACKAGES_PERMISSION", "Lcom/android/tools/lint/detector/api/Issue;", "QUERY_PERMISSIONS_NEEDED", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

