/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.MavenRepositories;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.BlockedDependencies;
import com.android.tools.lint.checks.DeprecatedSdkRegistry;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.GradleDetector$Companion$WhenMappings;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.model.LintModelArtifact;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 \u008d\u00012\u00020\u00012\u00020\u0002:\b\u008c\u0001\u008d\u0001\u008e\u0001\u008f\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010*\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J(\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010'\u001a\u00020/2\u0006\u00100\u001a\u00020\u000fH\u0002J\u0018\u00101\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00102\u001a\u00020\nH\u0002J,\u00103\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u00104\u001a\u0004\u0018\u00010\u000f2\u0006\u00105\u001a\u00020-2\b\u00106\u001a\u0004\u0018\u00010-H\u0002J\u001a\u00107\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u00104\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u00108\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u00104\u001a\u0004\u0018\u00010\u000fH\u0002J$\u00109\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u00104\u001a\u0004\u0018\u00010\u000f2\b\u0010:\u001a\u0004\u0018\u00010\u000fH\u0002J0\u0010;\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010.\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000fH\u0002J \u0010>\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020/2\u0006\u00100\u001a\u00020\u000fH\u0002JJ\u0010?\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010@\u001a\u00020-2\u0006\u0010A\u001a\u00020-2\u0006\u0010B\u001a\u00020-2\b\u0010C\u001a\u0004\u0018\u00010-2\u0006\u00100\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000fH\u0016J0\u0010E\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00105\u001a\u00020-2\u0006\u0010F\u001a\u00020-2\u0006\u0010G\u001a\u00020H2\u0006\u00104\u001a\u00020\u000fH\u0002J \u0010I\u001a\u00020\u00182\u0006\u0010'\u001a\u00020/2\u0006\u0010.\u001a\u00020<2\u0006\u00104\u001a\u00020\u000fH\u0002J \u0010J\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010A\u001a\u00020-2\u0006\u00104\u001a\u00020\u000fH\u0002JV\u0010K\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010L\u001a\u00020-2\b\u0010B\u001a\u0004\u0018\u00010-2\b\u0010C\u001a\u0004\u0018\u00010-2\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0N2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020-0P2\u0006\u00104\u001a\u00020\u000fH\u0016J \u0010Q\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010G\u001a\u00020\r2\u0006\u0010D\u001a\u00020\u000fH\u0002J \u0010R\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010A\u001a\u00020-2\u0006\u00104\u001a\u00020\u000fH\u0002J8\u0010S\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010.\u001a\u00020<2\u0006\u0010G\u001a\u00020H2\u0006\u0010T\u001a\u00020-2\u0006\u00104\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000fH\u0002J2\u0010U\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010.\u001a\u00020<2\u0006\u0010G\u001a\u00020H2\b\u0010V\u001a\u0004\u0018\u00010H2\u0006\u00104\u001a\u00020\u000fH\u0002J\u0010\u0010W\u001a\u00020&2\u0006\u0010'\u001a\u00020/H\u0002J:\u0010X\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\b\u0010G\u001a\u0004\u0018\u00010H2\u0006\u00104\u001a\u00020\u000f2\u0006\u0010Y\u001a\u00020\r2\u0006\u0010Z\u001a\u00020\r2\u0006\u0010[\u001a\u00020\rH\u0002J\"\u0010\\\u001a\u0004\u0018\u00010H2\u0006\u0010.\u001a\u00020<2\u000e\u0010]\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010^H\u0002J\u0016\u0010_\u001a\u00020`2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020`0bH\u0002J\u0016\u0010c\u001a\b\u0012\u0004\u0012\u00020d0P2\u0006\u00102\u001a\u00020\nH\u0002J\b\u0010e\u001a\u00020\u0007H\u0004J \u0010f\u001a\u0004\u0018\u00010-2\u0006\u0010'\u001a\u00020(2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020h0PH\u0002J\u0010\u0010i\u001a\u00020\u00112\u0006\u0010j\u001a\u00020kH\u0002J*\u0010l\u001a\u0004\u0018\u00010H2\u0006\u0010'\u001a\u00020/2\u0006\u0010.\u001a\u00020<2\u000e\u0010]\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010^H\u0002J\u0010\u0010m\u001a\u00020\u00132\u0006\u0010j\u001a\u00020kH\u0002J\u001a\u0010n\u001a\u0004\u0018\u00010H2\u0006\u0010o\u001a\u00020H2\u0006\u0010p\u001a\u00020HH\u0002J\"\u0010n\u001a\u0004\u0018\u00010H2\u0006\u0010o\u001a\u00020H2\u0006\u0010Y\u001a\u00020\r2\u0006\u0010Z\u001a\u00020\rH\u0002J*\u0010n\u001a\u0004\u0018\u00010H2\u0006\u0010o\u001a\u00020H2\u0006\u0010Y\u001a\u00020\r2\u0006\u0010Z\u001a\u00020\r2\u0006\u0010[\u001a\u00020\rH\u0002J\"\u0010q\u001a\u00020-2\u0006\u0010.\u001a\u00020<2\u0006\u0010G\u001a\u00020-2\b\u0010r\u001a\u0004\u0018\u00010HH\u0002J\u0010\u0010s\u001a\u00020\r2\u0006\u0010A\u001a\u00020-H\u0002J.\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00020-2\u0006\u0010w\u001a\u00020-2\b\b\u0002\u0010x\u001a\u00020\u00182\n\b\u0002\u0010y\u001a\u0004\u0018\u00010HH\u0002J0\u0010z\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010^2\u0006\u0010'\u001a\u00020/2\u0006\u00105\u001a\u00020-2\u0006\u0010F\u001a\u00020-2\u0006\u0010T\u001a\u00020-H\u0002J\u0018\u0010{\u001a\u00020\u00182\u0006\u00105\u001a\u00020-2\u0006\u0010F\u001a\u00020-H\u0002J\u0010\u0010|\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J6\u0010}\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00104\u001a\u00020\u000f2\u0006\u0010~\u001a\u00020\u007f2\u0007\u0010\u0080\u0001\u001a\u00020-2\u000b\b\u0002\u0010\u0081\u0001\u001a\u0004\u0018\u00010uH\u0002J$\u0010\u0082\u0001\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0080\u0001\u001a\u00020-H\u0002J\"\u0010\u0082\u0001\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00104\u001a\u00020\u000f2\u0007\u0010\u0080\u0001\u001a\u00020-H\u0002J-\u0010\u0082\u0001\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00104\u001a\u00020\u000f2\u0007\u0010\u0080\u0001\u001a\u00020-2\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010uH\u0002J$\u0010\u0085\u0001\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0080\u0001\u001a\u00020-H\u0002J/\u0010\u0085\u0001\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00104\u001a\u00020\u000f2\u0007\u0010\u0080\u0001\u001a\u00020-2\u000b\b\u0002\u0010\u0086\u0001\u001a\u0004\u0018\u00010uH\u0002J$\u0010\u0087\u0001\u001a\u0004\u0018\u00010<2\u0006\u0010'\u001a\u00020/2\u0006\u0010@\u001a\u00020-2\u0007\u0010\u0088\u0001\u001a\u00020<H\u0002J\u0011\u0010\u0089\u0001\u001a\u00020\u00182\u0006\u00102\u001a\u00020\nH\u0002J\r\u0010\u008a\u0001\u001a\u00020\u0018*\u00020`H\u0002J\r\u0010\u008b\u0001\u001a\u00020\u0018*\u00020`H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0090\u0001"}, d2={"Lcom/android/tools/lint/checks/GradleDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "()V", "agpVersionCheckInfo", "Lcom/android/tools/lint/checks/GradleDetector$AgpVersionCheckInfo;", "artifactCacheHome", "Ljava/io/File;", "blockedDependencies", "Ljava/util/HashMap;", "Lcom/android/tools/lint/detector/api/Project;", "Lcom/android/tools/lint/checks/BlockedDependencies;", "compileSdkVersion", "", "compileSdkVersionCookie", "", "deprecatedSdkRegistry", "Lcom/android/tools/lint/checks/DeprecatedSdkRegistry;", "googleMavenRepository", "Lcom/android/ide/common/repository/GoogleMavenRepository;", "gradleUserHome", "getGradleUserHome", "()Ljava/io/File;", "mAppliedJavaPlugin", "", "mAppliedKotlinAndroidPlugin", "mAppliedKotlinKaptPlugin", "mCheckedGms", "mCheckedSupportLibs", "mCheckedWearableLibs", "mDeclaredGoogleMavenRepository", "mDeclaredSourceCompatibility", "mDeclaredTargetCompatibility", "mJavaPluginInfo", "Lcom/android/tools/lint/checks/GradleDetector$JavaPluginInfo;", "minSdkVersion", "targetSdkVersion", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "afterCheckRootProject", "beforeCheckRootProject", "checkAnnotationProcessorOnCompilePath", "configuration", "", "dependency", "Lcom/android/tools/lint/detector/api/GradleContext;", "propertyCookie", "checkBlockedDependencies", "project", "checkConsistentLibraries", "cookie", "groupId", "groupId2", "checkConsistentPlayServices", "checkConsistentSupportLibraries", "checkConsistentWearableLibraries", "statementCookie", "checkDependency", "Lcom/android/ide/common/repository/GradleCoordinate;", "isResolved", "checkDeprecatedConfigurations", "checkDslPropertyAssignment", "property", "value", "parent", "parentParent", "valueCookie", "checkForKtxExtension", "artifactId", "version", "Lcom/android/ide/common/repository/GradleVersion;", "checkGradlePluginDependency", "checkIntegerAsString", "checkMethodCall", "statement", "namedArguments", "", "unnamedArguments", "", "checkMinSdkVersion", "checkOctal", "checkPlayServices", "revision", "checkSupportLibraries", "newerVersion", "checkTargetCompatibility", "ensureTargetCompatibleWithO", "major", "minor", "micro", "findCachedNewerVersion", "filter", "Ljava/util/function/Predicate;", "findFirst", "Lcom/android/tools/lint/model/LintModelMavenName;", "coordinates", "", "getAllLibraries", "Lcom/android/tools/lint/model/LintModelLibrary;", "getArtifactCacheHome", "getBlockedDependencyMessage", "path", "Lcom/android/tools/lint/model/LintModelDependency;", "getDeprecatedLibraryLookup", "client", "Lcom/android/tools/lint/client/api/LintClient;", "getGoogleMavenRepoVersion", "getGoogleMavenRepository", "getNewerVersion", "version1", "version2", "getNewerVersionAvailableMessage", "stable", "getSdkVersion", "getUpdateDependencyFix", "Lcom/android/tools/lint/detector/api/LintFix;", "currentVersion", "suggestedVersion", "suggestedVersionIsSafe", "safeReplacement", "getUpgradeVersionFilter", "isSupportLibraryDependentOnCompileSdk", "maybeReportAgpVersionIssue", "report", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "message", "fix", "reportFatalCompatibilityIssue", "location", "Lcom/android/tools/lint/detector/api/Location;", "reportNonFatalCompatibilityIssue", "lintFix", "resolveCoordinate", "gc", "usesLegacyHttpLibrary", "isAndroidxArtifact", "isSupportLibArtifact", "AgpVersionCheckInfo", "Companion", "DeprecatedConfiguration", "JavaPluginInfo", "android.sdktools.lint-checks"})
public class GradleDetector
extends Detector
implements GradleScanner {
    private int minSdkVersion;
    private int compileSdkVersion;
    private Object compileSdkVersionCookie;
    private int targetSdkVersion;
    private File artifactCacheHome;
    private boolean mCheckedGms;
    private boolean mCheckedSupportLibs;
    private boolean mCheckedWearableLibs;
    private boolean mAppliedKotlinAndroidPlugin;
    private boolean mAppliedKotlinKaptPlugin;
    private boolean mAppliedJavaPlugin;
    private JavaPluginInfo mJavaPluginInfo;
    private boolean mDeclaredSourceCompatibility;
    private boolean mDeclaredTargetCompatibility;
    private boolean mDeclaredGoogleMavenRepository;
    private AgpVersionCheckInfo agpVersionCheckInfo;
    private final HashMap<Project, BlockedDependencies> blockedDependencies = new HashMap();
    private GoogleMavenRepository googleMavenRepository;
    private DeprecatedSdkRegistry deprecatedSdkRegistry;
    @Nullable
    private static Calendar calendar;
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue DEPENDENCY;
    @JvmField
    @NotNull
    public static final Issue AGP_DEPENDENCY;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED_CONFIGURATION;
    @JvmField
    @NotNull
    public static final Issue GRADLE_PLUGIN_COMPATIBILITY;
    @JvmField
    @NotNull
    public static final Issue PATH;
    @JvmField
    @NotNull
    public static final Issue IDE_SUPPORT;
    @JvmField
    @NotNull
    public static final Issue PLUS;
    @JvmField
    @NotNull
    public static final Issue GRADLE_GETTER;
    @JvmField
    @NotNull
    public static final Issue COMPATIBILITY;
    @JvmField
    @NotNull
    public static final Issue STRING_INTEGER;
    @JvmField
    @NotNull
    public static final Issue NOT_INTERPOLATED;
    @JvmField
    @NotNull
    public static final Issue REMOTE_VERSION;
    @JvmField
    @NotNull
    public static final Issue MIN_SDK_TOO_LOW;
    @JvmField
    @NotNull
    public static final Issue ACCIDENTAL_OCTAL;
    @JvmField
    @NotNull
    public static final Issue BUNDLED_GMS;
    @JvmField
    @NotNull
    public static final Issue HIGH_APP_VERSION_CODE;
    @JvmField
    @NotNull
    public static final Issue DEV_MODE_OBSOLETE;
    @JvmField
    @NotNull
    public static final Issue DUPLICATE_CLASSES;
    @JvmField
    @NotNull
    public static final Issue EXPIRING_TARGET_SDK_VERSION;
    @JvmField
    @NotNull
    public static final Issue EXPIRED_TARGET_SDK_VERSION;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED_LIBRARY;
    @JvmField
    @NotNull
    public static final Issue DATA_BINDING_WITHOUT_KAPT;
    @JvmField
    @NotNull
    public static final Issue LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8;
    @JvmField
    @NotNull
    public static final Issue RISKY_LIBRARY;
    @JvmField
    @NotNull
    public static final Issue ANNOTATION_PROCESSOR_ON_COMPILE_PATH;
    @JvmField
    @NotNull
    public static final Issue KTX_EXTENSION_AVAILABLE;
    @JvmField
    @NotNull
    public static final Issue JAVA_PLUGIN_LANGUAGE_LEVEL;
    @JvmField
    @NotNull
    public static final Issue JCENTER_REPOSITORY_OBSOLETE;
    @NotNull
    private static final List<String> JAVA_PLUGIN_IDS;
    @NotNull
    public static final String APP_PLUGIN_ID = "com.android.application";
    @NotNull
    public static final String LIB_PLUGIN_ID = "com.android.library";
    @NotNull
    public static final String OLD_APP_PLUGIN_ID = "android";
    @NotNull
    public static final String OLD_LIB_PLUGIN_ID = "android-library";
    @NotNull
    public static final String GMS_GROUP_ID = "com.google.android.gms";
    @NotNull
    public static final String FIREBASE_GROUP_ID = "com.google.firebase";
    @NotNull
    public static final String GOOGLE_SUPPORT_GROUP_ID = "com.google.android.support";
    @NotNull
    public static final String ANDROID_WEAR_GROUP_ID = "com.google.android.wearable";
    private static final String WEARABLE_ARTIFACT_ID = "wearable";
    private static final GradleCoordinate PLAY_SERVICES_V650;
    private static final int VERSION_CODE_HIGH_THRESHOLD = 2000000000;
    private static int majorBuildTools;
    private static GradleVersion latestBuildTools;
    private static final Set<String> commonAnnotationProcessors;
    public static final Companion Companion;

    @NotNull
    protected File getGradleUserHome() {
        String gradleUserHome = System.getProperty("gradle.user.home");
        if (gradleUserHome == null && (gradleUserHome = System.getenv("GRADLE_USER_HOME")) == null) {
            gradleUserHome = System.getProperty("user.home") + File.separator + ".gradle";
        }
        return new File(gradleUserHome);
    }

    private final void checkOctal(GradleContext context2, String value, Object cookie) {
        if (value.length() >= 2 && value.charAt(0) == '0' && (value.length() > 2 || Intrinsics.compare((int)value.charAt(1), (int)56) >= 0 && GradleContext.Companion.isNonNegativeInteger(value)) && context2.isEnabled(ACCIDENTAL_OCTAL)) {
            String string;
            StringBuilder stringBuilder;
            String message2 = "The leading 0 turns this number into octal which is probably not what was intended";
            StringBuilder stringBuilder2 = new StringBuilder().append(message2);
            try {
                stringBuilder = stringBuilder2;
                Long numericValue = Long.decode(value);
                string = " (interpreted as " + numericValue + ')';
            }
            catch (NumberFormatException numberFormatException) {
                stringBuilder = stringBuilder2;
                string = " (and it is not a valid octal number)";
            }
            message2 = stringBuilder.append(string).toString();
            GradleDetector.report$default(this, context2, cookie, ACCIDENTAL_OCTAL, message2, null, 16, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkDslPropertyAssignment(@NotNull GradleContext context2, @NotNull String property, @NotNull String value, @NotNull String parent, @Nullable String parentParent, @NotNull Object propertyCookie, @NotNull Object valueCookie, @NotNull Object statementCookie) {
        if (Intrinsics.areEqual((Object)parent, (Object)"defaultConfig")) {
            int version;
            int version2;
            if (Intrinsics.areEqual((Object)property, (Object)"targetSdkVersion")) {
                version2 = this.getSdkVersion(value);
                if (version2 > 0 && version2 < context2.getClient().getHighestKnownApiLevel()) {
                    boolean warned = false;
                    if (version2 < 29) {
                        Calendar calendar = GradleDetector.calendar;
                        if (calendar == null) {
                            calendar = Calendar.getInstance();
                        }
                        Calendar now = calendar;
                        int year = now.get(1);
                        int month = now.get(2);
                        int required = 0;
                        Issue issue = null;
                        if (year > 2020 || month >= 10) {
                            required = 29;
                            issue = EXPIRED_TARGET_SDK_VERSION;
                        } else if (version2 < 28 && year > 2018) {
                            required = 28;
                            issue = EXPIRED_TARGET_SDK_VERSION;
                        } else if (year == 2020) {
                            required = 29;
                            issue = EXPIRING_TARGET_SDK_VERSION;
                        } else {
                            required = -1;
                            issue = IssueRegistry.LINT_ERROR;
                        }
                        if (required != -1) {
                            boolean alreadySuppressed;
                            String message2 = Intrinsics.areEqual((Object)issue, (Object)EXPIRED_TARGET_SDK_VERSION) ? "Google Play requires that apps target API level " + required + " or higher.\n" : "Google Play will soon require that apps target API level 29 or higher. This will be required for new apps in August 2020, and for updates to existing apps in November 2020.";
                            int highest = context2.getClient().getHighestKnownApiLevel();
                            String label = "Update targetSdkVersion to " + highest;
                            LintFix fix = this.fix().name(label).replace().text(value).with(String.valueOf(highest)).build();
                            boolean bl = alreadySuppressed = Intrinsics.areEqual((Object)issue, (Object)EXPIRING_TARGET_SDK_VERSION) ^ true && context2.containsCommentSuppress() && context2.isSuppressedWithComment(statementCookie, issue);
                            if (!alreadySuppressed) {
                                this.report(context2, statementCookie, issue, message2, fix);
                            }
                            warned = true;
                        }
                    }
                    if (!warned) {
                        String message3 = "Not targeting the latest versions of Android; compatibility modes apply. Consider testing and updating this version. Consult the android.os.Build.VERSION_CODES javadoc for details.";
                        int highest = context2.getClient().getHighestKnownApiLevel();
                        String label = "Update targetSdkVersion to " + highest;
                        LintFix fix = this.fix().name(label).replace().text(value).with(String.valueOf(highest)).build();
                        this.report(context2, statementCookie, ManifestDetector.TARGET_NEWER, message3, fix);
                    }
                }
                if (version2 > 0) {
                    this.targetSdkVersion = version2;
                    this.checkTargetCompatibility(context2);
                } else {
                    this.checkIntegerAsString(context2, value, statementCookie);
                }
            } else if (Intrinsics.areEqual((Object)property, (Object)"minSdkVersion")) {
                version2 = this.getSdkVersion(value);
                if (version2 > 0) {
                    this.minSdkVersion = version2;
                    this.checkMinSdkVersion(context2, version2, statementCookie);
                } else {
                    this.checkIntegerAsString(context2, value, statementCookie);
                }
            }
            if (StringsKt.startsWith$default((String)value, (String)"0", (boolean)false, (int)2, null)) {
                this.checkOctal(context2, value, valueCookie);
            }
            if (Intrinsics.areEqual((Object)property, (Object)"versionName") || Intrinsics.areEqual((Object)property, (Object)"versionCode") && !GradleContext.Companion.isNonNegativeInteger(value) || !GradleContext.Companion.isStringLiteral(value)) {
                if (Intrinsics.areEqual((Object)value, (Object)"getVersionCode") || Intrinsics.areEqual((Object)value, (Object)"getVersionName")) {
                    String message4 = "Bad method name: pick a unique method name which does not conflict with the implicit getters for the defaultConfig properties. For example, try using the prefix compute- instead of get-.";
                    GradleDetector.report$default(this, context2, statementCookie, GRADLE_GETTER, message4, null, 16, null);
                }
            } else if (Intrinsics.areEqual((Object)property, (Object)"packageName")) {
                String message5 = "Deprecated: Replace 'packageName' with 'applicationId'";
                LintFix fix = this.fix().name("Replace 'packageName' with 'applicationId'", true).replace().text("packageName").with("applicationId").autoFix().build();
                this.report(context2, propertyCookie, DEPRECATED, message5, fix);
            }
            if (Intrinsics.areEqual((Object)property, (Object)"versionCode") && context2.isEnabled(HIGH_APP_VERSION_CODE) && GradleContext.Companion.isNonNegativeInteger(value) && (version = GradleContext.Companion.getIntLiteralValue(value, -1)) >= 2000000000) {
                String message6 = "The 'versionCode' is very high and close to the max allowed value";
                GradleDetector.report$default(this, context2, statementCookie, HIGH_APP_VERSION_CODE, message6, null, 16, null);
            }
        } else if (Intrinsics.areEqual((Object)property, (Object)"compileSdkVersion") && Intrinsics.areEqual((Object)parent, (Object)OLD_APP_PLUGIN_ID)) {
            int version = -1;
            if (GradleContext.Companion.isStringLiteral(value)) {
                AndroidVersion platformVersion;
                String hash = GradleContext.Companion.getStringLiteralValue(value);
                if (hash != null && !Lint.isNumberString(hash) && (platformVersion = AndroidTargetHash.getPlatformVersion((String)hash)) != null) {
                    version = platformVersion.getFeatureLevel();
                }
            } else {
                version = GradleContext.Companion.getIntLiteralValue(value, -1);
            }
            if (version > 0) {
                this.compileSdkVersion = version;
                this.compileSdkVersionCookie = statementCookie;
                this.checkTargetCompatibility(context2);
            } else {
                this.checkIntegerAsString(context2, value, statementCookie);
            }
        } else if (Intrinsics.areEqual((Object)property, (Object)"buildToolsVersion") && Intrinsics.areEqual((Object)parent, (Object)OLD_APP_PLUGIN_ID)) {
            GradleVersion version;
            String versionString = GradleContext.Companion.getStringLiteralValue(value);
            if (versionString != null && (version = GradleVersion.tryParse((String)versionString)) != null) {
                String message7;
                GradleVersion recommended = GradleDetector.Companion.getLatestBuildTools(context2.getClient(), version.getMajor());
                if (recommended != null && version.compareTo(recommended) < 0) {
                    message7 = "Old buildToolsVersion " + version + "; recommended version is " + recommended + " or later";
                    LintFix fix = GradleDetector.getUpdateDependencyFix$default(this, version.toString(), recommended.toString(), false, null, 12, null);
                    this.report(context2, statementCookie, DEPENDENCY, message7, fix);
                }
                if (version.getMajor() == 23 && version.getMinor() == 0 && version.getMicro() == 0 && context2.isEnabled(COMPATIBILITY)) {
                    if (recommended == null || recommended.getMajor() < 23) {
                        recommended = new GradleVersion(23, 0, 3);
                    }
                    message7 = "Build Tools `23.0.0` should not be used; " + "it has some known serious bugs. Use version `" + recommended + "` " + "instead.";
                    this.reportFatalCompatibilityIssue((Context)context2, statementCookie, message7);
                }
            }
        } else if (Intrinsics.areEqual((Object)parent, (Object)"plugins")) {
            if (Intrinsics.areEqual((Object)property, (Object)"id")) {
                String plugin = GradleContext.Companion.getStringLiteralValue(value);
                boolean isOldAppPlugin = Intrinsics.areEqual((Object)OLD_APP_PLUGIN_ID, (Object)plugin);
                if (isOldAppPlugin || Intrinsics.areEqual((Object)OLD_LIB_PLUGIN_ID, (Object)plugin)) {
                    String replaceWith = isOldAppPlugin ? APP_PLUGIN_ID : LIB_PLUGIN_ID;
                    String message8 = '\'' + plugin + "' is deprecated; use '" + replaceWith + "' instead";
                    LintFix fix = this.fix().sharedName("Replace plugin").replace().text(plugin).with(replaceWith).autoFix().build();
                    this.report(context2, valueCookie, DEPRECATED, message8, fix);
                }
                if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-android")) {
                    this.mAppliedKotlinAndroidPlugin = true;
                }
                if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-kapt")) {
                    this.mAppliedKotlinKaptPlugin = true;
                }
                if (CollectionsKt.contains((Iterable)JAVA_PLUGIN_IDS, (Object)plugin)) {
                    this.mAppliedJavaPlugin = true;
                    this.mJavaPluginInfo = new JavaPluginInfo(statementCookie);
                }
            }
        } else if (Intrinsics.areEqual((Object)parent, (Object)"dependencies")) {
            if (StringsKt.startsWith$default((String)value, (String)"files('", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"')", (boolean)false, (int)2, null)) {
                String isOldAppPlugin = value;
                int replaceWith = "files('".length();
                int message8 = value.length() - 2;
                boolean fix = false;
                String string = isOldAppPlugin;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = string.substring(replaceWith, message8);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String path2 = string2;
                if (StringsKt.contains$default((CharSequence)path2, (CharSequence)"\\\\", (boolean)false, (int)2, null)) {
                    LintFix fix2 = this.fix().replace().text(path2).with(StringsKt.replace$default((String)path2, (String)"\\\\", (String)"/", (boolean)false, (int)4, null)).build();
                    String message9 = "Do not use Windows file separators in .gradle files; use / instead";
                    this.report(context2, valueCookie, PATH, message9, fix2);
                } else if (StringsKt.startsWith$default((String)path2, (String)"/", (boolean)false, (int)2, null) || new File(StringsKt.replace$default((String)path2, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null)).isAbsolute()) {
                    String message10 = "Avoid using absolute paths in .gradle files";
                    GradleDetector.report$default(this, context2, valueCookie, PATH, message10, null, 16, null);
                }
            } else {
                String dependency = GradleContext.Companion.getStringLiteralValue(value);
                if (dependency == null) {
                    dependency = Companion.getNamedDependency(value);
                }
                if (dependency != null) {
                    LintFix fix;
                    String message11;
                    void gc;
                    Ref.ObjectRef message10 = new Ref.ObjectRef();
                    message10.element = GradleCoordinate.parseCoordinateString((String)dependency);
                    Ref.BooleanRef message9 = new Ref.BooleanRef();
                    message9.element = false;
                    if ((GradleCoordinate)gc.element != null && StringsKt.contains$default((CharSequence)dependency, (CharSequence)"$", (boolean)false, (int)2, null)) {
                        if (StringsKt.startsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && context2.isEnabled(NOT_INTERPOLATED)) {
                            message11 = "It looks like you are trying to substitute a version variable, but using single quotes ('). For Groovy string interpolation you must use double quotes (\").";
                            LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().name("Replace single quotes with double quotes").replace().text(value);
                            StringBuilder stringBuilder = new StringBuilder().append("\"");
                            String string = value;
                            int n = 1;
                            int n2 = value.length() - 1;
                            boolean bl = false;
                            String string3 = string;
                            if (string3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string4 = string3.substring(n, n2);
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            fix = replaceStringBuilder.with(stringBuilder.append(string4).append("\"").toString()).build();
                            this.report(context2, statementCookie, NOT_INTERPOLATED, message11, fix);
                        }
                        gc.element = this.resolveCoordinate(context2, property, (GradleCoordinate)gc.element);
                        isResolved.element = true;
                    }
                    if ((GradleCoordinate)gc.element != null) {
                        void isResolved;
                        if (((GradleCoordinate)gc.element).acceptsGreaterRevisions()) {
                            message11 = "Avoid using + in version numbers; can lead to unpredictable and unrepeatable builds (" + dependency + ")";
                            fix = this.fix().data((GradleCoordinate)gc.element);
                            this.report(context2, valueCookie, PLUS, message11, fix);
                        }
                        context2.getDriver().runLaterOutsideReadAction(new Runnable(this, context2, (Ref.ObjectRef)gc, (Ref.BooleanRef)isResolved, valueCookie, statementCookie){
                            final /* synthetic */ GradleDetector this$0;
                            final /* synthetic */ GradleContext $context;
                            final /* synthetic */ Ref.ObjectRef $gc;
                            final /* synthetic */ Ref.BooleanRef $isResolved;
                            final /* synthetic */ Object $valueCookie;
                            final /* synthetic */ Object $statementCookie;

                            public final void run() {
                                GradleDetector.access$checkDependency(this.this$0, this.$context, (GradleCoordinate)this.$gc.element, this.$isResolved.element, this.$valueCookie, this.$statementCookie);
                            }
                            {
                                this.this$0 = gradleDetector;
                                this.$context = gradleContext;
                                this.$gc = objectRef;
                                this.$isResolved = booleanRef;
                                this.$valueCookie = object;
                                this.$statementCookie = object2;
                            }
                        });
                    }
                    if (GradleDetector.Companion.hasLifecycleAnnotationProcessor(dependency) && GradleDetector.Companion.targetJava8Plus(context2.getProject())) {
                        this.report(context2, valueCookie, LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8, "Use the Lifecycle Java 8 API provided by the `lifecycle-common-java8` library instead of Lifecycle annotations for faster incremental build.", null);
                    }
                    this.checkAnnotationProcessorOnCompilePath(property, dependency, context2, propertyCookie);
                }
                this.checkDeprecatedConfigurations(property, context2, propertyCookie);
            }
        } else if (Intrinsics.areEqual((Object)property, (Object)"packageNameSuffix")) {
            String message12 = "Deprecated: Replace 'packageNameSuffix' with 'applicationIdSuffix'";
            LintFix fix = this.fix().name("Replace 'packageNameSuffix' with 'applicationIdSuffix'", true).replace().text("packageNameSuffix").with("applicationIdSuffix").autoFix().build();
            this.report(context2, propertyCookie, DEPRECATED, message12, fix);
        } else if (Intrinsics.areEqual((Object)property, (Object)"applicationIdSuffix")) {
            String suffix = GradleContext.Companion.getStringLiteralValue(value);
            if (suffix != null && !StringsKt.startsWith$default((String)suffix, (String)".", (boolean)false, (int)2, null)) {
                String message13 = "Application ID suffix should probably start with a \".\"";
                GradleDetector.report$default(this, context2, statementCookie, PATH, message13, null, 16, null);
            }
        } else if (Intrinsics.areEqual((Object)property, (Object)"minSdkVersion") && Intrinsics.areEqual((Object)parent, (Object)"dev") && Intrinsics.areEqual((Object)"21", (Object)value) && Intrinsics.areEqual((Object)"gradle", (Object)LintClient.Companion.getClientName()) ^ true) {
            GradleDetector.report$default(this, context2, statementCookie, DEV_MODE_OBSOLETE, "You no longer need a `dev` mode to enable multi-dexing during development, and this can break API version checks", null, 16, null);
        } else if (Intrinsics.areEqual((Object)parent, (Object)"dataBinding") && (Intrinsics.areEqual((Object)property, (Object)"enabled") || Intrinsics.areEqual((Object)property, (Object)"isEnabled")) || Intrinsics.areEqual((Object)parent, (Object)"buildFeatures") && Intrinsics.areEqual((Object)property, (Object)"dataBinding")) {
            if (Intrinsics.areEqual((Object)value, (Object)"true") && this.mAppliedKotlinAndroidPlugin && !this.mAppliedKotlinKaptPlugin) {
                String message14 = "If you plan to use data binding in a Kotlin project, you should apply the kotlin-kapt plugin.";
                this.report(context2, statementCookie, DATA_BINDING_WITHOUT_KAPT, message14, null);
            }
        } else if ((Intrinsics.areEqual((Object)parent, (Object)"") || Intrinsics.areEqual((Object)parent, (Object)"java")) && Intrinsics.areEqual((Object)property, (Object)"sourceCompatibility")) {
            this.mDeclaredSourceCompatibility = true;
        } else if ((Intrinsics.areEqual((Object)parent, (Object)"") || Intrinsics.areEqual((Object)parent, (Object)"java")) && Intrinsics.areEqual((Object)property, (Object)"targetCompatibility")) {
            this.mDeclaredTargetCompatibility = true;
        }
    }

    private final void checkDeprecatedConfigurations(String configuration, GradleContext context2, Object propertyCookie) {
        GradleVersion gradleVersion = context2.getProject().getGradleModelVersion();
        if (gradleVersion != null) {
            if (!gradleVersion.isAtLeastIncludingPreviews(3, 0, 0)) {
                return;
            }
        }
        for (DeprecatedConfiguration deprecatedConfiguration : DeprecatedConfiguration.values()) {
            if (!deprecatedConfiguration.matches(configuration)) continue;
            if (deprecatedConfiguration == DeprecatedConfiguration.COMPILE && GradleDetector.Companion.suggestApiConfigurationUse(context2.getProject(), configuration)) {
                String implementation = null;
                String api = null;
                if (Intrinsics.areEqual((Object)configuration, (Object)"compile")) {
                    implementation = "implementation";
                    api = "api";
                } else {
                    String prefix = StringsKt.removeSuffix((String)configuration, (CharSequence)"Compile");
                    implementation = prefix + "Implementation";
                    api = prefix + "Api";
                }
                String message2 = '`' + configuration + "` is deprecated; " + "replace with either `" + api + "` to maintain current behavior, " + "or `" + implementation + "` to improve build performance " + "by not sharing this dependency transitively.";
                LintFix apiFix = this.fix().name("Replace '" + configuration + "' with '" + api + '\'').family("Replace compile with api").replace().text(configuration).with(api).independent(true).build();
                LintFix implementationFix = this.fix().name("Replace '" + configuration + "' with '" + implementation + '\'').family("Replace compile with implementation").replace().text(configuration).with(implementation).independent(true).build();
                LintFix fixes = this.fix().alternatives().name("Replace '" + configuration + "' with '" + api + "' or '" + implementation + '\'').add(apiFix).add(implementationFix).build();
                this.report(context2, propertyCookie, DEPRECATED_CONFIGURATION, message2, fixes);
                continue;
            }
            String replacement = deprecatedConfiguration.replacement(configuration);
            String message3 = '`' + configuration + "` is deprecated; replace with `" + replacement + '`';
            LintFix fix = this.fix().name("Replace '" + configuration + "' with '" + replacement + '\'').family("Replace deprecated configurations").replace().text(configuration).with(replacement).autoFix().build();
            this.report(context2, propertyCookie, DEPRECATED_CONFIGURATION, message3, fix);
        }
    }

    private final void checkAnnotationProcessorOnCompilePath(String configuration, String dependency, GradleContext context2, Object propertyCookie) {
        for (Companion.CompileConfiguration compileConfiguration : Companion.CompileConfiguration.values()) {
            if (!compileConfiguration.matches(configuration) || !GradleDetector.Companion.isCommonAnnotationProcessor(dependency)) continue;
            String replacement = compileConfiguration.replacement(configuration);
            LintFix fix = this.fix().name("Replace " + configuration + " with " + replacement).family("Replace compile classpath with annotationProcessor").replace().text(configuration).with(replacement).independent(true).build();
            String message2 = "Add annotation processor to processor path using `" + replacement + '`' + " instead of `" + configuration + '`';
            this.report(context2, propertyCookie, ANNOTATION_PROCESSOR_ON_COMPILE_PATH, message2, fix);
        }
    }

    private final void checkMinSdkVersion(GradleContext context2, int version, Object valueCookie) {
        int n = version;
        if (1 <= n && 16 > n) {
            String message2 = "The value of minSdkVersion is too low. It can be incremented without noticeably reducing the number of supported devices.";
            String label = "Update minSdkVersion to 16";
            LintFix fix = this.fix().name(label).replace().text(String.valueOf(version)).with(String.valueOf(16)).build();
            this.report(context2, valueCookie, MIN_SDK_TOO_LOW, message2, fix);
        }
    }

    private final void checkIntegerAsString(GradleContext context2, String value, Object cookie) {
        String string = GradleContext.Companion.getStringLiteralValue(value);
        if (Lint.isNumberString(string)) {
            String message2 = "Use an integer rather than a string here (replace " + value + " with just " + string + ')';
            LintFix fix = this.fix().name("Replace with integer", true).replace().text(value).with(string).build();
            this.report(context2, cookie, STRING_INTEGER, message2, fix);
        }
    }

    @Override
    public void checkMethodCall(@NotNull GradleContext context2, @NotNull String statement, @Nullable String parent, @Nullable String parentParent, @NotNull Map<String, String> namedArguments, @NotNull List<String> unnamedArguments, @NotNull Object cookie) {
        String plugin = namedArguments.get("plugin");
        if (Intrinsics.areEqual((Object)statement, (Object)"apply") && parent == null) {
            boolean isOldAppPlugin = Intrinsics.areEqual((Object)OLD_APP_PLUGIN_ID, (Object)plugin);
            if (isOldAppPlugin || Intrinsics.areEqual((Object)OLD_LIB_PLUGIN_ID, (Object)plugin)) {
                String replaceWith = isOldAppPlugin ? APP_PLUGIN_ID : LIB_PLUGIN_ID;
                String message2 = '\'' + plugin + "' is deprecated; use '" + replaceWith + "' instead";
                LintFix fix = this.fix().sharedName("Replace plugin").replace().text(plugin).with(replaceWith).autoFix().build();
                this.report(context2, cookie, DEPRECATED, message2, fix);
            }
            if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-android")) {
                this.mAppliedKotlinAndroidPlugin = true;
            }
            if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-kapt")) {
                this.mAppliedKotlinKaptPlugin = true;
            }
            if (CollectionsKt.contains((Iterable)JAVA_PLUGIN_IDS, (Object)plugin)) {
                this.mAppliedJavaPlugin = true;
                this.mJavaPluginInfo = new JavaPluginInfo(cookie);
            }
        }
        if (Intrinsics.areEqual((Object)statement, (Object)"google") && Intrinsics.areEqual((Object)parent, (Object)"repositories") && Intrinsics.areEqual((Object)parentParent, (Object)"buildscript")) {
            this.mDeclaredGoogleMavenRepository = true;
            this.maybeReportAgpVersionIssue(context2);
        }
        if (Intrinsics.areEqual((Object)statement, (Object)"jcenter") && Intrinsics.areEqual((Object)parent, (Object)"repositories")) {
            String message3 = "JCenter is at end of life";
            LintFix replaceFix = this.fix().name("Replace with mavenCentral").replace().text("jcenter").with("mavenCentral").build();
            LintFix deleteFix = this.fix().name("Delete this repository declaration").replace().all().with("").build();
            this.report(context2, cookie, JCENTER_REPOSITORY_OBSOLETE, message3, this.fix().alternatives(replaceFix, deleteFix));
        }
    }

    private final void checkTargetCompatibility(GradleContext context2) {
        if (this.compileSdkVersion > 0 && this.targetSdkVersion > 0 && this.targetSdkVersion > this.compileSdkVersion) {
            String message2 = "The compileSdkVersion (" + this.compileSdkVersion + ") should not be lower than the targetSdkVersion (" + this.targetSdkVersion + ")";
            LintFix fix = this.fix().name("Set compileSdkVersion to " + this.targetSdkVersion).replace().text(String.valueOf(this.compileSdkVersion)).with(String.valueOf(this.targetSdkVersion)).build();
            Context context3 = context2;
            Object object = this.compileSdkVersionCookie;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            this.reportNonFatalCompatibilityIssue(context3, object, message2, fix);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDependency(GradleContext context, GradleCoordinate dependency, boolean isResolved, Object cookie, Object statementCookie) {
        block37: {
            block45: {
                block40: {
                    block44: {
                        block41: {
                            block38: {
                                block39: {
                                    block43: {
                                        block42: {
                                            version = dependency.getVersion();
                                            groupId = dependency.getGroupId();
                                            artifactId = dependency.getArtifactId();
                                            revision = dependency.getRevision();
                                            safeReplacement = null;
                                            if (version == null) {
                                                return;
                                            }
                                            var11_11 = new Ref.ObjectRef();
                                            var11_11.element = null;
                                            filter = this.getUpgradeVersionFilter(context, groupId, artifactId, revision);
                                            v0 = groupId;
                                            if (v0 == null) break block37;
                                            var13_13 = v0;
                                            switch (var13_13.hashCode()) {
                                                case 432891823: {
                                                    if (!var13_13.equals("com.android.tools.build")) ** break;
                                                    break;
                                                }
                                                case -1893440090: {
                                                    if (!var13_13.equals("com.squareup.okhttp3")) ** break;
                                                    break block38;
                                                }
                                                case -491662668: {
                                                    if (!var13_13.equals("org.apache.httpcomponents")) ** break;
                                                    break block39;
                                                }
                                                case 1502450888: {
                                                    if (!var13_13.equals("com.bugsnag")) ** break;
                                                    break block40;
                                                }
                                                case -1266275135: {
                                                    if (!var13_13.equals("com.github.bumptech.glide")) ** break;
                                                    break block41;
                                                }
                                                case 2042560118: {
                                                    if (!var13_13.equals("com.google.guava")) ** break;
                                                    break block42;
                                                }
                                                case 325967270: {
                                                    if (!var13_13.equals("com.google.android.gms")) ** break;
                                                    ** GOTO lbl53
                                                }
                                                case 726153860: {
                                                    if (!var13_13.equals("com.google.code.gson")) ** break;
                                                    break block43;
                                                }
                                                case 288657178: {
                                                    if (!var13_13.equals("io.fabric.tools")) ** break;
                                                    break block44;
                                                }
                                                case 26640288: {
                                                    if (!var13_13.equals("com.google.android.wearable")) ** break;
                                                    ** GOTO lbl53
                                                }
                                                case -225004625: {
                                                    if (!var13_13.equals("com.google.firebase")) ** break;
                                                    ** GOTO lbl53
                                                }
                                                case -315438450: {
                                                    if (!var13_13.equals("org.robolectric")) ** break;
                                                    break block45;
                                                }
                                                case 1356232872: {
                                                    if (!var13_13.equals("com.google.android.support")) ** break;
lbl53:
                                                    // 4 sources

                                                    this.checkPlayServices(context, dependency, version, revision, cookie, statementCookie);
                                                    ** break;
                                                }
                                            }
                                            if (!Intrinsics.areEqual((Object)"gradle", (Object)artifactId)) ** break;
                                            if (this.checkGradlePluginDependency(context, dependency, statementCookie)) {
                                                return;
                                            }
                                            newerVersion.element = GradleVersion.max((GradleVersion)version, (GradleVersion)this.getGoogleMavenRepoVersion(context, dependency, filter));
                                            newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)this.findCachedNewerVersion(dependency, filter));
                                            newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)context.getClient().getHighestKnownVersion(dependency, filter));
                                            if ((GradleVersion)newerVersion.element != null && !version.isPreview() && Intrinsics.areEqual((Object)((GradleVersion)newerVersion.element), (Object)version) ^ true) {
                                                v1 = version.getMinorSegment();
                                                if (v1 != null) {
                                                    if (!v1.acceptsGreaterValue()) {
                                                        if (version.getMajor() != ((GradleVersion)newerVersion.element).getMajor() || version.getMinor() != ((GradleVersion)newerVersion.element).getMinor()) {
                                                            safeReplacement = this.getGoogleMavenRepoVersion(context, dependency, new Predicate<GradleVersion>(version, (Ref.ObjectRef)newerVersion){
                                                                final /* synthetic */ GradleVersion $version;
                                                                final /* synthetic */ Ref.ObjectRef $newerVersion;

                                                                /*
                                                                 * Enabled force condition propagation
                                                                 * Lifted jumps to return sites
                                                                 */
                                                                public final boolean test(@NotNull GradleVersion filterVersion) {
                                                                    if (filterVersion.getMajor() != this.$version.getMajor()) return false;
                                                                    if (filterVersion.getMinor() != this.$version.getMinor()) return false;
                                                                    if (filterVersion.getMicro() <= this.$version.getMicro()) return false;
                                                                    if (filterVersion.isPreview()) return false;
                                                                    GradleVersion gradleVersion = (GradleVersion)this.$newerVersion.element;
                                                                    if (gradleVersion == null) {
                                                                        Intrinsics.throwNpe();
                                                                    }
                                                                    if (filterVersion.compareTo(gradleVersion) >= 0) return false;
                                                                    return true;
                                                                }
                                                                {
                                                                    this.$version = gradleVersion;
                                                                    this.$newerVersion = objectRef;
                                                                }
                                                            });
                                                        }
                                                    }
                                                }
                                            }
                                            if ((GradleVersion)newerVersion.element != null && ((GradleVersion)newerVersion.element).compareTo(version) > 0) {
                                                this.agpVersionCheckInfo = new AgpVersionCheckInfo((GradleVersion)newerVersion.element, ((GradleVersion)newerVersion.element).getMajor() == version.getMajor() && ((GradleVersion)newerVersion.element).getMinor() == version.getMinor(), safeReplacement, dependency, isResolved, statementCookie);
                                                this.maybeReportAgpVersionIssue(context);
                                            }
                                            return;
                                        }
                                        if (!Intrinsics.areEqual((Object)"guava", (Object)artifactId)) ** break;
                                        newerVersion.element = this.getNewerVersion(version, 21, 0);
                                        ** break;
                                    }
                                    if (!Intrinsics.areEqual((Object)"gson", (Object)artifactId)) ** break;
                                    newerVersion.element = this.getNewerVersion(version, 2, 8, 2);
                                    ** break;
                                }
                                if (!Intrinsics.areEqual((Object)"httpclient", (Object)artifactId)) ** break;
                                newerVersion.element = this.getNewerVersion(version, 4, 5, 5);
                                ** break;
                            }
                            if (!Intrinsics.areEqual((Object)"okhttp", (Object)artifactId)) ** break;
                            newerVersion.element = this.getNewerVersion(version, 3, 10, 0);
                            ** break;
                        }
                        if (!Intrinsics.areEqual((Object)"glide", (Object)artifactId)) ** break;
                        newerVersion.element = this.getNewerVersion(version, 3, 7, 0);
                        ** break;
                    }
                    if (!Intrinsics.areEqual((Object)"gradle", (Object)artifactId)) ** break;
                    parsed = GradleVersion.tryParse((String)revision);
                    if (parsed != null && parsed.compareTo("1.21.6") < 0) {
                        fix = GradleDetector.getUpdateDependencyFix$default(this, revision, "1.22.1", false, null, 12, null);
                        this.report(context, statementCookie, GradleDetector.DEPENDENCY, "Use Fabric Gradle plugin version 1.21.6 or later to " + "improve Instant Run performance (was " + revision + ')', (LintFix)fix);
                        ** break;
                    }
                    newerVersion.element = this.getNewerVersion(version, new GradleVersion(1, 25, 1));
                    ** break;
                }
                if (!Intrinsics.areEqual((Object)"bugsnag-android-gradle-plugin", (Object)artifactId)) ** break;
                if (!version.isAtLeast(2, 1, 2)) {
                    fix = GradleDetector.getUpdateDependencyFix$default(this, revision, "2.4.1", false, null, 12, null);
                    this.report(context, statementCookie, GradleDetector.DEPENDENCY, "Use BugSnag Gradle plugin version 2.1.2 or later to " + "improve Instant Run performance (was " + revision + ')', (LintFix)fix);
                    ** break;
                }
                newerVersion.element = this.getNewerVersion(version, 3, 2, 5);
                ** break;
            }
            if (!Intrinsics.areEqual((Object)"robolectric", (Object)artifactId)) ** break;
            fix = System.getProperty("os.name");
            fix = Locale.US;
            var16_16 = false;
            var17_19 = fix;
            var18_20 = false;
            v2 = var17_19;
            if (v2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            v3 = v2.toLowerCase((Locale)fix);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"(this as java.lang.String).toLowerCase(locale)");
            if (StringsKt.contains$default((CharSequence)v3, (CharSequence)"windows", (boolean)false, (int)2, null) && !version.isAtLeast(4, 2, 1)) {
                fix = GradleDetector.getUpdateDependencyFix$default(this, revision, "4.2.1", false, null, 12, null);
                this.report(context, cookie, GradleDetector.DEPENDENCY, "Use robolectric version 4.2.1 or later to fix issues with parsing of Windows paths", (LintFix)fix);
                ** break;
            }
        }
        this.checkForKtxExtension(context, groupId, artifactId, version, cookie);
        blockedDependencies = this.blockedDependencies.get(context.getProject());
        if (blockedDependencies != null && (path = blockedDependencies.checkDependency(groupId, artifactId, true)) != null && (message = this.getBlockedDependencyMessage(context, path)) != null) {
            fix = this.fix().name("Delete dependency").replace().all().build();
            this.report(context, statementCookie, GradleDetector.DUPLICATE_CLASSES, message, fix);
        }
        if ((deprecated = (sdkRegistry = this.getDeprecatedLibraryLookup(context.getClient())).getVersionInfo(dependency)) != null) {
            prefix = null;
            issue = null;
            if (Intrinsics.areEqual((Object)deprecated.getStatus(), (Object)"insecure")) {
                prefix = "This version is known to be insecure.";
                issue = GradleDetector.RISKY_LIBRARY;
            } else {
                prefix = "This version is " + deprecated.getStatus() + '.';
                issue = GradleDetector.DEPRECATED_LIBRARY;
            }
            suffix = null;
            fix = null;
            recommended = deprecated.getRecommended();
            if (recommended != null) {
                suffix = " Consider switching to recommended version " + recommended + '.';
                fix = GradleDetector.getUpdateDependencyFix$default(this, dependency.getRevision(), recommended, false, null, 12, null);
            } else {
                suffix = "";
                fix = null;
            }
            var22_25 = deprecated.getMessage();
            var23_26 = false;
            separatorDot = var22_25.length() > 0 != false && StringsKt.endsWith$default((String)deprecated.getMessage(), (String)".", (boolean)false, (int)2, null) == false ? "." : "";
            message = prefix + " Details: " + deprecated.getMessage() + separatorDot + suffix;
            this.report(context, cookie, issue, message, fix);
        } else {
            recommended = sdkRegistry.getRecommendedVersion(dependency);
            if (recommended != null && ((GradleVersion)newerVersion.element == null || recommended.compareTo((GradleVersion)newerVersion.element) > 0)) {
                newerVersion.element = recommended;
            }
        }
        issue = GradleDetector.DEPENDENCY;
        if (context.getScope().size() > 1 && context.isEnabled(GradleDetector.REMOTE_VERSION) && (latest = GradleDetector.Companion.getLatestVersionFromRemoteRepo(context.getClient(), dependency, filter, dependency.isPreview())) != null && version.compareTo(latest) < 0) {
            newerVersion.element = latest;
            issue = GradleDetector.REMOTE_VERSION;
        }
        newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)this.findCachedNewerVersion(dependency, filter));
        newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)context.getClient().getHighestKnownVersion(dependency, filter));
        newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)this.getGoogleMavenRepoVersion(context, dependency, filter));
        if (Intrinsics.areEqual((Object)groupId, (Object)"com.android.support") || Intrinsics.areEqual((Object)groupId, (Object)"com.android.support.test")) {
            this.checkSupportLibraries(context, dependency, version, (GradleVersion)newerVersion.element, cookie);
        }
        if ((GradleVersion)newerVersion.element != null && ((GradleVersion)newerVersion.element).compareTo(version) > 0) {
            versionString = ((GradleVersion)newerVersion.element).toString();
            message = this.getNewerVersionAvailableMessage(dependency, versionString, null);
            fix = isResolved == false ? GradleDetector.getUpdateDependencyFix$default(this, revision, versionString, false, null, 12, null) : null;
            this.report(context, cookie, issue, message, fix);
        }
    }

    private final Predicate<GradleVersion> getUpgradeVersionFilter(GradleContext context2, String groupId, String artifactId, String revision) {
        if (this.isSupportLibraryDependentOnCompileSdk(groupId, artifactId)) {
            if (this.compileSdkVersion >= 18) {
                return new Predicate<GradleVersion>(this){
                    final /* synthetic */ GradleDetector this$0;

                    public final boolean test(@NotNull GradleVersion version) {
                        return version.getMajor() == GradleDetector.access$getCompileSdkVersion$p(this.this$0);
                    }
                    {
                        this.this$0 = gradleDetector;
                    }
                };
            }
            if (this.targetSdkVersion > 0) {
                return new Predicate<GradleVersion>(this){
                    final /* synthetic */ GradleDetector this$0;

                    public final boolean test(@NotNull GradleVersion version) {
                        return version.getMajor() >= GradleDetector.access$getTargetSdkVersion$p(this.this$0);
                    }
                    {
                        this.this$0 = gradleDetector;
                    }
                };
            }
        }
        if (Intrinsics.areEqual((Object)groupId, (Object)"com.android.tools.build") && LintClient.Companion.isStudio()) {
            String string = context2.getClient().getClientRevision();
            if (string == null) {
                return null;
            }
            String clientRevision = string;
            GradleVersion ideVersion = GradleVersion.parse((String)clientRevision);
            GradleVersion version = GradleVersion.parse((String)revision);
            return new Predicate<GradleVersion>(ideVersion, version){
                final /* synthetic */ GradleVersion $ideVersion;
                final /* synthetic */ GradleVersion $version;

                public final boolean test(@NotNull GradleVersion v) {
                    return v.getMajor() == this.$ideVersion.getMajor() && v.getMinor() == this.$ideVersion.getMinor() || v.getMajor() == this.$version.getMajor() && v.getMinor() == this.$version.getMinor();
                }
                {
                    this.$ideVersion = gradleVersion;
                    this.$version = gradleVersion2;
                }
            };
        }
        return null;
    }

    @NotNull
    protected final File getArtifactCacheHome() {
        File file = this.artifactCacheHome;
        if (file == null) {
            File home;
            GradleDetector gradleDetector = this;
            boolean bl = false;
            boolean bl2 = false;
            GradleDetector $this$run = gradleDetector;
            boolean bl3 = false;
            $this$run.artifactCacheHome = home = new File($this$run.getGradleUserHome(), "caches" + File.separator + "modules-2" + File.separator + "files-2.1");
            file = home;
        }
        return file;
    }

    private final GradleVersion findCachedNewerVersion(GradleCoordinate dependency, Predicate<GradleVersion> filter) {
        File versionDir = new File(this.getArtifactCacheHome(), dependency.getGroupId() + File.separator + dependency.getArtifactId());
        return versionDir.exists() ? MavenRepositories.getHighestVersion((File)versionDir, filter, (boolean)MavenRepositories.isPreview((GradleCoordinate)dependency), (FileOp)FileOpUtils.create()) : null;
    }

    private final void ensureTargetCompatibleWithO(GradleContext context2, GradleVersion version, Object cookie, int major, int minor, int micro) {
        if (version != null && !version.isAtLeast(major, minor, micro)) {
            GradleVersion revision = new GradleVersion(major, minor, micro);
            GradleVersion newest = this.getNewerVersion(version, revision);
            if (newest != null) {
                revision = newest;
            }
            String message2 = "Version must be at least " + revision + " when targeting O";
            this.reportFatalCompatibilityIssue((Context)context2, cookie, message2);
        }
    }

    private final boolean checkGradlePluginDependency(GradleContext context2, GradleCoordinate dependency, Object cookie) {
        GradleCoordinate minimum = GradleCoordinate.parseCoordinateString((String)"com.android.tools.build:gradle:1.0.0");
        if (minimum != null && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, minimum) < 0) {
            GradleVersion recommended = GradleVersion.max((GradleVersion)this.getGoogleMavenRepoVersion(context2, minimum, null), (GradleVersion)GradleVersion.tryParse((String)"3.3.2"));
            String message2 = "You must use a newer version of the Android Gradle plugin. The minimum supported version is 1.0.0 and the recommended version is " + recommended;
            GradleDetector.report$default(this, context2, cookie, GRADLE_PLUGIN_COMPATIBILITY, message2, null, 16, null);
            return true;
        }
        return false;
    }

    private final void checkSupportLibraries(GradleContext context2, GradleCoordinate dependency, GradleVersion version, GradleVersion newerVersion, Object cookie) {
        String artifactId;
        String groupId = dependency.getGroupId();
        if (this.isSupportLibraryDependentOnCompileSdk(groupId, artifactId = dependency.getArtifactId()) && this.compileSdkVersion >= 18 && dependency.getMajorVersion() != this.compileSdkVersion && dependency.getMajorVersion() != -1 && context2.isEnabled(COMPATIBILITY)) {
            if (this.compileSdkVersion >= 29 && dependency.getMajorVersion() < 29) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context2, cookie, "Version 28 (intended for Android Pie and below) is the last version of the legacy support library, so we recommend that you migrate to AndroidX libraries when using Android Q and moving forward. The IDE can help with this: Refactor > Migrate to AndroidX...", null, 8, null);
                return;
            }
            LintFix fix = null;
            if (newerVersion != null) {
                fix = this.fix().name("Replace with " + newerVersion).replace().text(version.toString()).with(newerVersion.toString()).build();
            }
            String message2 = "This support library should not use a different version (" + dependency.getMajorVersion() + ") than the `compileSdkVersion` (" + this.compileSdkVersion + ")";
            this.reportNonFatalCompatibilityIssue(context2, cookie, message2, fix);
        }
        if (!this.mCheckedSupportLibs && !StringsKt.startsWith$default((String)artifactId, (String)"multidex", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)artifactId, (String)"renderscript", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)artifactId, (Object)"support-annotations") ^ true) {
            this.mCheckedSupportLibs = true;
            if (!context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
                this.checkConsistentSupportLibraries(context2, cookie);
            }
        }
        if (Intrinsics.areEqual((Object)"appcompat-v7", (Object)artifactId)) {
            IAndroidTarget buildTarget;
            boolean compile26Beta;
            boolean supportLib26Beta = version.isAtLeast(26, 0, 0, "beta", 1, true);
            boolean bl = compile26Beta = this.compileSdkVersion >= 26;
            if (this.compileSdkVersion == 26 && (buildTarget = context2.getProject().getBuildTarget()) != null && buildTarget.getVersion().isPreview()) {
                boolean bl2 = compile26Beta = buildTarget.getRevision() != 1;
            }
            if (supportLib26Beta && !compile26Beta && this.compileSdkVersion == version.getMajor()) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context2, cookie, "When using a `compileSdkVersion` older than android-O revision 2, the support library version must be 26.0.0-alpha1 or lower " + "(was " + version + ')', null, 8, null);
            } else if (!supportLib26Beta && compile26Beta) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context2, cookie, "When using a `compileSdkVersion` android-O revision 2 or higher, the support library version should be 26.0.0-beta1 " + "or higher (was " + version + ')', null, 8, null);
            }
            if (this.minSdkVersion >= 14 && this.compileSdkVersion >= 1 && this.compileSdkVersion < 21) {
                GradleDetector.report$default(this, context2, cookie, DEPENDENCY, "Using the appcompat library when minSdkVersion >= 14 and compileSdkVersion < 21 is not necessary", null, 16, null);
            }
        }
    }

    private final void checkPlayServices(GradleContext context2, GradleCoordinate dependency, GradleVersion version, String revision, Object cookie, Object statementCookie) {
        String message2;
        LintFix fix;
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        if (Intrinsics.areEqual((Object)"5.2.08", (Object)revision) && context2.isEnabled(COMPATIBILITY)) {
            GradleVersion maxVersion = GradleVersion.max((GradleVersion)GradleVersion.parse((String)"10.2.1"), (GradleVersion)this.getGoogleMavenRepoVersion(context2, dependency, null));
            fix = GradleDetector.getUpdateDependencyFix$default(this, revision, maxVersion.toString(), false, null, 12, null);
            String message3 = "Version `5.2.08` should not be used; the app " + "can not be published with this version. Use version `" + maxVersion + "` " + "instead.";
            this.reportFatalCompatibilityIssue(context2, cookie, message3, fix);
        }
        if (context2.isEnabled(BUNDLED_GMS) && PLAY_SERVICES_V650.isSameArtifact(dependency) && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, PLAY_SERVICES_V650) >= 0) {
            message2 = "Avoid using bundled version of Google Play services SDK.";
            GradleDetector.report$default(this, context2, cookie, BUNDLED_GMS, message2, null, 16, null);
        }
        if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"play-services-appindexing", (Object)artifactId)) {
            message2 = "Deprecated: Replace 'com.google.android.gms:play-services-appindexing:" + revision + "' with 'com.google.firebase:firebase-appindexing:10.0.0' or above. " + "More info: http://firebase.google.com/docs/app-indexing/android/migrate";
            fix = this.fix().name("Replace with Firebase").replace().text("com.google.android.gms:play-services-appindexing:" + revision).with("com.google.firebase:firebase-appindexing:10.2.1").build();
            this.report(context2, cookie, DEPRECATED, message2, fix);
        }
        if (this.targetSdkVersion >= 26) {
            if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"play-services-gcm", (Object)artifactId)) {
                this.ensureTargetCompatibleWithO(context2, version, cookie, 10, 2, 1);
            } else if (Intrinsics.areEqual((Object)FIREBASE_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"firebase-messaging", (Object)artifactId)) {
                this.ensureTargetCompatibleWithO(context2, version, cookie, 10, 2, 1);
            } else if (Intrinsics.areEqual((Object)"firebase-jobdispatcher", (Object)artifactId) || Intrinsics.areEqual((Object)"firebase-jobdispatcher-with-gcm-dep", (Object)artifactId)) {
                this.ensureTargetCompatibleWithO(context2, version, cookie, 0, 6, 0);
            }
        }
        if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) || Intrinsics.areEqual((Object)FIREBASE_GROUP_ID, (Object)groupId)) {
            if (!this.mCheckedGms) {
                this.mCheckedGms = true;
                if (!context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
                    this.checkConsistentPlayServices(context2, cookie);
                }
            }
        } else if (!this.mCheckedWearableLibs) {
            this.mCheckedWearableLibs = true;
            if (!context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
                this.checkConsistentWearableLibraries(context2, cookie, statementCookie);
            }
        }
    }

    private final boolean isSupportLibArtifact(LintModelMavenName $this$isSupportLibArtifact) {
        return this.isSupportLibraryDependentOnCompileSdk($this$isSupportLibArtifact.getGroupId(), $this$isSupportLibArtifact.getArtifactId());
    }

    private final boolean isAndroidxArtifact(LintModelMavenName $this$isAndroidxArtifact) {
        return StringsKt.startsWith$default((String)$this$isAndroidxArtifact.getGroupId(), (String)"androidx.", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)$this$isAndroidxArtifact.getGroupId(), (Object)"androidx.navigation") ^ true;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConsistentSupportLibraries(Context context2, Object cookie) {
        void $this$filterIsInstanceTo$iv$iv;
        this.checkConsistentLibraries(context2, cookie, "com.android.support", null);
        Iterable $this$filterIsInstance$iv = this.getAllLibraries(context2.getProject());
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LintModelExternalLibrary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List androidLibraries = (List)destination$iv$iv;
        LintModelMavenName usesOldSupportLib = null;
        LintModelMavenName usesAndroidX = null;
        for (LintModelExternalLibrary library : androidLibraries) {
            LintModelMavenName coordinates = library.getResolvedCoordinates();
            if (usesOldSupportLib == null && this.isSupportLibArtifact(coordinates)) {
                usesOldSupportLib = coordinates;
            }
            if (usesAndroidX == null && this.isAndroidxArtifact(coordinates)) {
                usesAndroidX = coordinates;
            }
            if (usesOldSupportLib == null || usesAndroidX == null) continue;
            break;
        }
        if (usesOldSupportLib != null && usesAndroidX != null) {
            String message2 = "Dependencies using groupId `com.android.support` and `androidx.*` can not be combined but " + "found `" + usesOldSupportLib + "` and `" + usesAndroidX + "` incompatible dependencies";
            if (cookie != null) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context2, cookie, message2, null, 8, null);
            } else {
                this.reportNonFatalCompatibilityIssue(context2, Lint.guessGradleLocation(context2.getProject()), message2);
            }
        }
    }

    private final void checkConsistentPlayServices(Context context2, Object cookie) {
        this.checkConsistentLibraries(context2, cookie, GMS_GROUP_ID, FIREBASE_GROUP_ID);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConsistentWearableLibraries(Context context2, Object cookie, Object statementCookie) {
        Object library2;
        void $this$filterIsInstanceTo$iv$iv;
        Project project = context2.getMainProject();
        if (!project.isGradleProject()) {
            return;
        }
        HashSet<String> supportVersions = new HashSet<String>();
        HashSet<String> wearableVersions = new HashSet<String>();
        Iterable $this$filterIsInstance$iv = this.getAllLibraries(project);
        boolean $i$f$filterIsInstance = false;
        Object object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LintModelExternalLibrary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Object library2 : (List)destination$iv$iv) {
            LintModelMavenName coordinates = library2.getResolvedCoordinates();
            if (Intrinsics.areEqual((Object)WEARABLE_ARTIFACT_ID, (Object)coordinates.getArtifactId()) && Intrinsics.areEqual((Object)GOOGLE_SUPPORT_GROUP_ID, (Object)coordinates.getGroupId())) {
                supportVersions.add(coordinates.getVersion());
            }
            if (!Intrinsics.areEqual((Object)WEARABLE_ARTIFACT_ID, (Object)coordinates.getArtifactId()) || !Intrinsics.areEqual((Object)ANDROID_WEAR_GROUP_ID, (Object)coordinates.getGroupId())) continue;
            if (!library2.getProvided()) {
                if (statementCookie != null) {
                    String message2 = "This dependency should be marked as `compileOnly`, not `compile`";
                    this.reportFatalCompatibilityIssue(context2, statementCookie, message2);
                } else {
                    String message3 = "The com.google.android.wearable:wearable dependency should be marked as `compileOnly`, not `compile`";
                    this.reportFatalCompatibilityIssue(context2, Lint.guessGradleLocation(context2.getProject()), message3);
                }
            }
            wearableVersions.add(coordinates.getVersion());
        }
        library2 = supportVersions;
        boolean bl = false;
        if (!library2.isEmpty()) {
            String message4;
            if (wearableVersions.isEmpty()) {
                ArrayList list2 = new ArrayList(supportVersions);
                String first = (String)Collections.min(list2);
                message4 = "Project depends on com.google.android.support:wearable:" + first + ", " + "so it must also depend (as a provided dependency) on " + "com.google.android.wearable:wearable:" + first;
                if (cookie != null) {
                    this.reportFatalCompatibilityIssue(context2, cookie, message4);
                } else {
                    this.reportFatalCompatibilityIssue(context2, Lint.guessGradleLocation(context2.getProject()), message4);
                }
            } else if (Intrinsics.areEqual(supportVersions, wearableVersions) ^ true) {
                ArrayList sortedSupportVersions = new ArrayList(supportVersions);
                CollectionsKt.sort((List)sortedSupportVersions);
                ArrayList supportedWearableVersions = new ArrayList(wearableVersions);
                CollectionsKt.sort((List)supportedWearableVersions);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                object = "The wearable libraries for %1$s and %2$s must use **exactly** the same versions; found %3$s and %4$s";
                Object[] objectArray = new Object[]{GOOGLE_SUPPORT_GROUP_ID, ANDROID_WEAR_GROUP_ID, sortedSupportVersions.size() == 1 ? (String)sortedSupportVersions.get(0) : sortedSupportVersions.toString(), supportedWearableVersions.size() == 1 ? (String)supportedWearableVersions.get(0) : supportedWearableVersions.toString()};
                boolean bl2 = false;
                String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
                message4 = string;
                if (cookie != null) {
                    this.reportFatalCompatibilityIssue(context2, cookie, message4);
                } else {
                    this.reportFatalCompatibilityIssue(context2, Lint.guessGradleLocation(context2.getProject()), message4);
                }
            }
        }
    }

    private final List<LintModelLibrary> getAllLibraries(Project project) {
        Object object = project.getBuildVariant();
        if (object == null || (object = object.getMainArtifact()) == null || (object = object.getDependencies()) == null || (object = object.getAll()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConsistentLibraries(Context context2, Object cookie, String groupId, String groupId2) {
        void $this$filterIsInstanceTo$iv$iv;
        Project project = context2.getMainProject();
        ArrayListMultimap versionToCoordinate = ArrayListMultimap.create();
        Iterable $this$filterIsInstance$iv = this.getAllLibraries(project);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LintModelExternalLibrary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allLibraries = (List)destination$iv$iv;
        for (LintModelExternalLibrary library : allLibraries) {
            LintModelMavenName coordinates = library.getResolvedCoordinates();
            if (!Intrinsics.areEqual((Object)coordinates.getGroupId(), (Object)groupId) && !Intrinsics.areEqual((Object)coordinates.getGroupId(), (Object)groupId2) || StringsKt.startsWith$default((String)coordinates.getArtifactId(), (String)"multidex", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)coordinates.getArtifactId(), (String)"renderscript", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)coordinates.getArtifactId(), (String)"firebase-jobdispatcher", (boolean)false, (int)2, null) || !(Intrinsics.areEqual((Object)coordinates.getArtifactId(), (Object)"support-annotations") ^ true)) continue;
            versionToCoordinate.put((Object)coordinates.getVersion(), (Object)coordinates);
        }
        Set versions = versionToCoordinate.keySet();
        if (versions.size() > 1) {
            GradleVersion version;
            ArrayList sortedVersions = new ArrayList(versions);
            CollectionsKt.sortWith((List)sortedVersions, Collections.reverseOrder());
            LintModelMavenName c1 = this.findFirst(versionToCoordinate.get(sortedVersions.get(0)));
            LintModelMavenName c2 = this.findFirst(versionToCoordinate.get(sortedVersions.get(1)));
            if ((Intrinsics.areEqual((Object)groupId, (Object)GMS_GROUP_ID) || Intrinsics.areEqual((Object)groupId, (Object)FIREBASE_GROUP_ID)) && (version = GradleVersion.tryParse((String)c2.getVersion())) != null && (version.getMajor() >= 14 || version.getMajor() == 0)) {
                return;
            }
            String example1 = c1.getGroupId() + ":" + c1.getArtifactId() + ":" + c1.getVersion();
            String example2 = c2.getGroupId() + ":" + c2.getArtifactId() + ":" + c2.getVersion();
            String groupDesc = Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) ? "gms/firebase" : groupId;
            String message2 = "All " + groupDesc + " libraries must use the exact same " + "version specification (mixing versions can lead to runtime crashes). " + "Found versions " + Joiner.on((String)", ").join((Iterable)sortedVersions) + ". " + "Examples include `" + example1 + "` and `" + example2 + "`";
            Object object = project.getBuildVariant();
            if (object == null || (object = object.getMainArtifact()) == null || (object = object.getDependencies()) == null || (object = object.getCompileDependencies()) == null || (object = object.getAllGraphItems()) == null) {
                object = CollectionsKt.emptyList();
            }
            List<LintModelDependency> allItems = object;
            block2: for (LintModelDependency library : allItems) {
                if (!Intrinsics.areEqual((Object)library.getArtifactName(), (Object)"com.android.databinding:library")) continue;
                for (LintModelDependency dep : library.getDependencies()) {
                    Comparable<LintModelLibrary> comparable;
                    Comparable<LintModelLibrary> comparable2;
                    Comparable<LintModelLibrary> comparable3;
                    if (!Intrinsics.areEqual((Object)dep.getArtifactName(), (Object)"com.android.support:support-v4")) continue;
                    String string = (String)sortedVersions.get(0);
                    LintModelLibrary lintModelLibrary = dep.findLibrary();
                    if (!(lintModelLibrary instanceof LintModelExternalLibrary)) {
                        lintModelLibrary = null;
                    }
                    if (!(Intrinsics.areEqual((Object)string, (comparable3 = (LintModelExternalLibrary)lintModelLibrary) != null && (comparable3 = comparable3.getResolvedCoordinates()) != null ? comparable3.getVersion() : null) ^ true)) continue;
                    StringBuilder stringBuilder = new StringBuilder().append(message2).append(". Note that this project is using data binding (com.android.databinding:library:");
                    LintModelLibrary lintModelLibrary2 = library.findLibrary();
                    if (!(lintModelLibrary2 instanceof LintModelExternalLibrary)) {
                        lintModelLibrary2 = null;
                    }
                    StringBuilder stringBuilder2 = stringBuilder.append((comparable2 = (LintModelExternalLibrary)lintModelLibrary2) != null && (comparable2 = comparable2.getResolvedCoordinates()) != null ? comparable2.getVersion() : null).append(") which pulls in com.android.support:support-v4:");
                    LintModelLibrary lintModelLibrary3 = dep.findLibrary();
                    if (!(lintModelLibrary3 instanceof LintModelExternalLibrary)) {
                        lintModelLibrary3 = null;
                    }
                    message2 = stringBuilder2.append((comparable = (LintModelExternalLibrary)lintModelLibrary3) != null && (comparable = comparable.getResolvedCoordinates()) != null ? comparable.getVersion() : null).append(". You can try to work around this ").append("by adding an explicit dependency on ").append("com.android.support:support-v4:").append((String)sortedVersions.get(0)).toString();
                    break block2;
                }
            }
            if (cookie != null) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context2, cookie, message2, null, 8, null);
            } else {
                File projectDir = context2.getProject().getDir();
                Location location1 = Lint.guessGradleLocation(context2.getClient(), projectDir, example1);
                Location location2 = Lint.guessGradleLocation(context2.getClient(), projectDir, example2);
                if (location1.getStart() != null) {
                    if (location2.getStart() != null) {
                        location1.setSecondary(location2);
                    }
                } else if (location2.getStart() == null) {
                    location1 = Lint.guessGradleLocation(context2.getClient(), projectDir, c1.getGroupId() + ":" + c1.getArtifactId() + ":");
                    if (location1.getStart() == null) {
                        location1 = Lint.guessGradleLocation(context2.getClient(), projectDir, c2.getGroupId() + ":" + c2.getArtifactId() + ":");
                    }
                } else {
                    location1 = location2;
                }
                this.reportNonFatalCompatibilityIssue(context2, location1, message2);
            }
        }
    }

    @Override
    public void beforeCheckRootProject(@NotNull Context context2) {
        Project project = context2.getProject();
        ((Map)this.blockedDependencies).put(project, new BlockedDependencies(project));
    }

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Project project = context2.getProject();
        if (project == context2.getMainProject() && context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
            this.checkConsistentPlayServices(context2, null);
            this.checkConsistentSupportLibraries(context2, null);
            this.checkConsistentWearableLibraries(context2, null, null);
        }
        this.checkBlockedDependencies(context2, project);
    }

    @Override
    public void afterCheckFile(@NotNull Context context2) {
        if (!(!this.mAppliedJavaPlugin || this.mDeclaredSourceCompatibility && this.mDeclaredTargetCompatibility)) {
            File file = context2.file;
            String contents = ((Object)context2.getClient().readFile(file)).toString();
            String message2 = this.mDeclaredTargetCompatibility ? "no Java sourceCompatibility directive" : (this.mDeclaredSourceCompatibility ? "no Java targetCompatibility directive" : "no Java language level directives");
            String fixDisplayName = this.mDeclaredTargetCompatibility ? "Insert sourceCompatibility directive for JDK8" : (this.mDeclaredSourceCompatibility ? "Insert targetCompatibility directive for JDK8" : "Insert JDK8 language level directives");
            String insertion = this.mDeclaredTargetCompatibility ? "\njava.sourceCompatibility = JavaVersion.VERSION_1_8" : (this.mDeclaredSourceCompatibility ? "\njava.targetCompatibility = JavaVersion.VERSION_1_8" : "\njava {\n    sourceCompatibility = JavaVersion.VERSION_1_8\n    targetCompatibility = JavaVersion.VERSION_1_8\n}");
            LintFix fix = LintFix.create().replace().name(fixDisplayName).range(Location.Companion.create(context2.file, contents, 0, contents.length())).end().with(insertion).build();
            JavaPluginInfo javaPluginInfo = this.mJavaPluginInfo;
            if (javaPluginInfo == null) {
                Intrinsics.throwNpe();
            }
            this.report(context2, javaPluginInfo.getCookie(), JAVA_PLUGIN_LANGUAGE_LEVEL, message2, fix);
        }
    }

    private final void maybeReportAgpVersionIssue(Context context2) {
        block1: {
            if (!this.mDeclaredGoogleMavenRepository) break block1;
            AgpVersionCheckInfo agpVersionCheckInfo = this.agpVersionCheckInfo;
            if (agpVersionCheckInfo != null) {
                AgpVersionCheckInfo agpVersionCheckInfo2 = agpVersionCheckInfo;
                boolean bl = false;
                boolean bl2 = false;
                AgpVersionCheckInfo it = agpVersionCheckInfo2;
                boolean bl3 = false;
                String versionString = it.getNewerVersion().toString();
                String message2 = this.getNewerVersionAvailableMessage(it.getDependency(), versionString, it.getSafeReplacement());
                LintFix fix = it.isResolved() ? null : this.getUpdateDependencyFix(it.getDependency().getRevision(), versionString, it.getNewerVersionIsSafe(), it.getSafeReplacement());
                this.report(context2, it.getCookie(), AGP_DEPENDENCY, message2, fix);
            }
        }
    }

    private final void checkForKtxExtension(Context context2, String groupId, String artifactId, GradleVersion version, Object cookie) {
        if (!this.mAppliedKotlinAndroidPlugin) {
            return;
        }
        if (StringsKt.endsWith$default((String)artifactId, (String)"-ktx", (boolean)false, (int)2, null)) {
            return;
        }
        String mavenName = groupId + ':' + artifactId;
        if (!GradleDetector.Companion.libraryHasKtxExtension(mavenName)) {
            return;
        }
        LintModelVariant lintModelVariant = context2.getProject().getBuildVariant();
        if (lintModelVariant == null) {
            return;
        }
        LintModelVariant variant = lintModelVariant;
        if (variant.getMainArtifact().findCompileDependency("org.jetbrains.kotlin:kotlin-stdlib") == null) {
            return;
        }
        GoogleMavenRepository repository = this.getGoogleMavenRepository(context2.getClient());
        if (repository.findVersion(groupId, artifactId + "-ktx", (Function1)new Function1<GradleVersion, Boolean>(version){
            final /* synthetic */ GradleVersion $version;

            public final boolean invoke(@NotNull GradleVersion it) {
                return Intrinsics.areEqual((Object)it, (Object)this.$version);
            }
            {
                this.$version = gradleVersion;
                super(1);
            }
        }, true) == null) {
            return;
        }
        String msg = "Add suffix `-ktx` to enable the Kotlin extensions for this library";
        LintFix fix = this.fix().name("Replace with KTX dependency").replace().text(mavenName).with(mavenName + "-ktx").build();
        this.report(context2, cookie, KTX_EXTENSION_AVAILABLE, msg, fix);
    }

    private final void checkBlockedDependencies(Context context2, Project project) {
        BlockedDependencies blockedDependencies = this.blockedDependencies.get(project);
        if (blockedDependencies == null) {
            return;
        }
        BlockedDependencies blockedDependencies2 = blockedDependencies;
        List<List<LintModelDependency>> dependencies = blockedDependencies2.getForbiddenDependencies();
        Collection collection = dependencies;
        boolean bl = false;
        if (!collection.isEmpty()) {
            for (List<LintModelDependency> path2 : dependencies) {
                String message2;
                if (this.getBlockedDependencyMessage(context2, path2) == null) {
                    continue;
                }
                File projectDir = context2.getProject().getDir();
                String mavenName = path2.get(0).getArtifactName();
                Location location = Lint.guessGradleLocation(context2.getClient(), projectDir, mavenName);
                if (location.getStart() == null) {
                    String artifactId = path2.get(0).getArtifactId();
                    location = Lint.guessGradleLocation(context2.getClient(), projectDir, artifactId);
                }
                Context.report$default(context2, DUPLICATE_CLASSES, location, message2, null, 8, null);
            }
        }
        this.blockedDependencies.remove(project);
    }

    private final void report(Context context2, Object cookie, Issue issue, String message2, LintFix fix) {
        context2.getClient().runReadAction(new Runnable(context2, issue, cookie, message2, fix){
            final /* synthetic */ Context $context;
            final /* synthetic */ Issue $issue;
            final /* synthetic */ Object $cookie;
            final /* synthetic */ String $message;
            final /* synthetic */ LintFix $fix;

            public final void run() {
                if (this.$context.isEnabled(this.$issue) && this.$context instanceof GradleContext) {
                    boolean checkComments = this.$context.containsCommentSuppress();
                    if (checkComments && ((GradleContext)this.$context).isSuppressedWithComment(this.$cookie, this.$issue)) {
                        return;
                    }
                    Location location = ((GradleContext)this.$context).getLocation(this.$cookie);
                    this.$context.report(this.$issue, location, this.$message, this.$fix);
                }
            }
            {
                this.$context = context2;
                this.$issue = issue;
                this.$cookie = object;
                this.$message = string;
                this.$fix = lintFix;
            }
        });
    }

    static /* synthetic */ void report$default(GradleDetector gradleDetector, Context context2, Object object, Issue issue, String string, LintFix lintFix, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        gradleDetector.report(context2, object, issue, string, lintFix);
    }

    private final void reportFatalCompatibilityIssue(Context context2, Object cookie, String message2) {
        GradleDetector.report$default(this, context2, cookie, COMPATIBILITY, message2, null, 16, null);
    }

    private final void reportFatalCompatibilityIssue(Context context2, Object cookie, String message2, LintFix fix) {
        this.report(context2, cookie, COMPATIBILITY, message2, fix);
    }

    private final void reportNonFatalCompatibilityIssue(Context context2, Object cookie, String message2, LintFix lintFix) {
        if (context2.getDriver().getFatalOnlyMode()) {
            return;
        }
        this.report(context2, cookie, COMPATIBILITY, message2, lintFix);
    }

    static /* synthetic */ void reportNonFatalCompatibilityIssue$default(GradleDetector gradleDetector, Context context2, Object object, String string, LintFix lintFix, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportNonFatalCompatibilityIssue");
        }
        if ((n & 8) != 0) {
            lintFix = null;
        }
        gradleDetector.reportNonFatalCompatibilityIssue(context2, object, string, lintFix);
    }

    private final void reportFatalCompatibilityIssue(Context context2, Location location, String message2) {
        context2.getClient().runReadAction(new Runnable(context2, location, message2){
            final /* synthetic */ Context $context;
            final /* synthetic */ Location $location;
            final /* synthetic */ String $message;

            public final void run() {
                Context.report$default(this.$context, GradleDetector.COMPATIBILITY, this.$location, this.$message, null, 8, null);
            }
            {
                this.$context = context2;
                this.$location = location;
                this.$message = string;
            }
        });
    }

    private final void reportNonFatalCompatibilityIssue(Context context2, Location location, String message2) {
        if (context2.getDriver().getFatalOnlyMode()) {
            return;
        }
        context2.getClient().runReadAction(new Runnable(context2, location, message2){
            final /* synthetic */ Context $context;
            final /* synthetic */ Location $location;
            final /* synthetic */ String $message;

            public final void run() {
                Context.report$default(this.$context, GradleDetector.COMPATIBILITY, this.$location, this.$message, null, 8, null);
            }
            {
                this.$context = context2;
                this.$location = location;
                this.$message = string;
            }
        });
    }

    private final int getSdkVersion(String value) {
        int version = 0;
        if (GradleContext.Companion.isStringLiteral(value)) {
            String codeName = GradleContext.Companion.getStringLiteralValue(value);
            if (codeName != null) {
                if (Lint.isNumberString(codeName)) {
                    return -1;
                }
                AndroidVersion androidVersion = SdkVersionInfo.getVersion((String)codeName, null);
                if (androidVersion != null) {
                    version = androidVersion.getFeatureLevel();
                }
            }
        } else {
            version = GradleContext.Companion.getIntLiteralValue(value, -1);
        }
        return version;
    }

    private final GradleCoordinate resolveCoordinate(GradleContext context2, String property, GradleCoordinate gc) {
        boolean bl = StringsKt.contains$default((CharSequence)gc.getRevision(), (CharSequence)"$", (boolean)false, (int)2, null);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-GradleDetector$resolveCoordinate$22 = false;
            String $i$a$-assert-GradleDetector$resolveCoordinate$22 = gc.getRevision();
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-GradleDetector$resolveCoordinate$22));
        }
        Project project = context2.getProject();
        LintModelVariant variant = project.getBuildVariant();
        if (variant != null) {
            LintModelArtifact lintModelArtifact = StringsKt.startsWith$default((String)property, (String)"androidTest", (boolean)false, (int)2, null) ? (LintModelArtifact)variant.getAndroidTestArtifact() : (StringsKt.startsWith$default((String)property, (String)"test", (boolean)false, (int)2, null) ? (LintModelArtifact)variant.getTestArtifact() : (LintModelArtifact)variant.getMainArtifact());
            if (lintModelArtifact == null) {
                return null;
            }
            LintModelArtifact artifact = lintModelArtifact;
            for (LintModelLibrary library : artifact.getDependencies().getAll()) {
                LintModelMavenName mc;
                if (!(library instanceof LintModelExternalLibrary) || !Intrinsics.areEqual((Object)(mc = ((LintModelExternalLibrary)library).getResolvedCoordinates()).getGroupId(), (Object)gc.getGroupId()) || !Intrinsics.areEqual((Object)mc.getArtifactId(), (Object)gc.getArtifactId())) continue;
                List revisions = GradleCoordinate.parseRevisionNumber((String)mc.getVersion());
                Collection collection = revisions;
                boolean bl3 = false;
                if (!(!collection.isEmpty())) break;
                return new GradleCoordinate(mc.getGroupId(), mc.getArtifactId(), revisions, null);
            }
        }
        return null;
    }

    private final boolean usesLegacyHttpLibrary(Project project) {
        LintModelModule lintModelModule = project.getBuildModule();
        if (lintModelModule == null) {
            return false;
        }
        LintModelModule model = lintModelModule;
        for (File path2 : model.getBootClassPath()) {
            if (!FilesKt.endsWith((File)path2, (String)"org.apache.http.legacy.jar")) continue;
            return true;
        }
        return false;
    }

    private final LintFix getUpdateDependencyFix(String currentVersion, String suggestedVersion, boolean suggestedVersionIsSafe, GradleVersion safeReplacement) {
        LintFix lintFix;
        LintFix fix = LintFix.create().name("Change to " + suggestedVersion).sharedName("Update versions").replace().text(currentVersion).with(suggestedVersion).autoFix(suggestedVersionIsSafe, suggestedVersionIsSafe).build();
        if (safeReplacement != null) {
            String stableVersion = safeReplacement.toString();
            LintFix stableFix = LintFix.create().name("Change to " + stableVersion).sharedName("Update versions").replace().text(currentVersion).with(stableVersion).autoFix().build();
            lintFix = LintFix.create().alternatives(fix, stableFix);
        } else {
            lintFix = fix;
        }
        return lintFix;
    }

    static /* synthetic */ LintFix getUpdateDependencyFix$default(GradleDetector gradleDetector, String string, String string2, boolean bl, GradleVersion gradleVersion, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUpdateDependencyFix");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            gradleVersion = null;
        }
        return gradleDetector.getUpdateDependencyFix(string, string2, bl, gradleVersion);
    }

    private final String getNewerVersionAvailableMessage(GradleCoordinate dependency, String version, GradleVersion stable) {
        StringBuilder message2 = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$with = message2;
        boolean bl3 = false;
        $this$with.append("A newer version of ");
        $this$with.append(dependency.getGroupId());
        $this$with.append(":");
        $this$with.append(dependency.getArtifactId());
        $this$with.append(" than ");
        $this$with.append(dependency.getRevision());
        $this$with.append(" is available: ");
        $this$with.append(version);
        if (stable != null) {
            $this$with.append(". (There is also a newer version of ");
            $this$with.append(String.valueOf(stable.getMajor()));
            $this$with.append(".");
            $this$with.append(String.valueOf(stable.getMinor()));
            $this$with.append(".\ud835\udc65 available, if upgrading to ");
            $this$with.append(version);
            $this$with.append(" is difficult: ");
            $this$with.append(stable.toString());
            $this$with.append(")");
        }
        return message2.toString();
    }

    private final boolean isSupportLibraryDependentOnCompileSdk(String groupId, String artifactId) {
        return Intrinsics.areEqual((Object)"com.android.support", (Object)groupId) && !StringsKt.startsWith$default((String)artifactId, (String)"multidex", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)artifactId, (String)"renderscript", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)artifactId, (Object)"support-annotations") ^ true;
    }

    private final LintModelMavenName findFirst(Collection<? extends LintModelMavenName> coordinates) {
        return Collections.min(coordinates, findFirst.1.INSTANCE);
    }

    private final String getBlockedDependencyMessage(Context context2, List<? extends LintModelDependency> path2) {
        if (context2.getMainProject().getMinSdkVersion().getApiLevel() >= 23 && !this.usesLegacyHttpLibrary(context2.getMainProject())) {
            return null;
        }
        boolean direct = path2.size() == 1;
        String message2 = null;
        String resolution = "Solutions include finding newer versions or alternative libraries that don't have the same problem (for example, for `httpclient` use `HttpUrlConnection` or `okhttp` instead), or repackaging the library using something like `jarjar`.";
        if (direct) {
            message2 = '`' + path2.get(0).getArtifactId() + "` defines classes that conflict with classes now provided by Android. " + resolution;
        } else {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (LintModelDependency lintModelDependency : path2) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" \u2192 ");
                }
                String coordinates = lintModelDependency.getArtifactName();
                sb.append(coordinates);
            }
            sb.append(") ");
            String string = sb.toString();
            message2 = '`' + path2.get(0).getArtifactId() + "` depends on a library " + '(' + path2.get(path2.size() - 1).getArtifactName() + ") which defines " + "classes that conflict with classes now provided by Android. " + resolution + ' ' + "Dependency chain: " + string;
        }
        return message2;
    }

    private final GradleVersion getNewerVersion(GradleVersion version1, int major, int minor, int micro) {
        return !version1.isAtLeast(major, minor, micro) ? new GradleVersion(major, minor, micro) : null;
    }

    private final GradleVersion getNewerVersion(GradleVersion version1, int major, int minor) {
        return !version1.isAtLeast(major, minor, 0) ? new GradleVersion(major, minor) : null;
    }

    private final GradleVersion getNewerVersion(GradleVersion version1, GradleVersion version2) {
        return version1.compareTo(version2) < 0 ? version2 : null;
    }

    private final GradleVersion getGoogleMavenRepoVersion(GradleContext context2, GradleCoordinate dependency, Predicate<GradleVersion> filter) {
        GoogleMavenRepository repository = this.getGoogleMavenRepository(context2.getClient());
        return repository.findVersion(dependency, filter, dependency.isPreview());
    }

    private final GoogleMavenRepository getGoogleMavenRepository(LintClient client) {
        GoogleMavenRepository googleMavenRepository = this.googleMavenRepository;
        if (googleMavenRepository == null) {
            GradleDetector gradleDetector = this;
            boolean bl = false;
            boolean bl2 = false;
            GradleDetector $this$run = gradleDetector;
            boolean bl3 = false;
            File cacheDir = client.getCacheDir("maven.google", true);
            GoogleMavenRepository repository = new GoogleMavenRepository(cacheDir, cacheDir, client){
                final /* synthetic */ File $cacheDir;
                final /* synthetic */ LintClient $client$inlined;
                {
                    this.$cacheDir = $captured_local_variable$1;
                    this.$client$inlined = lintClient;
                    super($super_call_param$2, 0, 0, false, 14, null);
                }

                @Nullable
                public byte[] readUrlData(@NotNull String url, int timeout) {
                    return Lint.readUrlData(this.$client$inlined, url, timeout);
                }

                public void error(@NotNull Throwable throwable, @Nullable String message2) {
                    this.$client$inlined.log(throwable, message2, new Object[0]);
                }
            };
            $this$run.googleMavenRepository = repository;
            googleMavenRepository = repository;
        }
        return googleMavenRepository;
    }

    private final DeprecatedSdkRegistry getDeprecatedLibraryLookup(LintClient client) {
        DeprecatedSdkRegistry deprecatedSdkRegistry = this.deprecatedSdkRegistry;
        if (deprecatedSdkRegistry == null) {
            GradleDetector gradleDetector = this;
            boolean bl = false;
            boolean bl2 = false;
            GradleDetector $this$run = gradleDetector;
            boolean bl3 = false;
            File cacheDir = client.getCacheDir("sdk-registry.xml", true);
            DeprecatedSdkRegistry repository = new DeprecatedSdkRegistry(cacheDir, cacheDir, client){
                final /* synthetic */ File $cacheDir;
                final /* synthetic */ LintClient $client$inlined;
                {
                    this.$cacheDir = $captured_local_variable$1;
                    this.$client$inlined = lintClient;
                    super($super_call_param$2);
                }

                @Nullable
                public byte[] readUrlData(@NotNull String url, int timeout) {
                    return Lint.readUrlData(this.$client$inlined, url, timeout);
                }

                public void error(@NotNull Throwable throwable, @Nullable String message2) {
                    this.$client$inlined.log(throwable, message2, new Object[0]);
                }
            };
            $this$run.deprecatedSdkRegistry = repository;
            deprecatedSdkRegistry = repository;
        }
        return deprecatedSdkRegistry;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_9;
        void $this$flatMapTo$iv$iv;
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(GradleDetector.class, Scope.GRADLE_SCOPE);
        DEPENDENCY = Issue.Companion.create("GradleDependency", "Obsolete Gradle Dependency", "\n                This detector looks for usages of libraries where the version you are using \\\n                is not the current stable release. Using older versions is fine, and there \\\n                are cases where you deliberately want to stick with an older version. \\\n                However, you may simply not be aware that a more recent version is \\\n                available, and that is what this lint check helps find.", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Object object = true;
        Object object2 = Severity.WARNING;
        int n = 4;
        Object object3 = null;
        Object object4 = Category.CORRECTNESS;
        AGP_DEPENDENCY = Issue.Companion.create$default(Issue.Companion, "AndroidGradlePluginVersion", "Obsolete Android Gradle Plugin Version", "\n                This detector looks for usage of the Android Gradle Plugin where the version \\\n                you are using is not the current stable release. Using older versions is fine, \\\n                and there are cases where you deliberately want to stick with an older version. \\\n                However, you may simply not be aware that a more recent version is available, \\\n                and that is what this lint check helps find.", implementation, object3, (Category)object4, n, (Severity)((Object)object2), bl, object, enumSet, collection, 3344, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        object = Severity.WARNING;
        object2 = true;
        n = 6;
        object3 = null;
        object4 = Category.CORRECTNESS;
        DEPRECATED = Issue.Companion.create$default(Issue.Companion, "GradleDeprecated", "Deprecated Gradle Construct", "\n                This detector looks for deprecated Gradle constructs which currently work \\\n                but will likely stop working in a future update.", implementation, object3, (Category)object4, n, (Severity)((Object)object), bl, (Boolean)object2, enumSet, collection, 3344, null);
        collection = null;
        enumSet = null;
        implementation = null;
        bl = false;
        object = IMPLEMENTATION;
        object2 = Severity.WARNING;
        n = 6;
        object3 = "https://d.android.com/r/tools/update-dependency-configurations";
        object4 = Category.CORRECTNESS;
        DEPRECATED_CONFIGURATION = Issue.Companion.create$default(Issue.Companion, "GradleDeprecatedConfiguration", "Deprecated Gradle Configuration", "\n                Some Gradle configurations have been deprecated since Android Gradle Plugin 3.0.0 \\\n                and will be removed in a future version of the Android Gradle Plugin.\n             ", (Implementation)object, (String)object3, (Category)object4, n, (Severity)((Object)object2), bl, (Boolean)((Object)implementation), enumSet, collection, 3840, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        object = true;
        object2 = Severity.ERROR;
        n = 8;
        object3 = null;
        object4 = Category.CORRECTNESS;
        GRADLE_PLUGIN_COMPATIBILITY = Issue.Companion.create$default(Issue.Companion, "GradlePluginVersion", "Incompatible Android Gradle Plugin", "\n                Not all versions of the Android Gradle plugin are compatible with all \\\n                versions of the SDK. If you update your tools, or if you are trying to \\\n                open a project that was built with an old version of the tools, you may \\\n                need to update your plugin version number.", implementation, (String)object3, (Category)object4, n, (Severity)((Object)object2), bl, object, enumSet, collection, 3344, null);
        PATH = Issue.Companion.create("GradlePath", "Gradle Path Issues", "\n                Gradle build scripts are meant to be cross platform, so file paths use \\\n                Unix-style path separators (a forward slash) rather than Windows path \\\n                separators (a backslash). Similarly, to keep projects portable and \\\n                repeatable, avoid using absolute paths on the system; keep files within \\\n                the project instead. To share code between projects, consider creating \\\n                an android-library and an AAR dependency", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        IDE_SUPPORT = Issue.Companion.create("GradleIdeError", "Gradle IDE Support Issues", "\n                Gradle is highly flexible, and there are things you can do in Gradle \\\n                files which can make it hard or impossible for IDEs to properly handle \\\n                the project. This lint check looks for constructs that potentially \\\n                break IDE support.", Category.CORRECTNESS, 4, Severity.ERROR, IMPLEMENTATION);
        PLUS = Issue.Companion.create("GradleDynamicVersion", "Gradle Dynamic Version", "\n                Using `+` in dependencies lets you automatically pick up the latest \\\n                available version rather than a specific, named version. However, \\\n                this is not recommended; your builds are not repeatable; you may have \\\n                tested with a slightly different version than what the build server \\\n                used. (Using a dynamic version as the major version number is more \\\n                problematic than using it in the minor version position.)", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        object = true;
        object2 = Severity.ERROR;
        n = 6;
        object3 = null;
        object4 = Category.CORRECTNESS;
        GRADLE_GETTER = Issue.Companion.create$default(Issue.Companion, "GradleGetter", "Gradle Implicit Getter Call", "\n                Gradle will let you replace specific constants in your build scripts \\\n                with method calls, so you can for example dynamically compute a version \\\n                string based on your current version control revision number, rather \\\n                than hardcoding a number.\n\n                When computing a version name, it's tempting to for example call the \\\n                method to do that `getVersionName`. However, when you put that method \\\n                call inside the `defaultConfig` block, you will actually be calling the \\\n                Groovy getter for the `versionName` property instead. Therefore, you \\\n                need to name your method something which does not conflict with the \\\n                existing implicit getters. Consider using `compute` as a prefix instead \\\n                of `get`.", implementation, (String)object3, (Category)object4, n, (Severity)((Object)object2), bl, object, enumSet, collection, 3344, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        object = true;
        object2 = Severity.FATAL;
        n = 8;
        object3 = null;
        object4 = Category.CORRECTNESS;
        COMPATIBILITY = Issue.Companion.create$default(Issue.Companion, "GradleCompatible", "Incompatible Gradle Versions", "\n                There are some combinations of libraries, or tools and libraries, that \\\n                are incompatible, or can lead to bugs. One such incompatibility is \\\n                compiling with a version of the Android support libraries that is not \\\n                the latest version (or in particular, a version lower than your \\\n                `targetSdkVersion`).", implementation, (String)object3, (Category)object4, n, (Severity)((Object)object2), bl, object, enumSet, collection, 3344, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        object = true;
        object2 = Severity.ERROR;
        n = 8;
        object3 = null;
        object4 = Category.CORRECTNESS;
        STRING_INTEGER = Issue.Companion.create$default(Issue.Companion, "StringShouldBeInt", "String should be int", "\n                The properties `compileSdkVersion`, `minSdkVersion` and `targetSdkVersion` \\\n                are usually numbers, but can be strings when you are using an add-on (in \\\n                the case of `compileSdkVersion`) or a preview platform (for the other two \\\n                properties).\n\n                However, you can not use a number as a string (e.g. \"19\" instead of 19); \\\n                that will result in a platform not found error message at build/sync \\\n                time.", implementation, (String)object3, (Category)object4, n, (Severity)((Object)object2), bl, object, enumSet, collection, 3344, null);
        collection = null;
        enumSet = null;
        implementation = null;
        bl = false;
        object = IMPLEMENTATION;
        object2 = Severity.ERROR;
        n = 8;
        object3 = Category.CORRECTNESS;
        object4 = "https://www.groovy-lang.org/syntax.html#_string_interpolation";
        NOT_INTERPOLATED = Issue.Companion.create$default(Issue.Companion, "NotInterpolated", "Incorrect Interpolation", "\n                To insert the value of a variable, you can use `${variable}` inside a \\\n                string literal, but **only** if you are using double quotes!", (Implementation)object, (String)object4, (Category)object3, n, (Severity)((Object)object2), bl, (Boolean)((Object)implementation), enumSet, collection, 3840, null);
        collection = null;
        enumSet = null;
        implementation = null;
        bl = false;
        object = IMPLEMENTATION;
        object2 = Severity.WARNING;
        n = 4;
        object3 = null;
        object4 = Category.CORRECTNESS;
        REMOTE_VERSION = Issue.Companion.create$default(Issue.Companion, "NewerVersionAvailable", "Newer Library Versions Available", "\n                This detector checks with a central repository to see if there are newer \\\n                versions available for the dependencies used by this project. This is \\\n                similar to the `GradleDependency` check, which checks for newer versions \\\n                available in the Android SDK tools and libraries, but this works with any \\\n                MavenCentral dependency, and connects to the library every time, which \\\n                makes it more flexible but also **much** slower.", (Implementation)object, (String)object3, (Category)object4, n, (Severity)((Object)object2), bl, (Boolean)((Object)implementation), enumSet, collection, 3600, null);
        collection = null;
        enumSet = null;
        boolean bl2 = false;
        Boolean bl3 = true;
        object = IMPLEMENTATION;
        object2 = Severity.WARNING;
        n = 4;
        object3 = null;
        object4 = Category.CORRECTNESS;
        MIN_SDK_TOO_LOW = Issue.Companion.create$default(Issue.Companion, "MinSdkTooLow", "API Version Too Low", "\n                The value of the `minSdkVersion` property is too low and can be \\\n                incremented without noticeably reducing the number of supported \\\n                devices.", (Implementation)object, (String)object3, (Category)object4, n, (Severity)((Object)object2), bl2, bl3, enumSet, collection, 3088, null);
        ACCIDENTAL_OCTAL = Issue.Companion.create("AccidentalOctal", "Accidental Octal", "\n                In Groovy, an integer literal that starts with a leading 0 will be \\\n                interpreted as an octal number. That is usually (always?) an accident \\\n                and can lead to subtle bugs, for example when used in the `versionCode` \\\n                of an app.", Category.CORRECTNESS, 2, Severity.ERROR, IMPLEMENTATION);
        collection = null;
        enumSet = null;
        Object object5 = IMPLEMENTATION;
        boolean bl4 = false;
        object = true;
        object2 = Severity.WARNING;
        n = 4;
        object3 = Category.PERFORMANCE;
        object4 = "https://developers.google.com/android/guides/setup#split";
        BUNDLED_GMS = Issue.Companion.create$default(Issue.Companion, "UseOfBundledGooglePlayServices", "Use of bundled version of Google Play services", "\n                Google Play services SDK's can be selectively included, which enables a \\\n                smaller APK size. Consider declaring dependencies on individual Google \\\n                Play services SDK's. If you are using Firebase API's \\\n                (https://firebase.google.com/docs/android/setup), Android Studio's \\\n                Tools \u2192 Firebase assistant window can automatically add just the \\\n                dependencies needed for each feature.", (Implementation)object5, (String)object4, (Category)object3, n, (Severity)((Object)object2), bl4, object, enumSet, collection, 3328, null);
        collection = null;
        enumSet = null;
        object5 = IMPLEMENTATION;
        bl4 = false;
        object = true;
        object2 = Severity.ERROR;
        n = 8;
        object3 = Category.CORRECTNESS;
        object4 = "https://developer.android.com/studio/publish/versioning.html";
        HIGH_APP_VERSION_CODE = Issue.Companion.create$default(Issue.Companion, "HighAppVersionCode", "VersionCode too high", "\n                The declared `versionCode` is an Integer. Ensure that the version number is \\\n                not close to the limit. It is recommended to monotonically increase this \\\n                number each minor or major release of the app. Note that updating an app \\\n                with a versionCode over `Integer.MAX_VALUE` is not possible.", (Implementation)object5, (String)object4, (Category)object3, n, (Severity)((Object)object2), bl4, object, enumSet, collection, 3328, null);
        collection = null;
        enumSet = null;
        object5 = IMPLEMENTATION;
        bl4 = false;
        object = true;
        object2 = Severity.WARNING;
        n = 2;
        object3 = null;
        object4 = Category.PERFORMANCE;
        DEV_MODE_OBSOLETE = Issue.Companion.create$default(Issue.Companion, "DevModeObsolete", "Dev Mode Obsolete", "\n                In the past, our documentation recommended creating a `dev` product flavor \\\n                with has a minSdkVersion of 21, in order to enable multidexing to speed up \\\n                builds significantly during development.\n\n                That workaround is no longer necessary, and it has some serious downsides, \\\n                such as breaking API access checking (since the true `minSdkVersion` is no \\\n                longer known).\n\n                In recent versions of the IDE and the Gradle plugin, the IDE automatically \\\n                passes the API level of the connected device used for deployment, and if \\\n                that device is at least API 21, then multidexing is automatically turned \\\n                on, meaning that you get the same speed benefits as the `dev` product \\\n                flavor but without the downsides.", (Implementation)object5, (String)object3, (Category)object4, n, (Severity)((Object)object2), bl4, object, enumSet, collection, 3344, null);
        collection = null;
        enumSet = null;
        object5 = IMPLEMENTATION;
        bl4 = false;
        object = true;
        object2 = Severity.FATAL;
        n = 8;
        object3 = null;
        object4 = Category.CORRECTNESS;
        DUPLICATE_CLASSES = Issue.Companion.create$default(Issue.Companion, "DuplicatePlatformClasses", "Duplicate Platform Classes", "\n                There are a number of libraries that duplicate not just functionality \\\n                of the Android platform but using the exact same class names as the ones \\\n                provided in Android -- for example the apache http classes. This can \\\n                lead to unexpected crashes.\n\n                To solve this, you need to either find a newer version of the library \\\n                which no longer has this problem, or to repackage the library (and all \\\n                of its dependencies) using something like the `jarjar` tool, or finally, \\\n                rewriting the code to use different APIs (for example, for http code, \\\n                consider using `HttpUrlConnection` or a library like `okhttp`).", (Implementation)object5, (String)object3, (Category)object4, n, (Severity)((Object)object2), bl4, object, enumSet, collection, 3344, null);
        collection = null;
        enumSet = null;
        object5 = IMPLEMENTATION;
        bl4 = false;
        object = true;
        object2 = Severity.ERROR;
        n = 8;
        object3 = null;
        object4 = Category.COMPLIANCE;
        EXPIRING_TARGET_SDK_VERSION = Issue.Companion.create$default(Issue.Companion, "ExpiringTargetSdkVersion", "TargetSdkVersion Soon Expiring", "\n                In the second half of 2018, Google Play will require that new apps and app \\\n                updates target API level 26 or higher. This will be required for new apps in \\\n                August 2018, and for updates to existing apps in November 2018.\n\n                Configuring your app to target a recent API level ensures that users benefit \\\n                from significant security and performance improvements, while still allowing \\\n                your app to run on older Android versions (down to the `minSdkVersion`).\n\n                This lint check starts warning you some months **before** these changes go \\\n                into effect if your `targetSdkVersion` is 25 or lower. This is intended to \\\n                give you a heads up to update your app, since depending on your current \\\n                `targetSdkVersion` the work can be nontrivial.\n\n                To update your `targetSdkVersion`, follow the steps from \\\n                \"Meeting Google Play requirements for target API level\",\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ", (Implementation)object5, (String)object3, (Category)object4, n, (Severity)((Object)object2), bl4, object, enumSet, collection, 3344, null).addMoreInfo("https://support.google.com/googleplay/android-developer/answer/113469#targetsdk").addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html");
        collection = null;
        enumSet = null;
        object5 = IMPLEMENTATION;
        bl4 = false;
        object = true;
        object2 = Severity.FATAL;
        n = 8;
        object3 = Category.COMPLIANCE;
        object4 = "\n                As of the second half of 2018, Google Play requires that new apps and app \\\n                updates target API level 26 or higher.\n\n                Configuring your app to target a recent API level ensures that users benefit \\\n                from significant security and performance improvements, while still allowing \\\n                your app to run on older Android versions (down to the `minSdkVersion`).\n\n                To update your `targetSdkVersion`, follow the steps from \\\n                \"Meeting Google Play requirements for target API level\",\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ";
        String string = "https://support.google.com/googleplay/android-developer/answer/113469#targetsdk";
        EXPIRED_TARGET_SDK_VERSION = Issue.Companion.create$default(Issue.Companion, "ExpiredTargetSdkVersion", "TargetSdkVersion No Longer Supported", (String)object4, (Implementation)object5, string, (Category)object3, n, (Severity)((Object)object2), bl4, object, enumSet, collection, 3328, null).addMoreInfo("https://support.google.com/googleplay/android-developer/answer/113469#targetsdk").addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html");
        collection = null;
        enumSet = null;
        object5 = IMPLEMENTATION;
        bl4 = false;
        object = true;
        object2 = Severity.ERROR;
        n = 8;
        object3 = null;
        object4 = Category.COMPLIANCE;
        DEPRECATED_LIBRARY = Issue.Companion.create$default(Issue.Companion, "OutdatedLibrary", "Outdated Library", "\n                Your app is using an outdated version of a library. This may cause violations \\\n                of Google Play policies (see https://play.google.com/about/monetization-ads/ads/) \\\n                and/or may affect your app\u2019s visibility on the Play Store.\n\n                Please try updating your app with an updated version of this library, or remove \\\n                it from your app.\n                ", (Implementation)object5, (String)object3, (Category)object4, n, (Severity)((Object)object2), bl4, object, enumSet, collection, 3344, null);
        collection = null;
        enumSet = null;
        object5 = IMPLEMENTATION;
        bl4 = false;
        object = true;
        object2 = Severity.WARNING;
        n = 1;
        object3 = Category.CORRECTNESS;
        object4 = "\n                Apps that use Kotlin and data binding should also apply the kotlin-kapt plugin. \\\n                ";
        string = "https://kotlinlang.org/docs/reference/kapt.html";
        DATA_BINDING_WITHOUT_KAPT = Issue.Companion.create$default(Issue.Companion, "DataBindingWithoutKapt", "Data Binding without Annotation Processing", (String)object4, (Implementation)object5, string, (Category)object3, n, (Severity)((Object)object2), bl4, object, enumSet, collection, 3328, null);
        collection = null;
        enumSet = null;
        object5 = IMPLEMENTATION;
        bl4 = false;
        object = true;
        object2 = Severity.WARNING;
        n = 6;
        object3 = Category.PERFORMANCE;
        object4 = "\n                For faster incremental build, switch to the Lifecycle Java 8 API with these steps:\n\n                First replace\n                ```gradle\n                annotationProcessor \"androidx.lifecycle:lifecycle-compiler:*version*\"\n                kapt \"androidx.lifecycle:lifecycle-compiler:*version*\"\n                ```\n                with\n                ```gradle\n                implementation \"androidx.lifecycle:lifecycle-common-java8:*version*\"\n                ```\n                Then remove any `OnLifecycleEvent` annotations from `Observer` classes \\\n                and make them implement the `DefaultLifecycleObserver` interface.\n                ";
        string = "https://d.android.com/r/studio-ui/lifecycle-release-notes";
        LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8 = Issue.Companion.create$default(Issue.Companion, "LifecycleAnnotationProcessorWithJava8", "Lifecycle Annotation Processor with Java 8 Compile Option", (String)object4, (Implementation)object5, string, (Category)object3, n, (Severity)((Object)object2), bl4, object, enumSet, collection, 3328, null);
        collection = null;
        enumSet = null;
        object5 = IMPLEMENTATION;
        bl4 = false;
        object = true;
        object2 = Severity.ERROR;
        n = 8;
        object3 = null;
        object4 = Category.SECURITY;
        RISKY_LIBRARY = Issue.Companion.create$default(Issue.Companion, "RiskyLibrary", "Libraries with Privacy or Security Risks", "\n                Your app is using a version of a library that has been identified by \\\n                the library developer as a potential source of privacy and/or security risks. \\\n                This may be a violation of Google Play policies (see \\\n                https://play.google.com/about/monetization-ads/ads/) and/or affect your app\u2019s \\\n                visibility on the Play Store.\n\n                When available, the individual error messages from lint will include details \\\n                about the reasons for this advisory.\n\n                Please try updating your app with an updated version of this library, or remove \\\n                it from your app.\n            ", (Implementation)object5, (String)object3, (Category)object4, n, (Severity)((Object)object2), bl4, object, enumSet, collection, 3344, null);
        collection = null;
        enumSet = null;
        object5 = IMPLEMENTATION;
        bl4 = false;
        object = true;
        object2 = Severity.WARNING;
        n = 8;
        object3 = null;
        object4 = Category.PERFORMANCE;
        ANNOTATION_PROCESSOR_ON_COMPILE_PATH = Issue.Companion.create$default(Issue.Companion, "AnnotationProcessorOnCompilePath", "Annotation Processor on Compile Classpath", "\n               This dependency is identified as an annotation processor. Consider adding it to the \\\n               processor path using `annotationProcessor` instead of including it to the\n               compile path.\n            ", (Implementation)object5, (String)object3, (Category)object4, n, (Severity)((Object)object2), bl4, object, enumSet, collection, 3344, null);
        collection = null;
        enumSet = null;
        object5 = "https://developer.android.com/kotlin/ktx";
        bl4 = false;
        object = IMPLEMENTATION;
        object2 = true;
        Severity severity = Severity.INFORMATIONAL;
        int n2 = 4;
        object4 = Category.PRODUCTIVITY;
        KTX_EXTENSION_AVAILABLE = Issue.Companion.create$default(Issue.Companion, "KtxExtensionAvailable", "KTX Extension Available", "\n                Android KTX extensions augment some libraries with support for modern Kotlin \\\n                language features like extension functions, extension properties, lambdas, named \\\n                parameters, coroutines, and more.\n\n                In Kotlin projects, use the KTX version of a library by replacing the \\\n                dependency in your `build.gradle` file. For example, you can replace \\\n                `androidx.fragment:fragment` with `androidx.fragment:fragment-ktx`.\n            ", (Implementation)object, (String)object5, (Category)object4, n2, severity, bl4, (Boolean)object2, enumSet, collection, 3328, null);
        JAVA_PLUGIN_LANGUAGE_LEVEL = Issue.Companion.create("JavaPluginLanguageLevel", "No Explicit Java Language Level Given", "\n                In modules using plugins deriving from the Gradle `java` plugin (e.g. \\\n                `java-library` or `application`), the java source and target compatibility \\\n                default to the version of the JDK being used to run Gradle, which may cause \\\n                compatibility problems with Android (or other) modules.\n\n                You can specify an explicit sourceCompatibility and targetCompatibility in this \\\n                module to maintain compatibility no matter which JDK is used to run Gradle.\n            ", Category.INTEROPERABILITY, 6, Severity.WARNING, IMPLEMENTATION);
        collection = null;
        enumSet = null;
        object5 = null;
        bl4 = false;
        object = "https://developer.android.com/r/tools/jcenter-end-of-service";
        object2 = IMPLEMENTATION;
        severity = Severity.WARNING;
        n2 = 8;
        object4 = Category.CORRECTNESS;
        JCENTER_REPOSITORY_OBSOLETE = Issue.Companion.create$default(Issue.Companion, "JcenterRepositoryObsolete", "The JCenter Maven repository is obsolete from 1st May 2021", "\n                JFrog announced that the JCenter Maven repository would reach end of service \\\n                and would no longer be available from 1st May 2021; no new submissions would be \\\n                accepted from 28th February 2021, and there might be accessibility problems due \\\n                to maintenance windows before the end of service date.\n\n                We recommend configuring Gradle to retrieve Java artifacts using `mavenCentral` \\\n                instead.\n                ", (Implementation)object2, (String)object, (Category)object4, n2, severity, bl4, (Boolean)object5, enumSet, collection, 3840, null);
        Iterable $this$flatMap$iv = CollectionsKt.listOf((Object[])new String[]{"java", "java-library", "application"});
        boolean $i$f$flatMap = false;
        object5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl5 = false;
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])new String[]{it, "org.gradle." + it});
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        JAVA_PLUGIN_IDS = (List)var3_9;
        GradleCoordinate gradleCoordinate = GradleCoordinate.parseCoordinateString((String)"com.google.android.gms:play-services:6.5.0");
        if (gradleCoordinate == null) {
            Intrinsics.throwNpe();
        }
        PLAY_SERVICES_V650 = gradleCoordinate;
        commonAnnotationProcessors = SetsKt.setOf((Object[])new String[]{"com.jakewharton:butterknife-compiler", "com.github.bumptech.glide:compiler", "androidx.databinding:databinding-compiler", "com.google.dagger:dagger-compiler", "com.google.auto.service:auto-service", "android.arch.persistence.room:compiler", "android.arch.lifecycle:compiler", "io.realm:realm-annotations-processor", "com.google.dagger:dagger-android-processor", "androidx.room:room-compiler", "com.android.databinding:compiler", "androidx.lifecycle:lifecycle-compiler", "org.projectlombok:lombok", "com.google.auto.value:auto-value", "org.parceler:parceler", "com.github.hotchemi:permissionsdispatcher-processor", "com.alibaba:arouter-compiler", "org.androidannotations:androidannotations", "com.github.Raizlabs.DBFlow:dbflow-processor", "frankiesardo:icepick-processor", "org.greenrobot:eventbus-annotation-processor", "com.ryanharter.auto.value:auto-value-gson", "io.objectbox:objectbox-processor", "com.arello-mobile:moxy-compiler", "com.squareup.dagger:dagger-compiler", "io.realm:realm-android", "com.bluelinelabs:logansquare-compiler", "com.tencent.tinker:tinker-android-anno", "com.raizlabs.android:DBFlow-Compiler", "com.google.auto.factory:auto-factory", "com.airbnb:deeplinkdispatch-processor", "com.alipay.android.tools:androidannotations", "org.permissionsdispatcher:permissionsdispatcher-processor", "com.airbnb.android:epoxy-processor", "org.immutables:value", "com.github.stephanenicolas.toothpick:toothpick-compiler", "com.mindorks.android:placeholderview-compiler", "com.github.frankiesardo:auto-parcel-processor", "com.hannesdorfmann.fragmentargs:processor", "com.evernote:android-state-processor", "org.mapstruct:mapstruct-processor", "com.iqiyi.component.router:qyrouter-compiler", "com.iqiyi.component.mm:mm-compiler", "dk.ilios:realmfieldnameshelper", "com.lianjia.common.android.router2:compiler", "com.smile.gifshow.annotation:invoker_processor", "com.f2prateek.dart:dart-processor", "com.sankuai.waimai.router:compiler", "org.qiyi.card:card-action-compiler", "com.iqiyi.video:eventbus-annotation-processor", "ly.img.android.pesdk:build-processor", "org.apache.logging.log4j:log4j-core", "com.github.jokermonn:permissions4m", "com.arialyy.aria:aria-compiler", "com.smile.gifshow.annotation:provide_processor", "com.smile.gifshow.annotation:preference_processor", "com.smile.gifshow.annotation:plugin_processor", "org.inferred:freebuilder", "com.smile.gifshow.annotation:router_processor"});
    }

    public static final /* synthetic */ void access$checkDependency(GradleDetector $this, GradleContext context2, GradleCoordinate dependency, boolean isResolved, Object cookie, Object statementCookie) {
        $this.checkDependency(context2, dependency, isResolved, cookie, statementCookie);
    }

    public static final /* synthetic */ int access$getCompileSdkVersion$p(GradleDetector $this) {
        return $this.compileSdkVersion;
    }

    public static final /* synthetic */ void access$setCompileSdkVersion$p(GradleDetector $this, int n) {
        $this.compileSdkVersion = n;
    }

    public static final /* synthetic */ int access$getTargetSdkVersion$p(GradleDetector $this) {
        return $this.targetSdkVersion;
    }

    public static final /* synthetic */ void access$setTargetSdkVersion$p(GradleDetector $this, int n) {
        $this.targetSdkVersion = n;
    }

    @JvmStatic
    @Nullable
    public static final GradleVersion getLatestVersionFromRemoteRepo(@NotNull LintClient client, @NotNull GradleCoordinate dependency, @Nullable Predicate<GradleVersion> filter, boolean allowPreview) {
        return Companion.getLatestVersionFromRemoteRepo(client, dependency, filter, allowPreview);
    }

    @JvmStatic
    @Nullable
    public static final String getNamedDependency(@NotNull String expression) {
        return Companion.getNamedDependency(expression);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\t\u0010\u0006\u001a\u00020\u0001H\u00c6\u0003J\u0013\u0010\u0007\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$JavaPluginInfo;", "", "cookie", "(Ljava/lang/Object;)V", "getCookie", "()Ljava/lang/Object;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "android.sdktools.lint-checks"})
    public static final class JavaPluginInfo {
        @NotNull
        private final Object cookie;

        @NotNull
        public final Object getCookie() {
            return this.cookie;
        }

        public JavaPluginInfo(@NotNull Object cookie) {
            this.cookie = cookie;
        }

        @NotNull
        public final Object component1() {
            return this.cookie;
        }

        @NotNull
        public final JavaPluginInfo copy(@NotNull Object cookie) {
            return new JavaPluginInfo(cookie);
        }

        public static /* synthetic */ JavaPluginInfo copy$default(JavaPluginInfo javaPluginInfo, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = javaPluginInfo.cookie;
            }
            return javaPluginInfo.copy(object);
        }

        @NotNull
        public String toString() {
            return "JavaPluginInfo(cookie=" + this.cookie + ")";
        }

        public int hashCode() {
            Object object = this.cookie;
            return object != null ? object.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof JavaPluginInfo)) break block3;
                    JavaPluginInfo javaPluginInfo = (JavaPluginInfo)object;
                    if (!Intrinsics.areEqual((Object)this.cookie, (Object)javaPluginInfo.cookie)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0001H\u00c6\u0003JG\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/GradleDetector$AgpVersionCheckInfo;", "", "newerVersion", "Lcom/android/ide/common/repository/GradleVersion;", "newerVersionIsSafe", "", "safeReplacement", "dependency", "Lcom/android/ide/common/repository/GradleCoordinate;", "isResolved", "cookie", "(Lcom/android/ide/common/repository/GradleVersion;ZLcom/android/ide/common/repository/GradleVersion;Lcom/android/ide/common/repository/GradleCoordinate;ZLjava/lang/Object;)V", "getCookie", "()Ljava/lang/Object;", "getDependency", "()Lcom/android/ide/common/repository/GradleCoordinate;", "()Z", "getNewerVersion", "()Lcom/android/ide/common/repository/GradleVersion;", "getNewerVersionIsSafe", "getSafeReplacement", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "", "android.sdktools.lint-checks"})
    public static final class AgpVersionCheckInfo {
        @NotNull
        private final GradleVersion newerVersion;
        private final boolean newerVersionIsSafe;
        @Nullable
        private final GradleVersion safeReplacement;
        @NotNull
        private final GradleCoordinate dependency;
        private final boolean isResolved;
        @NotNull
        private final Object cookie;

        @NotNull
        public final GradleVersion getNewerVersion() {
            return this.newerVersion;
        }

        public final boolean getNewerVersionIsSafe() {
            return this.newerVersionIsSafe;
        }

        @Nullable
        public final GradleVersion getSafeReplacement() {
            return this.safeReplacement;
        }

        @NotNull
        public final GradleCoordinate getDependency() {
            return this.dependency;
        }

        public final boolean isResolved() {
            return this.isResolved;
        }

        @NotNull
        public final Object getCookie() {
            return this.cookie;
        }

        public AgpVersionCheckInfo(@NotNull GradleVersion newerVersion, boolean newerVersionIsSafe, @Nullable GradleVersion safeReplacement, @NotNull GradleCoordinate dependency, boolean isResolved, @NotNull Object cookie) {
            this.newerVersion = newerVersion;
            this.newerVersionIsSafe = newerVersionIsSafe;
            this.safeReplacement = safeReplacement;
            this.dependency = dependency;
            this.isResolved = isResolved;
            this.cookie = cookie;
        }

        @NotNull
        public final GradleVersion component1() {
            return this.newerVersion;
        }

        public final boolean component2() {
            return this.newerVersionIsSafe;
        }

        @Nullable
        public final GradleVersion component3() {
            return this.safeReplacement;
        }

        @NotNull
        public final GradleCoordinate component4() {
            return this.dependency;
        }

        public final boolean component5() {
            return this.isResolved;
        }

        @NotNull
        public final Object component6() {
            return this.cookie;
        }

        @NotNull
        public final AgpVersionCheckInfo copy(@NotNull GradleVersion newerVersion, boolean newerVersionIsSafe, @Nullable GradleVersion safeReplacement, @NotNull GradleCoordinate dependency, boolean isResolved, @NotNull Object cookie) {
            return new AgpVersionCheckInfo(newerVersion, newerVersionIsSafe, safeReplacement, dependency, isResolved, cookie);
        }

        public static /* synthetic */ AgpVersionCheckInfo copy$default(AgpVersionCheckInfo agpVersionCheckInfo, GradleVersion gradleVersion, boolean bl, GradleVersion gradleVersion2, GradleCoordinate gradleCoordinate, boolean bl2, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                gradleVersion = agpVersionCheckInfo.newerVersion;
            }
            if ((n & 2) != 0) {
                bl = agpVersionCheckInfo.newerVersionIsSafe;
            }
            if ((n & 4) != 0) {
                gradleVersion2 = agpVersionCheckInfo.safeReplacement;
            }
            if ((n & 8) != 0) {
                gradleCoordinate = agpVersionCheckInfo.dependency;
            }
            if ((n & 0x10) != 0) {
                bl2 = agpVersionCheckInfo.isResolved;
            }
            if ((n & 0x20) != 0) {
                object = agpVersionCheckInfo.cookie;
            }
            return agpVersionCheckInfo.copy(gradleVersion, bl, gradleVersion2, gradleCoordinate, bl2, object);
        }

        @NotNull
        public String toString() {
            return "AgpVersionCheckInfo(newerVersion=" + this.newerVersion + ", newerVersionIsSafe=" + this.newerVersionIsSafe + ", safeReplacement=" + this.safeReplacement + ", dependency=" + this.dependency + ", isResolved=" + this.isResolved + ", cookie=" + this.cookie + ")";
        }

        public int hashCode() {
            GradleVersion gradleVersion = this.newerVersion;
            int n = (gradleVersion != null ? gradleVersion.hashCode() : 0) * 31;
            int n2 = this.newerVersionIsSafe ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            GradleVersion gradleVersion2 = this.safeReplacement;
            GradleCoordinate gradleCoordinate = this.dependency;
            int n3 = (((n + n2) * 31 + (gradleVersion2 != null ? gradleVersion2.hashCode() : 0)) * 31 + (gradleCoordinate != null ? gradleCoordinate.hashCode() : 0)) * 31;
            int n4 = this.isResolved ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            Object object = this.cookie;
            return (n3 + n4) * 31 + (object != null ? object.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AgpVersionCheckInfo)) break block3;
                    AgpVersionCheckInfo agpVersionCheckInfo = (AgpVersionCheckInfo)object;
                    if (!Intrinsics.areEqual((Object)this.newerVersion, (Object)agpVersionCheckInfo.newerVersion) || this.newerVersionIsSafe != agpVersionCheckInfo.newerVersionIsSafe || !Intrinsics.areEqual((Object)this.safeReplacement, (Object)agpVersionCheckInfo.safeReplacement) || !Intrinsics.areEqual((Object)this.dependency, (Object)agpVersionCheckInfo.dependency) || this.isResolved != agpVersionCheckInfo.isResolved || !Intrinsics.areEqual((Object)this.cookie, (Object)agpVersionCheckInfo.cookie)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$DeprecatedConfiguration;", "", "deprecatedName", "", "replacementName", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "deprecatedSuffix", "replacementSuffix", "matches", "", "configurationName", "replacement", "COMPILE", "PROVIDED", "APK", "android.sdktools.lint-checks"})
    private static final class DeprecatedConfiguration
    extends Enum<DeprecatedConfiguration> {
        public static final /* enum */ DeprecatedConfiguration COMPILE;
        public static final /* enum */ DeprecatedConfiguration PROVIDED;
        public static final /* enum */ DeprecatedConfiguration APK;
        private static final /* synthetic */ DeprecatedConfiguration[] $VALUES;
        private final String deprecatedSuffix;
        private final String replacementSuffix;
        private final String deprecatedName;
        private final String replacementName;

        static {
            DeprecatedConfiguration[] deprecatedConfigurationArray = new DeprecatedConfiguration[3];
            DeprecatedConfiguration[] deprecatedConfigurationArray2 = deprecatedConfigurationArray;
            deprecatedConfigurationArray[0] = COMPILE = new DeprecatedConfiguration("compile", "implementation");
            deprecatedConfigurationArray[1] = PROVIDED = new DeprecatedConfiguration("provided", "compileOnly");
            deprecatedConfigurationArray[2] = APK = new DeprecatedConfiguration("apk", "runtimeOnly");
            $VALUES = deprecatedConfigurationArray;
        }

        public final boolean matches(@NotNull String configurationName) {
            return Intrinsics.areEqual((Object)configurationName, (Object)this.deprecatedName) || StringsKt.endsWith$default((String)configurationName, (String)this.deprecatedSuffix, (boolean)false, (int)2, null);
        }

        @NotNull
        public final String replacement(@NotNull String configurationName) {
            return Intrinsics.areEqual((Object)configurationName, (Object)this.deprecatedName) ? this.replacementName : StringsKt.removeSuffix((String)configurationName, (CharSequence)this.deprecatedSuffix) + this.replacementSuffix;
        }

        private DeprecatedConfiguration(String deprecatedName, String replacementName) {
            this.deprecatedName = deprecatedName;
            this.replacementName = replacementName;
            this.deprecatedSuffix = StringHelper.usLocaleCapitalize((String)this.deprecatedName);
            this.replacementSuffix = StringHelper.usLocaleCapitalize((String)this.replacementName);
        }

        public static DeprecatedConfiguration[] values() {
            return (DeprecatedConfiguration[])$VALUES.clone();
        }

        public static DeprecatedConfiguration valueOf(String string) {
            return Enum.valueOf(DeprecatedConfiguration.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001UB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010@\u001a\u0004\u0018\u00010>2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u000203H\u0002J2\u0010D\u001a\u0004\u0018\u00010>2\u0006\u0010A\u001a\u00020B2\u0006\u0010E\u001a\u00020-2\u000e\u0010F\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010G2\u0006\u0010H\u001a\u00020IH\u0007J\u0012\u0010J\u001a\u0004\u0018\u00010\u00072\u0006\u0010K\u001a\u00020\u0007H\u0007J\u0010\u0010L\u001a\u00020I2\u0006\u0010E\u001a\u00020\u0007H\u0002J\u0010\u0010M\u001a\u00020I2\u0006\u0010E\u001a\u00020\u0007H\u0002J\u0010\u0010N\u001a\u00020I2\u0006\u0010O\u001a\u00020\u0007H\u0002J\u0018\u0010P\u001a\u00020I2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0007H\u0002J\u0010\u0010T\u001a\u00020I2\u0006\u0010Q\u001a\u00020RH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0010\u0010\"\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u00105\u001a\u0004\u0018\u000106X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$Companion;", "", "()V", "ACCIDENTAL_OCTAL", "Lcom/android/tools/lint/detector/api/Issue;", "AGP_DEPENDENCY", "ANDROID_WEAR_GROUP_ID", "", "ANNOTATION_PROCESSOR_ON_COMPILE_PATH", "APP_PLUGIN_ID", "BUNDLED_GMS", "COMPATIBILITY", "DATA_BINDING_WITHOUT_KAPT", "DEPENDENCY", "DEPRECATED", "DEPRECATED_CONFIGURATION", "DEPRECATED_LIBRARY", "DEV_MODE_OBSOLETE", "DUPLICATE_CLASSES", "EXPIRED_TARGET_SDK_VERSION", "EXPIRING_TARGET_SDK_VERSION", "FIREBASE_GROUP_ID", "GMS_GROUP_ID", "GOOGLE_SUPPORT_GROUP_ID", "GRADLE_GETTER", "GRADLE_PLUGIN_COMPATIBILITY", "HIGH_APP_VERSION_CODE", "IDE_SUPPORT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "JAVA_PLUGIN_IDS", "", "getJAVA_PLUGIN_IDS", "()Ljava/util/List;", "JAVA_PLUGIN_LANGUAGE_LEVEL", "JCENTER_REPOSITORY_OBSOLETE", "KTX_EXTENSION_AVAILABLE", "LIB_PLUGIN_ID", "LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8", "MIN_SDK_TOO_LOW", "NOT_INTERPOLATED", "OLD_APP_PLUGIN_ID", "OLD_LIB_PLUGIN_ID", "PATH", "PLAY_SERVICES_V650", "Lcom/android/ide/common/repository/GradleCoordinate;", "PLUS", "REMOTE_VERSION", "RISKY_LIBRARY", "STRING_INTEGER", "VERSION_CODE_HIGH_THRESHOLD", "", "WEARABLE_ARTIFACT_ID", "calendar", "Ljava/util/Calendar;", "getCalendar", "()Ljava/util/Calendar;", "setCalendar", "(Ljava/util/Calendar;)V", "commonAnnotationProcessors", "", "latestBuildTools", "Lcom/android/ide/common/repository/GradleVersion;", "majorBuildTools", "getLatestBuildTools", "client", "Lcom/android/tools/lint/client/api/LintClient;", "major", "getLatestVersionFromRemoteRepo", "dependency", "filter", "Ljava/util/function/Predicate;", "allowPreview", "", "getNamedDependency", "expression", "hasLifecycleAnnotationProcessor", "isCommonAnnotationProcessor", "libraryHasKtxExtension", "mavenName", "suggestApiConfigurationUse", "project", "Lcom/android/tools/lint/detector/api/Project;", "configuration", "targetJava8Plus", "CompileConfiguration", "android.sdktools.lint-checks"})
    public static final class Companion {
        @Nullable
        public final Calendar getCalendar() {
            return calendar;
        }

        public final void setCalendar(@Nullable Calendar calendar) {
            GradleDetector.calendar = calendar;
        }

        @NotNull
        public final List<String> getJAVA_PLUGIN_IDS() {
            return JAVA_PLUGIN_IDS;
        }

        @JvmStatic
        @Nullable
        public final GradleVersion getLatestVersionFromRemoteRepo(@NotNull LintClient client, @NotNull GradleCoordinate dependency, @Nullable Predicate<GradleVersion> filter, boolean allowPreview) {
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            StringBuilder query = new StringBuilder();
            String encoding = Charsets.UTF_8.name();
            try {
                query.append("http://search.maven.org/solrsearch/select?q=g:%22");
                query.append(URLEncoder.encode(groupId, encoding));
                query.append("%22+AND+a:%22");
                query.append(URLEncoder.encode(artifactId, encoding));
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
            query.append("%22&core=gav");
            if (filter == null && allowPreview) {
                query.append("&rows=1");
            }
            query.append("&wt=json");
            String response = null;
            try {
                response = Lint.readUrlDataAsString(client, query.toString(), 20000);
                if (response == null) {
                    return null;
                }
            }
            catch (IOException e) {
                client.log(null, "Could not connect to maven central to look up the latest available version for %1$s", dependency);
                return null;
            }
            int index = StringsKt.indexOf$default((CharSequence)response, (String)"\"response\"", (int)0, (boolean)false, (int)6, null);
            while (index != -1) {
                boolean preview;
                String substring;
                int end;
                int start;
                int n;
                if ((index = StringsKt.indexOf$default((CharSequence)response, (String)"\"v\":", (int)index, (boolean)false, (int)4, null)) == -1 || 0 > (n = (start = StringsKt.indexOf$default((CharSequence)response, (char)'\"', (int)(index += 4), (boolean)false, (int)4, null) + 1)) || (end = StringsKt.indexOf$default((CharSequence)response, (char)'\"', (int)(start + 1), (boolean)false, (int)4, null)) <= n) continue;
                String string = response;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)string.substring(start, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                GradleVersion revision = GradleVersion.tryParse((String)substring);
                if (revision == null) continue;
                boolean bl2 = preview = revision.isPreview() && !StringsKt.endsWith$default((String)substring, (String)"-android", (boolean)false, (int)2, null);
                if (!allowPreview && preview || filter != null && !filter.test(revision)) continue;
                return revision;
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final String getNamedDependency(@NotNull String expression) {
            if (StringsKt.indexOf$default((CharSequence)expression, (char)',', (int)0, (boolean)false, (int)6, null) != -1 && StringsKt.contains$default((CharSequence)expression, (CharSequence)"version:", (boolean)false, (int)2, null)) {
                String artifact = null;
                String group = null;
                String version = null;
                Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
                for (String property : splitter.split((CharSequence)expression)) {
                    String value;
                    int valueEnd;
                    int colon = StringsKt.indexOf$default((CharSequence)property, (char)':', (int)0, (boolean)false, (int)6, null);
                    if (colon == -1) {
                        return null;
                    }
                    char quote = '\'';
                    int valueStart = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(colon + 1), (boolean)false, (int)4, null);
                    if (valueStart == -1) {
                        quote = '\"';
                        valueStart = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(colon + 1), (boolean)false, (int)4, null);
                    }
                    if (valueStart == -1) continue;
                    if ((valueEnd = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(++valueStart), (boolean)false, (int)4, null)) == -1) {
                        return null;
                    }
                    String string = property;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string2.substring(valueStart, valueEnd), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    if (StringsKt.startsWith$default((String)property, (String)"group:", (boolean)false, (int)2, null)) {
                        group = value;
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)property, (String)"name:", (boolean)false, (int)2, null)) {
                        artifact = value;
                        continue;
                    }
                    if (!StringsKt.startsWith$default((String)property, (String)"version:", (boolean)false, (int)2, null)) continue;
                    version = value;
                }
                if (artifact != null && group != null && version != null) {
                    return group + ':' + artifact + ':' + version;
                }
            }
            return null;
        }

        private final GradleVersion getLatestBuildTools(LintClient client, int major) {
            if (major != majorBuildTools) {
                File[] dirs;
                majorBuildTools = major;
                ArrayList<GradleVersion> revisions = new ArrayList<GradleVersion>();
                switch (major) {
                    case 267: {
                        revisions.add(new GradleVersion(27, 0, 3));
                        break;
                    }
                    case 26: {
                        revisions.add(new GradleVersion(26, 0, 3));
                        break;
                    }
                    case 25: {
                        revisions.add(new GradleVersion(25, 0, 3));
                        break;
                    }
                    case 24: {
                        revisions.add(new GradleVersion(24, 0, 3));
                        break;
                    }
                    case 23: {
                        revisions.add(new GradleVersion(23, 0, 3));
                        break;
                    }
                    case 22: {
                        revisions.add(new GradleVersion(22, 0, 1));
                        break;
                    }
                    case 21: {
                        revisions.add(new GradleVersion(21, 1, 2));
                        break;
                    }
                    case 20: {
                        revisions.add(new GradleVersion(20, 0));
                        break;
                    }
                    case 19: {
                        revisions.add(new GradleVersion(19, 1));
                        break;
                    }
                    case 18: {
                        revisions.add(new GradleVersion(18, 1, 1));
                        break;
                    }
                }
                File sdkHome = client.getSdkHome();
                if (sdkHome != null && (dirs = new File(sdkHome, "build-tools").listFiles()) != null) {
                    for (File dir : dirs) {
                        GradleVersion v;
                        String name = dir.getName();
                        if (!dir.isDirectory() || !Character.isDigit(name.charAt(0)) || (v = GradleVersion.tryParse((String)name)) == null || v.getMajor() != major) continue;
                        revisions.add(v);
                    }
                }
                Collection collection = revisions;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    latestBuildTools = (GradleVersion)Collections.max((Collection)revisions);
                }
            }
            return latestBuildTools;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean suggestApiConfigurationUse(Project project, String configuration) {
            if (StringsKt.startsWith$default((String)configuration, (String)"test", (boolean)false, (int)2, null)) return false;
            if (StringsKt.startsWith$default((String)configuration, (String)"androidTest", (boolean)false, (int)2, null)) {
                return false;
            }
            LintModelModuleType lintModelModuleType = project.getType();
            if (lintModelModuleType == null) throw new NoWhenBranchMatchedException();
            switch (GradleDetector$Companion$WhenMappings.$EnumSwitchMapping$0[lintModelModuleType.ordinal()]) {
                case 1: {
                    boolean bl = project.hasDynamicFeatures();
                    return bl;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 4: 
                case 5: {
                    return true;
                }
                case 6: {
                    return false;
                }
                case 7: {
                    return false;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final boolean targetJava8Plus(Project project) {
            return Lint.getLanguageLevel(project, LanguageLevel.JDK_1_7).isAtLeast(LanguageLevel.JDK_1_8);
        }

        private final boolean hasLifecycleAnnotationProcessor(String dependency) {
            return StringsKt.contains$default((CharSequence)dependency, (CharSequence)"android.arch.lifecycle:compiler", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)dependency, (CharSequence)"androidx.lifecycle:lifecycle-compiler", (boolean)false, (int)2, null);
        }

        private final boolean isCommonAnnotationProcessor(String dependency) {
            boolean bl;
            int index = StringsKt.lastIndexOf$default((CharSequence)dependency, (String)":", (int)0, (boolean)false, (int)6, null);
            switch (index) {
                case -1: {
                    bl = false;
                    break;
                }
                default: {
                    Set set = commonAnnotationProcessors;
                    String string = dependency;
                    int n = 0;
                    boolean bl2 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n, index);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    bl = set.contains(string3);
                }
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean libraryHasKtxExtension(String mavenName) {
            String string = mavenName;
            switch (string.hashCode()) {
                case -2871177: {
                    if (!string.equals("androidx.palette:palette")) return false;
                    return true;
                }
                case 143019008: {
                    if (!string.equals("androidx.paging:paging-runtime")) return false;
                    return true;
                }
                case 2126822828: {
                    if (!string.equals("androidx.lifecycle:lifecycle-viewmodel")) return false;
                    return true;
                }
                case 268228117: {
                    if (!string.equals("androidx.dynamicanimation:dynamicanimation")) return false;
                    return true;
                }
                case -264025202: {
                    if (!string.equals("androidx.lifecycle:lifecycle-livedata")) return false;
                    return true;
                }
                case -1586715678: {
                    if (!string.equals("androidx.lifecycle:lifecycle-reactivestreams")) return false;
                    return true;
                }
                case -1128017812: {
                    if (!string.equals("androidx.navigation:navigation-ui")) return false;
                    return true;
                }
                case 72318654: {
                    if (!string.equals("com.google.android.play:core")) return false;
                    return true;
                }
                case -1307799938: {
                    if (!string.equals("androidx.lifecycle:lifecycle-livedata-core")) return false;
                    return true;
                }
                case 291543125: {
                    if (!string.equals("androidx.activity:activity")) return false;
                    return true;
                }
                case 1493179093: {
                    if (!string.equals("androidx.core:core")) return false;
                    return true;
                }
                case 1496698848: {
                    if (!string.equals("androidx.lifecycle:lifecycle-runtime")) return false;
                    return true;
                }
                case -378178304: {
                    if (!string.equals("androidx.navigation:navigation-runtime")) return false;
                    return true;
                }
                case -568948541: {
                    if (!string.equals("androidx.paging:paging-common")) return false;
                    return true;
                }
                case -1453117067: {
                    if (!string.equals("androidx.fragment:fragment")) return false;
                    return true;
                }
                case 224658418: {
                    if (!string.equals("androidx.paging:paging-rxjava2")) return false;
                    return true;
                }
                case 346279413: {
                    if (!string.equals("androidx.sqlite:sqlite")) return false;
                    return true;
                }
                case 1039658464: {
                    if (!string.equals("androidx.slice:slice-builders")) return false;
                    return true;
                }
                case -1324096984: {
                    if (!string.equals("androidx.navigation:navigation-fragment")) return false;
                    return true;
                }
                case 2032872629: {
                    if (!string.equals("androidx.collection:collection")) return false;
                    return true;
                }
                case -1825909611: {
                    if (!string.equals("androidx.preference:preference")) return false;
                    return true;
                }
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$Companion$CompileConfiguration;", "", "compileConfigName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "annotationProcessor", "compileConfigSuffix", "matches", "", "configurationName", "replacement", "API", "COMPILE", "IMPLEMENTATION", "COMPILE_ONLY", "android.sdktools.lint-checks"})
        private static final class CompileConfiguration
        extends Enum<CompileConfiguration> {
            public static final /* enum */ CompileConfiguration API;
            public static final /* enum */ CompileConfiguration COMPILE;
            public static final /* enum */ CompileConfiguration IMPLEMENTATION;
            public static final /* enum */ CompileConfiguration COMPILE_ONLY;
            private static final /* synthetic */ CompileConfiguration[] $VALUES;
            private final String annotationProcessor;
            private final String compileConfigSuffix;
            private final String compileConfigName;

            static {
                CompileConfiguration[] compileConfigurationArray = new CompileConfiguration[4];
                CompileConfiguration[] compileConfigurationArray2 = compileConfigurationArray;
                compileConfigurationArray[0] = API = new CompileConfiguration("api");
                compileConfigurationArray[1] = COMPILE = new CompileConfiguration("compile");
                compileConfigurationArray[2] = IMPLEMENTATION = new CompileConfiguration("implementation");
                compileConfigurationArray[3] = COMPILE_ONLY = new CompileConfiguration("compileOnly");
                $VALUES = compileConfigurationArray;
            }

            public final boolean matches(@NotNull String configurationName) {
                return Intrinsics.areEqual((Object)configurationName, (Object)this.compileConfigName) || StringsKt.endsWith$default((String)configurationName, (String)this.compileConfigSuffix, (boolean)false, (int)2, null);
            }

            @NotNull
            public final String replacement(@NotNull String configurationName) {
                return Intrinsics.areEqual((Object)configurationName, (Object)this.compileConfigName) ? this.annotationProcessor : StringHelper.appendCapitalized((String)StringsKt.removeSuffix((String)configurationName, (CharSequence)this.compileConfigSuffix), (String)this.annotationProcessor);
            }

            private CompileConfiguration(String compileConfigName) {
                this.compileConfigName = compileConfigName;
                this.annotationProcessor = "annotationProcessor";
                this.compileConfigSuffix = StringHelper.usLocaleCapitalize((String)this.compileConfigName);
            }

            public static CompileConfiguration[] values() {
                return (CompileConfiguration[])$VALUES.clone();
            }

            public static CompileConfiguration valueOf(String string) {
                return Enum.valueOf(CompileConfiguration.class, string);
            }
        }
    }
}

