/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UInstanceExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAssertExpression;
import org.jetbrains.uast.java.JavaUInstanceCheckExpression;
import org.jetbrains.uast.kotlin.KotlinUTypeCheckExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0016J\u0018\u0010\u0017\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\u0018\u00010\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u001fH\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001fH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00162\u0006\u0010&\u001a\u00020\u001fH\u0002J \u0010'\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020\f2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u001fH\u0002\u00a8\u0006,"}, d2={"Lcom/android/tools/lint/checks/AssertDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkJavaAssertion", "", "expression", "Lorg/jetbrains/uast/java/JavaUAssertExpression;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "checkKotlinAssertion", "assertion", "Lorg/jetbrains/uast/UCallExpression;", "createJavaBuildConfigFix", "Lcom/android/tools/lint/detector/api/LintFix;", "createKotlinAssertionStatusFix", "assertCall", "createKotlinBuildConfigFix", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "getApplicableMethodNames", "", "", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "getErrorMessage", "isAndroidContext", "", "isExpensive", "argument", "Lorg/jetbrains/uast/UExpression;", "depth", "", "isNullOrInstanceCheck", "isWithinAssertionStatusCheck", "node", "negateSource", "condition", "visitMethodCall", "method", "Lcom/intellij/psi/PsiMethod;", "warnAboutWork", "Issues", "android.sdktools.lint-checks"})
public final class AssertDetector
extends Detector
implements SourceCodeScanner {
    @JvmField
    @NotNull
    public static final Issue DISABLED;
    @JvmField
    @NotNull
    public static final Issue EXPENSIVE;
    public static final Issues Issues;

    private final boolean isAndroidContext(JavaContext context2) {
        return context2.getMainProject().isAndroidProject();
    }

    @Override
    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @Override
    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        if (!this.isAndroidContext(context2)) {
            return null;
        }
        return new UElementHandler(this, context2){
            final /* synthetic */ AssertDetector this$0;
            final /* synthetic */ JavaContext $context;

            public void visitCallExpression(@NotNull UCallExpression node) {
                if (node instanceof JavaUAssertExpression) {
                    AssertDetector.access$checkJavaAssertion(this.this$0, (JavaUAssertExpression)node, this.$context);
                }
            }
            {
                this.this$0 = this$0;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"assert");
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        if (!Lint.isKotlin(node.getSourcePsi())) {
            return;
        }
        Object object = method.getContainingClass();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return;
        }
        Object containingClass = object;
        if (Intrinsics.areEqual((Object)containingClass, (Object)"kotlin.PreconditionsKt") ^ true && Intrinsics.areEqual((Object)containingClass, (Object)"kotlin.PreconditionsKt__AssertionsJVMKt") ^ true) {
            return;
        }
        this.checkKotlinAssertion(context2, node);
    }

    private final void checkJavaAssertion(JavaUAssertExpression expression, JavaContext context2) {
        Object value;
        UExpression condition = expression.getCondition();
        if (condition instanceof ULiteralExpression ? Intrinsics.areEqual((Object)Boolean.TRUE, (Object)(value = ((ULiteralExpression)condition).getValue())) : this.isNullOrInstanceCheck(condition)) {
            return;
        }
        String message2 = this.getErrorMessage();
        Location location = null;
        PsiElement firstChild = expression.getSourcePsi().getFirstChild();
        location = firstChild instanceof PsiKeyword && Intrinsics.areEqual((Object)"assert", (Object)firstChild.getText()) ? context2.getLocation(firstChild) : context2.getLocation((UElement)expression);
        LintFix fix = this.createJavaBuildConfigFix(context2, expression);
        context2.report(DISABLED, (UElement)expression, location, message2, fix);
    }

    private final void checkKotlinAssertion(JavaContext context2, UCallExpression assertion) {
        String message2;
        Location location;
        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)assertion.getValueArguments());
        if (uExpression == null) {
            return;
        }
        UExpression condition = uExpression;
        if (this.isAndroidContext(context2) && context2.isEnabled(DISABLED)) {
            location = context2.getLocation((UElement)assertion);
            message2 = this.getErrorMessage();
            context2.report(DISABLED, (UElement)assertion, location, message2, this.createKotlinBuildConfigFix(context2, assertion));
        }
        if (context2.isEnabled(EXPENSIVE) && this.warnAboutWork(assertion, condition)) {
            UClass cls;
            location = context2.getLocation((UElement)condition);
            message2 = "Kotlin assertion arguments are always evaluated, even when assertions are off";
            LintFix fix = null;
            UClass uClass = cls = (UClass)UastUtils.getParentOfType((UElement)((UElement)assertion), UClass.class, (boolean)true);
            if ((uClass != null ? uClass.getSourcePsi() : null) != null) {
                fix = this.createKotlinAssertionStatusFix(context2, assertion);
                message2 = message2 + ". Consider surrounding assertion with `if (javaClass.desiredAssertionStatus()) { assert(...) }`";
            } else {
                fix = null;
            }
            context2.report(EXPENSIVE, (UElement)assertion, location, message2, fix);
        }
    }

    private final String getErrorMessage() {
        return "Assertions are never enabled in Android. Use `BuildConfig.DEBUG` conditional checks instead";
    }

    private final LintFix createJavaBuildConfigFix(JavaContext context2, JavaUAssertExpression assertion) {
        Object object;
        String replacement;
        String string;
        Object object2;
        String string2 = context2.getMainProject().getPackage();
        if (string2 == null) {
            return null;
        }
        String pkgPrefix = string2;
        UExpression condition = assertion.getCondition();
        UExpression uExpression = condition;
        if (!(uExpression instanceof ULiteralExpression)) {
            uExpression = null;
        }
        ULiteralExpression uLiteralExpression = (ULiteralExpression)uExpression;
        Object object3 = object2 = uLiteralExpression != null ? uLiteralExpression.evaluate() : null;
        if (Intrinsics.areEqual((Object)object2, (Object)true)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)object2, (Object)false)) {
            string = pkgPrefix + ".BuildConfig.DEBUG";
        } else {
            String string3 = this.negateSource(condition);
            if (string3 == null) {
                return null;
            }
            String check = string3;
            string = replacement = pkgPrefix + ".BuildConfig.DEBUG && " + check;
        }
        if ((object = assertion.getMessage()) == null || (object = object.getSourcePsi()) == null || (object = object.getText()) == null) {
            object = "\"Assertion failed\"";
        }
        Object message2 = object;
        return this.fix().name("Replace with BuildConfig.DEBUG check").replace().range(context2.getLocation((UElement)assertion)).all().with("if (" + replacement + ") { throw new AssertionError(" + (String)message2 + "); }").reformat(true).shortenNames().build();
    }

    private final LintFix createKotlinBuildConfigFix(JavaContext context2, UCallExpression assertCall) {
        Object object;
        String replacement;
        block12: {
            block11: {
                Object object2;
                String string;
                Object object3;
                String string2 = context2.getMainProject().getPackage();
                if (string2 == null) {
                    return null;
                }
                String pkgPrefix = string2;
                List arguments = assertCall.getValueArguments();
                UExpression condition = (UExpression)arguments.get(0);
                UExpression uExpression = condition;
                if (!(uExpression instanceof ULiteralExpression)) {
                    uExpression = null;
                }
                ULiteralExpression uLiteralExpression = (ULiteralExpression)uExpression;
                Object object4 = object3 = uLiteralExpression != null ? uLiteralExpression.evaluate() : null;
                if (Intrinsics.areEqual((Object)object3, (Object)true)) {
                    return null;
                }
                if (Intrinsics.areEqual((Object)object3, (Object)false)) {
                    string = pkgPrefix + ".BuildConfig.DEBUG";
                } else {
                    String string3 = this.negateSource(condition);
                    if (string3 == null) {
                        return null;
                    }
                    String check = string3;
                    string = replacement = pkgPrefix + ".BuildConfig.DEBUG && " + check;
                }
                if (!((object2 = CollectionsKt.lastOrNull((List)arguments)) instanceof ULambdaExpression)) {
                    object2 = null;
                }
                if ((object = (ULambdaExpression)object2) == null || (object = object.getBody()) == null || (object = object.getSourcePsi()) == null || (object = object.getText()) == null) break block11;
                Object object5 = object;
                boolean bl = false;
                Object object6 = object5;
                if (object6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object6))).toString();
                if (object != null) break block12;
            }
            object = "\"Assertion failed\"";
        }
        Object message2 = object;
        return this.fix().name("Replace with BuildConfig.DEBUG check").replace().range(context2.getLocation((UElement)assertCall)).all().with("if (" + replacement + ") { error(" + (String)message2 + ") }").reformat(true).shortenNames().build();
    }

    private final LintFix createKotlinAssertionStatusFix(JavaContext context2, UCallExpression assertCall) {
        return this.fix().name("Surround with desiredAssertionStatus() check").replace().range(context2.getLocation((UElement)assertCall)).pattern("(.*)").with("if (javaClass.desiredAssertionStatus()) { \\k<1> }").reformat(true).build();
    }

    private final boolean isNullOrInstanceCheck(UExpression expression) {
        boolean bl;
        if (expression instanceof UParenthesizedExpression) {
            return this.isNullOrInstanceCheck(((UParenthesizedExpression)expression).getExpression());
        }
        UExpression uExpression = expression;
        if (uExpression instanceof JavaUInstanceCheckExpression) {
            bl = true;
        } else if (uExpression instanceof UBinaryExpression) {
            UExpression lOperand = ((UBinaryExpression)expression).getLeftOperand();
            UExpression rOperand = ((UBinaryExpression)expression).getRightOperand();
            bl = UastLiteralUtils.isNullLiteral((UElement)((UElement)lOperand)) || UastLiteralUtils.isNullLiteral((UElement)((UElement)rOperand)) || this.isNullOrInstanceCheck(lOperand) && this.isNullOrInstanceCheck(rOperand);
        } else if (uExpression instanceof UPolyadicExpression) {
            for (UExpression operand : ((UPolyadicExpression)expression).getOperands()) {
                if (this.isNullOrInstanceCheck(operand)) continue;
                return false;
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean warnAboutWork(UCallExpression assertCall, UExpression condition) {
        return this.isExpensive(condition, 0) && !this.isWithinAssertionStatusCheck((UExpression)assertCall);
    }

    private final boolean isExpensive(UExpression argument, int depth) {
        PsiMethod method;
        if (depth == 4) {
            return true;
        }
        if (argument instanceof ULiteralExpression || argument instanceof UInstanceExpression) {
            return false;
        }
        if (argument instanceof UBinaryExpressionWithType) {
            return argument instanceof KotlinUTypeCheckExpression ? false : this.isExpensive(((UBinaryExpressionWithType)argument).getOperand(), depth + 1);
        }
        if (argument instanceof UPolyadicExpression) {
            for (UExpression value : ((UPolyadicExpression)argument).getOperands()) {
                if (!this.isExpensive(value, depth + 1)) continue;
                return true;
            }
            return false;
        }
        if (argument instanceof UParenthesizedExpression) {
            return this.isExpensive(((UParenthesizedExpression)argument).getExpression(), depth + 1);
        }
        if (argument instanceof UBinaryExpression) {
            return this.isExpensive(((UBinaryExpression)argument).getLeftOperand(), depth + 1) || this.isExpensive(((UBinaryExpression)argument).getRightOperand(), depth + 1);
        }
        if (argument instanceof UUnaryExpression) {
            return this.isExpensive(((UUnaryExpression)argument).getOperand(), depth + 1);
        }
        if (argument instanceof USimpleNameReferenceExpression) {
            return false;
        }
        if (argument instanceof UQualifiedReferenceExpression) {
            if (((UQualifiedReferenceExpression)argument).getSelector() instanceof UCallExpression) {
                return this.isExpensive(((UQualifiedReferenceExpression)argument).getSelector(), depth + 1);
            }
            Object value = argument.evaluate();
            if (value != null) {
                return false;
            }
            PsiElement resolved = ((UQualifiedReferenceExpression)argument).resolve();
            if (resolved instanceof PsiVariable) {
                return false;
            }
        } else if (argument instanceof UCallExpression && (method = ((UCallExpression)argument).resolve()) != null && !(method instanceof PsiCompiledElement)) {
            UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)((PsiElement)method), UMethod.class);
            if (uMethod == null || (uMethod = uMethod.getUastBody()) == null) {
                return true;
            }
            UMethod body = uMethod;
            if (body instanceof UBlockExpression) {
                List expressions = ((UBlockExpression)body).getExpressions();
                if (expressions.size() == 1 && expressions.get(0) instanceof UReturnExpression) {
                    Object e = expressions.get(0);
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UReturnExpression");
                    }
                    UExpression retExp = ((UReturnExpression)e).getReturnExpression();
                    return retExp == null || this.isExpensive(retExp, depth + 1);
                }
            } else {
                return this.isExpensive((UExpression)body, depth + 1);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isWithinAssertionStatusCheck(UExpression node) {
        UExpression curr = node;
        while (true) {
            UIfExpression ifStatement;
            void $this$getParentOfType$iv;
            UElement uElement = (UElement)curr;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            if ((UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UIfExpression.class, (boolean)strict$iv) == null) {
                break;
            }
            Object object = ifStatement.getCondition().getSourcePsi();
            if (object != null && (object = object.getText()) != null) {
                if (StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"desiredAssertionStatus", (boolean)false, (int)2, null)) {
                    return true;
                }
            }
            curr = (UExpression)ifStatement;
        }
        return false;
    }

    private final String negateSource(UExpression condition) {
        Object object;
        String source;
        block18: {
            block17: {
                UastBinaryOperator uastBinaryOperator;
                if (condition instanceof UBinaryExpression) {
                    UastBinaryOperator.ComparisonOperator reverse;
                    uastBinaryOperator = ((UBinaryExpression)condition).getOperator();
                    Object object2 = Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS) ? UastBinaryOperator.GREATER_OR_EQUALS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS_OR_EQUALS) ? UastBinaryOperator.GREATER : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER) ? UastBinaryOperator.LESS_OR_EQUALS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER_OR_EQUALS) ? UastBinaryOperator.LESS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.EQUALS) ? UastBinaryOperator.NOT_EQUALS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_EQUALS) ? UastBinaryOperator.IDENTITY_NOT_EQUALS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.NOT_EQUALS) ? UastBinaryOperator.EQUALS : (reverse = Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS) ? UastBinaryOperator.IDENTITY_EQUALS : null)))))));
                    if (reverse != null) {
                        String right;
                        PsiElement psiElement = ((UBinaryExpression)condition).getLeftOperand().getSourcePsi();
                        String left = psiElement != null ? psiElement.getText() : null;
                        PsiElement psiElement2 = ((UBinaryExpression)condition).getRightOperand().getSourcePsi();
                        String string = right = psiElement2 != null ? psiElement2.getText() : null;
                        if (left != null && right != null) {
                            String operatorText = Lint.isKotlin(condition.getSourcePsi()) ? reverse.getText() : (Intrinsics.areEqual((Object)reverse, (Object)UastBinaryOperator.IDENTITY_EQUALS) ? "==" : (Intrinsics.areEqual((Object)reverse, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS) ? "!=" : reverse.getText()));
                            return left + ' ' + operatorText + ' ' + right;
                        }
                    }
                } else if (condition instanceof UUnaryExpression && Intrinsics.areEqual((Object)((UUnaryExpression)condition).getOperator(), (Object)UastPrefixOperator.LOGICAL_NOT)) {
                    String nested;
                    PsiElement psiElement = ((UUnaryExpression)condition).getOperand().getSourcePsi();
                    String string = nested = psiElement != null ? psiElement.getText() : null;
                    if (nested != null) {
                        return nested;
                    }
                } else if (condition instanceof UReferenceExpression || condition instanceof UCallExpression) {
                    String string;
                    Object object3 = condition.getSourcePsi();
                    if (object3 != null && (object3 = object3.getText()) != null) {
                        uastBinaryOperator = object3;
                        boolean bl = false;
                        UastBinaryOperator uastBinaryOperator2 = uastBinaryOperator;
                        if (uastBinaryOperator2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string = ((Object)StringsKt.trim((CharSequence)((CharSequence)uastBinaryOperator2))).toString();
                    } else {
                        string = source = null;
                    }
                    if (source != null) {
                        return '!' + source;
                    }
                }
                if ((object = condition.getSourcePsi()) == null || (object = object.getText()) == null) break block17;
                uastBinaryOperator = object;
                boolean bl = false;
                UastBinaryOperator uastBinaryOperator3 = uastBinaryOperator;
                if (uastBinaryOperator3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                object = ((Object)StringsKt.trim((CharSequence)((CharSequence)uastBinaryOperator3))).toString();
                if (object != null) break block18;
            }
            return null;
        }
        source = object;
        return "!(" + StringsKt.removeSurrounding((String)source, (CharSequence)"(", (CharSequence)")") + ')';
    }

    static {
        Issues = new Issues(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = new Implementation(AssertDetector.class, Scope.JAVA_FILE_SCOPE);
        boolean bl = false;
        Object object = true;
        Severity severity = Severity.WARNING;
        int n = 6;
        String string = null;
        Category category = Category.CORRECTNESS;
        DISABLED = Issue.Companion.create$default(Issue.Companion, "Assert", "Ignored Assertions", "\n                Assertions will never be turned on in Android. (It was possible to enable \\\n                it in Dalvik with `adb shell setprop debug.assert 1`, but it is not implemented \\\n                in ART, the runtime for Android 5.0 and later.)\n\n                This means that the assertion will never catch mistakes, and you should not \\\n                use assertions from Java or Kotlin for debug build checking.\n\n                Instead, perform conditional checking inside `if (BuildConfig.DEBUG) { }` blocks. \\\n                That constant is a static final boolean which will be true only in debug builds, \\\n                and false in release builds, and the compiler will completely remove all code \\\n                inside the `if`-body from the app.\n\n                For example, you can replace\n                ```\n                    assert(speed > 0, { \"Message\" })    // Kotlin\n                    assert speed > 0 : \"Message\"        // Java\n                ```\n                with\n                ```\n                    if (BuildConfig.DEBUG && !(speed > 0)) {\n                        throw new AssertionError(\"Message\")\n                    }\n                ```\n                (Note: This lint check does not flag assertions purely asserting nullness or \\\n                non-nullness in Java code; these are typically more intended for tools usage \\\n                than runtime checks.)", implementation, string, category, n, severity, bl, (Boolean)object, enumSet, collection, 3088, null);
        collection = null;
        enumSet = null;
        implementation = null;
        bl = false;
        object = new Implementation(AssertDetector.class, Scope.JAVA_FILE_SCOPE);
        severity = Severity.WARNING;
        n = 6;
        string = null;
        category = Category.PERFORMANCE;
        EXPENSIVE = Issue.Companion.create$default(Issue.Companion, "ExpensiveAssertion", "Expensive Assertions", "\n                In Kotlin, assertions are not handled the same way as from the Java programming \\\n                language. In particular, they're just implemented as a library call, and inside \\\n                the library call the error is only thrown if assertions are enabled.\n\n                This means that the arguments to the `assert` call will **always** \\\n                be evaluated. If you're doing any computation in the expression being \\\n                asserted, that computation will unconditionally be performed whether or not \\\n                assertions are turned on. This typically turns into wasted work in release \\\n                builds.\n\n                This check looks for cases where the assertion condition is nontrivial, e.g. \\\n                it is performing method calls or doing more work than simple comparisons \\\n                on local variables or fields.\n\n                You can work around this by writing your own inline assert method instead:\n\n                ```\n                @Suppress(\"INVISIBLE_REFERENCE\", \"INVISIBLE_MEMBER\")\n                inline fun assert(condition: () -> Boolean) {\n                    if (_Assertions.ENABLED && !condition()) {\n                        throw AssertionError()\n                    }\n                }\n                ```\n\n                In Android, because assertions are not enforced at runtime, instead use this:\n\n                ```kotlin\n                inline fun assert(condition: () -> Boolean) {\n                    if (BuildConfig.DEBUG && !condition()) {\n                        throw AssertionError()\n                    }\n                }\n                ```\n                ", (Implementation)object, string, category, n, severity, bl, (Boolean)((Object)implementation), enumSet, collection, 3600, null);
    }

    public static final /* synthetic */ void access$checkJavaAssertion(AssertDetector $this, JavaUAssertExpression expression, JavaContext context2) {
        $this.checkJavaAssertion(expression, context2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/AssertDetector$Issues;", "", "()V", "DISABLED", "Lcom/android/tools/lint/detector/api/Issue;", "EXPENSIVE", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

