/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model;

import com.android.tools.deployer.ZipUtils;
import com.android.tools.deployer.model.ApkEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class Apk
implements Serializable {
    public final String name;
    public final String checksum;
    public final String path;
    public final String packageName;
    public final List<String> libraryAbis;
    public final List<String> targetPackages;
    public final List<String> isolatedServices;
    public final Map<String, ApkEntry> apkEntries;

    private Apk(String name, String checksum, String path2, String packageName, List<String> libraryAbis, List<String> targetPackages, List<String> isolatedServices, Map<String, ApkEntry> apkEntries) {
        this.name = name;
        this.checksum = checksum;
        this.path = path2;
        this.packageName = packageName;
        this.libraryAbis = libraryAbis;
        this.targetPackages = targetPackages;
        this.isolatedServices = isolatedServices;
        this.apkEntries = apkEntries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name = "";
        private String checksum = "";
        private String path = "";
        private String packageName = "";
        private ImmutableList.Builder<String> libraryAbis = ImmutableList.builder();
        private List<String> targetPackages = null;
        private List<String> isolatedServices = null;
        private ImmutableMap.Builder<String, ApkEntry> apkEntries = ImmutableMap.builder();

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setChecksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder setPath(String path2) {
            this.path = path2;
            return this;
        }

        public Builder setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder setTargetPackages(List<String> targetPackages) {
            this.targetPackages = targetPackages;
            return this;
        }

        public Builder setIsolatedServices(List<String> isolatedServices) {
            this.isolatedServices = isolatedServices;
            return this;
        }

        public Builder addLibraryAbi(String abi) {
            this.libraryAbis.add((Object)abi);
            return this;
        }

        @VisibleForTesting
        public Builder addApkEntry(String name, long checksum) {
            this.apkEntries.put((Object)name, (Object)new ApkEntry(name, checksum, null));
            return this;
        }

        public Builder addApkEntry(ZipUtils.ZipEntry zipEntry) {
            this.apkEntries.put((Object)zipEntry.name, (Object)new ApkEntry(zipEntry));
            return this;
        }

        public Apk build() {
            this.targetPackages = this.targetPackages == null ? ImmutableList.of() : this.targetPackages;
            this.isolatedServices = this.isolatedServices == null ? ImmutableList.of() : this.isolatedServices;
            Apk apk = new Apk(this.name, this.checksum, this.path, this.packageName, (List)this.libraryAbis.build(), this.targetPackages, this.isolatedServices, (Map)this.apkEntries.build());
            apk.apkEntries.values().forEach(entry -> entry.setApk(apk));
            return apk;
        }
    }
}

