/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.ApkEntryExtractor;
import com.android.tools.deployer.ApplicationDumper;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DeployerOption;
import com.android.tools.deployer.DeploymentCacheDatabase;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.OverlayDiffer;
import com.android.tools.deployer.OverlayId;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.idea.protobuf.ByteString;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

class OptimisticApkInstaller {
    private static final Map<String, Deploy.Arch> ABI_MAP = ImmutableMap.of((Object)"arm64-v8a", (Object)Deploy.Arch.ARCH_64_BIT, (Object)"armeabi-v7a", (Object)Deploy.Arch.ARCH_32_BIT, (Object)"x86_64", (Object)Deploy.Arch.ARCH_64_BIT, (Object)"x86", (Object)Deploy.Arch.ARCH_32_BIT);
    private static final String DUMP_METRIC = "IWI_INSTALL_DUMP";
    private static final String DIFF_METRIC = "IWI_INSTALL_DIFF";
    private static final String EXTRACT_METRIC = "IWI_INSTALL_EXTRACT";
    private static final String UPDATE_METRIC = "IWI_INSTALL_UPDATE_OVERLAYS";
    private final Installer installer;
    private final AdbClient adb;
    private final DeploymentCacheDatabase cache;
    private final MetricsRecorder metrics;
    private final DeployerOption options;
    private final ILogger logger;

    public OptimisticApkInstaller(Installer installer, AdbClient adb, DeploymentCacheDatabase cache, MetricsRecorder metrics, DeployerOption options, ILogger logger) {
        this.installer = installer;
        this.adb = adb;
        this.cache = cache;
        this.metrics = metrics;
        this.options = options;
        this.logger = logger;
    }

    public OverlayId install(String packageName, List<Apk> apks) throws DeployerException {
        try {
            return this.tracedInstall(packageName, apks);
        }
        catch (DeployerException ex) {
            this.metrics.finish(ex.getError());
            throw ex;
        }
        catch (Exception ex) {
            DeployerException wrapper = DeployerException.runtimeException(ex);
            this.metrics.finish(wrapper.getError());
            throw wrapper;
        }
    }

    private OverlayId tracedInstall(String packageName, List<Apk> apks) throws DeployerException {
        Deploy.OverlayInstallResponse overlayInstallResponse;
        if (apks.stream().anyMatch(apk -> !apk.targetPackages.isEmpty())) {
            throw DeployerException.runTestsNotSupported();
        }
        String deviceSerial = this.adb.getSerial();
        Deploy.Arch targetArch = this.getArch(apks);
        this.metrics.start(DUMP_METRIC);
        DeploymentCacheDatabase.Entry entry = this.cache.get(deviceSerial, packageName);
        if (entry == null || entry.getOverlayId().isBaseInstall()) {
            ApplicationDumper dumper = new ApplicationDumper(this.installer);
            List<Apk> deviceApks = dumper.dump(apks).apks;
            this.cache.store(deviceSerial, packageName, deviceApks, new OverlayId(deviceApks));
            entry = this.cache.get(deviceSerial, packageName);
        }
        this.metrics.finish();
        this.metrics.start(DIFF_METRIC);
        OverlayId overlayId = entry.getOverlayId();
        OverlayDiffer.Result diff = new OverlayDiffer(this.options.optimisticInstallSupport).diff(apks, overlayId);
        this.metrics.finish();
        this.metrics.start(EXTRACT_METRIC);
        SortedMap<ApkEntry, ByteString> overlayFiles = new ApkEntryExtractor().extractFromEntries(diff.filesToAdd);
        this.metrics.finish();
        this.metrics.start(UPDATE_METRIC);
        OverlayId.Builder nextIdBuilder = OverlayId.builder(overlayId);
        Deploy.OverlayInstallRequest.Builder request = Deploy.OverlayInstallRequest.newBuilder().setPackageName(packageName).setArch(targetArch).setExpectedOverlayId(overlayId.isBaseInstall() ? "" : overlayId.getSha());
        for (Map.Entry entry2 : overlayFiles.entrySet()) {
            request.addOverlayFiles(Deploy.OverlayFile.newBuilder().setPath(((ApkEntry)entry2.getKey()).getQualifiedPath()).setContent((ByteString)entry2.getValue()));
            nextIdBuilder.addOverlayFile(((ApkEntry)entry2.getKey()).getQualifiedPath(), ((ApkEntry)entry2.getKey()).getChecksum());
        }
        for (String string : diff.filesToRemove) {
            request.addDeletedFiles(string);
            nextIdBuilder.removeOverlayFile(string);
        }
        OverlayId nextOverlayId = nextIdBuilder.build();
        request.setOverlayId(nextOverlayId.getSha());
        try {
            overlayInstallResponse = this.installer.overlayInstall(request.build());
        }
        catch (IOException ex) {
            throw DeployerException.installerIoException(ex);
        }
        if (overlayInstallResponse.getStatus() != Deploy.OverlayInstallResponse.Status.OK) {
            throw DeployerException.installFailed(overlayInstallResponse.getStatus(), "Overlay update failed");
        }
        this.metrics.finish();
        this.metrics.add(overlayInstallResponse.getAgentLogsList());
        return nextOverlayId;
    }

    private Deploy.Arch getArch(List<Apk> apks) throws DeployerException {
        HashSet<String> appSupported = new HashSet<String>();
        for (Apk apk : apks) {
            appSupported.addAll(apk.libraryAbis);
        }
        List<String> deviceSupported = this.adb.getAbis();
        if (deviceSupported.isEmpty()) {
            throw DeployerException.unsupportedArch();
        }
        if (appSupported.isEmpty()) {
            String abi = deviceSupported.get(0);
            return ABI_MAP.get(abi);
        }
        for (String abi : deviceSupported) {
            if (!appSupported.contains(abi)) continue;
            return ABI_MAP.get(abi);
        }
        throw DeployerException.unsupportedArch();
    }
}

