/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.lint.AndroidLintIdeIssueRegistry;
import com.android.tools.idea.lint.common.LintBatchResult;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeRequest;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.lint.checks.AppCompatCustomViewDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.analysis.AnalysisScope;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SmartList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.refactoring.AppCompatMigrationEntry;
import org.jetbrains.android.refactoring.MigrateToAppCompatUsageInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MigrateToAppCompatUtil {
    private MigrateToAppCompatUtil() {
    }

    static List<UsageInfo> findClassUsages(com.intellij.openapi.project.Project project, String qName) {
        PsiClass aClass = JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).findClass(qName, GlobalSearchScope.allScope((com.intellij.openapi.project.Project)project));
        return MigrateToAppCompatUtil.findRefs(project, (PsiElement)aClass);
    }

    public static List<UsageInfo> findPackageUsages(com.intellij.openapi.project.Project project, String qName) {
        PsiPackage aPackage = JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).findPackage(qName);
        return MigrateToAppCompatUtil.findRefs(project, (PsiElement)aPackage);
    }

    @NotNull
    private static List<UsageInfo> findRefs(com.intellij.openapi.project.Project project, PsiElement element2) {
        if (element2 == null) {
            return Collections.emptyList();
        }
        SmartList results = new SmartList();
        for (PsiReference usage : ReferencesSearch.search((PsiElement)element2, (SearchScope)GlobalSearchScope.projectScope((com.intellij.openapi.project.Project)project), (boolean)true)) {
            if (!usage.getElement().isWritable()) continue;
            results.add(new UsageInfo(usage));
        }
        return results;
    }

    static Collection<PsiReference> findChangeMethodRefs(com.intellij.openapi.project.Project project, AppCompatMigrationEntry.MethodMigrationEntry entry) {
        String psiClass = entry.myOldClassName;
        PsiClass psiLookupClass = JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).findClass(psiClass, GlobalSearchScope.allScope((com.intellij.openapi.project.Project)project));
        if (psiLookupClass == null) {
            return Collections.emptyList();
        }
        PsiMethod[] methods2 = psiLookupClass.findMethodsByName(entry.myOldMethodName, true);
        if (methods2.length > 0) {
            ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
            for (PsiMethod method2 : methods2) {
                RenamePsiElementProcessor processor = RenamePsiElementProcessor.forElement((PsiElement)method2);
                refs.addAll(processor.findReferences((PsiElement)methods2[0], (SearchScope)GlobalSearchScope.projectScope((com.intellij.openapi.project.Project)project), false));
            }
            return refs;
        }
        return Collections.emptyList();
    }

    static List<MigrateToAppCompatUsageInfo.ChangeCustomViewUsageInfo> findCustomViewsUsages(com.intellij.openapi.project.Project project, Module[] modules) {
        PsiManager manager = PsiManager.getInstance((com.intellij.openapi.project.Project)project);
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        Map<Issue, Map<File, List<LintProblemData>>> issues = MigrateToAppCompatUtil.computeCustomViewIssuesMap(project, modules);
        Map<File, List<LintProblemData>> fileListMap = issues.get(AppCompatCustomViewDetector.ISSUE);
        if (fileListMap == null) {
            return Collections.emptyList();
        }
        ArrayList result2 = Lists.newArrayList();
        Map<PsiFile, List> psiFileListMap = fileListMap.entrySet().stream().filter(e -> fileSystem.findFileByIoFile((File)e.getKey()) != null).collect(Collectors.toMap(e -> manager.findFile(fileSystem.findFileByIoFile((File)e.getKey())), Map.Entry::getValue));
        for (Map.Entry<PsiFile, List> entry : psiFileListMap.entrySet()) {
            PsiFile psiFile2 = entry.getKey();
            if (!psiFile2.isValid()) continue;
            List problemDataList = entry.getValue();
            for (LintProblemData problemData : problemDataList) {
                Integer start2 = problemData.getTextRange().getStartOffset();
                LintFix fix = problemData.getQuickfixData();
                if (!(fix instanceof LintFix.ReplaceString)) continue;
                LintFix.ReplaceString replaceFix = (LintFix.ReplaceString)fix;
                String suggestedSuperClass = replaceFix.replacement;
                PsiElement element2 = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile2, (int)start2, PsiElement.class, (boolean)true);
                if (element2 == null) continue;
                result2.add(new MigrateToAppCompatUsageInfo.ChangeCustomViewUsageInfo(element2, suggestedSuperClass));
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static Map<Issue, Map<File, List<LintProblemData>>> computeCustomViewIssuesMap(@NotNull com.intellij.openapi.project.Project project, @NotNull Module[] modules) {
        HashMap map2 = Maps.newHashMap();
        boolean detectorWasEnabled = AppCompatCustomViewDetector.ISSUE.isEnabledByDefault();
        AppCompatCustomViewDetector.ISSUE.setEnabledByDefault(true);
        AnalysisScope scope2 = new AnalysisScope(project);
        try {
            HashSet<Issue> issues = new HashSet<Issue>(1);
            issues.add(AppCompatCustomViewDetector.ISSUE);
            LintBatchResult lintResult = new LintBatchResult(project, (Map)map2, scope2, issues);
            LintIdeClient client = LintIdeSupport.get().createBatchClient(lintResult);
            LintIdeRequest request = new LintIdeRequest(client, project, null, Arrays.asList(modules), false){
                @Nullable
                Project myMainProject = null;

                public Project getMainProject(Project project) {
                    if (this.myMainProject == null) {
                        Project mainProject = super.getMainProject(project);
                        File dir = new File(mainProject.getDir().getParentFile(), mainProject.getName() + "-main");
                        this.myMainProject = new Project(mainProject.getClient(), dir, dir){

                            public Boolean dependsOn(@NotNull String artifact) {
                                if ("com.android.support:appcompat-v7".equals(artifact) || "androidx.appcompat:appcompat".equals(artifact)) {
                                    return Boolean.TRUE;
                                }
                                return super.dependsOn(artifact);
                            }
                        };
                    }
                    return this.myMainProject;
                }
            };
            request.setScope(Scope.JAVA_FILE_SCOPE);
            client.createDriver((LintRequest)request, (IssueRegistry)new AndroidLintIdeIssueRegistry()).analyze();
        }
        finally {
            AppCompatCustomViewDetector.ISSUE.setEnabledByDefault(detectorWasEnabled);
        }
        return map2;
    }

    static Set<XmlFile> getPsiFilesOfType(com.intellij.openapi.project.Project project, ResourceRepository repository, ResourceType resourceType) {
        Set itemsOfType = repository.getResources(ResourceNamespace.TODO(), resourceType).keySet();
        return itemsOfType.stream().map(name -> repository.getResources(ResourceNamespace.TODO(), resourceType, name)).flatMap(Collection::stream).map(item -> IdeResourcesUtil.getItemPsiFile(project, item)).filter(f -> f instanceof XmlFile).map(XmlFile.class::cast).collect(Collectors.toSet());
    }

    public static List<UsageInfo> findUsagesOfXmlElements(com.intellij.openapi.project.Project project, Module[] modules, List<AppCompatMigrationEntry.XmlElementMigration> operations, ResourceType resourceType) {
        if (operations.isEmpty()) {
            return Collections.emptyList();
        }
        final ArrayListMultimap tag2XmlOperation = ArrayListMultimap.create();
        for (AppCompatMigrationEntry.XmlElementMigration operation : operations) {
            for (String tagName : operation.applicableTagNames()) {
                tag2XmlOperation.put((Object)tagName, (Object)operation);
            }
        }
        final ArrayList<UsageInfo> usageInfos = new ArrayList<UsageInfo>();
        for (Module module2 : modules) {
            LocalResourceRepository projectResources = ResourceRepositoryManager.getProjectResources(module2);
            if (projectResources == null) continue;
            Set<XmlFile> xmlFiles = MigrateToAppCompatUtil.getPsiFilesOfType(project, (ResourceRepository)projectResources, resourceType);
            for (XmlFile file2 : xmlFiles) {
                file2.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        super.visitXmlTag(tag);
                        List operations = tag2XmlOperation.get((Object)tag.getName());
                        if (operations != null) {
                            for (AppCompatMigrationEntry.XmlElementMigration operation : operations) {
                                UsageInfo usage = operation.apply(tag);
                                if (usage == null) continue;
                                usageInfos.add(usage);
                            }
                        }
                    }
                });
            }
        }
        tag2XmlOperation.clear();
        return usageInfos;
    }

    public static void removeUnneededUsages(List<UsageInfo> infos) {
        ArrayListMultimap map2 = ArrayListMultimap.create();
        for (UsageInfo usageInfo : infos) {
            if (!(usageInfo instanceof MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo) || usageInfo.getElement() == null || usageInfo.getElement().getContainingFile() == null) continue;
            map2.put((Object)usageInfo.getElement().getContainingFile(), (Object)((MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo)usageInfo));
        }
        SmartList toRemove = new SmartList();
        for (PsiFile file2 : map2.keySet()) {
            List usages = map2.get((Object)file2);
            boolean excludeUsages = usages.stream().allMatch(u -> {
                String qname;
                return u.getElement() != null && u.getElement().getParent() instanceof PsiImportStatement && (qname = ((PsiImportStatement)u.getElement().getParent()).getQualifiedName()) != null && (qname.equals("android.app.Activity") || qname.equals("android.support.v4.app.FragmentActivity"));
            });
            if (!excludeUsages) continue;
            toRemove.addAll(usages);
        }
        infos.removeAll((Collection<?>)toRemove);
    }

    static boolean isKotlinSimpleNameReference(PsiReference reference2) {
        PluginId kotlinPluginId = PluginId.findId((String[])new String[]{"org.jetbrains.kotlin"});
        IdeaPluginDescriptor kotlinPlugin = Objects.requireNonNull(PluginManagerCore.getPlugin((PluginId)kotlinPluginId));
        ClassLoader pluginClassLoader = kotlinPlugin.getPluginClassLoader();
        try {
            Class<?> simpleNameReferenceClass = Class.forName("org.jetbrains.kotlin.idea.references.KtSimpleNameReference", true, pluginClassLoader);
            return simpleNameReferenceClass.isInstance(reference2);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

