/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.utils.SdkUtils;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.AndroidGotoRelatedLineMarkerProvider;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.dom.menu.MenuDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.intentions.AndroidCreateOnClickHandlerAction;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;

public class AndroidMissingOnClickHandlerInspection
extends LocalInspectionTool {
    @NotNull
    private static Collection<PsiClass> findRelatedActivities(@NotNull XmlFile file2, @NotNull AndroidFacet facet2, @NotNull DomFileDescription<?> description2) {
        if (AndroidResourceDomFileDescription.isFileInResourceFolderType(file2, ResourceFolderType.LAYOUT)) {
            List<GotoRelatedItem> items2 = AndroidGotoRelatedLineMarkerProvider.getItemsForXmlFile(file2, facet2);
            if (items2 == null || items2.isEmpty()) {
                return Collections.emptyList();
            }
            PsiClass activityClass = AndroidMissingOnClickHandlerInspection.findActivityClass(facet2.getModule());
            if (activityClass == null) {
                return Collections.emptyList();
            }
            ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
            for (GotoRelatedItem item : items2) {
                PsiClass aClass;
                PsiElement element2 = item.getElement();
                if (element2 instanceof PsiClass) {
                    aClass = (PsiClass)element2;
                    if (!aClass.isInheritor(activityClass, true)) continue;
                    result2.add(aClass);
                    continue;
                }
                if (!(element2 instanceof KtClass) || (aClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClass)element2))) == null || !aClass.isInheritor(activityClass, true)) continue;
                result2.add(aClass);
            }
            return result2;
        }
        return AndroidMissingOnClickHandlerInspection.findRelatedActivitiesForMenu(file2, facet2);
    }

    @NotNull
    private static Set<PsiClass> findRelatedActivitiesForMenu(@NotNull XmlFile file2, @NotNull AndroidFacet facet2) {
        String resourceName;
        String resType = ResourceType.MENU.getName();
        PsiField[] fields = IdeResourcesUtil.findResourceFields(facet2, resType, resourceName = SdkUtils.fileNameToResourceName((String)file2.getName()), true);
        if (fields.length == 0) {
            return Collections.emptySet();
        }
        Module module2 = facet2.getModule();
        GlobalSearchScope scope2 = module2.getModuleScope(false);
        final PsiClass activityClass = AndroidMissingOnClickHandlerInspection.findActivityClass(module2);
        if (activityClass == null) {
            return Collections.emptySet();
        }
        final HashSet<PsiClass> result2 = new HashSet<PsiClass>();
        ReferencesSearch.search((PsiElement)fields[0], (SearchScope)scope2).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference2) {
                PsiElement element2 = reference2.getElement();
                if (element2 == null) {
                    return true;
                }
                PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiClass.class);
                if (aClass != null && !result2.contains(aClass) && aClass.isInheritor(activityClass, true)) {
                    result2.add(aClass);
                }
                return true;
            }
        });
        return result2;
    }

    @Nullable
    public static PsiClass findActivityClass(@NotNull Module module2) {
        return JavaPsiFacade.getInstance((Project)module2.getProject()).findClass("android.app.Activity", module2.getModuleWithDependenciesAndLibrariesScope(false));
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (!(file2 instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
        if (facet2 == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DomFileDescription description2 = DomManager.getDomManager((Project)file2.getProject()).getDomFileDescription((XmlFile)file2);
        if (!AndroidResourceDomFileDescription.isFileInResourceFolderType((XmlFile)file2, ResourceFolderType.LAYOUT) && !(description2 instanceof MenuDomFileDescription)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Collection<PsiClass> activities = AndroidMissingOnClickHandlerInspection.findRelatedActivities((XmlFile)file2, facet2, description2);
        MyVisitor visitor2 = new MyVisitor(manager, isOnTheFly, activities);
        file2.accept((PsiElementVisitor)visitor2);
        return visitor2.myResult.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    public static class MyQuickFix
    extends AbstractIntentionAction
    implements LocalQuickFix {
        private final String myMethodName;
        private final OnClickConverter myConverter;
        private final PsiClass myClass;

        private MyQuickFix(@NotNull String methodName, @NotNull OnClickConverter converter, @NotNull PsiClass aClass) {
            this.myMethodName = methodName;
            this.myConverter = converter;
            this.myClass = aClass;
        }

        @NotNull
        public String getFamilyName() {
            return "Create '" + this.myMethodName + "(" + this.myConverter.getShortParameterName() + ")' in '" + this.myClass.getName() + "'";
        }

        @NotNull
        public String getText() {
            return this.getName();
        }

        public void invoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
            String paramType = this.myConverter.getDefaultMethodParameterType(this.myClass);
            AndroidCreateOnClickHandlerAction.addHandlerMethodAndNavigate(project, this.myClass, this.myMethodName, paramType);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            this.doApplyFix(project);
        }

        public void doApplyFix(@NotNull Project project) {
            String paramType = this.myConverter.getDefaultMethodParameterType(this.myClass);
            AndroidCreateOnClickHandlerAction.addHandlerMethod(project, this.myClass, this.myMethodName, paramType);
        }
    }

    private static class MyVisitor
    extends XmlRecursiveElementVisitor {
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        private final Collection<PsiClass> myRelatedActivities;
        final List<ProblemDescriptor> myResult = new ArrayList<ProblemDescriptor>();

        private MyVisitor(@NotNull InspectionManager inspectionManager, boolean onTheFly, @NotNull Collection<PsiClass> relatedActivities) {
            this.myInspectionManager = inspectionManager;
            this.myOnTheFly = onTheFly;
            this.myRelatedActivities = relatedActivities;
        }

        public void visitXmlAttributeValue(XmlAttributeValue value2) {
            for (PsiReference reference2 : value2.getReferences()) {
                OnClickConverter.MyReference ref;
                String methodName;
                if (!(reference2 instanceof OnClickConverter.MyReference) || (methodName = (ref = (OnClickConverter.MyReference)reference2).getValue()).isEmpty()) continue;
                ResolveResult[] results = ref.multiResolve(false);
                HashSet<PsiClass> resolvedClasses = new HashSet<PsiClass>();
                HashSet<PsiClass> resolvedClassesWithMistake = new HashSet<PsiClass>();
                for (ResolveResult result2 : results) {
                    PsiClass aClass;
                    PsiElement element2;
                    if (!(result2 instanceof OnClickConverter.MyResolveResult) || (element2 = result2.getElement()) == null || (aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiClass.class)) == null) continue;
                    resolvedClasses.add(aClass);
                    if (((OnClickConverter.MyResolveResult)result2).hasCorrectSignature()) continue;
                    resolvedClassesWithMistake.add(aClass);
                }
                PsiClass activity = null;
                for (PsiClass relatedActivity : this.myRelatedActivities) {
                    if (!MyVisitor.containsOrExtends(resolvedClasses, relatedActivity)) {
                        activity = relatedActivity;
                        break;
                    }
                    if (activity != null || !MyVisitor.containsOrExtends(resolvedClassesWithMistake, relatedActivity)) continue;
                    activity = relatedActivity;
                }
                if (activity != null) {
                    this.reportMissingOnClickProblem(ref, activity, methodName, resolvedClassesWithMistake.contains(activity));
                    continue;
                }
                if (results.length == 0) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor((PsiElement)value2, reference2.getRangeInElement(), ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference2), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]));
                    continue;
                }
                if (resolvedClassesWithMistake.isEmpty()) continue;
                this.reportMissingOnClickProblem(ref, (PsiClass)resolvedClassesWithMistake.iterator().next(), methodName, true);
            }
        }

        private static boolean containsOrExtends(@NotNull Set<PsiClass> resolvedClasses, @NotNull PsiClass relatedActivity) {
            if (resolvedClasses.contains(relatedActivity)) {
                return true;
            }
            for (PsiClass resolvedClass : resolvedClasses) {
                if (!relatedActivity.isInheritor(resolvedClass, false)) continue;
                return true;
            }
            return false;
        }

        private void reportMissingOnClickProblem(OnClickConverter.MyReference reference2, PsiClass activity, String methodName, boolean incorrectSignature) {
            LocalQuickFix[] localQuickFixArray;
            String message2;
            String activityName = activity.getName();
            if (activityName == null) {
                activityName = "";
            }
            String string = message2 = incorrectSignature ? AndroidBundle.message("android.inspections.on.click.missing.incorrect.signature", methodName, activityName) : AndroidBundle.message("android.inspections.on.click.missing.problem", methodName, activityName);
            if (StringUtil.isJavaIdentifier((String)methodName)) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new MyQuickFix(methodName, reference2.getConverter(), activity);
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            this.myResult.add(this.myInspectionManager.createProblemDescriptor(reference2.getElement(), reference2.getRangeInElement(), message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, fixes));
        }
    }
}

