/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.project.AndroidRunConfigurations;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.facet.FacetType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.importDependencies.ImportDependenciesUtil;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFrameworkDetector
extends FacetBasedFrameworkDetector<AndroidFacet, AndroidFacetConfiguration> {
    private static final NotificationGroup ANDROID_MODULE_IMPORTING_NOTIFICATION = NotificationGroup.balloonGroup((String)"Android Module Importing", (PluginId)PluginId.getId((String)"org.jetbrains.android"));

    public AndroidFrameworkDetector() {
        super("android");
    }

    public List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<VirtualFile> newFiles, @NotNull FrameworkDetectionContext context) {
        GradleProjectInfo gradleProjectInfo;
        Project project = context.getProject();
        if (project != null && ((gradleProjectInfo = GradleProjectInfo.getInstance(project)).isBuildWithGradle() || gradleProjectInfo.hasTopLevelGradleFile())) {
            return Collections.emptyList();
        }
        return super.detect(newFiles, context);
    }

    public void setupFacet(@NotNull AndroidFacet facet2, ModifiableRootModel model2) {
        Module module2 = facet2.getModule();
        Project project = module2.getProject();
        VirtualFile[] contentRoots = model2.getContentRoots();
        if (contentRoots.length == 1) {
            AndroidUtils.setUpAndroidFacetConfiguration(facet2, contentRoots[0].getPath());
        }
        ImportDependenciesUtil.importDependencies(module2, true);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> DumbService.getInstance((Project)project).runWhenSmart(() -> {
            AndroidFrameworkDetector.doImportSdkAndFacetConfiguration(facet2, model2);
            StoreUtil.saveDocumentsAndProjectSettings((Project)project);
        }));
    }

    public static void doImportSdkAndFacetConfiguration(@NotNull AndroidFacet facet2, @Nullable ModifiableRootModel model2) {
        Pair<String, VirtualFile> androidProjectTypeProperty;
        Pair<String, VirtualFile> androidLibraryProperty;
        Pair<String, VirtualFile> dexDisableMergerProperty;
        Pair<String, VirtualFile> manifestMergerProperty;
        Module module2 = facet2.getModule();
        AndroidSdkUtils.setupAndroidPlatformIfNecessary(module2, true);
        if (model2 != null && !model2.isDisposed() && model2.isWritable()) {
            model2.setSdk(ModuleRootManager.getInstance((Module)module2).getSdk());
        }
        if ((manifestMergerProperty = AndroidRootUtil.getProjectPropertyValue(module2, "manifestmerger.enabled")) != null) {
            facet2.getProperties().ENABLE_MANIFEST_MERGING = AndroidFrameworkDetector.getFirstAsBoolean(manifestMergerProperty);
        }
        if ((dexDisableMergerProperty = AndroidRootUtil.getProjectPropertyValue(module2, "dex.disable.merger")) != null) {
            boolean bl = facet2.getProperties().ENABLE_PRE_DEXING = !AndroidFrameworkDetector.getFirstAsBoolean(dexDisableMergerProperty);
        }
        if ((androidLibraryProperty = AndroidRootUtil.getProjectPropertyValue(module2, "android.library")) != null && AndroidFrameworkDetector.getFirstAsBoolean(androidLibraryProperty)) {
            ((AndroidFacetConfiguration)facet2.getConfiguration()).setProjectType(1);
        }
        if ((androidProjectTypeProperty = AndroidRootUtil.getProjectPropertyValue(module2, "project.type")) != null) {
            ((AndroidFacetConfiguration)facet2.getConfiguration()).setProjectType(Integer.parseInt((String)androidProjectTypeProperty.getFirst()));
        }
        if (((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()) {
            Manifest manifest;
            Pair<String, VirtualFile> dexForceJumboProperty = AndroidRootUtil.getProjectPropertyValue(module2, "dex.force.jumbo");
            if (dexForceJumboProperty != null) {
                AndroidFrameworkDetector.showDexOptionNotification(module2, "dex.force.jumbo");
            }
            if ((manifest = Manifest.getMainManifest(facet2)) != null && DefaultActivityLocator.getDefaultLauncherActivityName(module2.getProject(), manifest) != null) {
                AndroidRunConfigurations.getInstance().addRunConfiguration(facet2, null);
            }
        }
    }

    private static boolean getFirstAsBoolean(@NotNull Pair<String, VirtualFile> pair) {
        return Boolean.parseBoolean((String)pair.getFirst());
    }

    @NotNull
    public static Notification showDexOptionNotification(@NotNull Module module2, @NotNull String propertyName) {
        final Project project = module2.getProject();
        Notification notification = ANDROID_MODULE_IMPORTING_NOTIFICATION.createNotification(AndroidBundle.message("android.facet.importing.title", module2.getName()), "'" + propertyName + "' property is detected in " + "project.properties" + " file.<br>You may enable related option in <a href='configure'>Settings | Compiler | Android DX</a>", NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                notification.expire();
                ShowSettingsUtil.getInstance().showSettingsDialog(project, AndroidBundle.message("android.dex.compiler.configurable.display.name", new Object[0]));
            }
        });
        notification.notify(project);
        return notification;
    }

    @NotNull
    public FacetType<AndroidFacet, AndroidFacetConfiguration> getFacetType() {
        return AndroidFacet.getFacetType();
    }

    @NotNull
    public FileType getFileType() {
        return XmlFileType.INSTANCE;
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        return FileContentPattern.fileContent().withName("AndroidManifest.xml");
    }
}

