/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.wrappers;

import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileResourceElementWrapper
implements PsiFile,
ResourceElementWrapper,
PsiElementNavigationItem {
    @NotNull
    private final PsiFile myWrappedElement;
    @Nullable
    private final PsiDirectory myResourceDir;

    public FileResourceElementWrapper(@NotNull PsiFile wrappeeElement) {
        this.myWrappedElement = wrappeeElement;
        this.myResourceDir = this.getContainingFile().getContainingDirectory();
    }

    @Override
    @NotNull
    public PsiElement getWrappedElement() {
        return this.myWrappedElement;
    }

    @NotNull
    public Project getProject() throws PsiInvalidElementAccessException {
        return this.myWrappedElement.getProject();
    }

    @NotNull
    public Language getLanguage() {
        return this.myWrappedElement.getLanguage();
    }

    public PsiManager getManager() {
        return this.myWrappedElement.getManager();
    }

    @NotNull
    public PsiElement[] getChildren() {
        return this.myWrappedElement.getChildren();
    }

    public VirtualFile getVirtualFile() {
        return this.myWrappedElement.getVirtualFile();
    }

    public PsiDirectory getContainingDirectory() {
        return this.myWrappedElement.getContainingDirectory();
    }

    public boolean isDirectory() {
        return this.myWrappedElement.isDirectory();
    }

    public PsiDirectory getParent() {
        return this.myWrappedElement.getParent();
    }

    public long getModificationStamp() {
        return this.myWrappedElement.getModificationStamp();
    }

    @NotNull
    public PsiFile getOriginalFile() {
        return this.myWrappedElement.getOriginalFile();
    }

    @NotNull
    public FileType getFileType() {
        return this.myWrappedElement.getFileType();
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        return this.myWrappedElement.getPsiRoots();
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        return this.myWrappedElement.getViewProvider();
    }

    @Nullable
    public PsiElement getFirstChild() {
        return this.myWrappedElement.getFirstChild();
    }

    @Nullable
    public PsiElement getLastChild() {
        return this.myWrappedElement.getLastChild();
    }

    @Nullable
    public PsiElement getNextSibling() {
        return this.myWrappedElement.getNextSibling();
    }

    @Nullable
    public PsiElement getPrevSibling() {
        return this.myWrappedElement.getPrevSibling();
    }

    public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
        return this.myWrappedElement.getContainingFile();
    }

    public TextRange getTextRange() {
        return this.myWrappedElement.getTextRange();
    }

    public int getStartOffsetInParent() {
        return this.myWrappedElement.getStartOffsetInParent();
    }

    public int getTextLength() {
        return this.myWrappedElement.getTextLength();
    }

    @Nullable
    public PsiElement findElementAt(int offset2) {
        return this.myWrappedElement.findElementAt(offset2);
    }

    @Nullable
    public PsiReference findReferenceAt(int offset2) {
        return this.myWrappedElement.findReferenceAt(offset2);
    }

    public int getTextOffset() {
        return this.myWrappedElement.getTextOffset();
    }

    @NonNls
    public String getText() {
        return this.myWrappedElement.getText();
    }

    @NotNull
    public char[] textToCharArray() {
        return this.myWrappedElement.textToCharArray();
    }

    public PsiElement getNavigationElement() {
        return this.myWrappedElement.getNavigationElement();
    }

    public PsiElement getOriginalElement() {
        return this.myWrappedElement.getOriginalElement();
    }

    public boolean textMatches(@NotNull @NonNls CharSequence text2) {
        return this.myWrappedElement.textMatches(text2);
    }

    public boolean textMatches(@NotNull PsiElement element2) {
        return this.myWrappedElement.textMatches(element2);
    }

    public boolean textContains(char c) {
        return this.myWrappedElement.textContains(c);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        this.myWrappedElement.accept(visitor2);
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
        this.myWrappedElement.acceptChildren(visitor2);
    }

    public PsiElement copy() {
        return this.myWrappedElement.copy();
    }

    public PsiElement add(@NotNull PsiElement element2) throws IncorrectOperationException {
        return this.myWrappedElement.add(element2);
    }

    public PsiElement addBefore(@NotNull PsiElement element2, PsiElement anchor) throws IncorrectOperationException {
        return this.myWrappedElement.addBefore(element2, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element2, PsiElement anchor) throws IncorrectOperationException {
        return this.myWrappedElement.addAfter(element2, anchor);
    }

    public void checkAdd(@NotNull PsiElement element2) throws IncorrectOperationException {
        this.myWrappedElement.checkAdd(element2);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return this.myWrappedElement.addRange(first, last);
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return this.myWrappedElement.addRangeBefore(first, last, anchor);
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return this.myWrappedElement.addRangeAfter(first, last, anchor);
    }

    public void delete() throws IncorrectOperationException {
        this.myWrappedElement.delete();
    }

    public void checkDelete() throws IncorrectOperationException {
        this.myWrappedElement.checkDelete();
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        this.myWrappedElement.deleteChildRange(first, last);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        return this.myWrappedElement.replace(newElement);
    }

    public boolean isValid() {
        return this.myWrappedElement.isValid();
    }

    public boolean isWritable() {
        return this.myWrappedElement.isWritable();
    }

    @Nullable
    public PsiReference getReference() {
        return this.myWrappedElement.getReference();
    }

    @NotNull
    public PsiReference[] getReferences() {
        return this.myWrappedElement.getReferences();
    }

    @Nullable
    public <T> T getCopyableUserData(Key<T> key) {
        return (T)this.myWrappedElement.getCopyableUserData(key);
    }

    public <T> void putCopyableUserData(Key<T> key, T value2) {
        this.myWrappedElement.putCopyableUserData(key, value2);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        return this.myWrappedElement.processDeclarations(processor, state, lastParent, place);
    }

    @Nullable
    public PsiElement getContext() {
        return this.myWrappedElement.getContext();
    }

    public boolean isPhysical() {
        return false;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return this.myWrappedElement.getResolveScope();
    }

    @NotNull
    public SearchScope getUseScope() {
        return this.myWrappedElement.getUseScope();
    }

    @Nullable
    public FileASTNode getNode() {
        return this.myWrappedElement.getNode();
    }

    public void subtreeChanged() {
        this.myWrappedElement.subtreeChanged();
    }

    @NonNls
    public String toString() {
        return this.myWrappedElement.toString();
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof FileResourceElementWrapper) {
            another = ((FileResourceElementWrapper)another).getWrappedElement();
        }
        return this.myWrappedElement == another || this.myWrappedElement.isEquivalentTo(another);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myWrappedElement.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        this.myWrappedElement.putUserData(key, value2);
    }

    public Icon getIcon(int flags) {
        return this.myWrappedElement.getIcon(flags);
    }

    @NotNull
    public String getName() {
        return this.myWrappedElement.getName();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        return this.myWrappedElement.setName(name);
    }

    public boolean processChildren(@NotNull PsiElementProcessor<PsiFileSystemItem> processor) {
        return this.myWrappedElement.processChildren(processor);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                String name = FileResourceElementWrapper.this.myWrappedElement.getName();
                if (FileResourceElementWrapper.this.myResourceDir == null) {
                    return name;
                }
                return name + " (" + FileResourceElementWrapper.this.myResourceDir.getName() + ')';
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }

    public void navigate(boolean requestFocus) {
        this.myWrappedElement.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myWrappedElement.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myWrappedElement.canNavigateToSource();
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        this.myWrappedElement.checkSetName(name);
    }

    public PsiElement getTargetElement() {
        return this.myWrappedElement;
    }
}

