/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.manifest;

import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.xml.DomFileDescription;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestDomFileDescription
extends DomFileDescription<Manifest> {
    public ManifestDomFileDescription() {
        super(Manifest.class, "manifest", new String[0]);
    }

    public boolean isMyFile(@NotNull XmlFile file2, @Nullable Module module2) {
        return module2 == null ? ManifestDomFileDescription.isManifestFile(file2) : ManifestDomFileDescription.isManifestFile(file2, module2);
    }

    public static boolean isManifestFile(@NotNull XmlFile file2) {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
        return ManifestDomFileDescription.isManifestFile(file2, module2);
    }

    public static boolean isManifestFile(@NotNull XmlFile file2, @Nullable Module module2) {
        AndroidFacet facet2;
        if (module2 != null && !module2.isDisposed() && (facet2 = AndroidFacet.getInstance((Module)module2)) != null) {
            return ManifestDomFileDescription.isManifestFile(file2, facet2);
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (virtualFile.getFileSystem() instanceof ApkFileSystem || virtualFile instanceof LightVirtualFileBase) {
            return false;
        }
        return file2.getName().equals("AndroidManifest.xml");
    }

    public static boolean isManifestFile(@NotNull XmlFile file2, @NotNull AndroidFacet facet2) {
        return file2.getName().equals("AndroidManifest.xml") || AndroidModel.isRequired(facet2) && file2.getVirtualFile() != null && SourceProvidersKt.isManifestFile(facet2, file2.getVirtualFile());
    }

    protected void initializeFileDescription() {
        this.registerNamespacePolicy("android", new String[]{"http://schemas.android.com/apk/res/android"});
    }
}

