/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceNamespaceContext;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.AdditionalConverter;
import org.jetbrains.android.dom.AndroidResourceType;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.converters.AndroidResourceReference;
import org.jetbrains.android.dom.converters.AttributeValueDocumentationProvider;
import org.jetbrains.android.dom.converters.ResourceNamespaceReference;
import org.jetbrains.android.dom.drawable.DrawableStateListItem;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.CreateFileResourceQuickFix;
import org.jetbrains.android.inspections.CreateValueResourceQuickFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceReferenceConverter
extends ResolvingConverter<ResourceValue>
implements CustomReferenceConverter<ResourceValue>,
AttributeValueDocumentationProvider {
    private static final Pattern NAMESPACE_COLON = Pattern.compile("^((?:\\w|\\.)+):.*");
    private static final Pattern PREFIX_NAMESPACE_COLON = Pattern.compile("^@((?:\\w|\\.)+):.*");
    private static final ImmutableSet<String> TOP_PRIORITY_VALUES = ImmutableSet.of((Object)"match_parent", (Object)"wrap_content");
    private final Set<ResourceType> myResourceTypes;
    private ResolvingConverter<String> myAdditionalConverter;
    private boolean myAdditionalConverterSoft = false;
    private boolean myWithPrefix = true;
    private boolean myWithExplicitResourceType = true;
    private boolean myQuiet = false;
    private boolean myIncludeDynamicFeatures = false;
    private boolean myAllowAttributeReferences = true;
    private boolean myExpandedCompletionSuggestion = true;
    private boolean myAllowLiterals = true;
    @Nullable
    private AttributeDefinition myAttributeDefinition = null;

    public ResourceReferenceConverter() {
        this(EnumSet.noneOf(ResourceType.class));
    }

    public ResourceReferenceConverter(@NotNull Collection<ResourceType> resourceTypes) {
        this.myResourceTypes = EnumSet.copyOf(resourceTypes);
    }

    public ResourceReferenceConverter(@NotNull Collection<ResourceType> resourceTypes, @Nullable AttributeDefinition attributeDefinition) {
        this.myResourceTypes = EnumSet.copyOf(resourceTypes);
        this.myAttributeDefinition = attributeDefinition;
    }

    public void setAllowLiterals(boolean allowLiterals) {
        this.myAllowLiterals = allowLiterals;
    }

    public ResourceReferenceConverter(@NotNull ResourceType resourceType, boolean withPrefix, boolean withExplicitResourceType) {
        this.myResourceTypes = EnumSet.of(resourceType);
        this.myWithPrefix = withPrefix;
        this.myWithExplicitResourceType = withExplicitResourceType;
    }

    public void setAdditionalConverter(@Nullable ResolvingConverter<String> additionalConverter, boolean soft) {
        this.myAdditionalConverter = additionalConverter;
        this.myAdditionalConverterSoft = soft;
    }

    public void setQuiet(boolean quiet) {
        this.myQuiet = quiet;
    }

    public void setIncludeDynamicFeatures(boolean includeDynamicFeatures) {
        this.myIncludeDynamicFeatures = includeDynamicFeatures;
    }

    public boolean getIncludeDynamicFeatures() {
        return this.myIncludeDynamicFeatures;
    }

    public void setExpandedCompletionSuggestion(boolean expandedCompletionSuggestion) {
        this.myExpandedCompletionSuggestion = expandedCompletionSuggestion;
    }

    public void setAllowAttributeReferences(boolean allowAttributeReferences) {
        this.myAllowAttributeReferences = allowAttributeReferences;
    }

    @Nullable
    static String getValue(XmlElement element2) {
        if (element2 instanceof XmlAttribute) {
            return ((XmlAttribute)element2).getValue();
        }
        if (element2 instanceof XmlTag) {
            return ((XmlTag)element2).getValue().getText();
        }
        return null;
    }

    @NotNull
    public Collection<? extends ResourceValue> getVariants(ConvertContext context) {
        ResolvingConverter<String> additionalConverter;
        XmlElement element2;
        Module module2 = context.getModule();
        if (module2 == null || module2.isDisposed()) {
            return Collections.emptySet();
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return Collections.emptySet();
        }
        HashSet<ResourceValue> result2 = new HashSet<ResourceValue>();
        Set<ResourceType> recommendedTypes = this.getResourceTypes(context);
        if (recommendedTypes.contains(ResourceType.BOOL) && recommendedTypes.size() < IdeResourcesUtil.VALUE_RESOURCE_TYPES.size()) {
            result2.add(ResourceValue.literal("true"));
            result2.add(ResourceValue.literal("false"));
        }
        if (recommendedTypes.contains(ResourceType.ID) && recommendedTypes.size() == 1) {
            result2.add(ResourceValue.reference("@+id/"));
        }
        if ((element2 = context.getXmlElement()) == null) {
            return result2;
        }
        String value2 = ResourceReferenceConverter.getValue(element2);
        assert (value2 != null);
        boolean startsWithRefChar = StringUtil.startsWithChar((CharSequence)value2, (char)'@');
        if (!this.myQuiet || startsWithRefChar) {
            char prefix;
            ResourceNamespace namespace = null;
            String namespacePrefix = null;
            Matcher matcher = (this.myWithPrefix ? PREFIX_NAMESPACE_COLON : NAMESPACE_COLON).matcher(value2);
            if (matcher.matches()) {
                ResourceNamespaceContext namespacesContext = IdeResourcesUtil.getNamespacesContext(element2);
                namespacePrefix = matcher.group(1);
                namespace = namespacesContext != null ? ResourceNamespace.fromNamespacePrefix((String)namespacePrefix, (ResourceNamespace)namespacesContext.getCurrentNs(), (ResourceNamespace.Resolver)namespacesContext.getResolver()) : ResourceNamespace.fromPackageName((String)namespacePrefix);
            } else if (((Boolean)StudioFlags.COLLAPSE_ANDROID_NAMESPACE.get()).booleanValue()) {
                ResourceNamespace.Resolver resolver = IdeResourcesUtil.getNamespaceResolver(element2);
                String frameworkPrefix = (String)MoreObjects.firstNonNull((Object)resolver.uriToPrefix(ResourceNamespace.ANDROID.getXmlNamespaceUri()), (Object)ResourceNamespace.ANDROID.getPackageName());
                result2.add(ResourceValue.literal(this.myWithPrefix || startsWithRefChar ? '@' + frameworkPrefix + ':' : frameworkPrefix + ':'));
            }
            char c = prefix = this.myWithPrefix || startsWithRefChar ? (char)'@' : '\u0000';
            if (value2.startsWith("@+id/")) {
                this.addVariantsForIdDeclaration(context, facet2, prefix, value2, result2);
            }
            if (this.myExpandedCompletionSuggestion) {
                boolean explicitResourceType = startsWithRefChar || this.myWithExplicitResourceType;
                for (ResourceType type : recommendedTypes) {
                    if (!type.getCanBeReferenced() && type != ResourceType.SAMPLE_DATA) continue;
                    ResourceReferenceConverter.addResourceReferenceValues(facet2, element2, prefix, type, namespace, result2, explicitResourceType, this.myIncludeDynamicFeatures);
                }
            } else {
                Set<ResourceType> filteringSet = namespace == ResourceNamespace.ANDROID ? EnumSet.allOf(ResourceType.class) : ResourceReferenceConverter.getResourceTypesInCurrentModule(facet2);
                for (ResourceType resourceType : ResourceType.values()) {
                    if (!resourceType.getCanBeReferenced()) continue;
                    String typePrefix = this.getTypePrefix(namespacePrefix, resourceType);
                    if (value2.startsWith(typePrefix)) {
                        ResourceReferenceConverter.addResourceReferenceValues(facet2, element2, prefix, resourceType, namespace, result2, true, this.myIncludeDynamicFeatures);
                        continue;
                    }
                    if (!recommendedTypes.contains(resourceType) || !filteringSet.contains(resourceType)) continue;
                    result2.add(ResourceValue.literal(typePrefix));
                }
            }
        }
        if (this.myAllowAttributeReferences) {
            ResourceReferenceConverter.completeAttributeReferences(value2, facet2, result2);
        }
        if ((additionalConverter = this.getAdditionalConverter(context)) != null) {
            for (String variant2 : additionalConverter.getVariants(context)) {
                result2.add(ResourceValue.literal(variant2));
            }
        }
        return result2;
    }

    private void addVariantsForIdDeclaration(@NotNull ConvertContext context, @NotNull AndroidFacet facet2, final char prefix, final @NotNull String value2, final @NotNull Set<ResourceValue> result2) {
        final ResourceNamespace namespace = ResourceNamespace.TODO();
        XmlFile file2 = context.getFile();
        file2.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                String valueText = attributeValue.getValue();
                if (valueText != null && valueText.startsWith("@id/") && valueText.length() > "@id/".length()) {
                    String name = valueText.substring("@id/".length());
                    ResourceValue ref = ResourceReferenceConverter.referenceTo(prefix, "+id", namespace.getPackageName(), name, true);
                    if (!value2.startsWith(ResourceReferenceConverter.this.doToString(ref))) {
                        result2.add(ref);
                    }
                }
            }
        });
        Set ids2 = ResourceRepositoryManager.getAppResources(facet2).getResources(namespace, ResourceType.ID).keySet();
        for (String name : ids2) {
            ResourceValue ref = ResourceReferenceConverter.referenceTo(prefix, "+id", namespace.getPackageName(), name, true);
            if (value2.startsWith(this.doToString(ref))) continue;
            result2.add(ref);
        }
    }

    private static void completeAttributeReferences(String value2, AndroidFacet facet2, Set<ResourceValue> result2) {
        if (StringUtil.startsWith((CharSequence)value2, (CharSequence)"?attr/")) {
            ResourceReferenceConverter.addResourceReferenceValues(facet2, null, '?', ResourceType.ATTR, null, result2, true, false);
        } else if (StringUtil.startsWith((CharSequence)value2, (CharSequence)"?android:attr/")) {
            ResourceReferenceConverter.addResourceReferenceValues(facet2, null, '?', ResourceType.ATTR, ResourceNamespace.ANDROID, result2, true, false);
        } else if (StringUtil.startsWithChar((CharSequence)value2, (char)'?')) {
            ResourceReferenceConverter.addResourceReferenceValues(facet2, null, '?', ResourceType.ATTR, null, result2, false, false);
            ResourceReferenceConverter.addResourceReferenceValues(facet2, null, '?', ResourceType.ATTR, ResourceNamespace.ANDROID, result2, false, false);
            result2.add(ResourceValue.literal("?attr/"));
            result2.add(ResourceValue.literal("?android:attr/"));
        }
    }

    public boolean isReferenceTo(@NotNull PsiElement element2, String stringValue, @Nullable ResourceValue resolveResult, ConvertContext context) {
        if (((Boolean)StudioFlags.RESOLVE_USING_REPOS.get()).booleanValue() && element2 instanceof ResourceReferencePsiElement) {
            ResourceReference reference2 = ((ResourceReferencePsiElement)element2).getResourceReference();
            XmlElement xmlElement = context.getXmlElement();
            if (xmlElement != null && resolveResult != null) {
                ResourceNamespace resolvedNamespace = IdeResourcesUtil.resolveResourceNamespace(xmlElement, resolveResult.getPackage());
                return reference2.getNamespace().equals((Object)resolvedNamespace) && reference2.getResourceType().equals((Object)resolveResult.getType()) && reference2.getName().equals(resolveResult.getResourceName());
            }
        }
        return super.isReferenceTo(element2, stringValue, (Object)resolveResult, context);
    }

    @NotNull
    public static Set<ResourceType> getResourceTypesInCurrentModule(@NotNull AndroidFacet facet2) {
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(facet2);
        LocalResourceRepository repository = repositoryManager.getAppResources();
        return repository.getResourceTypes(repositoryManager.getNamespace());
    }

    @NotNull
    private String getTypePrefix(@Nullable String namespacePrefix, @NotNull ResourceType type) {
        StringBuilder sb = new StringBuilder();
        if (this.myWithPrefix) {
            sb.append('@');
        }
        if (namespacePrefix != null) {
            sb.append(namespacePrefix).append(':');
        }
        sb.append(type.getName()).append('/');
        return sb.toString();
    }

    @NotNull
    private Set<ResourceType> getResourceTypes(ConvertContext context) {
        return this.getResourceTypes(context.getInvocationElement());
    }

    @NotNull
    public Set<ResourceType> getResourceTypes(@NotNull DomElement element2) {
        String s;
        ResourceType t;
        AndroidResourceType resourceType = (AndroidResourceType)element2.getAnnotation(AndroidResourceType.class);
        EnumSet<ResourceType> types2 = EnumSet.copyOf(this.myResourceTypes);
        if (resourceType != null && (t = ResourceType.fromClassName((String)(s = resourceType.value()))) != null) {
            types2.add(t);
        }
        if (types2.isEmpty()) {
            return IdeResourcesUtil.VALUE_RESOURCE_TYPES;
        }
        if (types2.contains(ResourceType.DRAWABLE)) {
            types2.add(ResourceType.COLOR);
            if (element2.getParent() instanceof DrawableStateListItem) {
                types2.add(ResourceType.MIPMAP);
            }
        }
        if ("http://schemas.android.com/tools".equals(element2.getXmlElementNamespace())) {
            types2.add(ResourceType.SAMPLE_DATA);
        }
        return types2;
    }

    private static void addResourceReferenceValues(AndroidFacet facet2, @Nullable XmlElement element2, char prefix, ResourceType type, @Nullable ResourceNamespace onlyNamespace, Collection<ResourceValue> result2, boolean explicitResourceType, boolean includeDynamicFeatures) {
        PsiFile file2;
        PsiFile psiFile2 = file2 = element2 != null ? element2.getContainingFile() : null;
        if (type == ResourceType.ID && onlyNamespace != ResourceNamespace.ANDROID && file2 != null && ResourceReferenceConverter.isNonValuesResourceFile(file2)) {
            for (String id : IdeResourcesUtil.findIdsInFile(file2)) {
                result2.add(ResourceReferenceConverter.referenceTo(prefix, type.getName(), null, id, explicitResourceType));
            }
        } else {
            ResourceRepository frameworkResources;
            ResourceRepositoryManager repoManager = ResourceRepositoryManager.getInstance(facet2);
            LocalResourceRepository appResources = repoManager.getAppResources();
            ResourceVisibilityLookup visibilityLookup = repoManager.getResourceVisibility();
            if ((onlyNamespace == ResourceNamespace.ANDROID || onlyNamespace == null && !((Boolean)StudioFlags.COLLAPSE_ANDROID_NAMESPACE.get()).booleanValue()) && (frameworkResources = repoManager.getFrameworkResources((Set<String>)ImmutableSet.of())) != null) {
                ResourceReferenceConverter.addResourceReferenceValuesFromRepo(frameworkResources, repoManager, visibilityLookup, element2, prefix, type, ResourceNamespace.ANDROID, result2, explicitResourceType);
            }
            if (onlyNamespace == null) {
                for (ResourceNamespace namespace : appResources.getNamespaces()) {
                    ResourceReferenceConverter.addResourceReferenceValuesFromRepo((ResourceRepository)appResources, repoManager, visibilityLookup, element2, prefix, type, namespace, result2, explicitResourceType);
                }
            } else {
                ResourceReferenceConverter.addResourceReferenceValuesFromRepo((ResourceRepository)appResources, repoManager, visibilityLookup, element2, prefix, type, onlyNamespace, result2, explicitResourceType);
            }
            if (includeDynamicFeatures) {
                ResourceReferenceConverter.addResourceReferenceValuesFromDynamicFeatures(element2, prefix, type, onlyNamespace, result2);
            }
        }
    }

    private static void addResourceReferenceValuesFromDynamicFeatures(@Nullable XmlElement element2, char prefix, @Nullable ResourceType type, @Nullable ResourceNamespace onlyNamespace, @NotNull Collection<ResourceValue> result2) {
        ResourceNamespace namespace;
        ResourceNamespace resourceNamespace = namespace = onlyNamespace != null ? onlyNamespace : ResourceNamespace.RES_AUTO;
        if (element2 == null || type == null) {
            return;
        }
        AndroidModuleSystem androidModuleSystem2 = ProjectSystemUtil.getModuleSystem((PsiElement)element2);
        if (androidModuleSystem2 == null) {
            return;
        }
        ResourceNamespace.Resolver resolver = (ResourceNamespace.Resolver)MoreObjects.firstNonNull((Object)IdeResourcesUtil.getNamespaceResolver(element2), (Object)ResourceNamespace.Resolver.EMPTY_RESOLVER);
        String namespacePrefix = resolver.uriToPrefix(namespace.getXmlNamespaceUri());
        List<Module> modules = androidModuleSystem2.getDynamicFeatureModules();
        for (Module module2 : modules) {
            LocalResourceRepository moduleResources = ResourceRepositoryManager.getModuleResources(module2);
            if (moduleResources == null) continue;
            Set<String> resourceNames = moduleResources.getResourceNames(namespace, type);
            for (String name : resourceNames) {
                result2.add(ResourceReferenceConverter.referenceTo(prefix, type.getName(), namespacePrefix, name, true));
            }
        }
    }

    private static void addResourceReferenceValuesFromRepo(ResourceRepository repo, ResourceRepositoryManager repoManager, ResourceVisibilityLookup visibilityLookup, @Nullable XmlElement element2, char prefix, ResourceType type, @NotNull ResourceNamespace onlyNamespace, Collection<ResourceValue> result2, boolean explicitResourceType) {
        Collection<String> names = IdeResourcesUtil.getResourceItems(repo, onlyNamespace, type, visibilityLookup, ResourceVisibility.PUBLIC);
        ResourceNamespace.Resolver resolver = ResourceNamespace.Resolver.EMPTY_RESOLVER;
        if (element2 != null) {
            resolver = (ResourceNamespace.Resolver)MoreObjects.firstNonNull((Object)IdeResourcesUtil.getNamespaceResolver(element2), (Object)resolver);
        }
        String namespacePrefix = new ResourceReference((ResourceNamespace)onlyNamespace, (ResourceType)ResourceType.STRING, (String)"dummy").getRelativeResourceUrl((ResourceNamespace)repoManager.getNamespace(), (ResourceNamespace.Resolver)resolver).namespace;
        for (String name : names) {
            result2.add(ResourceReferenceConverter.referenceTo(prefix, type.getName(), namespacePrefix, name, explicitResourceType));
        }
    }

    private static boolean isNonValuesResourceFile(@NotNull PsiFile file2) {
        ResourceFolderType resourceType = IdeResourcesUtil.getFolderType(file2.getOriginalFile());
        return resourceType != null && resourceType != ResourceFolderType.VALUES;
    }

    private static ResourceValue referenceTo(char prefix, String type, String resPackage, String name, boolean explicitResourceType) {
        return ResourceValue.referenceTo(prefix, resPackage, explicitResourceType ? type : null, name);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        if (s == null || s.isEmpty()) {
            return "Missing value";
        }
        ResourceValue parsed = ResourceValue.parse(s, true, this.myWithPrefix, false);
        if (parsed == null || !parsed.isReference()) {
            ResolvingConverter<String> additionalConverter = this.getAdditionalConverter(context);
            if (this.myResourceTypes.contains(ResourceType.STRING)) {
                return null;
            }
            if (additionalConverter != null) {
                return additionalConverter.getErrorMessage(s, context);
            }
        } else {
            String errorMessage = parsed.getErrorMessage();
            if (errorMessage != null) {
                return errorMessage;
            }
        }
        return super.getErrorMessage(s, context);
    }

    @Nullable
    public LookupElement createLookupElement(ResourceValue resourceValue2) {
        String value2 = resourceValue2.toString();
        boolean deprecated = false;
        if (this.myAttributeDefinition != null) {
            deprecated = this.myAttributeDefinition.isValueDeprecated(value2);
        }
        LookupElementBuilder builder2 = LookupElementBuilder.create((String)value2);
        builder2 = builder2.withCaseSensitivity(true).withStrikeoutness(deprecated);
        String resourceName = resourceValue2.getResourceName();
        if (resourceName != null) {
            builder2 = builder2.withLookupString(resourceName);
        } else if (this.isNamespaceLiteral(resourceValue2.getValue())) {
            builder2 = builder2.withInsertHandler((context, item) -> context.setLaterRunnable(() -> new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(context.getProject(), context.getEditor())));
        }
        int priority = deprecated ? 0 : (TOP_PRIORITY_VALUES.contains((Object)value2) ? 2 : 1);
        return PrioritizedLookupElement.withPriority((LookupElement)builder2, (double)priority);
    }

    public boolean isNamespaceLiteral(@Nullable String value2) {
        return value2 != null && value2.charAt(value2.length() - 1) == ':' && value2.indexOf(47) == -1;
    }

    public ResourceValue fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        if (DataBindingUtil.isBindingExpression(s)) {
            return ResourceValue.INVALID;
        }
        ResourceValue parsed = ResourceValue.parse(s, true, this.myWithPrefix, true);
        ResolvingConverter<String> additionalConverter = this.getAdditionalConverter(context);
        if (parsed == null || !parsed.isReference()) {
            if (additionalConverter != null) {
                String value2 = (String)additionalConverter.fromString(s, context);
                if (value2 != null) {
                    return ResourceValue.literal(value2);
                }
                if (!this.myAdditionalConverterSoft) {
                    return null;
                }
            } else if (!this.myAllowLiterals) {
                return null;
            }
        }
        if (parsed != null) {
            String resType = parsed.getResourceType();
            if (parsed.getPrefix() == '?') {
                if (!this.myAllowAttributeReferences) {
                    return null;
                }
                if (resType == null) {
                    parsed.setResourceType(ResourceType.ATTR.getName());
                } else if (!ResourceType.ATTR.getName().equals(resType)) {
                    return null;
                }
            } else if (resType == null) {
                if (parsed.isReference()) {
                    if (this.myWithExplicitResourceType && !"@null".equals(s)) {
                        return null;
                    }
                    if (this.myResourceTypes.size() == 1) {
                        parsed.setResourceType(this.myResourceTypes.iterator().next().getName());
                    }
                } else {
                    Set<ResourceType> types2 = this.getResourceTypes(context);
                    if (types2.size() == 1 && types2.contains(ResourceType.BOOL) && !"true".equals(s) && !"false".equals(s)) {
                        return null;
                    }
                }
            }
        }
        return parsed;
    }

    @Nullable
    private ResolvingConverter<String> getAdditionalConverter(ConvertContext context) {
        if (this.myAdditionalConverter != null) {
            return this.myAdditionalConverter;
        }
        AdditionalConverter additionalConverterAnnotation = (AdditionalConverter)context.getInvocationElement().getAnnotation(AdditionalConverter.class);
        if (additionalConverterAnnotation != null) {
            Class<? extends ResolvingConverter> converterClass = additionalConverterAnnotation.value();
            ConverterManager converterManager = (ConverterManager)ServiceManager.getService(ConverterManager.class);
            return (ResolvingConverter)converterManager.getConverterInstance(converterClass);
        }
        return null;
    }

    public String toString(@Nullable ResourceValue element2, ConvertContext context) {
        return this.doToString(element2);
    }

    private String doToString(ResourceValue element2) {
        if (element2 == null) {
            return null;
        }
        if (this.myWithExplicitResourceType || !element2.isReference()) {
            return element2.toString();
        }
        return ResourceValue.referenceTo(element2.getPrefix(), element2.getPackage(), null, element2.getResourceName()).toString();
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        ResourceValue resourceValue2;
        String value2;
        DomElement domElement;
        AndroidFacet facet2 = AndroidFacet.getInstance((ConvertContext)context);
        if (facet2 != null && (domElement = context.getInvocationElement()) instanceof GenericDomValue && (value2 = ((GenericDomValue)domElement).getStringValue()) != null && (resourceValue2 = ResourceValue.parse(value2, false, this.myWithPrefix, true)) != null) {
            String aPackage = resourceValue2.getPackage();
            ResourceType resType = resourceValue2.getType();
            if (resType == null && this.myResourceTypes.size() == 1) {
                resType = this.myResourceTypes.iterator().next();
            }
            String resourceName = resourceValue2.getResourceName();
            if (aPackage == null && resType != null && resourceName != null && IdeResourcesUtil.isCorrectAndroidResourceName(resourceName)) {
                ArrayList<Object> fixes = new ArrayList<Object>();
                ResourceFolderType folderType = FolderTypeRelationship.getNonValuesRelatedFolder((ResourceType)resType);
                if (folderType != null) {
                    fixes.add(new CreateFileResourceQuickFix(facet2, folderType, resourceName, (PsiFile)context.getFile(), false));
                }
                if (IdeResourcesUtil.VALUE_RESOURCE_TYPES.contains(resType) && resType != ResourceType.LAYOUT) {
                    fixes.add(new CreateValueResourceQuickFix(facet2, resType, resourceName, (PsiFile)context.getFile(), false));
                }
                return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
            }
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<ResourceValue> value2, PsiElement element2, ConvertContext context) {
        XmlAttribute attribute;
        if ("@null".equals(value2.getStringValue())) {
            return PsiReference.EMPTY_ARRAY;
        }
        Module module2 = context.getModule();
        if (module2 == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ResourceValue resValue = (ResourceValue)value2.getValue();
        if (resValue == null || !resValue.isReference()) {
            return PsiReference.EMPTY_ARRAY;
        }
        String resType = resValue.getResourceType();
        if (resType == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (!((Boolean)StudioFlags.RESOLVE_USING_REPOS.get()).booleanValue() && resValue.getPackage() == null && "+id".equals(resType) && element2 != null && element2.getParent() instanceof XmlAttribute && "id".equals((attribute = (XmlAttribute)element2.getParent()).getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
            return PsiReference.EMPTY_ARRAY;
        }
        AndroidResourceReference resourceReference = new AndroidResourceReference(value2, facet2, resValue, this.myIncludeDynamicFeatures);
        if (!StringUtil.isEmpty((String)resValue.getPackage())) {
            ResourceNamespaceReference namespaceReference = new ResourceNamespaceReference(value2, resValue);
            return new PsiReference[]{namespaceReference, resourceReference};
        }
        return new PsiReference[]{resourceReference};
    }

    @Override
    public String getDocumentation(@NotNull String value2) {
        String description2;
        if (this.myAttributeDefinition != null && (description2 = this.myAttributeDefinition.getValueDescription(value2)) != null) {
            return description2;
        }
        return this.myAdditionalConverter instanceof AttributeValueDocumentationProvider ? ((AttributeValueDocumentationProvider)this.myAdditionalConverter).getDocumentation(value2) : null;
    }
}

