/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.annotations.NotNull;

public final class StyleableDefinitionImpl
implements StyleableDefinition {
    @NotNull
    private final ResourceReference myStyleable;
    @NotNull
    private final List<AttributeDefinition> myAttributes = new ArrayList<AttributeDefinition>();

    public StyleableDefinitionImpl(@NotNull ResourceNamespace namespace, @NotNull String name) {
        this.myStyleable = ResourceReference.styleable((ResourceNamespace)namespace, (String)name);
    }

    @Override
    @NotNull
    public ResourceReference getResourceReference() {
        return this.myStyleable;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myStyleable.getName();
    }

    public void addAttribute(@NotNull AttributeDefinition attrDef) {
        this.myAttributes.add(attrDef);
    }

    @Override
    @NotNull
    public List<AttributeDefinition> getAttributes() {
        return Collections.unmodifiableList(this.myAttributes);
    }
}

