/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AndroidFinalPackageElementType
extends PackagingElementType<AndroidFinalPackageElement> {
    @NonNls
    public static final String TYPE_ID = "android-final-package";

    protected AndroidFinalPackageElementType() {
        super(TYPE_ID, "Android Final Package");
    }

    public static AndroidFinalPackageElementType getInstance() {
        return (AndroidFinalPackageElementType)AndroidFinalPackageElementType.getInstance(AndroidFinalPackageElementType.class);
    }

    public Icon getCreateElementIcon() {
        return AndroidIcons.Android;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        return !AndroidFinalPackageElementType.getAndroidApplicationFacets(context, context.getModulesProvider().getModules()).isEmpty() && !AndroidArtifactUtil.containsAndroidPackage(context, artifact);
    }

    @NotNull
    private static List<AndroidFacet> getAndroidApplicationFacets(@NotNull ArtifactEditorContext context, @NotNull Module[] modules) {
        ArrayList<AndroidFacet> result2 = new ArrayList<AndroidFacet>();
        for (Module module2 : modules) {
            for (AndroidFacet facet2 : context.getFacetsProvider().getFacetsByType(module2, AndroidFacet.ID)) {
                if (!((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()) continue;
                result2.add(facet2);
            }
        }
        return result2;
    }

    @NotNull
    public List<? extends PackagingElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        List<AndroidFacet> facets = AndroidFinalPackageElementType.getAndroidApplicationFacets(context, context.getModulesProvider().getModules());
        AndroidFacet facet2 = AndroidArtifactUtil.chooseAndroidApplicationModule(context.getProject(), facets);
        if (facet2 == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new AndroidFinalPackageElement(context.getProject(), facet2));
    }

    @NotNull
    public AndroidFinalPackageElement createEmpty(@NotNull Project project) {
        return new AndroidFinalPackageElement(project, null);
    }
}

