/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.server.BuildManager;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactProperties;
import org.jetbrains.android.compiler.artifact.AndroidArtifactPropertiesProvider;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPrecompileTask
implements CompileTask {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidPrecompileTask");

    public boolean execute(@NotNull CompileContext context) {
        Project project = context.getProject();
        if (!ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID)) {
            return true;
        }
        BuildManager.forceModelLoading((CompileContext)context);
        AndroidPrecompileTask.createGenModulesAndSourceRoots(project);
        return true;
    }

    private static boolean prepareForCompilation(CompileContext context) {
        Project project = context.getProject();
        if (!AndroidPrecompileTask.checkArtifacts(context)) {
            return false;
        }
        AndroidPrecompileTask.checkAndroidDependencies(context);
        ExcludesConfiguration configuration = CompilerConfiguration.getInstance((Project)project).getExcludedEntriesConfiguration();
        HashSet<ExcludeEntryDescription> addedEntries = new HashSet<ExcludeEntryDescription>();
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidPlatform platform;
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
            if (facet2 == null) continue;
            if (context.isRebuild()) {
                AndroidPrecompileTask.clearResCache(facet2, context);
            }
            int platformToolsRevision = (platform = AndroidPlatform.getInstance(facet2.getModule())) != null ? platform.getSdkData().getPlatformToolsRevision() : -1;
            LOG.debug("Platform-tools revision for module " + module2.getName() + " is " + platformToolsRevision);
            if (((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()) continue;
            if (platformToolsRevision >= 0 && platformToolsRevision <= 7) {
                LOG.debug("Excluded sources of module " + module2.getName());
                AndroidPrecompileTask.excludeAllSourceRoots(module2, configuration, addedEntries);
                continue;
            }
            AndroidPrecompileTask.unexcludeAllSourceRoots(facet2, configuration);
        }
        if (!addedEntries.isEmpty()) {
            LOG.debug("Files excluded by Android: " + addedEntries.size());
            project.getMessageBus().connect().subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new MyCompilationStatusListener(project, addedEntries));
        }
        return true;
    }

    private static void createGenModulesAndSourceRoots(final Project project) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        final ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
            if (facet2 == null) continue;
            facets.add(facet2);
        }
        if (!facets.isEmpty()) {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AndroidCompileUtil.createGenModulesAndSourceRoots(project, facets);
                }
            }, indicator != null ? indicator.getModalityState() : ModalityState.NON_MODAL);
        }
    }

    private static boolean checkArtifacts(@NotNull CompileContext context) {
        String message2;
        final Project project = context.getProject();
        final CompileScope scope2 = context.getCompileScope();
        Set artifacts = (Set)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Set<Artifact>>(){

            public Set<Artifact> compute() {
                return ArtifactCompileScope.getArtifactsToBuild((Project)project, (CompileScope)scope2, (boolean)false);
            }
        });
        if (artifacts == null) {
            return true;
        }
        HashSet<Artifact> debugArtifacts = new HashSet<Artifact>();
        HashSet<Artifact> releaseArtifacts = new HashSet<Artifact>();
        HashMap<AndroidFacet, ArrayList<Artifact>> facet2artifacts = new HashMap<AndroidFacet, ArrayList<Artifact>>();
        for (final Artifact artifact : artifacts) {
            AndroidFacet facet2;
            ArtifactProperties properties2 = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance());
            if (properties2 instanceof AndroidApplicationArtifactProperties) {
                AndroidArtifactSigningMode mode = ((AndroidApplicationArtifactProperties)properties2).getSigningMode();
                if (mode == AndroidArtifactSigningMode.DEBUG || mode == AndroidArtifactSigningMode.DEBUG_WITH_CUSTOM_CERTIFICATE) {
                    debugArtifacts.add(artifact);
                } else {
                    releaseArtifacts.add(artifact);
                }
            }
            if ((facet2 = (AndroidFacet)ApplicationManager.getApplication().runReadAction((Computable)new Computable<AndroidFacet>(){

                @Nullable
                public AndroidFacet compute() {
                    return AndroidArtifactUtil.getPackagedFacet(project, artifact);
                }
            })) == null) continue;
            ArrayList<Artifact> list = (ArrayList<Artifact>)facet2artifacts.get(facet2);
            if (list == null) {
                list = new ArrayList<Artifact>();
                facet2artifacts.put(facet2, list);
            }
            list.add(artifact);
        }
        boolean success2 = true;
        if (!debugArtifacts.isEmpty() && !releaseArtifacts.isEmpty()) {
            message2 = "Cannot build debug and release Android artifacts in the same session\nDebug artifacts: " + AndroidPrecompileTask.toString(debugArtifacts) + "\nRelease artifacts: " + AndroidPrecompileTask.toString(releaseArtifacts);
            context.addMessage(CompilerMessageCategory.ERROR, message2, null, -1, -1);
            success2 = false;
        }
        if (!releaseArtifacts.isEmpty() && CompileStepBeforeRun.getRunConfiguration((CompileContext)context) != null) {
            message2 = "Cannot build release Android artifacts in the 'make before run' session\nRelease artifacts: " + AndroidPrecompileTask.toString(releaseArtifacts);
            context.addMessage(CompilerMessageCategory.ERROR, message2, null, -1, -1);
            success2 = false;
        }
        block1: for (Map.Entry entry : facet2artifacts.entrySet()) {
            List list = (List)entry.getValue();
            String moduleName2 = ((AndroidFacet)entry.getKey()).getModule().getName();
            if (list.size() <= 1) continue;
            Artifact firstArtifact = (Artifact)list.get(0);
            Object[] firstArtifactProGuardOptions = AndroidPrecompileTask.getProGuardOptions(firstArtifact);
            for (int i2 = 1; i2 < list.size(); ++i2) {
                Artifact artifact = (Artifact)list.get(i2);
                if (Arrays.equals(AndroidPrecompileTask.getProGuardOptions(artifact), firstArtifactProGuardOptions)) continue;
                context.addMessage(CompilerMessageCategory.ERROR, "Artifacts related to the same module '" + moduleName2 + "' have different ProGuard options: " + firstArtifact.getName() + ", " + artifact.getName(), null, -1, -1);
                success2 = false;
                continue block1;
            }
        }
        return success2;
    }

    @NotNull
    private static Object[] getProGuardOptions(@NotNull Artifact artifact) {
        ArtifactProperties properties2 = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance());
        if (properties2 instanceof AndroidApplicationArtifactProperties) {
            AndroidApplicationArtifactProperties p = (AndroidApplicationArtifactProperties)properties2;
            return new Object[]{p.isRunProGuard(), p.getProGuardCfgFiles()};
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static String toString(Collection<Artifact> artifacts) {
        StringBuilder result2 = new StringBuilder();
        for (Artifact artifact : artifacts) {
            if (result2.length() > 0) {
                result2.append(", ");
            }
            result2.append(artifact.getName());
        }
        return result2.toString();
    }

    private static void checkAndroidDependencies(@NotNull CompileContext context) {
        for (Module module2 : context.getCompileScope().getAffectedModules()) {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
            if (facet2 == null) continue;
            Pair<String, VirtualFile> manifestMergerProp = AndroidRootUtil.getProjectPropertyValue(module2, "manifestmerger.enabled");
            if (manifestMergerProp != null && Boolean.parseBoolean((String)manifestMergerProp.getFirst())) {
                context.addMessage(CompilerMessageCategory.WARNING, "[" + module2.getName() + "] " + AndroidBundle.message("android.manifest.merger.not.supported.error", new Object[0]), ((VirtualFile)manifestMergerProp.getSecond()).getUrl(), -1, -1);
            }
            if (!((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()) continue;
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)module2).getOrderEntries()) {
                AndroidFacet depFacet;
                Module depModule;
                ModuleOrderEntry moduleOrderEntry;
                if (!(entry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)entry).getScope() != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || (depFacet = AndroidFacet.getInstance((Module)depModule)) == null || ((AndroidFacetConfiguration)depFacet.getConfiguration()).canBeDependency()) continue;
                String message2 = "Suspicious module dependency " + module2.getName() + " -> " + depModule.getName() + ": Android application module depends on other application module. Possibly, you should ";
                message2 = message2 + "change dependency scope to 'Provided'.";
                context.addMessage(CompilerMessageCategory.WARNING, message2, null, -1, -1);
            }
        }
    }

    private static void clearResCache(@NotNull AndroidFacet facet2, @NotNull CompileContext context) {
        File dir;
        Module module2 = facet2.getModule();
        String dirPath = AndroidCompileUtil.findResourcesCacheDirectory(module2, false, null);
        if (dirPath != null && (dir = new File(dirPath)).exists()) {
            FileUtil.delete((File)dir);
        }
    }

    private static void unexcludeAllSourceRoots(AndroidFacet facet2, ExcludesConfiguration configuration) {
        VirtualFile buildconfigGenDir;
        VirtualFile rsGenRoot;
        VirtualFile aptGenSourceRoot;
        String aptGenSourceRootPath;
        VirtualFile aidlGenSourceRoot;
        VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)facet2.getModule()).getSourceRoots();
        HashSet<VirtualFile> sourceRootSet = new HashSet<VirtualFile>();
        sourceRootSet.addAll(Arrays.asList(sourceRoots));
        String aidlGenSourceRootPath = AndroidRootUtil.getAidlGenSourceRootPath(facet2);
        if (aidlGenSourceRootPath != null && (aidlGenSourceRoot = LocalFileSystem.getInstance().findFileByPath(aidlGenSourceRootPath)) != null) {
            sourceRootSet.remove(aidlGenSourceRoot);
        }
        if ((aptGenSourceRootPath = AndroidRootUtil.getAptGenSourceRootPath(facet2)) != null && (aptGenSourceRoot = LocalFileSystem.getInstance().findFileByPath(aptGenSourceRootPath)) != null) {
            sourceRootSet.remove(aptGenSourceRoot);
        }
        if ((rsGenRoot = AndroidRootUtil.getRenderscriptGenDir(facet2)) != null) {
            sourceRootSet.remove(rsGenRoot);
        }
        if ((buildconfigGenDir = AndroidRootUtil.getBuildconfigGenDir(facet2)) != null) {
            sourceRootSet.remove(buildconfigGenDir);
        }
        ExcludeEntryDescription[] descriptions = configuration.getExcludeEntryDescriptions();
        configuration.removeAllExcludeEntryDescriptions();
        for (ExcludeEntryDescription description2 : descriptions) {
            VirtualFile file2 = description2.getVirtualFile();
            if (file2 != null && sourceRootSet.contains(file2)) continue;
            configuration.addExcludeEntryDescription(description2);
        }
    }

    private static void excludeAllSourceRoots(Module module2, ExcludesConfiguration configuration, Collection<ExcludeEntryDescription> addedEntries) {
        VirtualFile[] sourceRoots;
        Project project = module2.getProject();
        for (VirtualFile sourceRoot : sourceRoots = ModuleRootManager.getInstance((Module)module2).getSourceRoots()) {
            ExcludeEntryDescription description2 = new ExcludeEntryDescription(sourceRoot, true, false, (Disposable)project);
            if (configuration.containsExcludeEntryDescription(description2)) continue;
            configuration.addExcludeEntryDescription(description2);
            addedEntries.add(description2);
        }
    }

    private static class MyCompilationStatusListener
    implements CompilationStatusListener {
        private final Project myProject;
        private final Set<ExcludeEntryDescription> myEntriesToRemove;

        public MyCompilationStatusListener(Project project, Set<ExcludeEntryDescription> entriesToRemove) {
            this.myProject = project;
            this.myEntriesToRemove = entriesToRemove;
        }

        public void compilationFinished(boolean aborted, int errors2, int warnings, @NotNull CompileContext compileContext) {
            ExcludesConfiguration configuration = CompilerConfiguration.getInstance((Project)this.myProject).getExcludedEntriesConfiguration();
            ExcludeEntryDescription[] descriptions = configuration.getExcludeEntryDescriptions();
            configuration.removeAllExcludeEntryDescriptions();
            for (ExcludeEntryDescription description2 : descriptions) {
                if (this.myEntriesToRemove.contains(description2)) continue;
                configuration.addExcludeEntryDescription(description2);
            }
        }
    }
}

