/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.google.common.collect.ImmutableSet;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.InnerRClassBase;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidInternalRClass
extends AndroidLightClassBase {
    private static final Key<Sdk> ANDROID_INTERNAL_R = Key.create((String)"ANDROID_INTERNAL_R");
    private final PsiFile myFile;
    private final AndroidPlatform myPlatform;
    private final PsiClass[] myInnerClasses;

    public AndroidInternalRClass(@NotNull PsiManager psiManager, @NotNull AndroidPlatform platform, Sdk sdk) {
        super(psiManager, (Collection<String>)ImmutableSet.of((Object)"public", (Object)"static", (Object)"final"));
        this.myFile = PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText("R.java", (FileType)JavaFileType.INSTANCE, (CharSequence)"");
        this.myFile.getViewProvider().getVirtualFile().putUserData(ANDROID_INTERNAL_R, (Object)sdk);
        this.setModuleInfo(sdk);
        this.myPlatform = platform;
        ResourceType[] types2 = ResourceType.values();
        this.myInnerClasses = new PsiClass[types2.length];
        for (int i2 = 0; i2 < types2.length; ++i2) {
            this.myInnerClasses[i2] = new MyInnerClass(types2[i2]);
        }
    }

    @Nullable
    public String getQualifiedName() {
        return "com.android.internal.R";
    }

    @NotNull
    public String getName() {
        return "R";
    }

    @Nullable
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return this.myFile;
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        return TextRange.EMPTY_RANGE;
    }

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        return this.myInnerClasses;
    }

    @Override
    @Nullable
    public PsiClass findInnerClassByName(@NonNls String name, boolean checkBases) {
        for (PsiClass aClass : this.getInnerClasses()) {
            if (!name.equals(aClass.getName())) continue;
            return aClass;
        }
        return null;
    }

    public static boolean isAndroidInternalR(@NotNull VirtualFile file2, @NotNull Sdk sdk) {
        return sdk.equals(file2.getUserData(ANDROID_INTERNAL_R));
    }

    private class MyInnerClass
    extends InnerRClassBase {
        private MyInnerClass(ResourceType resourceType) {
            super((PsiClass)AndroidInternalRClass.this, resourceType);
        }

        @Override
        @NotNull
        protected PsiField[] doGetFields() {
            AndroidTargetData targetData = AndroidInternalRClass.this.myPlatform.getSdkData().getTargetData(AndroidInternalRClass.this.myPlatform.getTarget());
            ResourceRepository repository = targetData.getFrameworkResources((Set<String>)ImmutableSet.of());
            if (repository == null) {
                return PsiField.EMPTY_ARRAY;
            }
            return MyInnerClass.buildResourceFields(repository, ResourceNamespace.ANDROID, AndroidLightField.FieldModifier.FINAL, (ResourceType type, String s) -> true, this.myResourceType, AndroidInternalRClass.this);
        }

        @Override
        @NotNull
        protected ModificationTracker getFieldsDependencies() {
            return ModificationTracker.NEVER_CHANGED;
        }
    }
}

