/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.CommonBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.xml.refactoring.XmlTagInplaceRenamer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.actions.CreateResourceActionBase;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateTypedResourceFileAction
extends CreateResourceActionBase {
    protected final ResourceFolderType myResourceFolderType;
    protected final String myResourcePresentableName;
    String myDefaultRootTag;
    private final boolean myValuesResourceFile;
    private boolean myChooseTagName;

    public CreateTypedResourceFileAction(@NotNull String resourcePresentableName, @NotNull ResourceFolderType resourceFolderType, boolean valuesResourceFile, boolean chooseTagName) {
        super(AndroidBundle.message("new.typed.resource.action.title", resourcePresentableName), AndroidBundle.message("new.typed.resource.action.description", resourcePresentableName), XmlFileType.INSTANCE.getIcon());
        this.myResourceFolderType = resourceFolderType;
        this.myResourcePresentableName = resourcePresentableName;
        this.myDefaultRootTag = CreateTypedResourceFileAction.getDefaultRootTagByResourceType(resourceFolderType);
        this.myValuesResourceFile = valuesResourceFile;
        this.myChooseTagName = chooseTagName;
    }

    @NotNull
    public ResourceFolderType getResourceFolderType() {
        return this.myResourceFolderType;
    }

    protected InputValidator createValidator(Project project, PsiDirectory directory) {
        return new MyValidator(project, directory);
    }

    @Override
    @NotNull
    protected PsiElement[] invokeDialog(@NotNull Project project, @NotNull DataContext dataContext) {
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view != null) {
            AbstractProjectViewPane pane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane();
            if (pane instanceof AndroidProjectViewPane) {
                return CreateResourceFileAction.getInstance().invokeDialog(project, dataContext);
            }
            PsiDirectory directory = view.getOrChooseDirectory();
            if (directory != null) {
                InputValidator validator = this.createValidator(project, directory);
                Messages.showInputDialog((Project)project, (String)AndroidBundle.message("new.file.dialog.text", new Object[0]), (String)AndroidBundle.message("new.typed.resource.dialog.title", this.myResourcePresentableName), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
            }
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    protected PsiElement[] create(String newName2, PsiDirectory directory) throws Exception {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
        return this.doCreateAndNavigate(newName2, directory, this.getDefaultRootTag(module2), this.myChooseTagName, true);
    }

    PsiElement[] doCreateAndNavigate(String newName2, PsiDirectory directory, String rootTagName, boolean chooseTagName, boolean navigate) throws Exception {
        Project project;
        Editor editor2;
        XmlTag rootTag;
        XmlDocument document;
        XmlFile file2 = IdeResourcesUtil.createFileResource(newName2, directory, rootTagName, this.myResourceFolderType.getName(), this.myValuesResourceFile);
        if (navigate) {
            this.doNavigate(file2);
        }
        if (chooseTagName && (document = file2.getDocument()) != null && (rootTag = document.getRootTag()) != null && (editor2 = FileEditorManager.getInstance((Project)(project = file2.getProject())).getSelectedTextEditor()) != null) {
            CaretModel caretModel = editor2.getCaretModel();
            caretModel.moveToOffset(rootTag.getTextOffset() + 1);
            XmlTagInplaceRenamer.rename((Editor)editor2, (XmlTag)rootTag);
        }
        return new PsiElement[]{file2};
    }

    protected void doNavigate(XmlFile file2) {
        if (file2.isValid() && LayoutPullParsers.isSupported((PsiFile)file2)) {
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile != null && virtualFile.isValid()) {
                if (AndroidEditorSettings.getInstance().getGlobalState().isPreferXmlEditor()) {
                    new OpenFileDescriptor(file2.getProject(), virtualFile, 0).navigate(true);
                } else {
                    new OpenFileDescriptor(file2.getProject(), virtualFile).navigate(true);
                }
            }
        } else {
            PsiNavigateUtil.navigate((PsiElement)file2);
        }
    }

    @Override
    protected boolean isAvailable(DataContext context) {
        return super.isAvailable(context) && CreateTypedResourceFileAction.doIsAvailable(context, this.myResourceFolderType.getName());
    }

    public boolean isChooseTagName() {
        return this.myChooseTagName;
    }

    @NotNull
    public List<String> getAllowedTagNames(@NotNull AndroidFacet facet2) {
        return Collections.singletonList(this.getDefaultRootTag(facet2.getModule()));
    }

    @NotNull
    public final List<String> getSortedAllowedTagNames(@NotNull AndroidFacet facet2) {
        ArrayList<String> result2 = new ArrayList<String>(this.getAllowedTagNames(facet2));
        Collections.sort(result2);
        return result2;
    }

    public String getDefaultRootTag(@Nullable Module module2) {
        return this.myDefaultRootTag;
    }

    static boolean doIsAvailable(DataContext context, String resourceType) {
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (element2 == null || AndroidFacet.getInstance((PsiElement)element2) == null) {
            return false;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            for (PsiElement e = element2; e != null; e = e.getParent()) {
                if (!(e instanceof PsiDirectory) || !IdeResourcesUtil.isResourceSubdirectory((PsiDirectory)e, resourceType)) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    @Override
    protected String getCommandName() {
        return AndroidBundle.message("new.typed.resource.command.name", this.myResourceFolderType);
    }

    @Override
    @Nullable
    protected String getActionName(PsiDirectory directory, String newName2) {
        return CreateResourceFileAction.doGetActionName(directory, newName2);
    }

    public String toString() {
        return this.myResourcePresentableName;
    }

    @NotNull
    public static String getDefaultRootTagByResourceType(@NotNull ResourceFolderType resourceType) {
        switch (resourceType) {
            case XML: {
                return "PreferenceScreen";
            }
            case DRAWABLE: {
                return "selector";
            }
            case COLOR: {
                return "selector";
            }
            case VALUES: {
                return "resources";
            }
            case MENU: {
                return "menu";
            }
            case ANIM: {
                return "set";
            }
            case ANIMATOR: {
                return "set";
            }
            case LAYOUT: {
                return "LinearLayout";
            }
            case TRANSITION: {
                return "transitionManager";
            }
            case FONT: {
                return "font-family";
            }
            case NAVIGATION: {
                return "navigation";
            }
        }
        throw new IllegalArgumentException("Incorrect resource folder type");
    }

    private class MyValidator
    extends CreateResourceActionBase.MyInputValidator
    implements InputValidatorEx {
        @NotNull
        private final IdeResourceNameValidator myNameValidator;

        public MyValidator(Project project, PsiDirectory directory) {
            super(project, directory);
            this.myNameValidator = IdeResourceNameValidator.forFilename(CreateTypedResourceFileAction.this.myResourceFolderType, ".xml");
        }

        @Override
        public boolean checkInput(String inputString) {
            return this.getErrorText(inputString) == null;
        }

        public String getErrorText(String inputString) {
            return this.myNameValidator.getErrorText(inputString);
        }
    }
}

