/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.compiler.AndroidAutogenerator;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidRegenerateSourcesAction
extends AnAction {
    private static final String TITLE = "Generate Sources";

    public AndroidRegenerateSourcesAction() {
        super(TITLE);
    }

    public void update(@NotNull AnActionEvent e) {
        String title;
        boolean visible;
        block1: {
            Project project;
            block2: {
                Module module2 = (Module)e.getData(LangDataKeys.MODULE);
                project = (Project)e.getData(CommonDataKeys.PROJECT);
                visible = project != null && !ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID).isEmpty();
                title = TITLE;
                if (!visible) break block1;
                visible = false;
                if (module2 == null) break block2;
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
                if (facet2 == null) break block1;
                visible = AndroidAutogenerator.supportsAutogeneration(facet2);
                title = "Generate Sources for '" + module2.getName() + "'";
                break block1;
            }
            List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
            for (AndroidFacet facet3 : facets) {
                if (!AndroidAutogenerator.supportsAutogeneration(facet3)) continue;
                visible = true;
                break;
            }
        }
        e.getPresentation().setEnabledAndVisible(visible);
        e.getPresentation().setText(title);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Module module2 = (Module)e.getData(LangDataKeys.MODULE);
        if (module2 != null) {
            AndroidRegenerateSourcesAction.generate(project, module2);
            return;
        }
        assert (project != null);
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        ArrayList<Module> modulesToProcess = new ArrayList<Module>();
        for (AndroidFacet facet2 : facets) {
            module2 = facet2.getModule();
            if (!AndroidAutogenerator.supportsAutogeneration(facet2)) continue;
            modulesToProcess.add(module2);
        }
        if (!modulesToProcess.isEmpty()) {
            AndroidRegenerateSourcesAction.generate(project, modulesToProcess.toArray(Module.EMPTY_ARRAY));
        }
    }

    private static void generate(Project project, final Module ... modules) {
        CompilerManager.getInstance((Project)project).executeTask(new CompileTask(){

            public boolean execute(@NotNull CompileContext context) {
                for (Module module2 : modules) {
                    AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
                    if (facet2 == null) continue;
                    for (AndroidAutogeneratorMode mode : AndroidAutogeneratorMode.values()) {
                        AndroidCompileUtil.generate(facet2, mode, context, true);
                    }
                }
                return true;
            }
        }, (CompileScope)new ModuleCompileScope(project, modules, false), AndroidBundle.message("android.compile.messages.generating.r.java.content.name", new Object[0]), null);
    }
}

