/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.SingleAlarm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.importDependencies.ImportDependenciesUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidPropertyFilesUpdater
implements Disposable {
    private static final NotificationGroup PROPERTY_FILES_UPDATING_NOTIFICATION = NotificationGroup.balloonGroup((String)"Android Property Files Updating", (PluginId)PluginId.getId((String)"org.jetbrains.android"));
    private static final Key<List<Object>> ANDROID_PROPERTIES_STATE_KEY = Key.create((String)"ANDROID_PROPERTIES_STATE");
    private Notification myNotification;
    private final SingleAlarm myAlarm = new SingleAlarm(this::updatePropertyFilesIfNecessary, 50, (Disposable)this);
    private final Project myProject;

    private AndroidPropertyFilesUpdater(Project project) {
        this.myProject = project;
    }

    public void dispose() {
        if (this.myNotification != null && !this.myNotification.isExpired()) {
            this.myNotification.expire();
        }
        this.myAlarm.cancel();
    }

    private void onRootsChanged() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> ((SingleAlarm)this.myAlarm).cancelAndRequest());
        }
    }

    private void updatePropertyFilesIfNecessary() {
        if (this.myProject.isDisposed()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        final ArrayList<Object> toAskFiles = new ArrayList<Object>();
        final ArrayList<AndroidFacet> toAskFacets = new ArrayList<AndroidFacet>();
        final ArrayList toAskChanges = new ArrayList();
        ArrayList<Object> files2 = new ArrayList<Object>();
        final ArrayList changes = new ArrayList();
        for (AndroidFacet facet2 : ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID)) {
            Pair<VirtualFile, List<Runnable>> pair;
            String updatePropertyFiles;
            boolean ask;
            if (AndroidModel.isRequired(facet2) || !(ask = (updatePropertyFiles = facet2.getProperties().UPDATE_PROPERTY_FILES).isEmpty()) && !Boolean.parseBoolean(updatePropertyFiles) || (pair = AndroidPropertyFilesUpdater.updateProjectPropertiesIfNecessary(facet2)) == null) continue;
            if (ask) {
                toAskFacets.add(facet2);
                toAskFiles.add(pair.getFirst());
                toAskChanges.addAll((Collection)pair.getSecond());
                continue;
            }
            files2.add(pair.getFirst());
            changes.addAll((Collection)pair.getSecond());
        }
        if (this.myNotification != null && !this.myNotification.isExpired()) {
            this.myNotification.expire();
        }
        if (!changes.isEmpty() || !toAskChanges.isEmpty()) {
            if (!toAskChanges.isEmpty()) {
                this.askUserIfUpdatePropertyFile(this.myProject, toAskFacets, new Processor<MyResult>(){

                    public boolean process(MyResult result2) {
                        if (result2 == MyResult.NEVER) {
                            for (AndroidFacet facet2 : toAskFacets) {
                                facet2.getProperties().UPDATE_PROPERTY_FILES = Boolean.FALSE.toString();
                            }
                            return true;
                        }
                        if (result2 == MyResult.ALWAYS) {
                            for (AndroidFacet facet3 : toAskFacets) {
                                facet3.getProperties().UPDATE_PROPERTY_FILES = Boolean.TRUE.toString();
                            }
                        }
                        if (ReadonlyStatusHandler.ensureFilesWritable((Project)AndroidPropertyFilesUpdater.this.myProject, (VirtualFile[])toAskFiles.toArray(VirtualFile.EMPTY_ARRAY))) {
                            CommandProcessor.getInstance().executeCommand(AndroidPropertyFilesUpdater.this.myProject, new Runnable(){

                                @Override
                                public void run() {
                                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                        @Override
                                        public void run() {
                                            for (Runnable change : toAskChanges) {
                                                change.run();
                                            }
                                        }
                                    });
                                }
                            }, "Update Android property files", null);
                        }
                        return true;
                    }
                });
            }
            if (!changes.isEmpty() && ReadonlyStatusHandler.ensureFilesWritable((Project)this.myProject, (VirtualFile[])files2.toArray(VirtualFile.EMPTY_ARRAY))) {
                CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                for (Runnable change : changes) {
                                    change.run();
                                }
                            }
                        });
                        CommandProcessor.getInstance().markCurrentCommandAsGlobal(AndroidPropertyFilesUpdater.this.myProject);
                    }
                }, "Update Android property files", null);
            }
        }
    }

    @Nullable
    private static Pair<VirtualFile, List<Runnable>> updateProjectPropertiesIfNecessary(@NotNull AndroidFacet facet2) {
        if (facet2.isDisposed()) {
            return null;
        }
        Module module2 = facet2.getModule();
        Pair<PropertiesFile, VirtualFile> pair = AndroidRootUtil.findPropertyFile(module2, "project.properties");
        if (pair == null) {
            return null;
        }
        PropertiesFile projectProperties = (PropertiesFile)pair.getFirst();
        VirtualFile projectPropertiesVFile = (VirtualFile)pair.getSecond();
        Pair<Properties, VirtualFile> localProperties = AndroidRootUtil.readPropertyFile(module2, "local.properties");
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(facet2.getModule());
        IAndroidTarget androidTarget = androidPlatform == null ? null : androidPlatform.getTarget();
        String androidTargetHashString = androidTarget != null ? androidTarget.hashString() : null;
        VirtualFile[] dependencies2 = AndroidPropertyFilesUpdater.collectDependencies(module2);
        String[] dependencyPaths = AndroidPropertyFilesUpdater.toSortedPaths(dependencies2);
        List<Object> newState = Arrays.asList(androidTargetHashString, ((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType(), Arrays.asList(dependencyPaths), facet2.getProperties().ENABLE_MANIFEST_MERGING, facet2.getProperties().ENABLE_PRE_DEXING);
        List state = (List)facet2.getUserData(ANDROID_PROPERTIES_STATE_KEY);
        if (state == null || !Objects.equals(state, newState)) {
            AndroidPropertyFilesUpdater.updateTargetProperty(facet2, projectProperties, changes);
            AndroidPropertyFilesUpdater.updateProjectTypeProperty(facet2, projectProperties, changes);
            AndroidPropertyFilesUpdater.updateManifestMergerProperty(facet2, projectProperties, changes);
            AndroidPropertyFilesUpdater.updateDependenciesInPropertyFile(projectProperties, localProperties, dependencies2, changes);
            facet2.putUserData(ANDROID_PROPERTIES_STATE_KEY, newState);
        }
        return !changes.isEmpty() ? Pair.create((Object)projectPropertiesVFile, changes) : null;
    }

    private static void updateDependenciesInPropertyFile(final @NotNull PropertiesFile projectProperties, @Nullable Pair<Properties, VirtualFile> localProperties, @NotNull VirtualFile[] dependencies2, @NotNull List<Runnable> changes) {
        VirtualFile vFile = projectProperties.getVirtualFile();
        if (vFile == null) {
            return;
        }
        Set<Object> localDependencies = localProperties != null ? ImportDependenciesUtil.getLibDirs(localProperties) : Collections.emptySet();
        VirtualFile baseDir = vFile.getParent();
        String baseDirPath = baseDir.getPath();
        final ArrayList<String> newDepValues = new ArrayList<String>();
        for (VirtualFile dependency : dependencies2) {
            if (localDependencies.contains(dependency)) continue;
            String relPath = FileUtil.getRelativePath((String)baseDirPath, (String)dependency.getPath(), (char)'/');
            String value2 = relPath != null ? relPath : dependency.getPath();
            newDepValues.add(value2);
        }
        HashSet<String> oldDepValues = new HashSet<String>();
        for (IProperty property2 : projectProperties.getProperties()) {
            String name = property2.getName();
            if (name == null || !name.startsWith("android.library.reference.")) continue;
            oldDepValues.add(property2.getValue());
        }
        if (!new HashSet(newDepValues).equals(oldDepValues)) {
            changes.add(new Runnable(){

                @Override
                public void run() {
                    for (IProperty property2 : projectProperties.getProperties()) {
                        String name = property2.getName();
                        if (name == null || !name.startsWith("android.library.reference.")) continue;
                        property2.getPsiElement().delete();
                    }
                    for (int i2 = 0; i2 < newDepValues.size(); ++i2) {
                        String value2 = (String)newDepValues.get(i2);
                        projectProperties.addProperty("android.library.reference." + Integer.toString(i2 + 1), value2);
                    }
                }
            });
        }
    }

    @NotNull
    private static VirtualFile[] collectDependencies(@NotNull Module module2) {
        ArrayList<VirtualFile> dependenciesList = new ArrayList<VirtualFile>();
        for (AndroidFacet depFacet : AndroidUtils.getAndroidLibraryDependencies(module2)) {
            Module depModule = depFacet.getModule();
            VirtualFile libDir = AndroidPropertyFilesUpdater.getBaseAndroidContentRoot(depModule);
            if (libDir == null) continue;
            dependenciesList.add(libDir);
        }
        return dependenciesList.toArray(VirtualFile.EMPTY_ARRAY);
    }

    private static void updateTargetProperty(@NotNull AndroidFacet facet2, final @NotNull PropertiesFile propertiesFile, @NotNull List<Runnable> changes) {
        IAndroidTarget androidTarget;
        final Project project = facet2.getModule().getProject();
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(facet2.getModule());
        IAndroidTarget iAndroidTarget = androidTarget = androidPlatform == null ? null : androidPlatform.getTarget();
        if (androidTarget != null) {
            PsiElement element2;
            final String targetPropertyValue = androidTarget.hashString();
            IProperty property2 = propertiesFile.findPropertyByKey("target");
            if (property2 == null) {
                changes.add(new Runnable(){

                    @Override
                    public void run() {
                        propertiesFile.addProperty(AndroidPropertyFilesUpdater.createProperty(project, targetPropertyValue));
                    }
                });
            } else if (!Objects.equals(property2.getValue(), targetPropertyValue) && (element2 = property2.getPsiElement()) != null) {
                changes.add(new Runnable(){

                    @Override
                    public void run() {
                        element2.replace(AndroidPropertyFilesUpdater.createProperty(project, targetPropertyValue).getPsiElement());
                    }
                });
            }
        }
    }

    public static void updateProjectTypeProperty(@NotNull AndroidFacet facet2, @NotNull PropertiesFile propertiesFile, @NotNull List<Runnable> changes) {
        IProperty property2 = propertiesFile.findPropertyByKey("project.type");
        String value2 = Integer.toString(((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType());
        if (property2 != null) {
            if (!value2.equals(property2.getValue())) {
                changes.add(() -> property2.setValue(value2));
            }
        } else {
            changes.add(() -> propertiesFile.addProperty("project.type", value2));
        }
    }

    public static void updateManifestMergerProperty(@NotNull AndroidFacet facet2, final @NotNull PropertiesFile propertiesFile, @NotNull List<Runnable> changes) {
        final IProperty property2 = propertiesFile.findPropertyByKey("manifestmerger.enabled");
        if (property2 != null) {
            final String value2 = Boolean.toString(facet2.getProperties().ENABLE_MANIFEST_MERGING);
            if (!value2.equals(property2.getValue())) {
                changes.add(new Runnable(){

                    @Override
                    public void run() {
                        property2.setValue(value2);
                    }
                });
            }
        } else if (facet2.getProperties().ENABLE_MANIFEST_MERGING) {
            changes.add(new Runnable(){

                @Override
                public void run() {
                    propertiesFile.addProperty("manifestmerger.enabled", Boolean.TRUE.toString());
                }
            });
        } else if (!facet2.getProperties().ENABLE_PRE_DEXING) {
            changes.add(new Runnable(){

                @Override
                public void run() {
                    propertiesFile.addProperty("dex.disable.merger", Boolean.TRUE.toString());
                }
            });
        }
    }

    @Nullable
    private static VirtualFile getBaseAndroidContentRoot(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        VirtualFile manifestFile = facet2 != null ? AndroidRootUtil.getPrimaryManifestFile(facet2) : null;
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        if (manifestFile != null) {
            for (VirtualFile contentRoot : contentRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)manifestFile, (boolean)true)) continue;
                return contentRoot;
            }
        }
        return contentRoots.length > 0 ? contentRoots[0] : null;
    }

    @NotNull
    private static IProperty createProperty(@NotNull Project project, @NotNull String targetPropertyValue) {
        String text2 = "target=" + targetPropertyValue;
        PropertiesFile dummyFile = PropertiesElementFactory.createPropertiesFile((Project)project, (String)text2);
        return (IProperty)dummyFile.getProperties().get(0);
    }

    @NotNull
    private static String[] toSortedPaths(@NotNull VirtualFile[] files2) {
        Object[] result2 = new String[files2.length];
        for (int i2 = 0; i2 < files2.length; ++i2) {
            result2[i2] = files2[i2].getPath();
        }
        Arrays.sort(result2);
        return result2;
    }

    private void askUserIfUpdatePropertyFile(@NotNull Project project, @NotNull Collection<AndroidFacet> facets, final @NotNull Processor<MyResult> callback2) {
        StringBuilder moduleList = new StringBuilder();
        for (AndroidFacet facet2 : facets) {
            moduleList.append(facet2.getModule().getName()).append("<br>");
        }
        this.myNotification = PROPERTY_FILES_UPDATING_NOTIFICATION.createNotification(AndroidBundle.message("android.update.project.properties.dialog.title", new Object[0]), AndroidBundle.message("android.update.project.properties.dialog.text", moduleList.toString()), NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                String desc = event.getDescription();
                if ("once".equals(desc)) {
                    callback2.process((Object)MyResult.ONCE);
                } else if ("never".equals(desc)) {
                    callback2.process((Object)MyResult.NEVER);
                } else {
                    callback2.process((Object)MyResult.ALWAYS);
                }
                notification.expire();
            }
        });
        this.myNotification.notify(project);
    }

    private static enum MyResult {
        ONCE,
        NEVER,
        ALWAYS;

    }

    public static class ModuleRootListenerImpl
    implements ModuleRootListener {
        public void rootsChanged(@NotNull ModuleRootEvent event) {
            ((AndroidPropertyFilesUpdater)ServiceManager.getService((Project)event.getProject(), AndroidPropertyFilesUpdater.class)).onRootsChanged();
        }
    }
}

