/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import java.util.Objects;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.AndroidDeprecationInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaCompletionContributor
extends CompletionContributor {
    private static final String[] EXCLUDED_PACKAGES = new String[]{"javax.swing", "javafx"};

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet resultSet) {
        super.fillCompletionVariants(parameters2, resultSet);
        PsiElement position = parameters2.getPosition();
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)position);
        if (facet2 == null) {
            return;
        }
        boolean filterPrivateResources = AndroidJavaCompletionContributor.shouldFilterPrivateResources(position, facet2);
        ResourceVisibilityLookup lookup = filterPrivateResources ? AndroidJavaCompletionContributor.getResourcesLookup(facet2) : null;
        resultSet.runRemainingContributors(parameters2, result2 -> {
            CompletionResult modifiedResult = result2;
            if (filterPrivateResources && lookup != null && AndroidJavaCompletionContributor.isForPrivateResource(modifiedResult, lookup)) {
                modifiedResult = null;
            }
            if (modifiedResult != null) {
                modifiedResult = AndroidJavaCompletionContributor.fixDeprecationPresentation(modifiedResult, parameters2);
            }
            if (modifiedResult != null) {
                resultSet.passResult(modifiedResult);
            }
        });
    }

    private static boolean shouldFilterPrivateResources(PsiElement position, AndroidFacet facet2) {
        PsiReferenceExpression ref3;
        PsiReferenceExpression ref2;
        PsiReferenceExpression ref;
        boolean filterPrivateResources = false;
        if (position.getParent() instanceof PsiReferenceExpression && (ref = (PsiReferenceExpression)position.getParent()).getQualifierExpression() != null && ref.getQualifierExpression() instanceof PsiReferenceExpression && (ref2 = (PsiReferenceExpression)ref.getQualifierExpression()).getQualifierExpression() instanceof PsiReferenceExpression && "R".equals((ref3 = (PsiReferenceExpression)ref2.getQualifierExpression()).getReferenceName())) {
            PsiExpression qualifierExpression = ref3.getQualifierExpression();
            if (qualifierExpression == null) {
                filterPrivateResources = true;
            } else if (qualifierExpression instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
                if (Objects.equals(AndroidManifestUtils.getPackageName(facet2), referenceExpression.getQualifiedName()) || Objects.equals(AndroidManifestUtils.getTestPackageName(facet2), referenceExpression.getQualifiedName())) {
                    filterPrivateResources = true;
                }
            }
        }
        return filterPrivateResources;
    }

    @NotNull
    public static CompletionResult fixDeprecationPresentation(@NotNull CompletionResult result2, @NotNull CompletionParameters parameters2) {
        PsiDocCommentOwner docCommentOwner;
        Object obj = result2.getLookupElement().getObject();
        if (obj instanceof PsiDocCommentOwner && (docCommentOwner = (PsiDocCommentOwner)obj).isDeprecated()) {
            for (AndroidDeprecationInspection.DeprecationFilter filter2 : AndroidDeprecationInspection.getFilters()) {
                if (!filter2.isExcluded((PsiElement)docCommentOwner, parameters2.getPosition(), null)) continue;
                result2 = result2.withLookupElement((LookupElement)new NonDeprecatedDecorator(result2.getLookupElement()));
            }
        }
        return result2;
    }

    @Nullable
    private static ResourceVisibilityLookup getResourcesLookup(AndroidFacet facet2) {
        ResourceVisibilityLookup lookup = ResourceRepositoryManager.getInstance(facet2).getResourceVisibility();
        if (lookup.isEmpty()) {
            return null;
        }
        return lookup;
    }

    public static boolean isForPrivateResource(@NotNull CompletionResult result2, @NotNull ResourceVisibilityLookup lookup) {
        PsiClass rClass;
        Object obj = result2.getLookupElement().getObject();
        if (!(obj instanceof PsiField)) {
            return false;
        }
        PsiField psiField = (PsiField)obj;
        PsiClass containingClass = psiField.getContainingClass();
        if (containingClass != null && (rClass = containingClass.getContainingClass()) != null && "R".equals(rClass.getName())) {
            String resourceTypeName = containingClass.getName();
            if (resourceTypeName == null) {
                return false;
            }
            ResourceType type = ResourceType.fromClassName((String)containingClass.getName());
            if (type != null && lookup.isPrivate(type, psiField.getName())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isAllowedInAndroid(@NotNull String qName) {
        for (String aPackage : EXCLUDED_PACKAGES) {
            if (!qName.startsWith(aPackage + ".")) continue;
            return false;
        }
        return true;
    }

    private static class NonDeprecatedDecorator
    extends LookupElementDecorator<LookupElement> {
        protected NonDeprecatedDecorator(@NotNull LookupElement delegate2) {
            super(delegate2);
        }

        public void renderElement(LookupElementPresentation presentation) {
            super.renderElement(presentation);
            presentation.setStrikeout(false);
        }
    }
}

