/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.FileResourceReader;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.ui.resourcechooser.common.ResourcePickerSources;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.ui.resourcemanager.rendering.MultipleColorIcon;
import com.android.utils.HashCodes;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.MouseInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.xmlpull.v1.XmlPullParser;

public class AndroidAnnotatorUtil {
    static final int MAX_ICON_SIZE = 20000;
    private static final String SET_COLOR_COMMAND_NAME = "Change Color";
    private static final int ICON_SIZE = 8;

    @Nullable
    public static VirtualFile resolveDrawableFile(@NotNull ResourceValue resourceValue2, @NotNull ResourceResolver resourceResolver2, @NotNull AndroidFacet facet2) {
        Project project = facet2.getModule().getProject();
        VirtualFile file2 = IdeResourcesUtil.resolveDrawable((RenderResources)resourceResolver2, resourceValue2, project);
        if (file2 != null && file2.getPath().endsWith(".xml")) {
            file2 = AndroidAnnotatorUtil.pickBitmapFromXml(file2, resourceResolver2, project, facet2, resourceValue2);
        }
        return AndroidAnnotatorUtil.pickBestBitmap(file2);
    }

    @Nullable
    private static VirtualFile pickBitmapFromXml(@NotNull VirtualFile file2, @NotNull ResourceResolver resourceResolver2, @NotNull Project project, @NotNull AndroidFacet facet2, @NotNull ResourceValue resourceValue2) {
        try {
            String source;
            String tagName;
            XmlPullParser parser = FileResourceReader.createXmlPullParser(file2);
            if (parser == null) {
                return null;
            }
            if (parser.nextTag() != 2) {
                return null;
            }
            switch (tagName = parser.getName()) {
                case "vector": {
                    LocalResourceRepository resourceRepository = ResourceRepositoryManager.getAppResources(facet2);
                    List<ResourceItem> items2 = resourceRepository.getResources(resourceValue2.getNamespace(), resourceValue2.getResourceType(), resourceValue2.getName());
                    for (ResourceItem item : items2) {
                        Density density;
                        FolderConfiguration configuration = item.getConfiguration();
                        DensityQualifier densityQualifier = configuration.getDensityQualifier();
                        if (densityQualifier == null || (density = densityQualifier.getValue()) == null || !density.isValidValueForDevice()) continue;
                        return IdeResourcesUtil.getSourceAsVirtualFile(item);
                    }
                    return file2;
                }
                case "bitmap": 
                case "nine-patch": {
                    source = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "src");
                    break;
                }
                case "clip": 
                case "inset": 
                case "scale": {
                    source = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "drawable");
                    break;
                }
                case "layer-list": 
                case "level-list": 
                case "selector": 
                case "shape": 
                case "transition": {
                    return file2;
                }
                default: {
                    return null;
                }
            }
            if (source == null) {
                return null;
            }
            ResourceValue resValue = resourceResolver2.findResValue(source, resourceValue2.isFramework());
            return resValue == null ? null : IdeResourcesUtil.resolveDrawable((RenderResources)resourceResolver2, resValue, project);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    @Nullable
    public static VirtualFile pickBestBitmap(@Nullable VirtualFile bitmap) {
        if (bitmap != null && bitmap.exists()) {
            VirtualFile smallest = AndroidAnnotatorUtil.findSmallestDpiVersion(bitmap);
            if (smallest != null) {
                return smallest;
            }
            long length = bitmap.getLength();
            if (length < 20000L) {
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findSmallestDpiVersion(@NotNull VirtualFile bitmap) {
        VirtualFile parentFile = bitmap.getParent();
        if (parentFile == null) {
            return null;
        }
        VirtualFile resFolder = parentFile.getParent();
        if (resFolder == null) {
            return null;
        }
        String parentName = parentFile.getName();
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)parentName);
        if (config == null) {
            return null;
        }
        DensityQualifier qualifier = config.getDensityQualifier();
        if (qualifier == null) {
            return null;
        }
        Density density = qualifier.getValue();
        if (density != null && density.isValidValueForDevice()) {
            String fileName = bitmap.getName();
            Density[] densities = Density.values();
            int i2 = densities.length;
            while (--i2 >= 0) {
                String folderName;
                VirtualFile folder;
                Density d = densities[i2];
                if (!d.isValidValueForDevice() || (folder = resFolder.findChild(folderName = parentName.replace(density.getResourceValue(), d.getResourceValue()))) == null || (bitmap = folder.findChild(fileName)) == null) continue;
                if (bitmap.getLength() > 20000L) {
                    return null;
                }
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    public static Configuration pickConfiguration(@NotNull PsiFile file2, @NotNull AndroidFacet facet2) {
        VirtualFile nearestConfigurationFile;
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(facet2);
        if (!(file2 instanceof XmlFile)) {
            nearestConfigurationFile = IdeResourcesUtil.pickAnyLayoutFile(facet2);
            if (nearestConfigurationFile == null) {
                return Configuration.create(configurationManager, null, FolderConfiguration.createDefault());
            }
        } else {
            nearestConfigurationFile = virtualFile;
        }
        return configurationManager.getConfiguration(nearestConfigurationFile);
    }

    @NotNull
    public static FileType getFileType(@NotNull PsiElement element2) {
        return (FileType)ApplicationManager.getApplication().runReadAction(() -> {
            PsiFile file2 = element2.getContainingFile();
            if (file2 != null) {
                return file2.getFileType();
            }
            return UnknownFileType.INSTANCE;
        });
    }

    @Nullable
    private static String convertResourceAttributeToIdentifier(@NotNull String colorAttributeValue, @NotNull ResourceType resourceType) {
        int nameStartIndex = colorAttributeValue.lastIndexOf(47);
        if (nameStartIndex == -1) {
            return null;
        }
        String resourceName = colorAttributeValue.substring(nameStartIndex + 1);
        if (resourceName.isEmpty()) {
            return null;
        }
        StringBuilder builder2 = new StringBuilder();
        if (colorAttributeValue.startsWith("@android:")) {
            builder2.append("android.");
        }
        return builder2.append("R.").append(resourceType.getName()).append(".").append(resourceName).toString();
    }

    public static PsiElement setJavaOrKotlinAttribute(@NotNull PsiElement psiElement, @NotNull String attributeValue, @NotNull ResourceType resourceType) {
        String resourceIdentifier = AndroidAnnotatorUtil.convertResourceAttributeToIdentifier(attributeValue, resourceType);
        if (resourceIdentifier == null) {
            return psiElement;
        }
        if (psiElement instanceof PsiReferenceExpression) {
            PsiExpression expression2 = PsiElementFactory.getInstance((Project)psiElement.getProject()).createExpressionFromText(resourceIdentifier, psiElement);
            return psiElement.replace((PsiElement)expression2);
        }
        KtExpression expression3 = KtPsiFactoryKt.KtPsiFactory((Project)psiElement.getProject()).createExpression(resourceIdentifier);
        return psiElement.getParent().replace((PsiElement)expression3).getLastChild();
    }

    public static PsiElement setXmlAttribute(@NotNull PsiElement element2, @NotNull String attributeValue) {
        XmlAttribute xmlAttribute;
        if (element2 instanceof XmlTag) {
            XmlTagValue xmlTagValue = ((XmlTag)element2).getValue();
            xmlTagValue.setText(attributeValue);
        } else if (element2 instanceof XmlAttributeValue && (xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlAttribute.class)) != null) {
            xmlAttribute.setValue(attributeValue);
            return xmlAttribute.getValueElement();
        }
        return element2;
    }

    public static class SetAttributeConsumer
    implements Consumer<String> {
        private PsiElement myElement;
        private final Consumer<String> myAttributeConsumer;
        private final ResourceType myResourceType;

        public SetAttributeConsumer(PsiElement psiElement, ResourceType resourceType) {
            this.myElement = psiElement;
            this.myResourceType = resourceType;
            this.myAttributeConsumer = this.createSetAttributeTask();
        }

        @VisibleForTesting
        @NotNull
        public PsiElement getElement() {
            return this.myElement;
        }

        public void consume(String s) {
            this.myAttributeConsumer.consume((Object)s);
        }

        @NotNull
        private Consumer<String> createSetAttributeTask() {
            return attributeValue -> {
                PsiElement psiElement = this.myElement;
                if (psiElement instanceof PsiReferenceExpression || psiElement instanceof KtNameReferenceExpression) {
                    this.myElement = AndroidAnnotatorUtil.setJavaOrKotlinAttribute(psiElement, attributeValue, this.myResourceType);
                } else if (psiElement != null) {
                    this.myElement = AndroidAnnotatorUtil.setXmlAttribute(psiElement, attributeValue);
                }
            };
        }
    }

    public static class ColorRenderer
    extends GutterIconRenderer {
        @NotNull
        private PsiElement myElement;
        @Nullable
        private final Color myColor;
        @NotNull
        private final ResourceResolver myResolver;
        @Nullable
        private final ResourceReference myResourceReference;
        private final Consumer<String> mySetColorTask;
        private final boolean myIncludeClickAction;
        private final boolean myHasCustomColor;
        @Nullable
        private final Configuration myConfiguration;

        public ColorRenderer(@NotNull PsiElement element2, @Nullable Color color, @NotNull ResourceResolver resolver, @Nullable ResourceReference resourceReference, boolean hasCustomColor, @Nullable Configuration configuration) {
            this.myElement = element2;
            this.myColor = color;
            this.myResolver = resolver;
            this.myResourceReference = resourceReference;
            this.myIncludeClickAction = true;
            this.myHasCustomColor = hasCustomColor;
            this.mySetColorTask = new SetAttributeConsumer(element2, ResourceType.COLOR);
            this.myConfiguration = configuration;
        }

        @NotNull
        public Icon getIcon() {
            AndroidFacet facet2;
            if (this.myResourceReference != null && (facet2 = AndroidFacet.getInstance((PsiElement)this.myElement)) != null) {
                ResourceValue value2 = this.myResolver.getUnresolvedResource(this.myResourceReference);
                List<Color> colors = IdeResourcesUtil.resolveMultipleColors((RenderResources)this.myResolver, value2, this.myElement.getProject());
                if (!colors.isEmpty()) {
                    MultipleColorIcon icon2 = new MultipleColorIcon();
                    icon2.setColors(colors);
                    int scaledIconSize = JBUIScale.scale((int)8);
                    icon2.setWidth(scaledIconSize);
                    icon2.setHeight(scaledIconSize);
                    return icon2;
                }
                return JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)8));
            }
            Color color = this.getCurrentColor();
            return color == null ? JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)8)) : JBUI.scale((JBUI.JBIcon)new ColorIcon(8, color));
        }

        @Nullable
        private Color getCurrentColor() {
            if (this.myColor != null) {
                return this.myColor;
            }
            if (this.myElement instanceof XmlTag) {
                return IdeResourcesUtil.parseColor(((XmlTag)this.myElement).getValue().getText());
            }
            if (this.myElement instanceof XmlAttributeValue) {
                return IdeResourcesUtil.parseColor(((XmlAttributeValue)this.myElement).getValue());
            }
            return null;
        }

        public AnAction getClickAction() {
            if ((this.myElement instanceof PsiReferenceExpression || this.myElement instanceof KtNameReferenceExpression) && !((Boolean)StudioFlags.NELE_COLOR_RESOURCE_PICKER_FOR_FILE_EDITORS.get()).booleanValue()) {
                return null;
            }
            if (!this.myIncludeClickAction) {
                return null;
            }
            return new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
                    if (editor2 != null) {
                        this.openColorPicker(this.getCurrentColor());
                    }
                }
            };
        }

        @NotNull
        public PsiElement getElement() {
            return this.myElement;
        }

        private void openColorPicker(@Nullable Color currentColor) {
            ArrayList<ResourcePickerSources> pickerSources = new ArrayList<ResourcePickerSources>();
            pickerSources.add(ResourcePickerSources.PROJECT);
            pickerSources.add(ResourcePickerSources.ANDROID);
            pickerSources.add(ResourcePickerSources.LIBRARY);
            if (AndroidAnnotatorUtil.getFileType(this.myElement) == XmlFileType.INSTANCE) {
                pickerSources.add(ResourcePickerSources.THEME_ATTR);
            }
            ResourceChooserHelperKt.createAndShowColorPickerPopup(currentColor, this.myResourceReference, this.myConfiguration, pickerSources, null, MouseInfo.getPointerInfo().getLocation(), (Function1<? super Color, Unit>)(this.myHasCustomColor ? color -> {
                this.setColorToAttribute((Color)color);
                return null;
            } : null), (Function1<? super String, Unit>)((Function1)resourceString -> {
                this.setColorStringAttribute((String)resourceString);
                return null;
            }));
        }

        private void setColorToAttribute(@NotNull Color color) {
            this.setColorStringAttribute(IdeResourcesUtil.colorToString(color));
        }

        private void setColorStringAttribute(@NotNull String colorString) {
            Project project = this.myElement.getProject();
            ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)project, (String)AndroidAnnotatorUtil.SET_COLOR_COMMAND_NAME, null, () -> this.mySetColorTask.consume((Object)colorString), (PsiFile[])new PsiFile[0]), project.getDisposed());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ColorRenderer that = (ColorRenderer)((Object)o);
            if (!Objects.equals(this.myColor, that.myColor)) {
                return false;
            }
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            return HashCodes.mix((int)this.myElement.hashCode(), (int)Objects.hashCode(this.myColor));
        }
    }
}

