/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.android.tools.adtui.DocumentAccessor;
import com.android.tools.adtui.TextAccessors;
import com.android.tools.idea.ui.ApiComboBoxItem;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Objects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.TextAccessor;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class ScopedDataBinder
implements ScopedStateStore.ScopedStoreListener,
FocusListener,
ChangeListener,
ActionListener,
DocumentListener,
ItemListener {
    protected ScopedStateStore myState;
    private final Map<Document, JComponent> myDocumentsToComponent = Maps.newIdentityHashMap();
    private final Map<ScopedStateStore.Key, ValueDeriver> myValueDerivers = Maps.newHashMap();
    private final Table<JComponent, ScopedStateStore.Key<?>, ComponentBinding<?, ?>> myComponentBindings = HashBasedTable.create();
    private final Set<ScopedStateStore.Key> myGuardedKeys = Sets.newHashSet();
    private final Set<ScopedStateStore.Key> myUserEditedKeys = Sets.newHashSet();
    private boolean myAlreadySavingState;
    private JComponent myUpdateTrigger;

    public ScopedDataBinder() {
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.STEP, null, this);
    }

    @Override
    public <T> void invokeUpdate(@Nullable ScopedStateStore.Key<T> changedKey) {
        if (changedKey == null) {
            ImmutableSet allKeys = ImmutableSet.copyOf((Collection)this.myComponentBindings.columnKeySet());
            this.myGuardedKeys.addAll((Collection<ScopedStateStore.Key>)allKeys);
            for (ScopedStateStore.Key key : allKeys) {
                if (!this.myComponentBindings.containsColumn((Object)key)) continue;
                this.internalUpdateKey(key);
            }
            this.deriveValues(null);
        } else {
            this.myGuardedKeys.add(changedKey);
            this.internalUpdateKey(changedKey);
        }
    }

    private <T> void internalUpdateKey(@NotNull ScopedStateStore.Key<T> changedKey) {
        T value2 = this.myState.get(changedKey);
        ImmutableMap keyBindings = ImmutableMap.copyOf((Map)this.myComponentBindings.column(changedKey));
        for (Map.Entry entry : keyBindings.entrySet()) {
            JComponent component = (JComponent)entry.getKey();
            if (!this.myComponentBindings.contains((Object)component, changedKey) || Objects.equal((Object)component, (Object)this.myUpdateTrigger)) continue;
            ComponentBinding binding = (ComponentBinding)this.myComponentBindings.get((Object)component, changedKey);
            try {
                binding.setValue(value2, component);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        this.deriveValues(changedKey);
        this.myGuardedKeys.remove(changedKey);
    }

    private <T> void deriveValues(@Nullable ScopedStateStore.Key<T> changedKey) {
        for (ScopedStateStore.Key key : this.myValueDerivers.keySet()) {
            if (this.myGuardedKeys.contains(key)) continue;
            ValueDeriver deriver = this.myValueDerivers.get(key);
            if (this.myUserEditedKeys.contains(key) && deriver.respectUserEdits()) continue;
            Set<ScopedStateStore.Key<?>> triggerKeys = deriver.getTriggerKeys();
            if (changedKey != null && triggerKeys != null && !triggerKeys.contains(changedKey)) continue;
            this.deriveValue(key, deriver, changedKey);
        }
    }

    private <T> void deriveValue(@NotNull ScopedStateStore.Key<T> key, @NotNull ValueDeriver<T> deriver, @Nullable ScopedStateStore.Key<?> changedKey) {
        T currentValue = this.myState.get(key);
        T newValue = deriver.deriveValue(this.myState, changedKey, currentValue);
        if (newValue != null && !key.expectedClass.isInstance(newValue)) {
            throw new IllegalArgumentException(String.format("Deriver %1$s returned value for key %2$s of type %3$s, should be %4$s", deriver.toString(), key.name, newValue.getClass().getName(), key.expectedClass.getName()));
        }
        this.myState.put(key, newValue);
    }

    public <T> void saveState(@NotNull JComponent component) {
        if (this.myAlreadySavingState) {
            return;
        }
        this.myAlreadySavingState = true;
        for (Map.Entry entry : this.myComponentBindings.row((Object)component).entrySet()) {
            if (this.myGuardedKeys.contains(entry.getKey())) continue;
            ComponentBinding binding = (ComponentBinding)entry.getValue();
            try {
                Object value2 = binding.getValue(component);
                this.storeValue((ScopedStateStore.Key)entry.getKey(), component, value2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        this.myAlreadySavingState = false;
    }

    private <T> void storeValue(@NotNull ScopedStateStore.Key<T> key, @NotNull JComponent updateTrigger, @Nullable T value2) {
        T oldValue = this.myState.get(key);
        if (oldValue != null && !oldValue.equals(value2) && !this.myGuardedKeys.contains(key)) {
            this.myUserEditedKeys.add(key);
        }
        this.myUpdateTrigger = updateTrigger;
        this.myState.put(key, value2);
        this.myUpdateTrigger = null;
    }

    @Nullable
    private static Object getComponentValue(@NotNull JComponent component) {
        Object newValue = null;
        if (component instanceof JCheckBox) {
            newValue = ((JCheckBox)component).isSelected();
        } else if (component instanceof JComboBox) {
            Object selectedObject = ((JComboBox)component).getSelectedItem();
            if (selectedObject instanceof ApiComboBoxItem) {
                ApiComboBoxItem selectedItem = (ApiComboBoxItem)selectedObject;
                newValue = selectedItem.getData();
            } else {
                newValue = selectedObject;
            }
        } else if (component instanceof JSlider) {
            newValue = ((JSlider)component).getValue();
        } else if (component instanceof JSpinner) {
            newValue = ((JSpinner)component).getValue();
        } else if (component instanceof ColorPanel) {
            newValue = ((ColorPanel)component).getSelectedColor();
        } else {
            TextAccessor accessor = TextAccessors.getTextAccessor((JComponent)component);
            if (accessor != null) {
                newValue = accessor.getText();
            }
        }
        return newValue;
    }

    private static void setComponentValue(@Nullable Object value2, @NotNull JComponent component) {
        if (component instanceof JCheckBox) {
            ((JCheckBox)component).setSelected(Boolean.TRUE.equals(value2));
        } else if (component instanceof JComboBox) {
            ScopedDataBinder.setSelectedItem((JComboBox)component, value2);
        } else if (component instanceof JSlider) {
            assert (value2 != null);
            ((JSlider)component).setValue((Integer)value2);
        } else if (component instanceof JSpinner) {
            ((JSpinner)component).setValue(value2);
        } else if (component instanceof ColorPanel && value2 != null) {
            ((ColorPanel)component).setSelectedColor((Color)value2);
        } else {
            String newValue;
            TextAccessor accessor = TextAccessors.getTextAccessor((JComponent)component);
            if (accessor != null && !(newValue = StringUtil.notNullize((String)((String)value2))).equals(accessor.getText())) {
                accessor.setText(newValue);
            }
        }
    }

    public <T> void registerValueDeriver(@NotNull ScopedStateStore.Key<T> key, @NotNull ValueDeriver<T> deriver) {
        this.myValueDerivers.put(key, deriver);
    }

    public <T, C extends JComponent> void register(@NotNull ScopedStateStore.Key<T> key, @NotNull C component, @NotNull ComponentBinding<T, ? super C> binding) {
        T value2 = this.bindAndGet(key, component, binding);
        if (value2 != null) {
            try {
                binding.setValue(value2, component);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        } else {
            try {
                this.myState.put(key, binding.getValue(component));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        component.addFocusListener(this);
        binding.addActionListener(this, component);
        binding.addChangeListener(this, component);
        binding.addItemListener(this, component);
        Document document = binding.getDocument(component);
        if (document != null) {
            this.myDocumentsToComponent.put(document, component);
            document.addDocumentListener(this);
        }
    }

    @Nullable
    private <T> T bindAndGet(@NotNull ScopedStateStore.Key<T> key, @NotNull JComponent component, @Nullable ComponentBinding<T, ?> binding) {
        DefaultBinding b = binding == null ? new DefaultBinding() : binding;
        this.myComponentBindings.put((Object)component, key, (Object)b);
        return this.myState.get(key);
    }

    public void register(@NotNull ScopedStateStore.Key<Boolean> key, @NotNull JCheckBox checkBox) {
        Boolean value2 = this.bindAndGet(key, checkBox, null);
        if (value2 != null) {
            checkBox.setSelected(value2);
        } else {
            this.myState.put(key, false);
        }
        checkBox.addFocusListener(this);
        checkBox.addItemListener(this);
    }

    protected <T> void register(@NotNull ScopedStateStore.Key<T> key, @NotNull JComboBox comboBox) {
        T value2 = this.bindAndGet(key, comboBox, null);
        if (value2 != null) {
            ScopedDataBinder.setSelectedItem(comboBox, value2);
        }
        comboBox.addFocusListener(this);
        comboBox.addActionListener(this);
    }

    public static <T> void setSelectedItem(JComboBox comboBox, @Nullable T value2) {
        int index2 = -1;
        for (int i2 = 0; i2 < comboBox.getItemCount(); ++i2) {
            Object item = comboBox.getItemAt(i2);
            if (item instanceof ApiComboBoxItem) {
                item = ((ApiComboBoxItem)item).getData();
            }
            if (!Objects.equal(item, value2)) continue;
            index2 = i2;
            break;
        }
        comboBox.setSelectedIndex(index2);
    }

    public void register(@NotNull ScopedStateStore.Key<String> key, @NotNull JTextField textField) {
        this.myDocumentsToComponent.put(textField.getDocument(), textField);
        String value2 = this.bindAndGet(key, textField, null);
        if (value2 != null) {
            textField.setText(value2);
        } else {
            this.myState.put(key, textField.getText());
        }
        textField.addFocusListener(this);
        textField.getDocument().addDocumentListener(this);
    }

    public void register(@NotNull ScopedStateStore.Key<String> key, @NotNull JLabel label) {
        String value2 = this.bindAndGet(key, label, null);
        if (value2 != null) {
            label.setText(value2);
        } else {
            this.myState.put(key, label.getText());
        }
    }

    public void register(@NotNull ScopedStateStore.Key<Integer> key, @NotNull JSlider paddingSlider) {
        Integer value2 = this.bindAndGet(key, paddingSlider, null);
        if (value2 != null) {
            paddingSlider.setValue(value2);
        } else {
            this.myState.put(key, paddingSlider.getValue());
        }
        paddingSlider.addFocusListener(this);
        paddingSlider.addChangeListener(this);
    }

    public void register(@NotNull ScopedStateStore.Key<String> key, @NotNull TextFieldWithBrowseButton field2) {
        this.myDocumentsToComponent.put(field2.getTextField().getDocument(), (JComponent)field2);
        String value2 = this.bindAndGet(key, (JComponent)field2, null);
        if (value2 != null) {
            field2.setText(value2);
        } else {
            this.myState.put(key, field2.getText());
        }
        field2.addFocusListener((FocusListener)this);
        field2.getTextField().getDocument().addDocumentListener(this);
        field2.getTextField().addFocusListener(this);
    }

    public void register(@NotNull ScopedStateStore.Key<String> key, @NotNull DocumentAccessor field2) {
        assert (field2 instanceof JComponent);
        JComponent component = (JComponent)field2;
        String value2 = this.bindAndGet(key, component, null);
        if (value2 != null) {
            field2.setText(value2);
        } else {
            this.myState.put(key, field2.getText());
        }
        component.addFocusListener(this);
        this.myDocumentsToComponent.put(field2.getDocument(), component);
        field2.getDocument().addDocumentListener(this);
    }

    public void register(@NotNull ScopedStateStore.Key<Color> key, @NotNull ColorPanel colorPanel) {
        Color value2 = this.bindAndGet(key, (JComponent)colorPanel, null);
        if (value2 != null) {
            colorPanel.setSelectedColor(value2);
        } else {
            this.myState.put(key, colorPanel.getSelectedColor());
        }
        colorPanel.addFocusListener((FocusListener)this);
        colorPanel.addActionListener((ActionListener)this);
    }

    protected void deregister(JComponent component) {
        if (this.myComponentBindings.rowMap().remove(component) != null) {
            component.removeFocusListener(this);
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).removeItemListener(this);
            } else if (component instanceof JComboBox) {
                ((JComboBox)component).removeActionListener(this);
            } else if (component instanceof JTextField) {
                ((JTextField)component).getDocument().removeDocumentListener(this);
            } else if (component instanceof JRadioButton) {
                ((JRadioButton)component).removeActionListener(this);
            } else if (component instanceof JSlider) {
                ((JSlider)component).removeChangeListener(this);
            } else if (component instanceof JSpinner) {
                ((JSpinner)component).removeChangeListener(this);
            } else if (component instanceof TextFieldWithBrowseButton) {
                ((TextFieldWithBrowseButton)component).getTextField().getDocument().removeDocumentListener(this);
                ((TextFieldWithBrowseButton)component).getTextField().removeFocusListener(this);
            } else if (component instanceof ColorPanel) {
                ((ColorPanel)component).removeActionListener((ActionListener)this);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.saveState((JComponent)e.getSource());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.saveState((JComponent)e.getSource());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.saveState((JComponent)e.getSource());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.saveState(this.myDocumentsToComponent.get(e.getDocument()));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.saveState(this.myDocumentsToComponent.get(e.getDocument()));
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private static class DefaultBinding
    extends ComponentBinding<Object, JComponent> {
        private DefaultBinding() {
        }

        @Override
        public void setValue(@Nullable Object newValue, @NotNull JComponent component) {
            ScopedDataBinder.setComponentValue(newValue, component);
        }

        @Override
        @Nullable
        public Object getValue(@NotNull JComponent component) {
            return ScopedDataBinder.getComponentValue(component);
        }
    }

    public static abstract class ComponentBinding<T, C extends JComponent> {
        public void setValue(@Nullable T newValue, @NotNull C component) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public T getValue(@NotNull C component) {
            throw new UnsupportedOperationException();
        }

        public void addActionListener(@NotNull ActionListener listener2, @NotNull C component) {
        }

        public void addChangeListener(@NotNull ChangeListener listener2, @NotNull C component) {
        }

        public void addItemListener(@NotNull ItemListener listener2, @NotNull C component) {
        }

        @Nullable
        public Document getDocument(@NotNull C component) {
            return null;
        }
    }

    public static abstract class ValueDeriver<T> {
        public boolean respectUserEdits() {
            return true;
        }

        @Nullable
        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            return null;
        }

        @Nullable
        protected static Set<ScopedStateStore.Key<?>> makeSetOf(ScopedStateStore.Key<?> ... elements) {
            HashSet keys = new HashSet(elements.length);
            Collections.addAll(keys, elements);
            return keys;
        }

        @Nullable
        public abstract T deriveValue(@NotNull ScopedStateStore var1, @Nullable ScopedStateStore.Key var2, @Nullable T var3);
    }
}

