/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard.deprecated;

import com.android.sdklib.devices.Storage;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.ui.DeprecatedSpinnerValueProperty;
import com.android.tools.idea.observable.ui.SliderValueProperty;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.HaxmKt;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class HaxmInstallSettingsStep
extends FirstRunWizardStep {
    private static final int MAJOR_TICKS = 4;
    private static final int MINOR_TICKS = 512;
    private static final int MAX_TICK_RESOLUTION = 32;
    private static final int MIN_EMULATOR_MEMORY = 512;
    private final BindingsManager myBindings;
    private final IntProperty myEmulatorMemory;
    private final int myRecommendedMemorySize;
    private final ScopedStateStore.Key<Boolean> myKeyCustomInstall;
    private final BoolProperty myInstallHaxm;
    private JBScrollPane myRoot;
    private HyperlinkLabel myIntelHAXMDocumentationButton;
    private JSlider myMemorySlider;
    private JSpinner myMemorySize;
    private JLabel myUnitLabel;
    private JButton myRecommended;

    public HaxmInstallSettingsStep(@NotNull ScopedStateStore.Key<Boolean> keyCustomInstall, @NotNull BoolProperty installHaxm, @NotNull IntProperty emulatorMemory) {
        super("Emulator Settings");
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myKeyCustomInstall = keyCustomInstall;
        this.myInstallHaxm = installHaxm;
        this.myUnitLabel.setText(HaxmKt.UI_UNITS.toString());
        this.myEmulatorMemory = emulatorMemory;
        this.myIntelHAXMDocumentationButton.setHyperlinkText("Intel\u00ae HAXM Documentation");
        this.myIntelHAXMDocumentationButton.setHyperlinkTarget("https://github.com/intel/haxm");
        this.myRecommendedMemorySize = HaxmInstallSettingsStep.setupSliderAndSpinner(AvdManagerConnection.getMemorySize(), this.myMemorySlider, this.myMemorySize);
        this.setComponent((JComponent)this.myRoot);
        this.myRecommended.addActionListener(e -> this.myEmulatorMemory.set(this.myRecommendedMemorySize));
    }

    private static int setupSliderAndSpinner(long memorySize, @NotNull JSlider slider2, @NotNull JSpinner spinner) {
        int recommendedMemorySize = FirstRunWizardDefaults.getRecommendedHaxmMemory(memorySize);
        int maxMemory = Math.max(HaxmInstallSettingsStep.getMaxMemoryAllocation(memorySize), recommendedMemorySize);
        int ticks = Math.min(maxMemory / 32, 512);
        slider2.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 30));
        slider2.setMinimum(512);
        slider2.setMaximum(maxMemory);
        slider2.setMinorTickSpacing(maxMemory / ticks);
        slider2.setMajorTickSpacing(maxMemory / 4);
        Storage.Unit displayUnit = HaxmInstallSettingsStep.getMemoryDisplayUnit((long)maxMemory * HaxmKt.UI_UNITS.getNumberOfBytes());
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        int labelSpacing = Math.max((maxMemory - 512) / 4, 1);
        int minDistanceBetweenLabels = labelSpacing / 3;
        for (int i2 = maxMemory; i2 >= labelSpacing; i2 -= labelSpacing) {
            if (Math.abs(i2 - recommendedMemorySize) <= minDistanceBetweenLabels || i2 - 512 <= minDistanceBetweenLabels) continue;
            labels.put(i2, new JLabel(HaxmInstallSettingsStep.getMemoryLabel(i2, displayUnit)));
        }
        if (recommendedMemorySize - 512 > minDistanceBetweenLabels) {
            labels.put(512, new JLabel(HaxmInstallSettingsStep.getMemoryLabel(512, HaxmKt.UI_UNITS)));
        }
        labels.put(recommendedMemorySize, HaxmInstallSettingsStep.createRecommendedSizeLabel(recommendedMemorySize, displayUnit));
        slider2.setLabelTable(labels);
        spinner.setModel(new SpinnerNumberModel(512, 512, maxMemory, maxMemory / ticks));
        return recommendedMemorySize;
    }

    @NotNull
    private static JLabel createRecommendedSizeLabel(int memorySize, Storage.Unit displayUnit) {
        String labelText = String.format("<html><center>%s<br>(Recommended)<center></html>", HaxmInstallSettingsStep.getMemoryLabel(memorySize, displayUnit));
        final Font boldLabelFont = UIUtil.getLabelFont().deriveFont(1);
        return new JLabel(labelText){

            @Override
            public Font getFont() {
                return boldLabelFont;
            }
        };
    }

    private static int getMaxMemoryAllocation(long memorySize) {
        long GB = Storage.Unit.GiB.getNumberOfBytes();
        long maxMemory = memorySize > 4L * GB ? memorySize - 2L * GB : memorySize / 2L;
        return (int)(maxMemory / HaxmKt.UI_UNITS.getNumberOfBytes());
    }

    private static Storage.Unit getMemoryDisplayUnit(long memorySizeBytes) {
        Storage.Unit memUnits = Storage.Unit.B;
        for (Storage.Unit unit : Storage.Unit.values()) {
            if (unit.getNumberOfBytes() <= memUnits.getNumberOfBytes() || memorySizeBytes / unit.getNumberOfBytes() < 1L) continue;
            memUnits = unit;
        }
        return memUnits;
    }

    @NotNull
    private static String getMemoryLabel(int memorySize, Storage.Unit displayUnit) {
        long totalMemBytes = (long)memorySize * HaxmKt.UI_UNITS.getNumberOfBytes();
        return String.format(Locale.US, "%.1f %s", Float.valueOf((float)totalMemBytes / (float)displayUnit.getNumberOfBytes()), displayUnit.getDisplayValue());
    }

    @Override
    public boolean isStepVisible() {
        return !SystemInfo.isLinux && Boolean.TRUE.equals(this.myState.get(this.myKeyCustomInstall)) && (Boolean)this.myInstallHaxm.get() != false;
    }

    @Override
    public void init() {
        this.myBindings.bindTwoWay(new DeprecatedSpinnerValueProperty(this.myMemorySize), this.myEmulatorMemory);
        this.myBindings.bindTwoWay(new SliderValueProperty(this.myMemorySlider), this.myEmulatorMemory);
    }

    @Override
    @Nullable
    public JLabel getMessageLabel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMemorySlider;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JLabel jLabel;
        JSpinner jSpinner;
        JSlider jSlider;
        HyperlinkLabel hyperlinkLabel;
        JBScrollPane jBScrollPane;
        this.myRoot = jBScrollPane = new JBScrollPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("<html>We have detected that your system can run the Android emulator in an accelerated performance mode.</html>");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, new Dimension(10, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("<html>Set the maximum amount of RAM available for the Intel\u00ae Hardware Accelerated Execution Manager (HAXM) to use for all x86 emulator instances. You can change these settings at any time by running the Intel\u00ae HAXM installer.</html>");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 0, 1, 1, 0, null, new Dimension(10, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Refer to the ");
        Component component = jPanel2.add(jLabel4);
        this.myIntelHAXMDocumentationButton = hyperlinkLabel = new HyperlinkLabel();
        Component component2 = jPanel2.add((Component)hyperlinkLabel);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(" for more information.");
        Component component3 = jPanel2.add(jLabel5);
        this.myMemorySlider = jSlider = new JSlider();
        jSlider.setMajorTickSpacing(32);
        jSlider.setMaximum(512);
        jSlider.setMinorTickSpacing(0);
        jSlider.setPaintLabels(true);
        jSlider.setPaintTicks(false);
        jSlider.setPaintTrack(true);
        jSlider.setSnapToTicks(true);
        jSlider.setValueIsAdjusting(false);
        jPanel.add((Component)jSlider, new GridConstraints(6, 0, 1, 1, 0, 1, 3, 0, new Dimension(200, -1), new Dimension(750, -1), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(8, 0, 1, 1, 4, 2, 1, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("RAM allocation: ");
        jPanel3.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myMemorySize = jSpinner = new JSpinner();
        jPanel3.add((Component)jSpinner, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(100, -1), null));
        this.myUnitLabel = jLabel = new JLabel();
        jLabel.setText("MiB");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRecommended = jButton = new JButton();
        jButton.setText("Use recommended size");
        jPanel3.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer5 = new Spacer();
        jPanel.add((Component)spacer5, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        jLabel6.setLabelFor(jSpinner);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

