/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionHandlerBase;
import com.android.tools.idea.common.surface.InteractionHandlerKt;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.CanvasResizeInteraction;
import com.android.tools.idea.uibuilder.surface.DragDropInteraction;
import com.android.tools.idea.uibuilder.surface.MarqueeInteraction;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\bH\u0016J\"\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\"\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\bH\u0016J$\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\bH\u0016J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\"\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlInteractionHandler;", "Lcom/android/tools/idea/common/surface/InteractionHandlerBase;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "clickPreview", "", "x", "", "y", "needsFocusEditor", "", "createInteractionOnDrag", "Lcom/android/tools/idea/common/surface/Interaction;", "mouseX", "mouseY", "modifiersEx", "createInteractionOnPressed", "doubleClick", "getCursorWhenNoInteraction", "Ljava/awt/Cursor;", "isInResizeZone", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "singleClick", "intellij.android.designer"})
public final class NlInteractionHandler
extends InteractionHandlerBase {
    private final DesignSurface surface;

    @Override
    @Nullable
    public Interaction createInteractionOnPressed(int mouseX, int mouseY, int modifiersEx) {
        SceneView view;
        SceneView sceneView = this.surface.getSceneView(mouseX, mouseY);
        if (sceneView == null) {
            return null;
        }
        SceneView sceneView2 = view = sceneView;
        if (sceneView2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.uibuilder.surface.ScreenView");
        }
        ScreenView screenView = (ScreenView)sceneView2;
        if (this.isInResizeZone(view, mouseX, mouseY)) {
            Configuration configuration = ((ScreenView)view).getSceneManager().getModel().getConfiguration();
            DesignSurface designSurface = this.surface;
            if (designSurface == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.uibuilder.surface.NlDesignSurface");
            }
            return new CanvasResizeInteraction((NlDesignSurface)designSurface, screenView, configuration);
        }
        SelectionModel selectionModel = screenView.getSelectionModel();
        NlComponent component = Coordinates.findComponent(screenView, mouseX, mouseY);
        if (component == null) {
            if (!selectionModel.isEmpty()) {
                component = selectionModel.getPrimary();
            } else {
                return null;
            }
        }
        Interaction interaction = null;
        if (!selectionModel.isEmpty()) {
            ViewGroupHandler handler2;
            NlComponent parent;
            NlComponent primary;
            NlComponent nlComponent = primary = screenView.getSelectionModel().getPrimary();
            NlComponent nlComponent2 = parent = nlComponent != null ? nlComponent.getParent() : null;
            if (parent != null && (handler2 = NlComponentHelperKt.getViewGroupHandler(parent)) != null) {
                interaction = handler2.createInteraction(screenView, mouseX, mouseY, primary);
            }
        }
        if (interaction == null) {
            ViewGroupHandler viewGroupHandler;
            NlComponent nlComponent = component;
            ViewGroupHandler viewGroupHandler2 = viewGroupHandler = nlComponent != null ? NlComponentHelperKt.getViewGroupHandler(nlComponent) : null;
            if (viewGroupHandler != null) {
                NlComponent nlComponent3 = component;
                if (nlComponent3 == null) {
                    Intrinsics.throwNpe();
                }
                interaction = viewGroupHandler.createInteraction(screenView, mouseX, mouseY, nlComponent3);
            }
        }
        if (interaction == null) {
            interaction = new SceneInteraction(screenView);
        }
        return interaction;
    }

    private final boolean isInResizeZone(SceneView sceneView, int mouseX, int mouseY) {
        if (!sceneView.isResizeable() || !sceneView.getScene().isResizeAvailable()) {
            return false;
        }
        Dimension size = sceneView.getScaledContentSize();
        Rectangle resizeZone = new Rectangle(sceneView.getX() + size.width, sceneView.getY() + size.height, 48, 48);
        return resizeZone.contains(mouseX, mouseY);
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDrag(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        NlComponent primarySelectedComponent;
        SceneComponent primary;
        SceneView sceneView = this.surface.getSceneView(mouseX, mouseY);
        if (sceneView == null) {
            return null;
        }
        SceneView sceneView2 = sceneView;
        Scene scene = sceneView2.getScene();
        SelectionModel selectionModel = sceneView2.getSelectionModel();
        int xDp = Coordinates.getAndroidXDip(sceneView2, mouseX);
        int yDp = Coordinates.getAndroidYDip(sceneView2, mouseY);
        NlModel model2 = sceneView2.getModel();
        SceneComponent component = null;
        if (selectionModel.isEmpty() && !model2.getComponents().isEmpty()) {
            NlComponent nlComponent = ((NlComponent)model2.getComponents().get(0)).getRoot();
            if (nlComponent == null) {
                Intrinsics.throwNpe();
            }
            selectionModel.setSelection(CollectionsKt.listOf((Object)nlComponent));
        }
        if ((primary = scene.getSceneComponent(primarySelectedComponent = selectionModel.getPrimary())) != null && primary.getParent() != null && primary.containsX(xDp) && primary.containsY(yDp)) {
            component = primary;
        }
        if (component == null) {
            component = scene.findComponent(sceneView2.getContext(), xDp, yDp);
        }
        SceneComponent sceneComponent = component;
        if ((sceneComponent != null ? sceneComponent.getParent() : null) == null) {
            return new MarqueeInteraction(sceneView2);
        }
        SceneComponent sceneComponent2 = primary;
        if (sceneComponent2 == null) {
            sceneComponent2 = component;
        }
        SceneComponent primaryDraggedComponent = sceneComponent2;
        List dragged = null;
        if (this.surface.getSelectionModel().isSelected(component.getNlComponent())) {
            boolean bl = false;
            List selectedDraggedComponents = new ArrayList();
            NlComponent primaryNlComponent = null;
            if (primaryDraggedComponent.getParent() == null) {
                primaryNlComponent = null;
            } else {
                primaryNlComponent = primaryDraggedComponent.getNlComponent();
                selectedDraggedComponents.add(primaryNlComponent);
            }
            for (NlComponent selected : this.surface.getSelectionModel().getSelection()) {
                if (selected.isRoot() || selected == primaryNlComponent) continue;
                selectedDraggedComponents.add(selected);
            }
            dragged = selectedDraggedComponents;
        } else {
            dragged = CollectionsKt.listOf((Object)primaryDraggedComponent.getNlComponent());
        }
        return new DragDropInteraction(this.surface, dragged);
    }

    @Override
    public void singleClick(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        DesignSurface designSurface = this.surface;
        if (designSurface == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.uibuilder.surface.NlDesignSurface");
        }
        if (((NlDesignSurface)designSurface).isPreviewSurface()) {
            this.clickPreview(x, y, false);
        } else {
            super.singleClick(x, y, modifiersEx);
        }
    }

    @Override
    public void doubleClick(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        DesignSurface designSurface = this.surface;
        if (designSurface == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.uibuilder.surface.NlDesignSurface");
        }
        if (((NlDesignSurface)designSurface).isPreviewSurface()) {
            this.clickPreview(x, y, true);
        } else {
            super.doubleClick(x, y, modifiersEx);
        }
    }

    private final void clickPreview(int x, int y, boolean needsFocusEditor) {
        SceneView sceneView = this.surface.getSceneView(x, y);
        if (sceneView == null) {
            return;
        }
        SceneView sceneView2 = sceneView;
        int androidX = Coordinates.getAndroidXDip(sceneView2, x);
        int androidY = Coordinates.getAndroidYDip(sceneView2, y);
        SceneComponent sceneComponent = sceneView2.getScene().findComponent(sceneView2.getContext(), androidX, androidY);
        if (sceneComponent == null) {
            return;
        }
        SceneComponent sceneComponent2 = sceneComponent;
        DesignSurface designSurface = this.surface;
        if (designSurface == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.uibuilder.surface.NlDesignSurface");
        }
        NlDesignSurface.NavigationHandler navigationHandler = ((NlDesignSurface)designSurface).getNavigationHandler();
        if (navigationHandler == null || !navigationHandler.handleNavigate(sceneView2, sceneComponent2, x, y, needsFocusEditor)) {
            InteractionHandlerKt.navigateToComponent(sceneComponent2.getNlComponent(), needsFocusEditor);
        }
    }

    @Override
    @Nullable
    public Cursor getCursorWhenNoInteraction(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        SceneView sceneView = this.surface.getSceneView(mouseX, mouseY);
        if (sceneView != null && this.isInResizeZone(sceneView, mouseX, mouseY)) {
            return Cursor.getPredefinedCursor(5);
        }
        return super.getCursorWhenNoInteraction(mouseX, mouseY, modifiersEx);
    }

    public NlInteractionHandler(@NotNull DesignSurface surface2) {
        super(surface2);
        this.surface = surface2;
    }
}

