/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.SdkConstants;
import com.android.resources.Density;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\f\u0010\u000e\u001a\u00020\f*\u00020\rH\u0007\u001a\u0012\u0010\u000f\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"CUSTOM_DENSITY_ID", "", "updateConfigurationScreenSize", "", "configuration", "Lcom/android/tools/idea/configurations/Configuration;", "xDimension", "", "yDimension", "original", "Lcom/android/sdklib/devices/Device;", "currentActivityIsDerivedFromAppCompatActivity", "", "Lcom/android/tools/idea/common/model/NlModel;", "moduleDependsOnAppCompat", "overrideConfigurationDensity", "density", "Lcom/android/resources/Density;", "intellij.android.designer"})
public final class NlModelHelperKt {
    @NotNull
    public static final String CUSTOM_DENSITY_ID = "Custom Density";

    @JvmOverloads
    public static final void updateConfigurationScreenSize(@NotNull Configuration configuration, int xDimension, int yDimension, @Nullable Device original) {
        if (original == null) {
            return;
        }
        Device.Builder deviceBuilder = new Device.Builder(original);
        deviceBuilder.setTagId(original.getTagId());
        deviceBuilder.setName("Custom");
        deviceBuilder.setId("Custom");
        Device device = deviceBuilder.build();
        for (State state : device.getAllStates()) {
            Screen screen = state.getHardware().getScreen();
            screen.setXDimension(xDimension);
            screen.setYDimension(yDimension);
            double dpi = screen.getPixelDensity().getDpiValue();
            double width = (double)xDimension / dpi;
            double height = (double)yDimension / dpi;
            double diagonalLength = Math.sqrt(width * width + height * height);
            screen.setDiagonalLength(diagonalLength);
            screen.setSize(ScreenSize.getScreenSize((Double)diagonalLength));
            screen.setRatio(AvdScreenData.getScreenRatio(xDimension, yDimension));
            screen.setScreenRound(device.getDefaultHardware().getScreen().getScreenRound());
            screen.setChin(device.getDefaultHardware().getScreen().getChin());
        }
        State newState = xDimension > yDimension ? device.getState("Landscape") : device.getState("Portrait");
        configuration.setEffectiveDevice(device, newState);
    }

    public static /* synthetic */ void updateConfigurationScreenSize$default(Configuration configuration, int n, int n2, Device device, int n3, Object object) {
        if ((n3 & 8) != 0) {
            device = configuration.getCachedDevice();
        }
        NlModelHelperKt.updateConfigurationScreenSize(configuration, n, n2, device);
    }

    @JvmOverloads
    public static final void updateConfigurationScreenSize(@NotNull Configuration configuration, int xDimension, int yDimension) {
        NlModelHelperKt.updateConfigurationScreenSize$default(configuration, xDimension, yDimension, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void overrideConfigurationDensity(@NotNull NlModel $this$overrideConfigurationDensity, @NotNull Density density) {
        void $this$mapTo$iv$iv;
        Device device = $this$overrideConfigurationDensity.getConfiguration().getCachedDevice();
        if (device == null) {
            return;
        }
        Device original = device;
        Device.Builder deviceBuilder = new Device.Builder(original);
        deviceBuilder.setTagId(original.getTagId());
        deviceBuilder.setName("Custom");
        deviceBuilder.setId(CUSTOM_DENSITY_ID);
        Device device2 = deviceBuilder.build();
        Iterable $this$map$iv = device2.getAllStates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            State state = (State)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Screen screen = it.getHardware().getScreen();
            collection2.add(screen);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Screen it = (Screen)element$iv;
            boolean bl = false;
            it.setPixelDensity(density);
        }
        $this$overrideConfigurationDensity.getConfiguration().setEffectiveDevice(device2, device2.getDefaultState());
    }

    @Deprecated(message="Use NlModel.module.dependsOnAppCompat()", replaceWith=@ReplaceWith(imports={}, expression="com.android.tools.idea.util.dependsOnAppCompat()"))
    public static final boolean moduleDependsOnAppCompat(@NotNull NlModel $this$moduleDependsOnAppCompat) {
        return DependencyManagementUtil.dependsOnAppCompat($this$moduleDependsOnAppCompat.getModule());
    }

    public static final boolean currentActivityIsDerivedFromAppCompatActivity(@NotNull NlModel $this$currentActivityIsDerivedFromAppCompatActivity) {
        PsiClass activityClass;
        String activityClassName;
        String string = $this$currentActivityIsDerivedFromAppCompatActivity.getConfiguration().getActivity();
        if (string == null) {
            return true;
        }
        String string2 = activityClassName = string;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        if (StringsKt.startsWith$default((String)string2, (String)".", (boolean)false, (int)2, null)) {
            String pkg = StringUtil.notNullize((String)AndroidManifestUtils.getPackageName($this$currentActivityIsDerivedFromAppCompatActivity.getFacet()));
            activityClassName = pkg + activityClassName;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)$this$currentActivityIsDerivedFromAppCompatActivity.getProject());
        for (activityClass = facade.findClass(activityClassName, $this$currentActivityIsDerivedFromAppCompatActivity.getModule().getModuleScope()); activityClass != null && !SdkConstants.CLASS_APP_COMPAT_ACTIVITY.isEquals(activityClass.getQualifiedName()); activityClass = activityClass.getSuperClass()) {
        }
        return activityClass != null;
    }
}

