/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.MockupFileHelper;
import com.android.tools.idea.uibuilder.mockup.editor.creators.FloatingActionButtonCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.viewgroupattributes.ViewGroupAttributesManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Color;
import java.awt.Rectangle;
import java.nio.file.Path;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WidgetCreator {
    private static final String COLORS_XML = "colors.xml";
    private final NlModel myModel;
    private final SceneView myScreenView;
    @NotNull
    private Mockup myMockup;
    @Nullable
    private NlComponent myComponent;
    @Nullable
    private ViewGroupAttributesManager myViewGroupAttributesManager;

    protected WidgetCreator(@NotNull Mockup mockup, @NotNull NlModel model2, @NotNull SceneView screenView) {
        this.myMockup = mockup;
        this.myModel = model2;
        this.myScreenView = screenView;
    }

    protected static void createColorResource(@NotNull String colorName, @NotNull Color color, @NotNull NlModel model2) {
        if (colorName.isEmpty()) {
            Logger.getInstance(FloatingActionButtonCreator.class).error("The color name can't be empty. Aborting color resource creation");
            return;
        }
        VirtualFile primaryResourceDir = ResourceFolderManager.getInstance(model2.getFacet()).getPrimaryFolder();
        FolderConfiguration configForFolder = FolderConfiguration.getConfigForFolder((String)ResourceFolderType.VALUES.getName());
        if (primaryResourceDir != null && configForFolder != null) {
            IdeResourcesUtil.createValueResource(model2.getProject(), primaryResourceDir, colorName, ResourceType.COLOR, COLORS_XML, Collections.singletonList(configForFolder.getFolderName(ResourceFolderType.VALUES)), String.format("#%06X", color.getRGB()));
        }
    }

    public void setViewGroupAttributesManager(@Nullable ViewGroupAttributesManager viewGroupAttributesManager) {
        this.myViewGroupAttributesManager = viewGroupAttributesManager;
    }

    @NotNull
    protected final Mockup getMockup() {
        return this.myMockup;
    }

    protected final NlModel getModel() {
        return this.myModel;
    }

    @NotNull
    public SceneView getScreenView() {
        return this.myScreenView;
    }

    protected abstract void addAttributes(@NotNull AttributesTransaction var1);

    @Nullable
    public NlComponent addToModel() {
        this.ensureNewComponentCreated();
        assert (this.myComponent != null);
        AttributesTransaction transaction = this.myComponent.startAttributeTransaction();
        this.addAttributes(transaction);
        if (this.myViewGroupAttributesManager != null) {
            this.myViewGroupAttributesManager.addLayoutAttributes(transaction);
        }
        transaction.commit();
        this.myModel.addComponents(Collections.singletonList(this.myComponent), this.myMockup.getComponent(), null, InsertType.CREATE_PREVIEW, this.myScreenView.getSurface());
        return this.myComponent;
    }

    public boolean hasOptionsComponent() {
        return false;
    }

    @Nullable
    public JComponent getOptionsComponent(@NotNull DoneCallback doneCallback) {
        return null;
    }

    protected void addSizeAttributes(@NotNull AttributesTransaction transaction, @NotNull Rectangle bounds2) {
        transaction.setAttribute(null, "android:layout_width", String.format("%ddp", Coordinates.pxToDp(this.myModel, bounds2.width)));
        transaction.setAttribute(null, "android:layout_height", String.format("%ddp", Coordinates.pxToDp(this.myModel, bounds2.height)));
    }

    protected void addLayoutEditorPositionAttribute(@NotNull AttributesTransaction transaction, @NotNull Rectangle bounds2) {
        transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", String.format("%ddp", Coordinates.pxToDp(this.myModel, bounds2.x)));
        transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", String.format("%ddp", Coordinates.pxToDp(this.myModel, bounds2.y)));
    }

    protected void addMockupAttributes(@NotNull AttributesTransaction transaction, @NotNull Rectangle bounds2) {
        this.ensureNewComponentCreated();
        assert (this.myComponent != null);
        Mockup newMockup = Mockup.create(this.myComponent, true);
        if (newMockup == null) {
            return;
        }
        Rectangle cropping = this.myMockup.getComputedCropping();
        newMockup.setCropping(cropping.x + bounds2.x, cropping.y + bounds2.y, bounds2.width, bounds2.height);
        transaction.setAttribute("http://schemas.android.com/tools", "mockup_crop", MockupFileHelper.getPositionString(newMockup));
        transaction.setAttribute("http://schemas.android.com/tools", "mockup", WidgetCreator.getMockupImagePath(this.myMockup));
    }

    private void ensureNewComponentCreated() {
        if (this.myComponent == null) {
            XmlTag parentTag = this.myMockup.getComponent().getTagDeprecated();
            XmlTag childTag = parentTag.createChildTag(this.getAndroidViewTag(), null, null, false);
            this.myComponent = this.myModel.createComponent(childTag);
        }
    }

    @NotNull
    private static String getMockupImagePath(@NotNull Mockup mockup) {
        Path xmlFilePath = MockupFileHelper.getXMLFilePath(mockup.getComponent().getModel().getProject(), mockup.getFilePath());
        return xmlFilePath != null ? xmlFilePath.toString() : "";
    }

    @NotNull
    public abstract String getAndroidViewTag();

    public static class ColorResourceHolder {
        @Nullable
        public Color value;
        @Nullable
        public String name;

        public ColorResourceHolder(@Nullable Color value2, @Nullable String name) {
            this.value = value2;
            this.name = name;
        }
    }

    public static interface DoneCallback {
        public static final int FINISH = 1;
        public static final int CANCEL = 0;

        public void done(int var1);
    }
}

