/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.SimpleViewCreator;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.utils.SdkUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Rectangle;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class IncludeTagCreator
extends SimpleViewCreator {
    private String myNewLayoutResource;

    public IncludeTagCreator(@NotNull Mockup mockup, @NotNull NlModel model2, @NotNull SceneView screenView, @NotNull Rectangle selection) {
        super(mockup, model2, screenView, selection);
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        this.myNewLayoutResource = this.createNewIncludedLayout();
        super.addAttributes(transaction);
        if (this.myNewLayoutResource != null) {
            IncludeTagCreator.addIncludeAttribute(transaction, this.myNewLayoutResource);
        }
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        return "include";
    }

    @Override
    public NlComponent addToModel() {
        NlComponent component = this.getMockup().getComponent();
        if (NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.CLASS_RECYCLER_VIEW_V7)) {
            this.addListItemAttribute(component);
            return component;
        }
        return super.addToModel();
    }

    private void addListItemAttribute(NlComponent component) {
        String newLayoutResource = this.createNewIncludedLayout();
        NlWriteCommandActionUtil.run(component, "Add listitem attribute", () -> component.setAttribute("http://schemas.android.com/tools", "listitem", "@layout/" + newLayoutResource));
    }

    private static void addIncludeAttribute(@NotNull AttributesTransaction transaction, @NotNull String resourceName) {
        transaction.setAttribute(null, "layout", "@layout/" + resourceName);
    }

    private String createNewIncludedLayout() {
        AndroidFacet facet2 = this.getMockup().getComponent().getModel().getFacet();
        XmlFile newFile = CreateResourceFileAction.createFileResource(facet2, ResourceFolderType.LAYOUT, null, null, null, true, null, null, null, false);
        if (newFile == null) {
            return null;
        }
        XmlTag rootTag = newFile.getRootTag();
        if (rootTag == null) {
            return null;
        }
        DesignSurface surface2 = this.getScreenView().getSurface();
        final LayoutlibSceneManager manager = (LayoutlibSceneManager)surface2.getSceneManager();
        if (manager != null) {
            VirtualFile virtualFile = newFile.getVirtualFile();
            final NlModel model2 = NlModel.builder(facet2, virtualFile, ConfigurationManager.getOrCreateInstance(facet2).getConfiguration(virtualFile)).withParentDisposable((Disposable)newFile.getProject()).withComponentRegistrar(surface2.getComponentRegistrar()).build();
            manager.addRenderListener(new RenderListener(){

                @Override
                public void onRenderCompleted() {
                    manager.removeRenderListener(this);
                    if (model2.getComponents().isEmpty()) {
                        return;
                    }
                    NlComponent component = (NlComponent)model2.getComponents().get(0);
                    AttributesTransaction transaction = component.startAttributeTransaction();
                    IncludeTagCreator.this.addShowInAttribute(transaction);
                    IncludeTagCreator.this.addSizeAttributes(transaction, IncludeTagCreator.this.getAndroidBounds());
                    IncludeTagCreator.this.addMockupAttributes(transaction, IncludeTagCreator.this.getSelectionBounds());
                    NlWriteCommandActionUtil.run(component, "", transaction::commit);
                }
            });
        }
        return SdkUtils.fileNameToResourceName((String)newFile.getName());
    }

    private void addShowInAttribute(@NotNull AttributesTransaction transaction) {
        String showInName = SdkUtils.fileNameToResourceName((String)this.getModel().getFile().getName());
        transaction.setAttribute("http://schemas.android.com/tools", "showIn", "@layout/" + showInName);
    }
}

