/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.mockup.MockupFileHelper;
import com.android.tools.idea.uibuilder.mockup.editor.DeviceSelectionPopup;
import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.PixelProbe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class MockUpFileChooser {
    public static final MockUpFileChooser INSTANCE = new MockUpFileChooser();
    private String myLastOpenedFileName = null;

    private MockUpFileChooser() {
    }

    public void chooseMockUpFile(@NotNull NlComponent component, @NotNull Consumer<String> callback2) {
        VirtualFile file2;
        String fileName = component.getAttribute("http://schemas.android.com/tools", "mockup");
        VirtualFile virtualFile2 = file2 = fileName != null ? MockUpFileChooser.getVirtualFile(fileName) : null;
        if (file2 == null && this.myLastOpenedFileName != null) {
            file2 = MockUpFileChooser.getVirtualFile(this.myLastOpenedFileName);
        }
        FileChooser.chooseFile((FileChooserDescriptor)MockupFileHelper.getFileChooserDescriptor(), null, null, (VirtualFile)file2, virtualFile -> this.handleFileSelection(component, (VirtualFile)virtualFile, callback2));
    }

    private void handleFileSelection(@NotNull NlComponent component, @NotNull VirtualFile virtualFile, @NotNull Consumer<String> callback2) {
        if (!virtualFile.exists() || virtualFile.isDirectory()) {
            return;
        }
        this.myLastOpenedFileName = virtualFile.getPath();
        if (component.isRoot()) {
            MockUpFileChooser.openDeviceChoiceDialog(component, virtualFile, callback2);
        } else {
            MockUpFileChooser.accept(component, virtualFile, callback2);
        }
    }

    private static void accept(@NotNull NlComponent component, @NotNull VirtualFile virtualFile, @NotNull Consumer<String> callback2) {
        Path path2 = MockupFileHelper.getXMLFilePath(component.getModel().getProject(), virtualFile.getPath());
        if (path2 != null) {
            callback2.accept(path2.toString());
        }
    }

    private static void openDeviceChoiceDialog(@NotNull NlComponent component, @NotNull VirtualFile virtualFile, @NotNull Consumer<String> callback2) {
        try {
            Image probe = PixelProbe.probe((InputStream)virtualFile.getInputStream());
            BufferedImage image = probe.getMergedImage();
            if (image == null) {
                return;
            }
            NlModel model2 = component.getModel();
            Configuration configuration = model2.getConfiguration();
            Device device = configuration.getDevice();
            if (device == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                DeviceSelectionPopup deviceSelectionPopup = new DeviceSelectionPopup(model2.getProject(), configuration, image);
                if (deviceSelectionPopup.showAndGet()) {
                    MockUpFileChooser.accept(component, virtualFile, callback2);
                }
            });
        }
        catch (IOException e1) {
            Logger.getInstance(MockUpFileChooser.class).warn("Unable to open this file\n" + e1.getMessage());
        }
    }

    private static VirtualFile getVirtualFile(@NotNull String fileName) {
        return VfsUtil.findFileByIoFile((File)new File(FileUtil.toSystemIndependentName((String)fileName)), (boolean)false);
    }
}

