/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2.action;

import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTagWriter;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionLayoutAttributesModel;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionSelection;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.property.panel.api.InspectorLineModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubSectionControlAction
extends AnAction {
    private final NelePropertyItem myProperty;
    private InspectorLineModel myLineModel;
    private LookupResult myLookupResult;

    public SubSectionControlAction(@Nullable NelePropertyItem property2) {
        this.myProperty = property2;
        this.myLookupResult = new LookupResult();
    }

    public void setLineModel(@NotNull InspectorLineModel lineModel) {
        this.myLineModel = lineModel;
        this.myLineModel.setEnabled(this.check());
    }

    public void update(@NotNull AnActionEvent event) {
        boolean isPresent = this.check();
        Presentation presentation = event.getPresentation();
        presentation.setDescription(this.getCommandName(isPresent));
        presentation.setIcon(isPresent ? AllIcons.Diff.GutterCheckBoxSelected : AllIcons.Diff.GutterCheckBox);
        if (this.myLineModel != null) {
            this.myLineModel.setEnabled(isPresent);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        boolean isPresent = this.check();
        String commandName = this.getCommandName(isPresent);
        if (commandName == null) {
            return;
        }
        if (isPresent) {
            MotionSceneTagWriter tagWriter = this.myLookupResult.subTag.getTagWriter();
            tagWriter.deleteTag();
            tagWriter.commit(commandName);
        } else {
            MTag.TagWriter tagWriter = MotionLayoutAttributesModel.createSubTag(this.myLookupResult.selection, this.myLookupResult.tag, this.myLookupResult.subTagName);
            tagWriter.commit(commandName);
        }
    }

    private boolean check() {
        if (this.myProperty == null) {
            return false;
        }
        MotionSelection selection = MotionLayoutAttributesModel.getMotionSelection(this.myProperty);
        String subTagName = MotionLayoutAttributesModel.getSubTag(this.myProperty);
        if (selection == null || subTagName == null || selection.getType() != MotionEditorSelector.Type.CONSTRAINT && selection.getType() != MotionEditorSelector.Type.TRANSITION) {
            return false;
        }
        MotionSceneTag tag = selection.getMotionSceneTag();
        if (tag == null) {
            return false;
        }
        MotionSceneTag subTag = MotionLayoutAttributesModel.getSubTag(tag, subTagName);
        this.myLookupResult.selection = selection;
        this.myLookupResult.tag = tag;
        this.myLookupResult.subTagName = subTagName;
        this.myLookupResult.subTag = subTag;
        return subTag != null;
    }

    @Nullable
    private String getCommandName(boolean isPresent) {
        String subTagName = this.myLookupResult.subTagName;
        if (subTagName == null) {
            return null;
        }
        if (!isPresent) {
            return String.format("Create %1$s tag", subTagName);
        }
        return String.format("Remove %1$s tag", subTagName);
    }

    private static class LookupResult {
        MotionSelection selection;
        MotionSceneTag tag;
        String subTagName;
        MotionSceneTag subTag;

        private LookupResult() {
        }
    }
}

