/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.NlComponentTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEList;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEScrollPane;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.METabbedPane;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateConstraintSet;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateOnClick;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateOnSwipe;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateTransition;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.CombinedListPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.ConstraintSetPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.ErrorPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.LayoutPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MTagActionListener;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.OverviewPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.TransitionPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class MotionEditor
extends JPanel {
    public static final boolean DEBUG = false;
    private final JPanel mMainPanel;
    private CardLayout mErrorSwitchCard;
    public Track myTrack = new Track();
    ErrorPanel myErrorPanel = new ErrorPanel();
    MeModel mMeModel;
    MotionEditorSelector mMotionEditorSelector = new MotionEditorSelector();
    JTabbedPane mTabbedTopPane = new METabbedPane();
    MotionScenePanel mMotionSceneTabb = new MotionScenePanel();
    private TransitionPanel mTransitionPanel = new TransitionPanel(this);
    ConstraintSetPanel mConstraintSetPanel = new ConstraintSetPanel();
    LayoutPanel mLayoutPanel = new LayoutPanel();
    CombinedListPanel mCombinedListPanel = new CombinedListPanel();
    OverviewPanel mOverviewPanel = new OverviewPanel();
    JScrollPane mOverviewScrollPane = new MEScrollPane(this.mOverviewPanel);
    CardLayout mCardLayout = new CardLayout();
    JPanel mCenterPanel = new JPanel(this.mCardLayout);
    JButton mCreateGestureToolbarButton;
    JButton mCreateTransitionToolbarButton;
    private static final String LAYOUT_PANEL = "Layout";
    private static final String TRANSITION_PANEL = "Transition";
    private static final String CONSTRAINTSET_PANEL = "ConstraintSet";
    private String mCurrentlyDisplaying = "ConstraintSet";
    private final List<Command> myCommandListeners = new ArrayList<Command>();
    CreateConstraintSet mCreateConstraintSet = new CreateConstraintSet();
    CreateOnClick mCreateOnClick = new CreateOnClick();
    CreateOnSwipe mCreateOnSwipe = new CreateOnSwipe();
    CreateTransition mCreateTransition = new CreateTransition();
    JSplitPane mTopPanel;
    boolean mUpdatingModel;
    JPopupMenu myPopupMenu = new JPopupMenu();
    private static final String MAIN_PANEL = "main";
    private static final String ERROR_PANEL = "error";
    private int mFlags;
    LayoutMode mLayoutMode = null;
    private MTag mSelectedTag;

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.mMotionSceneTabb != null) {
            this.myErrorPanel.updateUI();
            this.mMotionSceneTabb.updateUI();
            this.mTransitionPanel.updateUI();
            this.mConstraintSetPanel.updateUI();
            this.mLayoutPanel.updateUI();
            this.mCombinedListPanel.updateUI();
            this.mOverviewScrollPane.updateUI();
            this.mCenterPanel.updateUI();
            this.myPopupMenu.updateUI();
            int n = this.myPopupMenu.getComponentCount();
            for (int i2 = 0; i2 < n; ++i2) {
                Component component = this.myPopupMenu.getComponent(i2);
                if (!(component instanceof JComponent)) continue;
                ((JComponent)component).updateUI();
            }
        }
    }

    public void selectById(String[] ids2) {
        switch (this.mCurrentlyDisplaying) {
            case "Layout": {
                this.mLayoutPanel.selectByIds(ids2);
                break;
            }
            case "ConstraintSet": {
                this.mConstraintSetPanel.selectById(ids2);
                break;
            }
        }
    }

    public void addCommandListener(Command command) {
        this.myCommandListeners.add(command);
    }

    private void fireCommand(Command.Action action2, MTag[] tags2) {
        for (Command listener2 : this.myCommandListeners) {
            listener2.perform(action2, tags2);
        }
    }

    public void stopAnimation() {
        this.mTransitionPanel.mTimeLinePanel.stopAnimation();
    }

    public void dataChanged() {
        this.setMTag(this.mMeModel);
    }

    public MotionEditor() {
        super(new CardLayout());
        this.mErrorSwitchCard = (CardLayout)this.getLayout();
        this.mMainPanel = new JPanel(new BorderLayout());
        this.add((Component)this.mMainPanel, MAIN_PANEL);
        this.add((Component)this.myErrorPanel, ERROR_PANEL);
        this.mErrorSwitchCard.show(this, MAIN_PANEL);
        this.mOverviewScrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel ui = new JPanel(new GridLayout(2, 1));
        this.mCombinedListPanel.setSelectionListener(e -> this.listSelection());
        this.mMotionEditorSelector.addSelectionListener(new MotionEditorSelector.Listener(){

            @Override
            public void selectionChanged(MotionEditorSelector.Type selection, MTag[] tag, int flags) {
                MotionEditor.this.mMeModel.setSelected(selection, tag);
            }
        });
        ui.setBackground(MEUI.ourPrimaryPanelBackground);
        this.mCombinedListPanel.setPreferredSize(new Dimension(10, 100));
        this.mTopPanel = new JSplitPane(1, this.mCombinedListPanel, this.mOverviewScrollPane);
        this.mTopPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, MEUI.ourBorder));
        ui.add(this.mTopPanel);
        ui.add((Component)this.mCenterPanel, "Center");
        this.mCenterPanel.add((Component)this.mTransitionPanel, TRANSITION_PANEL);
        this.mCenterPanel.add((Component)this.mConstraintSetPanel, CONSTRAINTSET_PANEL);
        this.mCenterPanel.add((Component)this.mLayoutPanel, LAYOUT_PANEL);
        this.mTransitionPanel.setListeners(this.mMotionEditorSelector);
        this.mConstraintSetPanel.setListeners(this.mMotionEditorSelector);
        this.mLayoutPanel.setListeners(this.mMotionEditorSelector);
        this.mCenterPanel.setBackground(MEUI.ourPrimaryPanelBackground);
        this.mLayoutPanel.setBackground(MEUI.ourPrimaryPanelBackground);
        this.mConstraintSetPanel.setBackground(MEUI.ourPrimaryPanelBackground);
        this.mCombinedListPanel.setBackground(MEUI.ourPrimaryPanelBackground);
        this.mOverviewPanel.setBorder(BorderFactory.createEmptyBorder());
        this.mTransitionPanel.addTimeLineListener(new MotionEditorSelector.TimeLineListener(){

            @Override
            public void command(MotionEditorSelector.TimeLineCmd cmd, float pos) {
                switch (cmd) {
                    case MOTION_PROGRESS: {
                        MotionEditor.this.mOverviewPanel.setTransitionProgress(pos);
                        break;
                    }
                    case MOTION_SCRUB: 
                    case MOTION_PLAY: {
                        break;
                    }
                    case MOTION_STOP: {
                        MotionEditor.this.mOverviewPanel.setTransitionProgress(Float.NaN);
                    }
                }
            }
        });
        MTagActionListener mTagActionListener = new MTagActionListener(){

            @Override
            public void select(MTag selected, int flags) {
                MotionEditor.this.selectTag(selected, flags);
            }

            @Override
            public void delete(MTag[] tags2, int flags) {
                MotionEditor.this.fireCommand(Command.Action.DELETE, tags2);
            }
        };
        this.mOverviewPanel.setActionListener(mTagActionListener);
        this.mTransitionPanel.setActionListener(mTagActionListener);
        this.mMainPanel.add(ui);
        JPanel toolbarLeft = new JPanel(new FlowLayout(0));
        JPanel toolbarRight = new JPanel(new FlowLayout(2));
        JPanel toolbar2 = new JPanel(new BorderLayout());
        toolbar2.add((Component)toolbarLeft, "West");
        toolbar2.add((Component)toolbarRight, "East");
        JButton create_constraintSet = MEUI.createToolBarButton(MEIcons.CREATE_MENU, "Create ConstraintSet");
        toolbarLeft.add(create_constraintSet);
        this.mCreateTransitionToolbarButton = MEUI.createToolBarButton(MEIcons.CREATE_TRANSITION, MEIcons.LIST_TRANSITION, "Create Transition between ConstraintSets");
        toolbarLeft.add(this.mCreateTransitionToolbarButton);
        this.mCreateGestureToolbarButton = MEUI.createToolBarButton(MEIcons.CREATE_ON_STAR, MEIcons.GESTURE, "Create click or swipe handler");
        toolbarLeft.add(this.mCreateGestureToolbarButton);
        create_constraintSet.setAction(this.mCreateConstraintSet.getAction(create_constraintSet, this));
        this.mCreateTransitionToolbarButton.setAction(this.mCreateTransition.getAction(this.mCreateTransitionToolbarButton, this));
        create_constraintSet.setHideActionText(true);
        this.mCreateTransitionToolbarButton.setHideActionText(true);
        this.mCreateGestureToolbarButton.setHideActionText(true);
        this.myPopupMenu.add(this.mCreateOnClick.getAction(this.mCreateGestureToolbarButton, this));
        this.myPopupMenu.add(this.mCreateOnSwipe.getAction(this.mCreateGestureToolbarButton, this));
        this.mCreateGestureToolbarButton.addActionListener(e -> this.myPopupMenu.show(create_constraintSet, 0, 0));
        JButton cycle = MEUI.createToolBarButton(MEIcons.CYCLE_LAYOUT, "Cycle between layouts");
        toolbarRight.add(cycle);
        cycle.addActionListener(e -> this.layoutTop());
        this.mMainPanel.add((Component)toolbar2, "North");
        this.layoutTop();
    }

    public void addSelectionListener(MotionEditorSelector.Listener listener2) {
        this.mMotionEditorSelector.addSelectionListener(listener2);
    }

    private void notifyListeners(MotionEditorSelector.Type type, MTag[] tags2, int flags) {
        this.mMotionEditorSelector.notifyListeners(type, tags2, flags);
    }

    public MeModel getMeModel() {
        return this.mMeModel;
    }

    public MTag getSelectedTag() {
        return this.mSelectedTag;
    }

    public void selectTag(MTag tag, int flags) {
        String tagName;
        this.mFlags = flags;
        String string = tagName = tag != null ? tag.getTagName() : null;
        if (tag != null && tagName != null && tag.equals(this.mSelectedTag)) {
            this.mConstraintSetPanel.clearSelection();
            this.mLayoutPanel.clearSelection();
            this.mTransitionPanel.clearSelection();
            this.mMeModel.setSelectedViewIDs(new ArrayList<String>());
            this.notifyListeners(this.findSelectionType(tagName), new MTag[]{tag}, flags);
        }
        this.mSelectedTag = tag;
        if (tag != null) {
            this.mCombinedListPanel.selectTag(tag);
        }
    }

    private MotionEditorSelector.Type findSelectionType(String tagName) {
        switch (tagName) {
            case "ConstraintSet": {
                return MotionEditorSelector.Type.CONSTRAINT_SET;
            }
            case "Transition": {
                return MotionEditorSelector.Type.TRANSITION;
            }
        }
        return MotionEditorSelector.Type.LAYOUT;
    }

    public void setMTag(MTag motionScene, MTag layout2, String layoutFileName, String motionSceneFileName, String setupError) {
        if (setupError == null && this.myErrorPanel.validateMotionScene(motionScene)) {
            this.mErrorSwitchCard.show(this, MAIN_PANEL);
            this.setMTag(new MeModel(motionScene, layout2, layoutFileName, motionSceneFileName, this.myTrack));
        } else {
            if (setupError != null) {
                this.myErrorPanel.myErrorLabel.setText("<HTML>MotionScene error:<ul>" + setupError + "</ul></HTML>");
            }
            this.mErrorSwitchCard.show(this, ERROR_PANEL);
        }
    }

    private MTag findSelectedTagInNewModel(MeModel newModel) {
        if (this.mSelectedTag instanceof MotionSceneTag) {
            return newModel.motionScene.getChildTagWithTreeId(this.mSelectedTag.getTagName(), this.mSelectedTag.getTreeId());
        }
        if (this.mSelectedTag instanceof NlComponentTag) {
            return newModel.layout;
        }
        return null;
    }

    private static MTag asConstraintSet(MTag selection) {
        return selection != null && selection.getTagName().equals(CONSTRAINTSET_PANEL) ? selection : null;
    }

    private static MTag asTransition(MTag selection) {
        return selection != null && selection.getTagName().equals(TRANSITION_PANEL) ? selection : null;
    }

    private static MTag asLayout(MTag selection) {
        return selection instanceof NlComponentTag ? selection : null;
    }

    public void clearSelectedTags() {
        this.mSelectedTag = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMTag(MeModel model2) {
        this.mUpdatingModel = true;
        try {
            MTag newSelection = this.findSelectedTagInNewModel(model2);
            model2.setSelectedViewIDs(this.mMeModel != null ? this.mMeModel.getSelectedViewIDs() : MeModel.EMPTY_STRING_ARRAY);
            this.mSelectedTag = newSelection;
            this.mMeModel = model2;
            this.mMotionSceneTabb.setMTag(this.mMeModel.motionScene);
            this.mCombinedListPanel.setMTag(this.mMeModel.motionScene, this.mMeModel.layout);
            this.mOverviewPanel.setMTag(this.mMeModel.motionScene, this.mMeModel.layout);
            this.mLayoutPanel.setMTag(MotionEditor.asLayout(newSelection), this.mMeModel);
            this.mConstraintSetPanel.setMTag(MotionEditor.asConstraintSet(newSelection), this.mMeModel);
            this.mTransitionPanel.setMTag(MotionEditor.asTransition(newSelection), this.mMeModel);
            this.mSelectedTag = newSelection;
            MTag[] mtags = model2.motionScene.getChildTags(CONSTRAINTSET_PANEL);
            this.mCreateTransitionToolbarButton.setEnabled(mtags.length >= 2);
            mtags = model2.motionScene.getChildTags(TRANSITION_PANEL);
            this.mCreateGestureToolbarButton.setEnabled(mtags.length >= 1);
        }
        finally {
            this.mUpdatingModel = false;
        }
    }

    public boolean isUpdatingModel() {
        return this.mUpdatingModel;
    }

    private void layoutTop() {
        this.mLayoutMode = this.mLayoutMode == null ? LayoutMode.OVERVIEW_ONLY_LAYOUT : LayoutMode.values()[(this.mLayoutMode.ordinal() + 1) % LayoutMode.values().length];
        Track.changeLayout(this.myTrack);
        switch (this.mLayoutMode) {
            case VERTICAL_LAYOUT: {
                this.mCombinedListPanel.setSplitView(true);
                this.mTopPanel.setOrientation(0);
                this.mTopPanel.remove(this.mCombinedListPanel);
                this.mTopPanel.remove(this.mOverviewScrollPane);
                this.mTopPanel.setBottomComponent(this.mCombinedListPanel);
                this.mTopPanel.setTopComponent(this.mOverviewScrollPane);
                this.mTopPanel.setResizeWeight(0.666);
                this.mTopPanel.setDividerLocation(0.666);
                this.mTopPanel.setEnabled(false);
                this.mTopPanel.setDividerSize(0);
                break;
            }
            case HORIZONTAL_LAYOUT: {
                this.mCombinedListPanel.setSplitView(false);
                this.mTopPanel.setOrientation(1);
                this.mTopPanel.remove(this.mCombinedListPanel);
                this.mTopPanel.remove(this.mOverviewScrollPane);
                this.mTopPanel.setRightComponent(this.mOverviewScrollPane);
                this.mTopPanel.setLeftComponent(this.mCombinedListPanel);
                this.mTopPanel.setResizeWeight(0.333);
                this.mTopPanel.setDividerLocation(0.333);
                this.mTopPanel.setEnabled(false);
                this.mTopPanel.setDividerSize(0);
                break;
            }
            case OVERVIEW_ONLY_LAYOUT: {
                this.mCombinedListPanel.setSplitView(false);
                this.mTopPanel.setOrientation(1);
                this.mTopPanel.remove(this.mCombinedListPanel);
                this.mTopPanel.remove(this.mOverviewScrollPane);
                this.mTopPanel.setRightComponent(this.mOverviewScrollPane);
                this.mTopPanel.setResizeWeight(0.0);
                this.mTopPanel.setDividerLocation(0.0);
                this.mTopPanel.setEnabled(false);
                this.mTopPanel.setDividerSize(0);
            }
        }
        this.mTopPanel.validate();
    }

    void listSelection() {
        int index2 = this.mCombinedListPanel.getSelectedConstraintSet();
        if (index2 >= 0) {
            this.constraintSetSelection();
        } else {
            this.transitionSelection();
        }
    }

    void constraintSetSelection() {
        int index2 = this.mCombinedListPanel.getSelectedConstraintSet();
        this.mOverviewPanel.setConstraintSetIndex(index2);
        this.mTransitionPanel.stopAnimation();
        if (index2 >= 0) {
            Track.showConstraintSetTable(this.myTrack);
            MTag[] c_sets = this.mCombinedListPanel.mMotionScene.getChildTags(CONSTRAINTSET_PANEL);
            if (0 < index2) {
                this.mCurrentlyDisplaying = CONSTRAINTSET_PANEL;
                this.mCardLayout.show(this.mCenterPanel, CONSTRAINTSET_PANEL);
                MTag selectedConstraintSet = c_sets[index2 - 1];
                this.notifyListeners(MotionEditorSelector.Type.CONSTRAINT_SET, new MTag[]{selectedConstraintSet}, 0);
                this.mSelectedTag = selectedConstraintSet;
                this.mConstraintSetPanel.setMTag(selectedConstraintSet, this.mMeModel);
            } else {
                MTag[] mTagArray;
                Track.showLayoutTable(this.myTrack);
                this.mCurrentlyDisplaying = LAYOUT_PANEL;
                this.mCardLayout.show(this.mCenterPanel, LAYOUT_PANEL);
                if (this.mCombinedListPanel.mMotionLayout == null) {
                    mTagArray = new MTag[]{};
                } else {
                    MTag[] mTagArray2 = new MTag[1];
                    mTagArray = mTagArray2;
                    mTagArray2[0] = this.mCombinedListPanel.mMotionLayout;
                }
                this.notifyListeners(MotionEditorSelector.Type.LAYOUT, mTagArray, 0);
                this.mLayoutPanel.setMTag(this.mCombinedListPanel.mMotionLayout, this.mMeModel);
                this.mSelectedTag = this.mCombinedListPanel.mMotionLayout;
            }
        }
    }

    void transitionSelection() {
        Track.transitionSelection(this.myTrack);
        int index2 = this.mCombinedListPanel.getSelectedTransition();
        this.mOverviewPanel.setTransitionSetIndex(index2);
        this.mCurrentlyDisplaying = TRANSITION_PANEL;
        this.mCardLayout.show(this.mCenterPanel, TRANSITION_PANEL);
        MTag[] transitions = this.mCombinedListPanel.mMotionScene.getChildTags(TRANSITION_PANEL);
        if (transitions.length == 0) {
            this.constraintSetSelection();
            return;
        }
        MTag selectedTransition = transitions[index2];
        this.mTransitionPanel.setMTag(selectedTransition, this.mMeModel);
        this.notifyListeners(MotionEditorSelector.Type.TRANSITION, new MTag[]{selectedTransition}, this.mFlags);
        this.mSelectedTag = selectedTransition;
    }

    public void selectTransition() {
        this.mCombinedListPanel.selectTransition();
        this.transitionSelection();
    }

    public void addTimeLineListener(MotionEditorSelector.TimeLineListener timeLineListener) {
        this.mTransitionPanel.addTimeLineListener(timeLineListener);
    }

    public static interface Command {
        public void perform(Action var1, MTag[] var2);

        public static enum Action {
            DELETE,
            COPY;

        }
    }

    class ConstraintSetListPanel
    extends BaseListPanel {
        boolean building;
        JList<String> mConstraintSetList;
        JScrollPane mTListPane;

        ConstraintSetListPanel() {
            this.building = false;
            this.mConstraintSetList = new MEList();
            this.mTListPane = new MEScrollPane(this.mConstraintSetList);
            this.add((Component)this.mTListPane, "Center");
            this.mConstraintSetList.addListSelectionListener(e -> {
                if (e.getValueIsAdjusting() || this.building) {
                    return;
                }
                this.select(e);
            });
            this.add((Component)new JLabel("States"), "North");
        }

        void select(ListSelectionEvent e) {
            this.fireSelection(e);
        }

        String buildListString(MTag tag) {
            String cid = Utils.stripID(tag.getAttributeValue("id"));
            int noc = tag.getChildTags().length;
            String end = tag.getAttributeValue("constraintSetEnd");
            return "<html> <b> " + cid + "(" + noc + ")</html>";
        }

        public void setMTag(MTag motionScene, MTag layout2) {
            this.building = true;
            this.mMotionScene = motionScene;
            this.mMotionLayout = layout2;
            int selected = this.mConstraintSetList.getSelectedIndex();
            selected = Math.max(0, selected);
            MTag[] sets = motionScene.getChildTags(MotionEditor.CONSTRAINTSET_PANEL);
            String[] tStrings = new String[sets.length + 1];
            for (int i2 = 0; i2 < tStrings.length - 1; ++i2) {
                tStrings[i2] = this.buildListString(sets[i2]);
            }
            int count = this.mMotionLayout == null ? -1 : this.mMotionLayout.getChildTags().length;
            tStrings[tStrings.length - 1] = count == -1 ? "layout" : "layout(" + count + ")";
            if ((selected = Math.min(tStrings.length - 1, selected)) == -1) {
                selected = 0;
            }
            this.mConstraintSetList.setListData((String[])tStrings);
            this.mConstraintSetList.setSelectedIndex(selected);
            this.building = false;
        }

        public void clearSelection() {
            this.building = true;
            this.mConstraintSetList.clearSelection();
            this.building = false;
        }

        public int getSelected() {
            return this.mConstraintSetList.getSelectedIndex();
        }
    }

    class TransitionListPanel
    extends BaseListPanel {
        boolean building;
        String[] mTransitionStrings;
        JList<String> mTransitionJList;
        JScrollPane mTListPane;

        TransitionListPanel() {
            this.building = false;
            this.mTransitionStrings = new String[]{"<html> <b> Transition_A </b><br>base -> first_state </html>"};
            this.mTransitionJList = new JList<String>(this.mTransitionStrings);
            this.mTListPane = new JScrollPane(this.mTransitionJList);
            this.add((Component)this.mTListPane, "Center");
            this.add((Component)new JLabel("Transitions"), "North");
            this.mTransitionJList.addListSelectionListener(e -> {
                if (e.getValueIsAdjusting() || this.building) {
                    return;
                }
                this.select(e);
            });
        }

        void select(ListSelectionEvent e) {
            this.fireSelection(e);
        }

        String buildListString(MTag tag) {
            String tid = tag.getAttributeValue("id");
            tid = tid == null ? "T" : Utils.stripID(tid);
            String start2 = Utils.stripID(tag.getAttributeValue("constraintSetStart"));
            String end = Utils.stripID(tag.getAttributeValue("constraintSetEnd"));
            return "<html> <b> " + tid + "</b>(" + start2 + " -> " + end + ") </html>";
        }

        public void setMTag(MTag motionScene) {
            this.building = true;
            this.mMotionScene = motionScene;
            int selected = this.mTransitionJList.getSelectedIndex();
            selected = Math.max(0, selected);
            MTag[] transitions = motionScene.getChildTags(MotionEditor.TRANSITION_PANEL);
            String[] tStrings = new String[transitions.length];
            for (int i2 = 0; i2 < tStrings.length; ++i2) {
                tStrings[i2] = this.buildListString(transitions[i2]);
            }
            if ((selected = Math.min(tStrings.length - 1, selected)) == -1) {
                selected = 0;
            }
            this.mTransitionJList.setListData((String[])tStrings);
            this.mTransitionJList.setSelectedIndex(selected);
            this.building = false;
        }

        public void clearSelection() {
            this.building = true;
            this.mTransitionJList.clearSelection();
            this.building = false;
        }

        public int getSelected() {
            return this.mTransitionJList.getSelectedIndex();
        }

        public void setSelectedIndex(int index2) {
            this.mTransitionJList.setSelectedIndex(index2);
        }
    }

    class BaseListPanel
    extends JPanel {
        MTag mMotionScene;
        MTag mMotionLayout;
        ListSelectionListener mListSelectionListener;

        BaseListPanel() {
            super(new BorderLayout());
        }

        void setSelectionListener(ListSelectionListener l) {
            this.mListSelectionListener = l;
        }

        void fireSelection(ListSelectionEvent e) {
            this.mListSelectionListener.valueChanged(e);
        }
    }

    class MotionScenePanel
    extends JPanel {
        Icon icon;
        JTextField mDefaultDurationText;
        JButton mTransitionHeader;
        DefaultTableModel mTransitionModel;
        JTable mTransitionTable;
        JScrollPane mSPTransition;
        JButton mConstraintSetHeader;
        DefaultTableModel mConstraintSetModel;
        JTable mConstraintSetTable;
        JScrollPane mSPConstraintSet;

        private void stripButton(JButton button2) {
            button2.setBackground(this.getBackground());
            button2.setBorderPainted(false);
            button2.setContentAreaFilled(false);
            button2.setFocusPainted(false);
            button2.setOpaque(false);
            button2.setAlignmentX(1.0f);
        }

        public void setMTag(MTag motionScene) {
            String value2 = motionScene.getAttributeValue("defaultDuration");
            this.mDefaultDurationText.setText(value2 == null ? "" : value2);
            MTag[] transitions = motionScene.getChildTags(MotionEditor.TRANSITION_PANEL);
            this.mTransitionHeader.setText("Transitions (" + transitions.length + ")");
            Object[] table_data = new String[4];
            this.mTransitionModel.setNumRows(0);
            for (int i2 = 0; i2 < transitions.length; ++i2) {
                MTag t = transitions[i2];
                String id = t.getAttributeValue("id");
                String start2 = t.getAttributeValue("constraintSetStart");
                String end = t.getAttributeValue("constraintSetEnd");
                String duration2 = t.getAttributeValue("duration");
                table_data[0] = id;
                table_data[1] = start2;
                table_data[2] = end;
                table_data[3] = duration2;
                this.mTransitionModel.addRow(table_data);
            }
            this.mTransitionModel.fireTableDataChanged();
            MTag[] sets = motionScene.getChildTags(MotionEditor.CONSTRAINTSET_PANEL);
            this.mConstraintSetModel.setNumRows(0);
            for (int i3 = 0; i3 < sets.length; ++i3) {
                MTag t = sets[i3];
                String id = t.getAttributeValue("id");
                String derive = t.getAttributeValue("deriveConstraintsFrom");
                if (derive == null) {
                    derive = "(base)";
                }
                MTag[] children = t.getChildTags();
                table_data[0] = id;
                table_data[1] = derive;
                table_data[2] = "" + children.length;
                this.mConstraintSetModel.addRow(table_data);
            }
            this.mConstraintSetModel.fireTableDataChanged();
        }

        MotionScenePanel() {
            super(new GridBagLayout());
            this.icon = UIManager.getIcon("Tree.closedIcon");
            this.mDefaultDurationText = new JTextField();
            this.mTransitionHeader = new JButton("Transitions (1)", this.icon);
            this.mTransitionModel = new DefaultTableModel(new String[]{"id", "start", "end", "duration"}, 0);
            this.mTransitionTable = new JTable(this.mTransitionModel);
            this.mSPTransition = new JScrollPane(this.mTransitionTable);
            this.mConstraintSetHeader = new JButton("ConstraintSets (2)", this.icon);
            this.mConstraintSetModel = new DefaultTableModel(new String[]{"id", "derived", "Constraints"}, 0);
            this.mConstraintSetTable = new JTable(this.mConstraintSetModel);
            this.mSPConstraintSet = new JScrollPane(this.mConstraintSetTable);
            this.stripButton(this.mTransitionHeader);
            this.stripButton(this.mConstraintSetHeader);
            Insets table_inset = new Insets(0, 20, 0, 20);
            GridBagConstraints gbc = new GridBagConstraints();
            Insets default_inset = gbc.insets;
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            JLabel label = new JLabel("Default Duration");
            this.add((Component)label, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            this.mDefaultDurationText.setText("XXXXXXXX");
            this.mDefaultDurationText.setPreferredSize(this.mDefaultDurationText.getPreferredSize());
            this.mDefaultDurationText.setText(" 1000ms");
            this.add((Component)this.mDefaultDurationText, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.weightx = 0.0;
            gbc.gridwidth = 1;
            this.add((Component)this.mTransitionHeader, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            this.add((Component)new JSeparator(), gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            gbc.fill = 1;
            gbc.insets = table_inset;
            this.mSPTransition.setPreferredSize(this.mTransitionTable.getPreferredSize());
            gbc.weighty = 1.0;
            this.add((Component)this.mSPTransition, gbc);
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.weightx = 0.0;
            gbc.gridwidth = 1;
            gbc.insets = default_inset;
            gbc.fill = 2;
            this.add((Component)this.mConstraintSetHeader, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            this.add((Component)new JSeparator(), gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 20, 0, 20);
            this.mSPConstraintSet.setPreferredSize(this.mConstraintSetTable.getPreferredSize());
            this.add((Component)this.mSPConstraintSet, gbc);
            gbc.weighty = 0.0;
            ++gbc.gridy;
            gbc.weighty = 0.0;
            this.add((Component)new JComponent(){}, gbc);
        }
    }

    static enum LayoutMode {
        VERTICAL_LAYOUT,
        HORIZONTAL_LAYOUT,
        OVERVIEW_ONLY_LAYOUT;

    }
}

