/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.api.AccessorySelectionListener;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionAccessoryPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.utils.Debug;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.intellij.ui.JBColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MotionAttributePanel
implements AccessoryPanelInterface {
    private static final boolean DEBUG = false;
    static Color ourSecondaryPanelBackground;
    static Color ourMainBackground;
    private MotionAccessoryPanel myMotionAccessoryPanel;
    private final ViewGroupHandler.AccessoryPanelVisibility myVisibilityCallback;
    private final NlComponent myMotionLayout;
    private JPanel myPanel;
    private JEditorPane myEditorPane;
    private NlComponent mySelection;
    public NlModel myNlModel;
    JPanel myAttributeGroups;

    public MotionAttributePanel(@NotNull NlComponent parent, @NotNull ViewGroupHandler.AccessoryPanelVisibility visibility) {
        this.myMotionLayout = parent;
        this.myVisibilityCallback = visibility;
    }

    @Override
    @NotNull
    public JPanel getPanel() {
        if (this.myPanel == null) {
            this.myPanel = this.createPanel(AccessoryPanel.Type.EAST_PANEL);
        }
        return this.myPanel;
    }

    @Override
    @NotNull
    public JPanel createPanel(AccessoryPanel.Type type) {
        JPanel panel2 = new JPanel(new BorderLayout()){
            {
                this.setPreferredSize(new Dimension(250, 250));
                MotionAttributePanel.this.myEditorPane = new JEditorPane();
                this.add(MotionAttributePanel.this.myEditorPane);
            }
        };
        Debug.log("createPanel");
        return panel2;
    }

    @Override
    public void updateAccessoryPanelWithSelection(@NotNull AccessoryPanel.Type type, @NotNull List<NlComponent> selection) {
        this.myEditorPane.setText(this.myEditorPane.getText() + "\n" + (Object)((Object)type) + " " + (selection.size() > 0 ? selection.get(0) : "null"));
    }

    @Override
    public void deactivate() {
    }

    @Override
    public void updateAfterModelDerivedDataChanged() {
    }

    @Override
    public void requestSelection() {
    }

    @Override
    public void addListener(@NotNull AccessorySelectionListener listener2) {
    }

    @Override
    public void removeListener(@NotNull AccessorySelectionListener listener2) {
    }

    static {
        ourMainBackground = ourSecondaryPanelBackground = new JBColor(0xFCFCFC, 3224629);
    }
}

