/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.grid;

import com.android.SdkConstants;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.grid.GridInfo;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GridDragHandler
extends DragHandler {
    private final GridInfo info;
    private int row;
    private int column;

    GridDragHandler(@NotNull ViewEditor editor2, @NotNull ViewGroupHandler handler2, @NotNull SceneComponent layout2, @NotNull List<NlComponent> components, @NotNull DragType type) {
        super(editor2, handler2, layout2, components, type);
        this.info = new GridInfo(layout2.getNlComponent());
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        NlComponent layoutComponent = this.layout.getNlComponent();
        DesignSurface surface2 = this.editor.getScene().getDesignSurface();
        if (this.layout.getChildCount() == 0) {
            AttributesTransaction transaction = ((NlComponent)this.components.get(0)).startAttributeTransaction();
            this.setRowAndColumnAttribute(transaction, 0, 0);
            this.editor.getModel().addComponents(this.components, layoutComponent, null, insertType, surface2, () -> transaction.commit());
            return;
        }
        if (insertType.isCreate() && this.components.size() == 1) {
            NlComponent component = (NlComponent)this.components.get(0);
            int row = this.getRow(this.lastY);
            int column = this.getColumn(this.lastX);
            if (row == -1 || column == -1 || this.info.cellHasChild(row, column)) {
                return;
            }
            AttributesTransaction transaction = component.startAttributeTransaction();
            this.setRowAndColumnAttribute(transaction, row, column);
            this.editor.getModel().addComponents(this.components, layoutComponent, null, insertType, surface2, () -> transaction.commit());
            return;
        }
        if (this.info.cellHasChild(this.row, this.column)) {
            return;
        }
        NlComponent[][] children = this.info.getChildren();
        NlComponent child = children[this.getStartRow()][this.getStartColumn()];
        int row = this.info.getRowSkippingEqualLineLocations(y);
        int column = this.info.getColumnSkippingEqualLineLocations(x);
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_row", Integer.toString(row));
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_column", Integer.toString(column));
        this.editor.insertChildren(layoutComponent, this.components, -1, insertType);
    }

    private void setRowAndColumnAttribute(@NotNull AttributesTransaction transaction, int row, int column) {
        String tagName = this.layout.getNlComponent().getTagName();
        if ("GridLayout".equals(tagName)) {
            transaction.setAndroidAttribute("layout_row", String.valueOf(row));
            transaction.setAndroidAttribute("layout_column", String.valueOf(column));
        } else if (SdkConstants.GRID_LAYOUT_V7.isEquals(tagName)) {
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_row", String.valueOf(row));
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_column", String.valueOf(column));
        }
    }

    GridInfo getInfo() {
        return this.info;
    }

    @VisibleForTesting
    int getStartRow() {
        return this.getRow(this.startY);
    }

    @VisibleForTesting
    int getStartColumn() {
        return this.getColumn(this.startX);
    }

    private int getRow(int y) {
        return this.info.getRow(this.editor.dpToPx(y));
    }

    private int getColumn(int x) {
        return this.info.getColumn(this.editor.dpToPx(x));
    }

    @Override
    public String update(int x, int y, int modifiers, @NotNull SceneContext sceneContext) {
        String successful = super.update(x, y, modifiers, sceneContext);
        this.row = this.info.getRow(this.editor.dpToPx(y));
        this.column = this.info.getColumn(this.editor.dpToPx(x));
        return successful;
    }

    @Override
    public void paint(@NotNull NlGraphics graphics) {
        Insets padding = NlComponentHelperKt.getPadding(this.layout.getNlComponent());
        int layoutX1 = this.editor.dpToPx(this.layout.getDrawX()) + padding.left;
        int layoutY1 = this.editor.dpToPx(this.layout.getDrawY()) + padding.top;
        int layoutX2 = this.editor.dpToPx(this.layout.getDrawX()) + padding.left + this.editor.dpToPx(this.layout.getDrawWidth()) - padding.width() - 1;
        int layoutY2 = this.editor.dpToPx(this.layout.getDrawY()) + padding.top + this.editor.dpToPx(this.layout.getDrawHeight()) - padding.height() - 1;
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        for (int x : this.info.getVerticalLineLocations()) {
            graphics.drawLine(x, layoutY1, x, layoutY2);
        }
        for (int y : this.info.getHorizontalLineLocations()) {
            graphics.drawLine(layoutX1, y, layoutX2, y);
        }
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        graphics.drawRect(layoutX1, layoutY1, this.editor.dpToPx(this.layout.getDrawWidth()) - padding.width(), this.editor.dpToPx(this.layout.getDrawHeight()) - padding.height());
        graphics.useStyle(this.info.cellHasChild(this.row, this.column) ? NlDrawingStyle.INVALID : NlDrawingStyle.DROP_ZONE_ACTIVE);
        Rectangle rectangle = this.getActiveDropZoneRectangle();
        if (rectangle != null) {
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Nullable
    private Rectangle getActiveDropZoneRectangle() {
        int startRow;
        if (this.row == -1 || this.column == -1) {
            return null;
        }
        int startColumn = this.column;
        int endRow = this.row + 1;
        int endColumn = this.column + 1;
        if (this.info.cellHasChild(this.row, this.column)) {
            NlComponent[][] children = this.info.getChildren();
            for (startRow = this.row; startRow > 0 && children[this.row][this.column].equals(children[startRow - 1][this.column]); --startRow) {
            }
            while (startColumn > 0 && children[this.row][this.column].equals(children[this.row][startColumn - 1])) {
                --startColumn;
            }
            int rowCount = this.info.getRowCount();
            while (endRow < rowCount && children[this.row][this.column].equals(children[endRow][this.column])) {
                ++endRow;
            }
            if (endRow >= rowCount) {
                return null;
            }
            int columnCount = this.info.getColumnCount();
            while (endColumn < columnCount && children[this.row][this.column].equals(children[this.row][endColumn])) {
                ++endColumn;
            }
            if (endColumn >= columnCount) {
                return null;
            }
        }
        int[] verticalLineLocations = this.info.getVerticalLineLocations();
        int[] horizontalLineLocations = this.info.getHorizontalLineLocations();
        int x = verticalLineLocations[startColumn];
        int y = horizontalLineLocations[startRow];
        int width = verticalLineLocations[endColumn] - x;
        int height = horizontalLineLocations[endRow] - y;
        return new Rectangle(x, y, width, height);
    }
}

