/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import icons.StudioIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BaseLineToggleViewAction
extends ToggleViewAction {
    public BaseLineToggleViewAction() {
        super(StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED_CONSTRAINT, StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED, "Show Baseline", "Hide Baseline");
    }

    @Override
    public boolean isSelected(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
        if (selectedChildren.size() != 1) {
            return false;
        }
        NlComponent selectedComponent = selectedChildren.get(0);
        SceneComponent c = editor2.getScene().getSceneComponent(selectedComponent);
        return c != null && c.canShowBaseline();
    }

    @Override
    public void setSelected(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
        if (selectedChildren.size() == 1) {
            NlComponent selectedComponent = selectedChildren.get(0);
            SceneComponent c = editor2.getScene().getSceneComponent(selectedComponent);
            if (c != null) {
                c.setShowBaseline(selected);
                c.getScene().getSceneManager().update();
            }
        }
    }

    @Override
    public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, int modifiers, boolean selected) {
        super.updatePresentation(presentation, editor2, handler2, component, selectedChildren, modifiers, selected);
        boolean visible = false;
        if (selectedChildren.size() == 1) {
            NlComponent selectedComponent = selectedChildren.get(0);
            int baseline = NlComponentHelperKt.getBaseline(selectedComponent);
            ViewInfo info2 = NlComponentHelperKt.getViewInfo(selectedComponent);
            if (baseline <= 0 && info2 != null) {
                baseline = info2.getBaseLine();
            }
            visible = baseline >= 0;
        }
        presentation.setVisible(visible);
    }
}

