/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.designer.overlays;

import com.android.tools.idea.ui.designer.overlays.OverlayEntry;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="OverlayPersistentState", storages={@Storage(value="overlayData.xml")})
public final class OverlayPersistentStateService
implements PersistentStateComponent<OverlayPersistentStateService> {
    public List<String> overlayIds = new ArrayList<String>();
    public List<String> overlayNames = new ArrayList<String>();
    public List<String> providers = new ArrayList<String>();

    public static OverlayPersistentStateService getInstance() {
        return (OverlayPersistentStateService)ServiceManager.getService(OverlayPersistentStateService.class);
    }

    public void addOverlayData(@NotNull OverlayEntry overlayEntry, @NotNull String name) {
        this.overlayIds.add(overlayEntry.getId());
        this.overlayNames.add(name);
        this.providers.add(overlayEntry.getOverlayProvider().getClass().getSimpleName());
    }

    public void deleteOverlayData(@NotNull OverlayEntry overlayEntry) {
        String provider2 = overlayEntry.getOverlayProvider().getClass().getSimpleName();
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            if (!this.overlayIds.get(i2).equals(overlayEntry.getId()) || !this.providers.get(i2).equals(provider2)) continue;
            this.overlayIds.remove(i2);
            this.overlayNames.remove(i2);
            this.providers.remove(i2);
            break;
        }
    }

    public void updateOverlayName(@NotNull OverlayEntry overlayEntry, @NotNull String overlayName) {
        String provider2 = overlayEntry.getOverlayProvider().getClass().getSimpleName();
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            if (!this.overlayIds.get(i2).equals(overlayEntry.getId()) || !this.providers.get(i2).equals(provider2)) continue;
            this.overlayNames.set(i2, overlayName);
        }
    }

    public int getSize() {
        return this.overlayIds.size();
    }

    public OverlayPersistentStateService getState() {
        return this;
    }

    public void loadState(@NotNull OverlayPersistentStateService state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }
}

