/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ServiceProxy {
    private final ServiceDescriptor myServiceDescriptor;

    public ServiceProxy(@NotNull ServiceDescriptor serviceDescriptor) {
        this.myServiceDescriptor = serviceDescriptor;
    }

    public abstract ServerServiceDefinition getServiceDefinition();

    public void disconnect() {
    }

    protected final ServerServiceDefinition generatePassThroughDefinitions(@NotNull Map<MethodDescriptor, ServerCallHandler> overrides, @NotNull AbstractStub blockingStub) {
        ServerServiceDefinition.Builder builder2 = ServerServiceDefinition.builder((ServiceDescriptor)this.myServiceDescriptor);
        overrides.forEach((method2, handler2) -> builder2.addMethod(method2, handler2));
        this.myServiceDescriptor.getMethods().forEach(descriptor2 -> {
            if (overrides.containsKey(descriptor2)) {
                return;
            }
            switch (descriptor2.getType()) {
                case UNARY: {
                    builder2.addMethod(descriptor2, ServerCalls.asyncUnaryCall((request, observer2) -> this.invokeAsyncUnaryCalls((MethodDescriptor)descriptor2, blockingStub, (Object)request, (StreamObserver)observer2)));
                    break;
                }
                case CLIENT_STREAMING: 
                case SERVER_STREAMING: 
                case BIDI_STREAMING: 
                case UNKNOWN: {
                    throw new UnsupportedOperationException();
                }
            }
        });
        return builder2.build();
    }

    private <Req, Resp> void invokeAsyncUnaryCalls(@NotNull MethodDescriptor descriptor2, @NotNull AbstractStub stubInstance, Req request, @NotNull StreamObserver<Resp> observer2) {
        ClientCalls.asyncUnaryCall((ClientCall)stubInstance.getChannel().newCall(descriptor2, stubInstance.getCallOptions()), request, observer2);
    }
}

