/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeJavaArtifact;
import com.android.ide.common.gradle.model.IdeSourceProvider;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependenciesExtractor;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.android.tools.idea.testartifacts.scopes.ExcludedModules;
import com.android.tools.idea.testartifacts.scopes.ExcludedRoots;
import com.android.tools.idea.testartifacts.scopes.FileRootSearchScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleTestArtifactSearchScopes
implements TestArtifactSearchScopes {
    private static final Key<GradleTestArtifactSearchScopes> SEARCH_SCOPES_KEY = Key.create((String)"TEST_ARTIFACT_SEARCH_SCOPES");
    @NotNull
    private final Module myModule;
    @NotNull
    private final AndroidModuleModel myAndroidModel;
    private FileRootSearchScope myAndroidTestSourceScope;
    private FileRootSearchScope myUnitTestSourceScope;
    private FileRootSearchScope myAndroidTestExcludeScope;
    private FileRootSearchScope myUnitTestExcludeScope;
    private FileRootSearchScope myAndroidTestDependencyExcludeScope;
    private FileRootSearchScope mySharedTestsExcludeScope;
    private FileRootSearchScope myUnitTestDependencyExcludeScope;
    private static final Object ourLock = new Object();
    private DependencySet myMainDependencies;
    private DependencySet myUnitTestDependencies;
    private DependencySet myAndroidTestDependencies;

    @Nullable
    public static GradleTestArtifactSearchScopes getInstance(@NotNull Module module2) {
        return (GradleTestArtifactSearchScopes)module2.getUserData(SEARCH_SCOPES_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeScopes(@NotNull Project project) {
        List models2 = ContainerUtil.map((Object[])ModuleManager.getInstance((Project)project).getModules(), it -> Pair.create((Object)it, (Object)AndroidModuleModel.get(it)));
        Object object = ourLock;
        synchronized (object) {
            for (Pair modelPair : models2) {
                @NotNull Module module2 = (Module)modelPair.first;
                @Nullable AndroidModuleModel model2 = (AndroidModuleModel)modelPair.second;
                module2.putUserData(SEARCH_SCOPES_KEY, (Object)(model2 == null ? null : new GradleTestArtifactSearchScopes(module2, model2)));
            }
        }
    }

    private GradleTestArtifactSearchScopes(@NotNull Module module2, @NotNull AndroidModuleModel androidModel) {
        this.myModule = module2;
        this.myAndroidModel = androidModel;
    }

    @Override
    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @Override
    public boolean isAndroidTestSource(@NotNull VirtualFile file2) {
        return this.getAndroidTestSourceScope().accept(file2);
    }

    @Override
    public boolean isUnitTestSource(@NotNull VirtualFile file2) {
        return this.getUnitTestSourceScope().accept(file2);
    }

    @Override
    @NotNull
    public FileRootSearchScope getAndroidTestSourceScope() {
        if (this.myAndroidTestSourceScope == null) {
            this.myAndroidTestSourceScope = this.getSourceScope("_android_test_");
        }
        return this.myAndroidTestSourceScope;
    }

    @Override
    @NotNull
    public FileRootSearchScope getUnitTestSourceScope() {
        if (this.myUnitTestSourceScope == null) {
            this.myUnitTestSourceScope = this.getSourceScope("_unit_test_");
        }
        return this.myUnitTestSourceScope;
    }

    @NotNull
    private FileRootSearchScope getSourceScope(@NotNull String artifactName) {
        HashSet<File> roots = new HashSet<File>();
        if (artifactName.equals("_android_test_") && this.myAndroidModel.getAndroidProject().getProjectType() == 2) {
            roots.add(this.myAndroidModel.getRootDirPath());
            for (IdeSourceProvider sourceProvider : this.myAndroidModel.getActiveSourceProviders()) {
                roots.addAll(ExcludedRoots.getAllSourceFolders(sourceProvider));
            }
        } else {
            IdeJavaArtifact testArtifact;
            for (IdeSourceProvider sourceProvider : this.myAndroidModel.getTestSourceProviders(artifactName)) {
                roots.addAll(ExcludedRoots.getAllSourceFolders(sourceProvider));
            }
            switch (artifactName) {
                case "_unit_test_": {
                    testArtifact = this.myAndroidModel.getSelectedVariant().getUnitTestArtifact();
                    break;
                }
                case "_android_test_": {
                    testArtifact = this.myAndroidModel.getSelectedVariant().getAndroidTestArtifact();
                    break;
                }
                default: {
                    testArtifact = null;
                }
            }
            if (testArtifact != null) {
                roots.addAll(testArtifact.getGeneratedSourceFolders());
            }
        }
        return new FileRootSearchScope(this.myModule.getProject(), roots);
    }

    @Override
    @NotNull
    public FileRootSearchScope getSharedTestExcludeScope() {
        if (this.mySharedTestsExcludeScope == null) {
            this.mySharedTestsExcludeScope = this.getAndroidTestExcludeClasspathScope().add(this.getUnitTestExcludeClasspathScope());
        }
        return this.mySharedTestsExcludeScope;
    }

    @Override
    @NotNull
    public FileRootSearchScope getAndroidTestExcludeScope() {
        if (this.myAndroidTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getUnitTestSourceScope().subtract(this.getAndroidTestSourceScope());
            this.myAndroidTestExcludeScope = exclude.add(this.getAndroidTestExcludeClasspathScope());
        }
        return this.myAndroidTestExcludeScope;
    }

    @Override
    @NotNull
    public FileRootSearchScope getUnitTestExcludeScope() {
        if (this.myUnitTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getAndroidTestSourceScope().subtract(this.getUnitTestSourceScope());
            this.myUnitTestExcludeScope = exclude.add(this.getUnitTestExcludeClasspathScope());
        }
        return this.myUnitTestExcludeScope;
    }

    @Override
    public boolean includeInUnitTestClasspath(@NotNull File file2) {
        return !this.getUnitTestExcludeScope().accept(file2);
    }

    @NotNull
    private FileRootSearchScope getAndroidTestExcludeClasspathScope() {
        if (this.myAndroidTestDependencyExcludeScope == null) {
            this.myAndroidTestDependencyExcludeScope = this.getExcludeClasspathScope("_android_test_");
        }
        return this.myAndroidTestDependencyExcludeScope;
    }

    @NotNull
    private FileRootSearchScope getUnitTestExcludeClasspathScope() {
        if (this.myUnitTestDependencyExcludeScope == null) {
            this.myUnitTestDependencyExcludeScope = this.getExcludeClasspathScope("_unit_test_");
        }
        return this.myUnitTestDependencyExcludeScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private FileRootSearchScope getExcludeClasspathScope(@NotNull String artifactName) {
        Set<File> excluded;
        boolean isAndroidTest = "_android_test_".equals(artifactName);
        Object object = ourLock;
        synchronized (object) {
            DependencySet dependenciesToInclude = isAndroidTest ? this.getAndroidTestDependencies() : this.getUnitTestDependencies();
            DependencySet dependenciesToExclude = isAndroidTest ? this.getUnitTestDependencies() : this.getAndroidTestDependencies();
            ExcludedModules excludedModules = new ExcludedModules(this.myModule);
            excludedModules.add(dependenciesToExclude);
            excludedModules.remove(dependenciesToInclude);
            excludedModules.remove(this.getMainDependencies());
            ExcludedRoots excludedRoots = new ExcludedRoots(excludedModules, dependenciesToExclude, dependenciesToInclude, isAndroidTest);
            excludedRoots.removeLibraryPaths(this.getMainDependencies());
            excluded = excludedRoots.get();
        }
        return new FileRootSearchScope(this.myModule.getProject(), excluded);
    }

    @NotNull
    private static DependencySet extractDependencies(@NotNull Project project, @Nullable IdeBaseArtifact artifact) {
        if (artifact != null) {
            ModuleFinder moduleFinder = ProjectStructure.getInstance(project).getModuleFinder();
            return DependenciesExtractor.getInstance().extractFrom(artifact.getLevel2Dependencies(), moduleFinder);
        }
        return DependencySet.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static DependencySet mergeSubmoduleDependencies(@NotNull DependencySet original, boolean mergeAndroid, boolean mergeUnit) {
        LinkedHashSet<ModuleDependency> moduleDependencies = new LinkedHashSet<ModuleDependency>((Collection<ModuleDependency>)original.onModules());
        Object object = ourLock;
        synchronized (object) {
            for (ModuleDependency moduleDependency : moduleDependencies) {
                GradleTestArtifactSearchScopes moduleScope;
                Module module2 = moduleDependency.getModule();
                if (module2 == null || (moduleScope = GradleTestArtifactSearchScopes.getInstance(module2)) == null) continue;
                original.addAll(moduleScope.getMainDependencies());
                if (mergeAndroid) {
                    original.addAll(moduleScope.getMainDependencies());
                }
                if (!mergeUnit) continue;
                original.addAll(moduleScope.getMainDependencies());
            }
        }
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    DependencySet getMainDependencies() {
        Object object = ourLock;
        synchronized (object) {
            if (this.myMainDependencies == null) {
                this.myMainDependencies = DependencySet.THROWING;
                this.myMainDependencies = GradleTestArtifactSearchScopes.mergeSubmoduleDependencies(GradleTestArtifactSearchScopes.extractDependencies(this.myModule.getProject(), (IdeBaseArtifact)this.myAndroidModel.getMainArtifact()), false, false);
            }
            return this.myMainDependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    DependencySet getUnitTestDependencies() {
        Object object = ourLock;
        synchronized (object) {
            if (this.myUnitTestDependencies == null) {
                this.myUnitTestDependencies = DependencySet.THROWING;
                this.myUnitTestDependencies = GradleTestArtifactSearchScopes.mergeSubmoduleDependencies(GradleTestArtifactSearchScopes.extractDependencies(this.myModule.getProject(), (IdeBaseArtifact)this.myAndroidModel.getSelectedVariant().getUnitTestArtifact()), false, true);
            }
            return this.myUnitTestDependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    DependencySet getAndroidTestDependencies() {
        Object object = ourLock;
        synchronized (object) {
            if (this.myAndroidTestDependencies == null) {
                this.myAndroidTestDependencies = DependencySet.THROWING;
                this.myAndroidTestDependencies = GradleTestArtifactSearchScopes.mergeSubmoduleDependencies(GradleTestArtifactSearchScopes.extractDependencies(this.myModule.getProject(), (IdeBaseArtifact)this.myAndroidModel.getSelectedVariant().getAndroidTestArtifact()), true, false);
            }
            return this.myAndroidTestDependencies;
        }
    }

    public String toString() {
        return this.myModule.getName();
    }
}

