/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.annotations.concurrency.Slow;
import com.android.repository.Revision;
import com.android.tools.idea.downloads.DownloadService;
import com.android.tools.idea.stats.Distribution;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ResourceUtil;
import com.intellij.util.download.FileDownloader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DistributionService
extends DownloadService {
    private static final Logger LOG = Logger.getInstance(DistributionService.class);
    private static final String STATS_URL = "https://dl.google.com/android/studio/metadata/distributions.json";
    private static final String STATS_FILENAME = "distributions.json";
    private static final String DOWNLOAD_FILENAME = "distributions_temp.json";
    private static final URL FALLBACK_URL = ResourceUtil.getResource(DistributionService.class, (String)"wizardData", (String)"distributions.json");
    private static final File CACHE_PATH = new File(PathManager.getSystemPath(), "stats");
    private List<Distribution> myDistributions;
    private static DistributionService ourInstance;

    @NotNull
    public static DistributionService getInstance() {
        if (ourInstance == null) {
            ourInstance = new DistributionService();
        }
        return ourInstance;
    }

    @Nullable
    public List<Distribution> getDistributions() {
        return this.myDistributions;
    }

    @Slow
    public double getSupportedDistributionForApiLevel(int apiLevel) {
        if (apiLevel <= 0) {
            return 0.0;
        }
        this.refreshSynchronously();
        List<Distribution> distributions = this.getDistributions();
        if (distributions == null) {
            return -1.0;
        }
        double unsupportedSum = 0.0;
        for (Distribution d : distributions) {
            if (d.getApiLevel() >= apiLevel) break;
            unsupportedSum += d.getDistributionPercentage();
        }
        return 1.0 - unsupportedSum;
    }

    @Nullable
    public Distribution getDistributionForApiLevel(int apiLevel) {
        this.refreshSynchronously();
        List<Distribution> distributions = this.getDistributions();
        if (distributions == null) {
            return null;
        }
        for (Distribution d : distributions) {
            if (d.getApiLevel() != apiLevel) continue;
            return d;
        }
        return null;
    }

    @VisibleForTesting
    DistributionService(@NotNull FileDownloader downloader, @NotNull File cachePath, @NotNull URL fallback) {
        super(downloader, "Distribution Stats", fallback, cachePath, STATS_FILENAME);
    }

    private DistributionService() {
        super("Distribution Stats", STATS_URL, FALLBACK_URL, CACHE_PATH, DOWNLOAD_FILENAME, STATS_FILENAME);
    }

    @Override
    public void loadFromFile(@NotNull URL url) {
        try {
            String jsonString = ResourceUtil.loadText((URL)url);
            List<Distribution> distributions = DistributionService.loadDistributionsFromJson(jsonString);
            this.myDistributions = distributions != null ? ImmutableList.copyOf(distributions) : null;
        }
        catch (IOException e) {
            LOG.error("Error while trying to load distributions file", (Throwable)e);
        }
    }

    @Nullable
    private static List<Distribution> loadDistributionsFromJson(String jsonString) {
        Type fullRevisionType = new TypeToken<Revision>(){}.getType();
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(fullRevisionType, (json, typeOfT, context) -> Revision.parseRevision((String)json.getAsString()));
        Gson gson = gsonBuilder.create();
        Type listType = new TypeToken<ArrayList<Distribution>>(){}.getType();
        try {
            return (List)gson.fromJson(jsonString, listType);
        }
        catch (JsonParseException e) {
            LOG.error("Parse exception while reading distributions.json", (Throwable)e);
            return null;
        }
    }
}

