/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install;

import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.tools.idea.gradle.project.sync.setup.post.cleanup.SdksCleanupStep;
import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class VfsInstallListener
implements PackageOperation.StatusChangeListener {
    public void statusChanged(final PackageOperation op, final ProgressIndicator progress) {
        if (op.getInstallStatus().equals((Object)PackageOperation.InstallStatus.COMPLETE)) {
            Task.Backgroundable refreshTask = new Task.Backgroundable(null, "Refreshing...", false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator) {
                    indicator.setIndeterminate(true);
                    VfsInstallListener.doRefresh(op, progress);
                }
            };
            ApplicationManager.getApplication().invokeLater(() -> ((Task)refreshTask).queue(), ModalityState.NON_MODAL);
        }
    }

    private static void doRefresh(PackageOperation op, ProgressIndicator progress) {
        VirtualFile file2 = VfsUtil.findFileByIoFile((File)op.getLocation(progress), (boolean)true);
        if (file2 != null) {
            file2.refresh(false, true);
        }
        RefreshQueue.getInstance().refresh(true, false, () -> {
            AndroidSdks androidSdks = AndroidSdks.getInstance();
            for (Sdk sdk : androidSdks.getAllAndroidSdks()) {
                SdksCleanupStep.updateSdkIfNeeded(sdk, androidSdks);
            }
        }, new VirtualFile[0]);
    }
}

