/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeSdks {
    @NonNls
    public static final String MAC_JDK_CONTENT_PATH = "/Contents/Home";
    @NonNls
    private static final String ANDROID_SDK_PATH_KEY = "android.sdk.path";
    @NotNull
    public static final JavaSdkVersion DEFAULT_JDK_VERSION = JavaSdkVersion.JDK_11;
    @NotNull
    public static final String JDK_LOCATION_ENV_VARIABLE_NAME = "STUDIO_GRADLE_JDK";
    @NotNull
    private static final Logger LOG = Logger.getInstance(IdeSdks.class);
    @NotNull
    private final AndroidSdks myAndroidSdks;
    @NotNull
    private final Jdks myJdks;
    @NotNull
    private final EmbeddedDistributionPaths myEmbeddedDistributionPaths;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final Map<String, LocalPackage> localPackagesByPrefix = new HashMap<String, LocalPackage>();
    private final EnvVariableSettings myEnvVariableSettings = new EnvVariableSettings();

    @NotNull
    public static IdeSdks getInstance() {
        return (IdeSdks)ServiceManager.getService(IdeSdks.class);
    }

    public IdeSdks() {
        this(AndroidSdks.getInstance(), Jdks.getInstance(), EmbeddedDistributionPaths.getInstance(), IdeInfo.getInstance());
    }

    @NonInjectable
    @VisibleForTesting
    public IdeSdks(@NotNull AndroidSdks androidSdks, @NotNull Jdks jdks, @NotNull EmbeddedDistributionPaths embeddedDistributionPaths, @NotNull IdeInfo ideInfo) {
        this.myAndroidSdks = androidSdks;
        this.myJdks = jdks;
        this.myEmbeddedDistributionPaths = embeddedDistributionPaths;
        this.myIdeInfo = ideInfo;
    }

    @Nullable
    public File getAndroidSdkPath() {
        File candidate;
        File candidate2;
        String sdkHome = null;
        Sdk sdk = this.getFirstAndroidSdk();
        if (sdk != null) {
            sdkHome = sdk.getHomePath();
        }
        if (sdkHome != null && this.isValidAndroidSdkPath(candidate2 = FilePaths.toSystemDependentPath((String)sdkHome))) {
            return candidate2;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        PropertiesComponent component = PropertiesComponent.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
        String sdkPath = component.getValue(ANDROID_SDK_PATH_KEY);
        if (sdkPath != null && this.isValidAndroidSdkPath(candidate = new File(sdkPath))) {
            return candidate;
        }
        return null;
    }

    @Nullable
    public LocalPackage getSpecificLocalPackage(@NotNull String prefix) {
        if (this.localPackagesByPrefix.containsKey(prefix)) {
            return this.localPackagesByPrefix.get(prefix);
        }
        AndroidSdkHandler sdkHandler = this.myAndroidSdks.tryToChooseSdkHandler();
        LocalPackage result2 = sdkHandler.getLatestLocalPackageForPrefix(prefix, null, true, (ProgressIndicator)new StudioLoggerProgressIndicator(IdeSdks.class));
        if (result2 != null) {
            this.setSpecificLocalPackage(prefix, result2);
        }
        return result2;
    }

    @VisibleForTesting
    public void setSpecificLocalPackage(@NotNull String prefix, @NotNull LocalPackage localPackage) {
        this.localPackagesByPrefix.put(prefix, localPackage);
    }

    @Nullable
    public LocalPackage getHighestLocalNdkPackage(boolean allowPreview) {
        return this.getHighestLocalNdkPackage(allowPreview, null);
    }

    @Nullable
    public LocalPackage getHighestLocalNdkPackage(boolean allowPreview, @Nullable Predicate<Revision> filter2) {
        AndroidSdkHandler sdkHandler = this.myAndroidSdks.tryToChooseSdkHandler();
        LocalPackage ndk = sdkHandler.getLatestLocalPackageForPrefix("ndk", filter2, allowPreview, (ProgressIndicator)new StudioLoggerProgressIndicator(IdeSdks.class));
        if (ndk != null) {
            return ndk;
        }
        LocalPackage ndkPackage = sdkHandler.getLocalPackage("ndk-bundle", (ProgressIndicator)new StudioLoggerProgressIndicator(IdeSdks.class));
        if (filter2 != null && ndkPackage != null && filter2.test(ndkPackage.getVersion())) {
            return ndkPackage;
        }
        return null;
    }

    @Nullable
    public File getAndroidNdkPath() {
        return this.getAndroidNdkPath(null);
    }

    @Nullable
    public File getAndroidNdkPath(@Nullable Predicate<Revision> filter2) {
        LocalPackage ndk = this.getHighestLocalNdkPackage(false, filter2);
        if (ndk != null) {
            return ndk.getLocation();
        }
        return null;
    }

    @Nullable
    public File getJdkPath() {
        return this.doGetJdkPath(true);
    }

    @Nullable
    private File doGetJdkPath(boolean createJdkIfNeeded) {
        if (this.isUsingEnvVariableJdk()) {
            return this.getEnvVariableJdkFile();
        }
        List<Sdk> androidSdks = this.getEligibleAndroidSdks();
        if (androidSdks.isEmpty() && createJdkIfNeeded) {
            String jdkPath;
            Sdk jdk = this.myJdks.chooseOrCreateJavaSdk();
            if (jdk != null && (jdkPath = jdk.getHomePath()) != null) {
                return FilePaths.toSystemDependentPath((String)jdkPath);
            }
        } else {
            for (Sdk sdk : androidSdks) {
                String jdkHomePath;
                AndroidSdkAdditionalData data = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
                assert (data != null);
                Sdk jdk = data.getJavaSdk();
                if (jdk == null || (jdkHomePath = jdk.getHomePath()) == null) continue;
                return FilePaths.toSystemDependentPath((String)jdkHomePath);
            }
        }
        return null;
    }

    public void cleanJdkEnvVariableInitialization() {
        this.myEnvVariableSettings.cleanInitialization();
    }

    public void overrideJdkEnvVariable(@Nullable String envVariableValue) {
        this.myEnvVariableSettings.overrideValue(envVariableValue);
    }

    public boolean isUsingEnvVariableJdk() {
        return this.myEnvVariableSettings.isUseJdkEnvVariable();
    }

    public boolean isJdkEnvVariableDefined() {
        return this.myEnvVariableSettings.isJdkEnvVariableDefined();
    }

    public boolean isJdkEnvVariableValid() {
        return this.myEnvVariableSettings.IsJdkEnvVariableValid();
    }

    @Nullable
    public File getEnvVariableJdkFile() {
        return this.myEnvVariableSettings.getJdkFile();
    }

    @Nullable
    public String getEnvVariableJdkValue() {
        return this.myEnvVariableSettings.getVariableValue();
    }

    public boolean setUseEnvVariableJdk(boolean useJdkEnvVariable) {
        return this.myEnvVariableSettings.setUseJdkEnvVariable(useJdkEnvVariable);
    }

    @Nullable
    private Sdk getFirstAndroidSdk() {
        List<Sdk> allAndroidSdks = this.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        return null;
    }

    public Sdk setJdkPath(@NotNull File path2) {
        if (JdkUtil.checkForJdk((File)path2)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            File canonicalPath = IdeSdks.resolvePath(path2);
            Sdk chosenJdk = null;
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            if (this.myIdeInfo.isAndroidStudio()) {
                List jdks = projectJdkTable.getSdksOfType((SdkTypeId)JavaSdk.getInstance());
                Project[] projectArray = jdks.iterator();
                while (projectArray.hasNext()) {
                    Sdk jdk = (Sdk)projectArray.next();
                    projectJdkTable.removeJdk(jdk);
                }
            } else {
                for (Sdk jdk : projectJdkTable.getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
                    if (!FileUtil.pathsEqual((String)jdk.getHomePath(), (String)canonicalPath.getPath())) continue;
                    chosenJdk = jdk;
                    break;
                }
            }
            if (chosenJdk == null) {
                if (canonicalPath.isDirectory()) {
                    Project[] openProjects;
                    chosenJdk = this.createJdk(canonicalPath);
                    if (chosenJdk == null) {
                        throw new IllegalStateException("Failed to create IDEA JDK from '" + path2.getPath() + "'");
                    }
                    this.setJdkOfAndroidSdks(chosenJdk);
                    for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
                        NewProjectUtil.applyJdkToProject((Project)project, (Sdk)chosenJdk);
                    }
                } else {
                    throw new IllegalStateException("The resolved path '" + canonicalPath.getPath() + "' was not found");
                }
            }
            this.setUseEnvVariableJdk(false);
            return chosenJdk;
        }
        return null;
    }

    private void setJdkOfAndroidSdks(@NotNull Sdk jdk) {
        for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
            AndroidSdkAdditionalData oldData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            if (oldData == null) continue;
            oldData.setJavaSdk(jdk);
            SdkModificator modificator = sdk.getSdkModificator();
            modificator.setSdkAdditionalData((SdkAdditionalData)oldData);
            modificator.commitChanges();
        }
    }

    @NotNull
    public List<Sdk> setAndroidSdkPath(@NotNull File path2, @Nullable Project currentProject) {
        return this.setAndroidSdkPath(path2, null, currentProject);
    }

    @NotNull
    public List<Sdk> setAndroidSdkPath(@NotNull File path2, @Nullable Sdk javaSdk, @Nullable Project currentProject) {
        if (this.isValidAndroidSdkPath(path2)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (currentProject != null && !currentProject.isDisposed()) {
                String sdkPath = FileUtil.toCanonicalPath((String)path2.getAbsolutePath());
                PropertiesComponent.getInstance((Project)currentProject).setValue(ANDROID_SDK_PATH_KEY, sdkPath);
                if (!currentProject.isDefault()) {
                    PropertiesComponent component = PropertiesComponent.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
                    component.setValue(ANDROID_SDK_PATH_KEY, sdkPath);
                }
            }
            this.updateSdkData(path2);
            ArrayList<Sdk> sdksToDelete = new ArrayList<Sdk>();
            File resolved = IdeSdks.resolvePath(path2);
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(resolved, true);
            if (sdkData != null) {
                for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
                    if (!sdk.getName().startsWith("Android ")) continue;
                    sdksToDelete.add(sdk);
                }
            }
            for (Sdk sdk : sdksToDelete) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
            List<Sdk> sdks = this.createAndroidSdkPerAndroidTarget(resolved, javaSdk);
            IdeSdks.afterAndroidSdkPathUpdate(resolved);
            return sdks;
        }
        return Collections.emptyList();
    }

    private void updateSdkData(@NotNull File path2) {
        AndroidSdkData oldSdkData = AndroidSdkData.getSdkData(path2);
        this.myAndroidSdks.setSdkData(oldSdkData);
    }

    public void updateFromAndroidSdkPath(@Nullable Project currentProject) {
        String sdkPath;
        File sdkDir = null;
        if (currentProject != null && !currentProject.isDisposed() && (sdkPath = PropertiesComponent.getInstance((Project)currentProject).getValue(ANDROID_SDK_PATH_KEY)) != null) {
            sdkDir = new File(sdkPath);
        }
        if (sdkDir == null) {
            sdkDir = this.getAndroidSdkPath();
        }
        assert (sdkDir != null);
        assert (this.isValidAndroidSdkPath(sdkDir));
        this.updateSdkData(sdkDir);
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        for (Sdk sdk : this.getEligibleAndroidSdks()) {
            VirtualFile homeDir = sdk.getHomeDirectory();
            if (homeDir == null || !homeDir.exists()) {
                jdkTable.removeJdk(sdk);
                continue;
            }
            IAndroidTarget target = IdeSdks.getTarget(sdk);
            File targetFile = new File(target.getLocation());
            if (targetFile.exists()) continue;
            jdkTable.removeJdk(sdk);
        }
        File resolved = IdeSdks.resolvePath(sdkDir);
        this.createAndroidSdkPerAndroidTarget(resolved);
    }

    private static void afterAndroidSdkPathUpdate(@NotNull File androidSdkPath) {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length == 0) {
            return;
        }
        AndroidSdkEventListener[] eventListeners = (AndroidSdkEventListener[])AndroidSdkEventListener.EP_NAME.getExtensions();
        for (Project project : openProjects) {
            if (!AndroidProjectInfo.getInstance(project).requiresAndroidModel()) continue;
            for (AndroidSdkEventListener listener2 : eventListeners) {
                listener2.afterSdkPathChange(androidSdkPath, project);
            }
        }
    }

    public boolean isValidAndroidSdkPath(@NotNull File path2) {
        return SdkPaths.validateAndroidSdk((File)path2, (boolean)false).success;
    }

    @NotNull
    public List<Sdk> createAndroidSdkPerAndroidTarget(@NotNull File androidSdkPath) {
        List<Sdk> sdks = this.createAndroidSdkPerAndroidTarget(androidSdkPath, null);
        IdeSdks.updateWelcomeRunAndroidSdkAction();
        return sdks;
    }

    public static void updateWelcomeRunAndroidSdkAction() {
        ActionManager actionManager = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class);
        if (actionManager == null) {
            return;
        }
        AnAction sdkManagerAction = actionManager.getAction("WelcomeScreen.RunAndroidSdkManager");
        if (sdkManagerAction != null) {
            sdkManagerAction.update(AnActionEvent.createFromDataContext((String)"unknown", null, dataId -> null));
        }
    }

    @NotNull
    private List<Sdk> createAndroidSdkPerAndroidTarget(@NotNull File androidSdkPath, @Nullable Sdk javaSdk) {
        Sdk ideJdk;
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(androidSdkPath);
        if (sdkData == null) {
            return Collections.emptyList();
        }
        IAndroidTarget[] targets = sdkData.getTargets(false);
        if (targets.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Sdk> sdks = new ArrayList<Sdk>();
        Sdk sdk = ideJdk = javaSdk != null ? javaSdk : this.getJdk();
        if (ideJdk != null) {
            for (IAndroidTarget target : targets) {
                if (!target.isPlatform() || this.doesIdeAndroidSdkExist(target)) continue;
                String name = this.myAndroidSdks.chooseNameForNewLibrary(target);
                Sdk sdk2 = this.myAndroidSdks.create(target, sdkData.getLocation(), name, ideJdk, true);
                if (sdk2 == null) continue;
                sdks.add(sdk2);
            }
        }
        return sdks;
    }

    private boolean doesIdeAndroidSdkExist(@NotNull IAndroidTarget target) {
        for (Sdk sdk : this.getEligibleAndroidSdks()) {
            IAndroidTarget platformTarget = IdeSdks.getTarget(sdk);
            AndroidVersion version2 = target.getVersion();
            AndroidVersion existingVersion = platformTarget.getVersion();
            if (!existingVersion.equals((Object)version2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static IAndroidTarget getTarget(@NotNull Sdk sdk) {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(sdk);
        assert (androidPlatform != null);
        return androidPlatform.getTarget();
    }

    @NotNull
    private static File resolvePath(@NotNull File path2) {
        try {
            String resolvedPath = FileUtil.resolveShortWindowsName((String)path2.getPath());
            return new File(resolvedPath);
        }
        catch (IOException iOException) {
            return path2;
        }
    }

    public boolean isUsingEmbeddedJdk() {
        if (!this.myIdeInfo.isAndroidStudio()) {
            return false;
        }
        File jdkPath = this.doGetJdkPath(false);
        return jdkPath != null && FileUtil.filesEqual((File)jdkPath, (File)this.getEmbeddedJdkPath());
    }

    public void setUseEmbeddedJdk() {
        Preconditions.checkState((boolean)this.myIdeInfo.isAndroidStudio(), (Object)"This method is for use in Android Studio only.");
        File embeddedJdkPath = this.getEmbeddedJdkPath();
        assert (embeddedJdkPath != null);
        this.setJdkPath(embeddedJdkPath);
    }

    @Nullable
    public File getEmbeddedJdkPath() {
        if (!this.myIdeInfo.isAndroidStudio()) {
            return null;
        }
        return this.myEmbeddedDistributionPaths.getEmbeddedJdkPath();
    }

    public boolean isUsingJavaHomeJdk() {
        return this.isUsingJavaHomeJdk(ApplicationManager.getApplication().isUnitTestMode());
    }

    @VisibleForTesting
    boolean isUsingJavaHomeJdk(boolean assumeUnitTest) {
        if (!this.myIdeInfo.isAndroidStudio()) {
            return false;
        }
        File jdkPath = assumeUnitTest ? this.doGetJdkPath(false) : this.getJdkPath();
        return IdeSdks.isSameAsJavaHomeJdk(jdkPath);
    }

    public static boolean isSameAsJavaHomeJdk(@Nullable File path2) {
        String javaHome = IdeSdks.getJdkFromJavaHome();
        return javaHome != null && FileUtil.filesEqual((File)path2, (File)FilePaths.toSystemDependentPath((String)javaHome));
    }

    @Nullable
    public static String getJdkFromJavaHome() {
        String terminalValue = IdeSdks.doGetJdkFromPathOrParent(EnvironmentUtil.getValue((String)"JAVA_HOME"));
        if (!Strings.isNullOrEmpty((String)terminalValue)) {
            return terminalValue;
        }
        String envVariableValue = IdeSdks.doGetJdkFromPathOrParent(System.getenv("JAVA_HOME"));
        if (!Strings.isNullOrEmpty((String)envVariableValue)) {
            return envVariableValue;
        }
        return IdeSdks.doGetJdkFromPathOrParent(SystemProperties.getJavaHome());
    }

    @VisibleForTesting
    @Nullable
    static String doGetJdkFromPathOrParent(@Nullable String path2) {
        if (Strings.isNullOrEmpty((String)path2)) {
            return null;
        }
        File pathFile = new File(FileUtil.toSystemDependentName((String)path2));
        String result2 = IdeSdks.doGetJdkFromPath(pathFile);
        if (result2 != null) {
            return result2;
        }
        File parentFile = pathFile.getParentFile();
        if (parentFile != null) {
            return IdeSdks.doGetJdkFromPath(parentFile);
        }
        return null;
    }

    @Nullable
    private static String doGetJdkFromPath(@NotNull File file2) {
        File potentialPath;
        if (JdkUtil.checkForJdk((File)file2)) {
            return file2.getPath();
        }
        if (SystemInfo.isMac && (potentialPath = new File(file2, MAC_JDK_CONTENT_PATH)).isDirectory() && JdkUtil.checkForJdk((File)potentialPath)) {
            return potentialPath.getPath();
        }
        return null;
    }

    @Nullable
    public Sdk getJdk() {
        if (this.myEnvVariableSettings.isUseJdkEnvVariable()) {
            return this.myEnvVariableSettings.getSdk();
        }
        return this.getJdk(this.getRunningVersionOrDefault());
    }

    @Nullable
    private Sdk getJdk(@Nullable JavaSdkVersion preferredVersion) {
        Sdk jdk;
        List<Sdk> androidSdks = this.getEligibleAndroidSdks();
        if (!androidSdks.isEmpty()) {
            Sdk androidSdk = androidSdks.get(0);
            AndroidSdkAdditionalData data = this.myAndroidSdks.getAndroidSdkAdditionalData(androidSdk);
            assert (data != null);
            jdk = data.getJavaSdk();
            if (IdeSdks.isJdkCompatible(jdk, preferredVersion)) {
                return jdk;
            }
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        if (!jdks.isEmpty()) {
            jdk = jdks.iterator();
            while (jdk.hasNext()) {
                Sdk jdk2 = (Sdk)jdk.next();
                if (!IdeSdks.isJdkCompatible(jdk2, preferredVersion)) continue;
                return jdk2;
            }
        }
        if (this.myIdeInfo.isAndroidStudio() && (jdk = this.myJdks.createEmbeddedJdk()) != null) {
            assert (IdeSdks.isJdkCompatible(jdk, preferredVersion));
            return jdk;
        }
        Set checkedJdkPaths = jdks.stream().map(Sdk::getHomePath).collect(Collectors.toSet());
        List<File> jdkPaths = IdeSdks.getPotentialJdkPaths();
        for (File jdkPath : jdkPaths) {
            Sdk jdk3;
            if (checkedJdkPaths.contains(jdkPath.getAbsolutePath())) continue;
            if (JdkUtil.checkForJdk((File)jdkPath) && IdeSdks.isJdkCompatible(jdk3 = this.createJdk(jdkPath), preferredVersion)) {
                return jdk3;
            }
            if (!SystemInfo.isLinux) continue;
            for (File child : FileUtil.notNullize((File[])jdkPath.listFiles())) {
                Sdk jdk4;
                if (!child.isDirectory() || !JdkUtil.checkForJdk((File)child) || !IdeSdks.isJdkCompatible(jdk4 = this.myJdks.createJdk(child.getPath()), preferredVersion)) continue;
                return jdk4;
            }
        }
        return null;
    }

    @NotNull
    private static List<File> getPotentialJdkPaths() {
        JavaSdk javaSdk = JavaSdk.getInstance();
        ArrayList jdkPaths = Lists.newArrayList((Iterable)javaSdk.suggestHomePaths());
        jdkPaths.add(SystemProperties.getJavaHome());
        jdkPaths.add(0, System.getenv("JDK_HOME"));
        ArrayList virtualFiles = Lists.newArrayListWithCapacity((int)jdkPaths.size());
        for (String jdkPath : jdkPaths) {
            File javaHome;
            if (jdkPath == null || !(javaHome = new File(jdkPath)).isDirectory()) continue;
            virtualFiles.add(javaHome);
        }
        return virtualFiles;
    }

    @VisibleForTesting
    static boolean isJdkCompatible(@Nullable Sdk jdk, @Nullable JavaSdkVersion preferredVersion) {
        if (jdk == null) {
            return false;
        }
        if (preferredVersion == null) {
            return true;
        }
        if (!JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_1_8)) {
            return false;
        }
        if (((Boolean)StudioFlags.ALLOW_DIFFERENT_JDK_VERSION.get()).booleanValue()) {
            return true;
        }
        return JavaSdk.getInstance().isOfVersionOrHigher(jdk, preferredVersion);
    }

    @NotNull
    public List<Sdk> getEligibleAndroidSdks() {
        ArrayList<Sdk> sdks = new ArrayList<Sdk>();
        for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
            if (!sdk.getName().startsWith("Android ") || AndroidPlatform.getInstance(sdk) == null) continue;
            sdks.add(sdk);
        }
        return sdks;
    }

    @Nullable
    private Sdk createJdk(@NotNull File homeDirectory) {
        return this.myJdks.createJdk(homeDirectory.getPath());
    }

    public boolean isJdk7Supported(@Nullable AndroidSdkData sdkData) {
        if (sdkData != null) {
            Revision revision;
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(Jdks.class);
            LocalPackage info2 = sdkData.getSdkHandler().getLocalPackage("platform-tools", (ProgressIndicator)progress);
            if (info2 != null && (revision = info2.getVersion()).getMajor() >= 19) {
                JavaSdkVersion version2;
                JavaSdk jdk = JavaSdk.getInstance();
                Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk);
                if (sdk != null && (version2 = jdk.getVersion(sdk)) != null && version2.isAtLeast(JavaSdkVersion.JDK_1_7)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static void removeJdksOn(@NotNull Disposable disposable2) {
        if (disposable2 instanceof ProjectEx) {
            disposable2 = ((ProjectEx)disposable2).getEarlyDisposable();
        }
        Disposer.register((Disposable)disposable2, () -> WriteAction.run(() -> {
            for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
        }));
    }

    @Nullable
    public File validateJdkPath(@NotNull File file2) {
        File macPath;
        File possiblePath = null;
        if (JdkUtil.checkForJdk((File)file2)) {
            possiblePath = file2;
        } else if (SystemInfo.isMac && (macPath = new File(file2, MAC_JDK_CONTENT_PATH)).isDirectory() && JdkUtil.checkForJdk((File)macPath)) {
            possiblePath = macPath;
        }
        if (possiblePath != null) {
            if (((Boolean)StudioFlags.ALLOW_DIFFERENT_JDK_VERSION.get()).booleanValue() || IdeSdks.isJdkSameVersion(possiblePath, this.getRunningVersionOrDefault())) {
                return possiblePath;
            }
            LOG.warn("Trying to use JDK with different version: " + possiblePath);
        } else {
            IdeSdks.showValidateDetails(file2);
            if (SystemInfo.isMac) {
                IdeSdks.showValidateDetails(new File(file2, MAC_JDK_CONTENT_PATH));
            }
        }
        return null;
    }

    private static void showValidateDetails(@NotNull File homePath) {
        LOG.warn("Could not validate JDK at " + homePath + ":");
        LOG.warn("  File exists: " + homePath.exists());
        LOG.warn("  Javac: " + (new File(homePath, "bin/javac").isFile() || new File(homePath, "bin/javac.exe").isFile()));
        LOG.warn("  JDK: " + new File(homePath, "jre/lib/rt.jar").exists());
        LOG.warn("  JRE: " + new File(homePath, "lib/rt.jar").exists());
        LOG.warn("  Jigsaw JDK/JRE: " + JdkUtil.isModularRuntime((File)homePath));
        LOG.warn("  Apple JDK: " + new File(homePath, "../Classes/classes.jar").exists());
        LOG.warn("  IBM JDK: " + new File(homePath, "jre/lib/vm.jar").exists());
        LOG.warn("  Custom build: " + new File(homePath, "classes").isDirectory());
    }

    @NotNull
    public JavaSdkVersion getRunningVersionOrDefault() {
        JavaSdkVersion currentlyRunning;
        String versionString = System.getProperty("java.version");
        if (versionString != null && (currentlyRunning = JavaSdkVersion.fromVersionString((String)versionString)) != null) {
            return currentlyRunning;
        }
        JavaSdkVersion embeddedVersion = Jdks.getInstance().findVersion(this.myEmbeddedDistributionPaths.getEmbeddedJdkPath());
        return embeddedVersion != null ? embeddedVersion : DEFAULT_JDK_VERSION;
    }

    @Contract(value="null, _ -> false")
    public static boolean isJdkSameVersion(@Nullable File jdkLocation, @NotNull JavaSdkVersion expectedVersion) {
        if (jdkLocation == null) {
            return false;
        }
        JavaSdkVersion version2 = Jdks.getInstance().findVersion(jdkLocation);
        return version2 != null && version2.compareTo((Enum)expectedVersion) == 0;
    }

    private class EnvVariableSettings {
        private Sdk mySdk;
        private String myVariableValue;
        private File myJdkFile;
        private boolean myUseJdkEnvVariable;
        private boolean myInitialized;
        private final Object myInitializationLock = new Object();

        public EnvVariableSettings() {
            this.cleanInitialization();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanInitialization() {
            Object object = this.myInitializationLock;
            synchronized (object) {
                this.myVariableValue = null;
                this.myJdkFile = null;
                this.mySdk = null;
                this.myUseJdkEnvVariable = false;
                this.myInitialized = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize() {
            Object object = this.myInitializationLock;
            synchronized (object) {
                if (this.myInitialized) {
                    return;
                }
            }
            this.initialize(System.getenv(IdeSdks.JDK_LOCATION_ENV_VARIABLE_NAME));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize(@Nullable String value2) {
            File envVariableJdkFile;
            Object object = this.myInitializationLock;
            synchronized (object) {
                if (this.myInitialized) {
                    return;
                }
                if (value2 == null) {
                    this.setInitializationAsNotDefined();
                    return;
                }
                envVariableJdkFile = IdeSdks.this.validateJdkPath(new File(FileUtil.toSystemDependentName((String)value2)));
                if (envVariableJdkFile == null) {
                    this.setInitializationAsDefinedButInvalid(value2);
                    LOG.warn("The provided JDK path is invalid: " + value2);
                    return;
                }
            }
            File finalEnvVariableJdkFile = envVariableJdkFile;
            Runnable createJdkTask = () -> {
                Object object = this.myInitializationLock;
                synchronized (object) {
                    if (!this.myInitialized) {
                        try {
                            @Nullable Sdk jdk = IdeSdks.this.createJdk(finalEnvVariableJdkFile);
                            if (jdk != null) {
                                this.setInitialization(value2, finalEnvVariableJdkFile, jdk);
                                LOG.info("Using Gradle JDK from STUDIO_GRADLE_JDK=" + value2);
                            } else {
                                this.setInitializationAsDefinedButInvalid(value2);
                                LOG.warn("Could not use provided jdk from " + value2);
                            }
                        }
                        catch (Throwable exc) {
                            this.setInitializationAsDefinedButInvalid(value2);
                            LOG.warn("Could not use provided jdk from " + value2, exc);
                        }
                    }
                }
            };
            Application application = ApplicationManager.getApplication();
            boolean onReadAction = application.isReadAccessAllowed();
            boolean hasWriteIntendLock = application.isWriteThread();
            if (onReadAction && !hasWriteIntendLock) {
                application.invokeLater(createJdkTask);
                throw new AssertionError((Object)"Cannot create JDK from a read action without write intend");
            }
            application.invokeAndWait(createJdkTask);
        }

        private void setInitializationAsNotDefined() {
            this.setInitialization(null, null, null);
        }

        private void setInitializationAsDefinedButInvalid(@NotNull String envVariableValue) {
            this.setInitialization(envVariableValue, null, null);
        }

        private void setInitialization(@Nullable String variableValue2, @Nullable File jdkFile, @Nullable Sdk sdk) {
            this.myVariableValue = variableValue2;
            this.myJdkFile = jdkFile;
            this.mySdk = sdk;
            this.myUseJdkEnvVariable = variableValue2 != null && jdkFile != null && sdk != null;
            this.myInitialized = true;
        }

        public boolean isUseJdkEnvVariable() {
            this.initialize();
            return this.myUseJdkEnvVariable;
        }

        boolean isJdkEnvVariableDefined() {
            this.initialize();
            return this.myVariableValue != null;
        }

        public boolean IsJdkEnvVariableValid() {
            this.initialize();
            return this.mySdk != null;
        }

        public File getJdkFile() {
            this.initialize();
            return this.myJdkFile;
        }

        public Sdk getSdk() {
            this.initialize();
            return this.mySdk;
        }

        public String getVariableValue() {
            this.initialize();
            return this.myVariableValue;
        }

        public boolean setUseJdkEnvVariable(boolean use2) {
            this.initialize();
            if (!this.IsJdkEnvVariableValid()) {
                return false;
            }
            this.myUseJdkEnvVariable = use2;
            return true;
        }

        public void overrideValue(@Nullable String value2) {
            ExternalSystemApiUtil.doWriteAction(() -> {
                Object object = this.myInitializationLock;
                synchronized (object) {
                    this.myInitialized = false;
                    this.initialize(value2);
                }
            });
        }
    }

    public static interface AndroidSdkEventListener {
        public static final ExtensionPointName<AndroidSdkEventListener> EP_NAME = ExtensionPointName.create((String)"com.android.ide.sdkEventListener");

        public void afterSdkPathChange(@NotNull File var1, @NotNull Project var2);
    }
}

