/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.startup.ExternalAnnotationsSupport;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.serviceContainer.NonInjectable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdks {
    @NonNls
    public static final String SDK_NAME_PREFIX = "Android ";
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final Jdks myJdks;
    @Nullable
    private AndroidSdkData mySdkData;

    @NotNull
    public static AndroidSdks getInstance() {
        return (AndroidSdks)ServiceManager.getService(AndroidSdks.class);
    }

    public AndroidSdks() {
        this(Jdks.getInstance(), IdeInfo.getInstance());
    }

    @NonInjectable
    @VisibleForTesting
    public AndroidSdks(@NotNull Jdks jdks, @NotNull IdeInfo ideInfo) {
        this.myIdeInfo = ideInfo;
        this.myJdks = jdks;
    }

    @Nullable
    public Sdk findSuitableAndroidSdk(@NotNull String targetHash) {
        for (Sdk sdk : this.getAllAndroidSdks()) {
            AndroidSdkAdditionalData originalData = this.getAndroidSdkAdditionalData(sdk);
            if (originalData == null || !targetHash.equals(originalData.getBuildTargetHashString())) continue;
            return sdk;
        }
        return null;
    }

    @Nullable
    public AndroidSdkAdditionalData getAndroidSdkAdditionalData(@NotNull Sdk sdk) {
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        return data instanceof AndroidSdkAdditionalData ? (AndroidSdkAdditionalData)data : null;
    }

    public void setSdkData(@Nullable AndroidSdkData data) {
        this.mySdkData = data;
    }

    @NotNull
    public AndroidSdkHandler tryToChooseSdkHandler() {
        AndroidSdkData data = this.tryToChooseAndroidSdk();
        return data != null ? data.getSdkHandler() : AndroidSdkHandler.getInstance(null);
    }

    @Nullable
    public AndroidSdkData tryToChooseAndroidSdk() {
        if (this.mySdkData == null) {
            File path2;
            if (this.myIdeInfo.isAndroidStudio() && (path2 = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                this.mySdkData = AndroidSdkData.getSdkData(path2);
                if (this.mySdkData != null) {
                    return this.mySdkData;
                }
            }
            for (File path3 : this.getAndroidSdkPathsFromExistingPlatforms()) {
                this.mySdkData = AndroidSdkData.getSdkData(path3);
                if (this.mySdkData == null) continue;
                break;
            }
        }
        return this.mySdkData;
    }

    @NotNull
    public Collection<File> getAndroidSdkPathsFromExistingPlatforms() {
        ArrayList<File> result2 = new ArrayList<File>();
        for (Sdk androidSdk : this.getAllAndroidSdks()) {
            File sdkPath;
            AndroidPlatform androidPlatform = AndroidPlatform.getInstance(androidSdk);
            if (androidPlatform == null || result2.contains(sdkPath = androidPlatform.getSdkData().getLocation())) continue;
            if (androidSdk.getName().startsWith(SDK_NAME_PREFIX)) {
                result2.add(0, sdkPath);
                continue;
            }
            result2.add(sdkPath);
        }
        return result2;
    }

    @NotNull
    public List<Sdk> getAllAndroidSdks() {
        return (List)ReadAction.compute(() -> ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)AndroidSdkType.getInstance()));
    }

    @Nullable
    public Sdk tryToCreate(@NotNull File sdkPath, @NotNull String targetHashString) {
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdkPath);
        if (sdkData != null) {
            sdkData.getSdkHandler().getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(AndroidSdks.class)).markInvalid();
            IAndroidTarget target = sdkData.findTargetByHashString(targetHashString);
            if (target != null) {
                return this.create(target, sdkData.getLocation(), true);
            }
        }
        return null;
    }

    @Nullable
    public Sdk create(@NotNull IAndroidTarget target, @NotNull File sdkPath, boolean addRoots) {
        Sdk jdk = this.myJdks.chooseOrCreateJavaSdk();
        return jdk != null ? this.create(target, sdkPath, jdk, addRoots) : null;
    }

    @Nullable
    public Sdk create(@NotNull IAndroidTarget target, @NotNull File sdkPath, @NotNull Sdk jdk, boolean addRoots) {
        return this.create(target, sdkPath, this.chooseNameForNewLibrary(target), jdk, addRoots);
    }

    @Nullable
    public Sdk create(@NotNull IAndroidTarget target, @NotNull File sdkPath, @NotNull String sdkName, @NotNull Sdk jdk, boolean addRoots) {
        if (!target.getAdditionalLibraries().isEmpty()) {
            String parentHashString;
            String string = parentHashString = target.getParent() == null ? null : target.getParent().hashString();
            if (parentHashString != null && this.findSuitableAndroidSdk(parentHashString) == null) {
                this.tryToCreate(sdkPath, parentHashString);
            }
            return null;
        }
        ProjectJdkTable table2 = ProjectJdkTable.getInstance();
        String tempName = SdkConfigurationUtil.createUniqueSdkName((String)"Android SDK", Arrays.asList(table2.getAllJdks()));
        Sdk sdk = table2.createSdk(tempName, (SdkTypeId)AndroidSdkType.getInstance());
        SdkModificator sdkModificator = AndroidSdks.getAndInitialiseSdkModificator(sdk, target, jdk);
        sdkModificator.setHomePath(FileUtil.toSystemIndependentName((String)sdkPath.getPath()));
        this.setUpSdkAndCommit(sdkModificator, sdkName, Arrays.asList(table2.getAllJdks()), addRoots);
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk));
        return sdk;
    }

    public void setUpSdk(@NotNull Sdk androidSdk, @NotNull IAndroidTarget target, @NotNull String sdkName, @NotNull Collection<Sdk> allSdks, @Nullable Sdk jdk) {
        this.setUpSdkAndCommit(AndroidSdks.getAndInitialiseSdkModificator(androidSdk, target, jdk), sdkName, allSdks, true);
    }

    @NotNull
    private static SdkModificator getAndInitialiseSdkModificator(@NotNull Sdk androidSdk, @NotNull IAndroidTarget target, @Nullable Sdk jdk) {
        SdkModificator sdkModificator = androidSdk.getSdkModificator();
        AndroidSdkAdditionalData data = new AndroidSdkAdditionalData(androidSdk, jdk);
        data.setBuildTarget(target);
        sdkModificator.setSdkAdditionalData((SdkAdditionalData)data);
        if (jdk != null) {
            sdkModificator.setVersionString(jdk.getVersionString());
        }
        return sdkModificator;
    }

    private void setUpSdkAndCommit(@NotNull SdkModificator sdkModificator, @NotNull String sdkName, @NotNull Collection<Sdk> allSdks, boolean addRoots) {
        AndroidSdkAdditionalData data = (AndroidSdkAdditionalData)sdkModificator.getSdkAdditionalData();
        assert (data != null);
        AndroidSdkData androidSdkData = AndroidSdkData.getSdkData(sdkModificator.getHomePath());
        assert (androidSdkData != null);
        IAndroidTarget target = data.getBuildTarget(androidSdkData);
        assert (target != null);
        String name = SdkConfigurationUtil.createUniqueSdkName((String)sdkName, allSdks);
        sdkModificator.setName(name);
        if (addRoots) {
            List<OrderRoot> newRoots = this.getLibraryRootsForTarget(target, FilePaths.toSystemDependentPath((String)sdkModificator.getHomePath()), true);
            sdkModificator.removeAllRoots();
            for (OrderRoot orderRoot : newRoots) {
                sdkModificator.addRoot(orderRoot.getFile(), orderRoot.getType());
            }
            this.findAndSetPlatformSources(target, sdkModificator);
            ExternalAnnotationsSupport.attachJdkAnnotations(sdkModificator);
        }
        sdkModificator.commitChanges();
    }

    public void findAndSetPlatformSources(@NotNull IAndroidTarget target, @NotNull SdkModificator sdkModificator) {
        VirtualFile virtualFile;
        File sources = this.findPlatformSources(target);
        if (sources != null && (virtualFile = VfsUtil.findFileByIoFile((File)sources, (boolean)true)) != null) {
            for (VirtualFile file2 : sdkModificator.getRoots(OrderRootType.SOURCES)) {
                if (!file2.equals(virtualFile)) continue;
                return;
            }
            sdkModificator.addRoot(virtualFile, OrderRootType.SOURCES);
        }
    }

    @Nullable
    public File findPlatformSources(@NotNull IAndroidTarget target) {
        File platformSource;
        String path2 = target.getPath(18);
        if (path2 != null && (platformSource = new File(path2)).isDirectory()) {
            return platformSource;
        }
        return null;
    }

    @NotNull
    public List<OrderRoot> getLibraryRootsForTarget(@NotNull IAndroidTarget target, @Nullable File sdkPath, boolean addPlatformAndAddOnJars) {
        File annotationsJarPath;
        VirtualFile annotationsJar;
        String resFolderPath;
        VirtualFile resFolder;
        VirtualFile javadoc;
        VirtualFile platformSourcesDir;
        VirtualFile platformFolder;
        ArrayList<OrderRoot> result2 = new ArrayList<OrderRoot>();
        if (addPlatformAndAddOnJars) {
            for (VirtualFile file2 : this.getPlatformAndAddOnJars(target)) {
                result2.add(new OrderRoot(file2, OrderRootType.CLASSES));
            }
        }
        if ((platformFolder = AndroidSdks.getPlatformFolder(target)) == null) {
            return result2;
        }
        VirtualFile targetDir = platformFolder;
        if (!target.isPlatform()) {
            targetDir = AndroidSdks.findFileInLocalFileSystem(target.getLocation());
        }
        boolean docsOrSourcesFound = false;
        if (targetDir != null) {
            docsOrSourcesFound = AndroidSdks.addJavaDocAndSources(result2, targetDir);
        }
        VirtualFile sdkDir = sdkPath != null ? ExternalSystemUtil.refreshAndFindFileByIoFile((File)sdkPath) : null;
        VirtualFile sourcesDir = null;
        if (sdkDir != null) {
            docsOrSourcesFound = AndroidSdks.addJavaDocAndSources(result2, sdkDir) || docsOrSourcesFound;
            sourcesDir = VfsUtil.refreshAndFindChild((VirtualFile)sdkDir, (String)"sources");
        }
        if (sourcesDir != null && sourcesDir.isDirectory() && (platformSourcesDir = VfsUtil.refreshAndFindChild(sourcesDir, (String)platformFolder.getName())) != null && platformSourcesDir.isDirectory()) {
            result2.add(new OrderRoot(platformSourcesDir, OrderRootType.SOURCES));
            docsOrSourcesFound = true;
        }
        if (!docsOrSourcesFound && (javadoc = VirtualFileManager.getInstance().findFileByUrl("http://developer.android.com/reference/")) != null) {
            result2.add(new OrderRoot(javadoc, JavadocOrderRootType.getInstance()));
        }
        if ((resFolder = AndroidSdks.findFileInLocalFileSystem(resFolderPath = target.getPath(11))) != null) {
            result2.add(new OrderRoot(resFolder, OrderRootType.CLASSES));
        }
        if (sdkPath != null && this.needsAnnotationsJarInClasspath(target) && (annotationsJar = AndroidSdks.findFileInJarFileSystem(annotationsJarPath = new File(sdkPath, FileUtil.toSystemDependentName((String)"/tools/support/annotations.jar")))) != null) {
            result2.add(new OrderRoot(annotationsJar, OrderRootType.CLASSES));
        }
        return result2;
    }

    @NotNull
    public List<VirtualFile> getPlatformAndAddOnJars(@NotNull IAndroidTarget target) {
        VirtualFile androidJar;
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        VirtualFile platformFolder = AndroidSdks.getPlatformFolder(target);
        if (platformFolder != null && (androidJar = VfsUtil.refreshAndFindChild((VirtualFile)platformFolder, (String)"android.jar")) != null) {
            File androidJarPath = VfsUtilCore.virtualToIoFile((VirtualFile)androidJar);
            VirtualFile androidJarRoot = AndroidSdks.findFileInJarFileSystem(androidJarPath);
            if (androidJarRoot != null) {
                result2.add(androidJarRoot);
            }
            List libraries = target.getAdditionalLibraries();
            for (OptionalLibrary library : libraries) {
                VirtualFile root2 = AndroidSdks.getRoot(library);
                if (root2 == null) continue;
                result2.add(root2);
            }
        }
        return result2;
    }

    @NotNull
    private static String getPlatformPath(@NotNull IAndroidTarget target) {
        return target.isPlatform() ? target.getLocation() : target.getParent().getLocation();
    }

    @Nullable
    private static VirtualFile getPlatformFolder(@NotNull IAndroidTarget target) {
        String platformPath = AndroidSdks.getPlatformPath(target);
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)platformPath));
    }

    @Nullable
    private static VirtualFile getRoot(@NotNull OptionalLibrary library) {
        File jar = library.getJar();
        if (jar != null) {
            return AndroidSdks.findFileInJarFileSystem(jar);
        }
        return null;
    }

    private static boolean addJavaDocAndSources(@NotNull List<OrderRoot> orderRoots, @NotNull VirtualFile sdkFolder) {
        VirtualFile sourcesFolder;
        boolean found = false;
        VirtualFile javadocFolder = AndroidSdks.findJavadocFolder(sdkFolder);
        if (javadocFolder != null) {
            orderRoots.add(new OrderRoot(javadocFolder, JavadocOrderRootType.getInstance()));
            found = true;
        }
        if ((sourcesFolder = VfsUtil.refreshAndFindChild((VirtualFile)sdkFolder, (String)"src")) != null) {
            orderRoots.add(new OrderRoot(sourcesFolder, OrderRootType.SOURCES));
            found = true;
        }
        return found;
    }

    @Nullable
    private static VirtualFile findJavadocFolder(@NotNull VirtualFile folder) {
        VirtualFile docsFolder = VfsUtil.refreshAndFindChild((VirtualFile)folder, (String)"docs");
        return docsFolder != null ? VfsUtil.refreshAndFindChild((VirtualFile)docsFolder, (String)"reference") : null;
    }

    @Nullable
    private static File findJavadocFolder(@NotNull File folder) {
        File docsFolder = new File(folder, FileUtil.join((String[])new String[]{"docs", "reference"}));
        return docsFolder.isDirectory() ? docsFolder : null;
    }

    @Nullable
    private static VirtualFile findFileInLocalFileSystem(@NotNull String path2) {
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(path2));
    }

    @Nullable
    private static VirtualFile findFileInJarFileSystem(@NotNull File path2) {
        String canonicalPath = FileUtil.toCanonicalPath((String)path2.getPath());
        return JarFileSystem.getInstance().refreshAndFindFileByPath(canonicalPath + "!/");
    }

    @NotNull
    public String chooseNameForNewLibrary(@NotNull IAndroidTarget target) {
        if (target.isPlatform()) {
            return SDK_NAME_PREFIX + target.getVersion().toString() + " Platform";
        }
        IAndroidTarget parentTarget = target.getParent();
        String name = SDK_NAME_PREFIX;
        if (parentTarget != null) {
            name = name + parentTarget.getVersionName() + ' ';
        }
        return name + target.getName();
    }

    public boolean isAndroidSdk(@NotNull Sdk sdk) {
        return sdk.getSdkType() == AndroidSdkType.getInstance();
    }

    public boolean needsAnnotationsJarInClasspath(@NotNull IAndroidTarget target) {
        return target.getVersion().getApiLevel() <= 15;
    }

    public void refreshLibrariesIn(@NotNull Sdk sdk) {
        VirtualFile[] libraries = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        this.replaceLibraries(sdk, libraries);
    }

    @VisibleForTesting
    void replaceLibraries(@NotNull Sdk sdk, @NotNull VirtualFile[] libraries) {
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        for (VirtualFile library : libraries) {
            sdkModificator.addRoot(library, OrderRootType.CLASSES);
        }
        sdkModificator.commitChanges();
    }

    public boolean isInAndroidSdk(PsiElement element2) {
        VirtualFile file2 = AndroidSdks.getVirtualFile(element2);
        if (file2 == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)element2.getProject()).getFileIndex();
        List entries = projectFileIndex.getOrderEntriesForFile(file2);
        for (OrderEntry entry : entries) {
            Sdk sdk;
            if (!(entry instanceof JdkOrderEntry) || (sdk = ((JdkOrderEntry)entry).getJdk()) == null || !(sdk.getSdkType() instanceof AndroidSdkType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull PsiElement element2) {
        PsiFile file2 = element2.getContainingFile();
        return file2 != null ? file2.getVirtualFile() : null;
    }
}

